/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Graph;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import dagger.internal.codegen.binding.AutoValue_BindingGraphConverter_MissingBindingImpl;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingDeclarationFormatter;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingGraphFactory;
import dagger.internal.codegen.binding.BindingNode;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ChildFactoryMethodEdgeImpl;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentNodeImpl;
import dagger.internal.codegen.binding.DependencyEdgeImpl;
import dagger.internal.codegen.binding.ResolvedBindings;
import dagger.internal.codegen.binding.SubcomponentCreatorBindingEdgeImpl;
import dagger.internal.codegen.extension.DaggerGraphs;
import dagger.internal.codegen.model.BindingGraph;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.ComponentPath;
import dagger.internal.codegen.model.DaggerTypeElement;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.Key;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

final class BindingGraphConverter {
    private final BindingDeclarationFormatter bindingDeclarationFormatter;

    @Inject
    BindingGraphConverter(BindingDeclarationFormatter bindingDeclarationFormatter) {
        this.bindingDeclarationFormatter = bindingDeclarationFormatter;
    }

    BindingGraph convert(BindingGraphFactory.LegacyBindingGraph legacyBindingGraph, boolean isFullBindingGraph) {
        MutableNetwork<BindingGraph.Node, BindingGraph.Edge> network = this.asNetwork(legacyBindingGraph);
        BindingGraph.ComponentNode rootNode = legacyBindingGraph.componentNode();
        if (!isFullBindingGraph) {
            DaggerGraphs.unreachableNodes((Graph)network.asGraph(), (Object)rootNode).forEach(arg_0 -> network.removeNode(arg_0));
        }
        BindingGraph.TopLevelBindingGraph topLevelBindingGraph = BindingGraph.TopLevelBindingGraph.create((ImmutableNetwork<BindingGraph.Node, BindingGraph.Edge>)ImmutableNetwork.copyOf(network), isFullBindingGraph);
        return BindingGraph.create(rootNode, topLevelBindingGraph);
    }

    private MutableNetwork<BindingGraph.Node, BindingGraph.Edge> asNetwork(BindingGraphFactory.LegacyBindingGraph graph) {
        Converter converter = new Converter();
        converter.visitRootComponent(graph);
        return converter.network;
    }

    @AutoValue
    static abstract class MissingBindingImpl
    extends BindingGraph.MissingBinding {
        MissingBindingImpl() {
        }

        static BindingGraph.MissingBinding create(ComponentPath component, Key key) {
            return new AutoValue_BindingGraphConverter_MissingBindingImpl(component, key);
        }

        @Memoized
        public abstract int hashCode();

        public abstract boolean equals(Object var1);
    }

    private final class Converter {
        private final Deque<BindingGraphFactory.LegacyBindingGraph> bindingGraphPath = new ArrayDeque<BindingGraphFactory.LegacyBindingGraph>();
        private final MutableNetwork<BindingGraph.Node, BindingGraph.Edge> network = NetworkBuilder.directed().allowsParallelEdges(true).allowsSelfLoops(true).build();
        private final Set<BindingNode> bindings = new HashSet<BindingNode>();
        private final Map<ResolvedBindings, ImmutableSet<BindingNode>> resolvedBindingsMap = new HashMap<ResolvedBindings, ImmutableSet<BindingNode>>();

        private Converter() {
        }

        private void visitRootComponent(BindingGraphFactory.LegacyBindingGraph graph) {
            this.visitComponent(graph);
        }

        private void visitComponent(BindingGraphFactory.LegacyBindingGraph graph) {
            this.bindingGraphPath.addLast(graph);
            this.network.addNode((Object)graph.componentNode());
            for (ComponentDescriptor.ComponentMethodDescriptor entryPointMethod : graph.componentDescriptor().entryPointMethods()) {
                this.addDependencyEdges(graph.componentNode(), entryPointMethod.dependencyRequest().get());
            }
            for (ResolvedBindings resolvedBindings : graph.resolvedBindings()) {
                for (BindingNode binding : this.bindingNodes(resolvedBindings)) {
                    if (this.bindings.add(binding)) {
                        this.network.addNode((Object)binding);
                        for (DependencyRequest dependencyRequest : binding.dependencies()) {
                            this.addDependencyEdges(binding, dependencyRequest);
                        }
                    }
                    if (!binding.kind().equals((Object)BindingKind.SUBCOMPONENT_CREATOR) || !binding.componentPath().equals(graph.componentPath())) continue;
                    this.network.addEdge((Object)binding, (Object)this.subcomponentNode(binding.key().type().xprocessing(), graph), (Object)new SubcomponentCreatorBindingEdgeImpl(resolvedBindings.subcomponentDeclarations()));
                }
            }
            for (BindingGraphFactory.LegacyBindingGraph childGraph : graph.subgraphs()) {
                this.visitComponent(childGraph);
                graph.componentDescriptor().getFactoryMethodForChildComponent(childGraph.componentDescriptor()).ifPresent(childFactoryMethod -> this.network.addEdge((Object)graph.componentNode(), (Object)childGraph.componentNode(), (Object)new ChildFactoryMethodEdgeImpl(childFactoryMethod.methodElement())));
            }
            Verify.verify((boolean)this.bindingGraphPath.removeLast().equals(graph));
        }

        private ComponentPath componentPath() {
            return this.bindingGraphPath.getLast().componentPath();
        }

        private ComponentPath pathFromRootToAncestor(XTypeElement ancestor) {
            for (BindingGraphFactory.LegacyBindingGraph graph : this.bindingGraphPath) {
                if (!graph.componentDescriptor().typeElement().equals(ancestor)) continue;
                return graph.componentPath();
            }
            throw new IllegalArgumentException(String.format("%s is not in the current path: %s", ancestor.getQualifiedName(), this.componentPath()));
        }

        private BindingGraphFactory.LegacyBindingGraph graphForAncestor(XTypeElement ancestor) {
            for (BindingGraphFactory.LegacyBindingGraph graph : this.bindingGraphPath) {
                if (!graph.componentDescriptor().typeElement().equals(ancestor)) continue;
                return graph;
            }
            throw new IllegalArgumentException(String.format("%s is not in the current path: %s", ancestor.getQualifiedName(), this.componentPath()));
        }

        private void addDependencyEdges(BindingGraph.Node source, DependencyRequest dependencyRequest) {
            ResolvedBindings dependencies = this.resolvedDependencies(source, dependencyRequest);
            if (dependencies.isEmpty()) {
                this.addDependencyEdge(source, dependencyRequest, this.missingBindingNode(dependencies));
            } else {
                for (BindingNode dependency : this.bindingNodes(dependencies)) {
                    this.addDependencyEdge(source, dependencyRequest, dependency);
                }
            }
        }

        private void addDependencyEdge(BindingGraph.Node source, DependencyRequest dependencyRequest, BindingGraph.Node dependency) {
            this.network.addNode((Object)dependency);
            if (!this.hasDependencyEdge(source, dependency, dependencyRequest)) {
                this.network.addEdge((Object)source, (Object)dependency, (Object)new DependencyEdgeImpl(dependencyRequest, source instanceof BindingGraph.ComponentNode));
            }
        }

        private boolean hasDependencyEdge(BindingGraph.Node source, BindingGraph.Node dependency, DependencyRequest dependencyRequest) {
            for (BindingGraph.Edge edge : this.network.edgesConnecting((Object)source, (Object)dependency)) {
                if (!(edge instanceof BindingGraph.DependencyEdge) || !((BindingGraph.DependencyEdge)edge).dependencyRequest().equals(dependencyRequest)) continue;
                return true;
            }
            return false;
        }

        private ResolvedBindings resolvedDependencies(BindingGraph.Node source, DependencyRequest dependencyRequest) {
            return this.graphForAncestor(source.componentPath().currentComponent().xprocessing()).resolvedBindings(BindingRequest.bindingRequest(dependencyRequest));
        }

        private ImmutableSet<BindingNode> bindingNodes(ResolvedBindings resolvedBindings) {
            return this.resolvedBindingsMap.computeIfAbsent(resolvedBindings, this::uncachedBindingNodes);
        }

        private ImmutableSet<BindingNode> uncachedBindingNodes(ResolvedBindings resolvedBindings) {
            ImmutableSet.Builder bindingNodes = ImmutableSet.builder();
            resolvedBindings.allBindings().asMap().forEach((component, bindings) -> {
                for (Binding binding : bindings) {
                    bindingNodes.add((Object)this.bindingNode(resolvedBindings, binding, (XTypeElement)component));
                }
            });
            return bindingNodes.build();
        }

        private BindingNode bindingNode(ResolvedBindings resolvedBindings, Binding binding, XTypeElement owningComponent) {
            return BindingNode.create(this.pathFromRootToAncestor(owningComponent), binding, resolvedBindings.multibindingDeclarations(), resolvedBindings.optionalBindingDeclarations(), resolvedBindings.subcomponentDeclarations(), BindingGraphConverter.this.bindingDeclarationFormatter);
        }

        private BindingGraph.MissingBinding missingBindingNode(ResolvedBindings dependencies) {
            return MissingBindingImpl.create(ComponentPath.create((Iterable<DaggerTypeElement>)ImmutableList.of((Object)this.componentPath().rootComponent())), dependencies.key());
        }

        private BindingGraph.ComponentNode subcomponentNode(XType subcomponentBuilderType, BindingGraphFactory.LegacyBindingGraph graph) {
            XTypeElement subcomponentBuilderElement = subcomponentBuilderType.getTypeElement();
            ComponentDescriptor subcomponent = graph.componentDescriptor().getChildComponentWithBuilderType(subcomponentBuilderElement);
            return ComponentNodeImpl.create(this.componentPath().childPath(DaggerTypeElement.from(subcomponent.typeElement())), subcomponent);
        }
    }
}

