/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.binding.AutoValue_Nullability;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XNullability;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import java.util.stream.Stream;

@AutoValue
public abstract class Nullability {
    public static final Nullability NOT_NULLABLE = new AutoValue_Nullability(false, (ImmutableSet<ClassName>)ImmutableSet.of());

    public static Nullability of(XElement element) {
        return new AutoValue_Nullability(Nullability.isKotlinTypeNullable(element), Nullability.getNullableAnnotations(element));
    }

    private static ImmutableSet<ClassName> getNullableAnnotations(XElement element) {
        return Nullability.getNullableAnnotations(element.getAllAnnotations().stream());
    }

    private static ImmutableSet<ClassName> getNullableAnnotations(Stream<XAnnotation> annotations) {
        return (ImmutableSet)annotations.map(XAnnotations::getClassName).filter(annotation -> annotation.simpleName().contentEquals("Nullable")).collect(DaggerStreams.toImmutableSet());
    }

    private static boolean isKotlinTypeNullable(XElement element) {
        if (element.getClosestMemberContainer().isFromJava()) {
            return false;
        }
        if (XElementKt.isMethod((XElement)element)) {
            return Nullability.isKotlinTypeNullable(XElements.asMethod(element).getReturnType());
        }
        if (XElementKt.isVariableElement((XElement)element)) {
            return Nullability.isKotlinTypeNullable(XElements.asVariable(element).getType());
        }
        return false;
    }

    private static boolean isKotlinTypeNullable(XType type) {
        return type.getNullability() == XNullability.NULLABLE;
    }

    public abstract boolean isKotlinTypeNullable();

    public abstract ImmutableSet<ClassName> nullableAnnotations();

    public final boolean isNullable() {
        return this.isKotlinTypeNullable() || !this.nullableAnnotations().isEmpty();
    }

    Nullability() {
    }
}

