/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.base.ClearableCache;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.base.Keys;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.base.OptionalType;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingDeclaration;
import dagger.internal.codegen.binding.BindingFactory;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingGraphConverter;
import dagger.internal.codegen.binding.BindingNode;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.ComponentDeclarations;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentNodeImpl;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.DelegateDeclaration;
import dagger.internal.codegen.binding.InjectBindingRegistry;
import dagger.internal.codegen.binding.KeyFactory;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.MultibindingDeclaration;
import dagger.internal.codegen.binding.OptionalBindingDeclaration;
import dagger.internal.codegen.binding.ResolvedBindings;
import dagger.internal.codegen.binding.SubcomponentCreatorBinding;
import dagger.internal.codegen.binding.SubcomponentDeclaration;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.model.BindingGraph;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.ComponentPath;
import dagger.internal.codegen.model.DaggerTypeElement;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.model.Scope;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class BindingGraphFactory
implements ClearableCache {
    private final InjectBindingRegistry injectBindingRegistry;
    private final KeyFactory keyFactory;
    private final BindingFactory bindingFactory;
    private final BindingNode.Factory bindingNodeFactory;
    private final ComponentDeclarations.Factory componentDeclarationsFactory;
    private final BindingGraphConverter bindingGraphConverter;
    private final Map<Key, ImmutableSet<Key>> keysMatchingRequestCache = new HashMap<Key, ImmutableSet<Key>>();
    private final CompilerOptions compilerOptions;

    @Inject
    BindingGraphFactory(InjectBindingRegistry injectBindingRegistry, KeyFactory keyFactory, BindingFactory bindingFactory, BindingNode.Factory bindingNodeFactory, ComponentDeclarations.Factory componentDeclarationsFactory, BindingGraphConverter bindingGraphConverter, CompilerOptions compilerOptions) {
        this.injectBindingRegistry = injectBindingRegistry;
        this.keyFactory = keyFactory;
        this.bindingFactory = bindingFactory;
        this.bindingNodeFactory = bindingNodeFactory;
        this.componentDeclarationsFactory = componentDeclarationsFactory;
        this.bindingGraphConverter = bindingGraphConverter;
        this.compilerOptions = compilerOptions;
    }

    public BindingGraph create(ComponentDescriptor componentDescriptor, boolean createFullBindingGraph) {
        return this.bindingGraphConverter.convert(this.createLegacyBindingGraph(Optional.empty(), componentDescriptor, createFullBindingGraph), createFullBindingGraph);
    }

    private LegacyBindingGraph createLegacyBindingGraph(Optional<Resolver> parentResolver, ComponentDescriptor componentDescriptor, boolean createFullBindingGraph) {
        Resolver requestResolver = new Resolver(parentResolver, componentDescriptor);
        componentDescriptor.entryPointMethods().stream().map(method -> method.dependencyRequest().get()).forEach(entryPoint -> {
            if (entryPoint.kind().equals((Object)RequestKind.MEMBERS_INJECTION)) {
                requestResolver.resolveMembersInjection(entryPoint.key());
            } else {
                requestResolver.resolve(entryPoint.key());
            }
        });
        if (createFullBindingGraph) {
            requestResolver.declarations.allDeclarations().stream().filter(declaration -> declaration.contributingModule().isPresent()).map(BindingDeclaration::key).map(Key::withoutMultibindingContributionIdentifier).forEach(requestResolver::resolve);
        }
        HashSet<ComponentDescriptor> resolvedSubcomponents = new HashSet<ComponentDescriptor>();
        ImmutableList.Builder subgraphs = ImmutableList.builder();
        for (ComponentDescriptor subcomponent : Iterables.consumingIterable(requestResolver.subcomponentsToResolve)) {
            if (!resolvedSubcomponents.add(subcomponent)) continue;
            subgraphs.add((Object)this.createLegacyBindingGraph(Optional.of(requestResolver), subcomponent, createFullBindingGraph));
        }
        return new LegacyBindingGraph(requestResolver, (ImmutableList<LegacyBindingGraph>)subgraphs.build());
    }

    @Override
    public void clearCache() {
        this.keysMatchingRequestCache.clear();
    }

    static final class LegacyBindingGraph {
        private final Resolver resolver;
        private final ImmutableList<LegacyBindingGraph> resolvedSubgraphs;
        private final BindingGraph.ComponentNode componentNode;

        LegacyBindingGraph(Resolver resolver, ImmutableList<LegacyBindingGraph> resolvedSubgraphs) {
            this.resolver = resolver;
            this.resolvedSubgraphs = resolvedSubgraphs;
            this.componentNode = ComponentNodeImpl.create(resolver.componentPath, resolver.componentDescriptor);
        }

        BindingGraph.ComponentNode componentNode() {
            return this.componentNode;
        }

        ComponentPath componentPath() {
            return this.resolver.componentPath;
        }

        ComponentDescriptor componentDescriptor() {
            return this.resolver.componentDescriptor;
        }

        ResolvedBindings resolvedBindings(BindingRequest request) {
            return request.isRequestKind(RequestKind.MEMBERS_INJECTION) ? this.resolver.getResolvedMembersInjectionBindings(request.key()) : this.resolver.getResolvedContributionBindings(request.key());
        }

        Iterable<ResolvedBindings> resolvedBindings() {
            return Iterables.concat(this.resolver.resolvedMembersInjectionBindings.values(), this.resolver.resolvedContributionBindings.values());
        }

        ImmutableList<LegacyBindingGraph> subgraphs() {
            return this.resolvedSubgraphs;
        }
    }

    private final class Resolver {
        final ComponentPath componentPath;
        final Optional<Resolver> parentResolver;
        final ComponentDescriptor componentDescriptor;
        final ComponentDeclarations declarations;
        final Map<Key, ResolvedBindings> resolvedContributionBindings = new LinkedHashMap<Key, ResolvedBindings>();
        final Map<Key, ResolvedBindings> resolvedMembersInjectionBindings = new LinkedHashMap<Key, ResolvedBindings>();
        final Deque<Key> cycleStack = new ArrayDeque<Key>();
        final Map<Key, Boolean> keyDependsOnLocalBindingsCache = new HashMap<Key, Boolean>();
        final Map<Binding, Boolean> bindingDependsOnLocalBindingsCache = new HashMap<Binding, Boolean>();
        final Queue<ComponentDescriptor> subcomponentsToResolve = new ArrayDeque<ComponentDescriptor>();

        Resolver(Optional<Resolver> parentResolver, ComponentDescriptor componentDescriptor) {
            this.parentResolver = parentResolver;
            this.componentDescriptor = (ComponentDescriptor)Preconditions.checkNotNull((Object)componentDescriptor);
            DaggerTypeElement componentType = DaggerTypeElement.from(componentDescriptor.typeElement());
            this.componentPath = parentResolver.isPresent() ? parentResolver.get().componentPath.childPath(componentType) : ComponentPath.create((Iterable<DaggerTypeElement>)ImmutableList.of((Object)componentType));
            this.declarations = BindingGraphFactory.this.componentDeclarationsFactory.create(parentResolver.map(parent -> parent.componentDescriptor), componentDescriptor);
            this.subcomponentsToResolve.addAll((Collection<ComponentDescriptor>)componentDescriptor.childComponentsDeclaredByFactoryMethods().values());
            this.subcomponentsToResolve.addAll((Collection<ComponentDescriptor>)componentDescriptor.childComponentsDeclaredByBuilderEntryPoints().values());
        }

        ResolvedBindings lookUpBindings(Key requestKey) {
            LinkedHashSet<ContributionBinding> bindings = new LinkedHashSet<ContributionBinding>();
            LinkedHashSet<ContributionBinding> multibindingContributions = new LinkedHashSet<ContributionBinding>();
            LinkedHashSet<MultibindingDeclaration> multibindingDeclarations = new LinkedHashSet<MultibindingDeclaration>();
            LinkedHashSet optionalBindingDeclarations = new LinkedHashSet();
            LinkedHashSet<SubcomponentDeclaration> subcomponentDeclarations = new LinkedHashSet<SubcomponentDeclaration>();
            ImmutableSet<Key> multibindingKeysMatchingRequest = this.multibindingKeysMatchingRequest(requestKey);
            for (Resolver resolver : this.getResolverLineage()) {
                bindings.addAll((Collection<ContributionBinding>)resolver.getLocalExplicitBindings(requestKey));
                subcomponentDeclarations.addAll((Collection<SubcomponentDeclaration>)resolver.declarations.subcomponents(requestKey));
                BindingGraphFactory.this.keyFactory.unwrapOptional(requestKey).map(resolver.declarations::optionalBindings).ifPresent(optionalBindingDeclarations::addAll);
                for (Key key : multibindingKeysMatchingRequest) {
                    multibindingContributions.addAll((Collection<ContributionBinding>)resolver.getLocalMultibindingContributions(key));
                    multibindingDeclarations.addAll((Collection<MultibindingDeclaration>)resolver.declarations.multibindings(key));
                }
            }
            if (!multibindingContributions.isEmpty() || !multibindingDeclarations.isEmpty()) {
                if (MapType.isMap(requestKey)) {
                    bindings.add(BindingGraphFactory.this.bindingFactory.multiboundMap(requestKey, multibindingContributions));
                } else if (SetType.isSet(requestKey)) {
                    bindings.add(BindingGraphFactory.this.bindingFactory.multiboundSet(requestKey, multibindingContributions));
                } else {
                    throw new AssertionError((Object)("Unexpected type in multibinding key: " + requestKey));
                }
            }
            if (!optionalBindingDeclarations.isEmpty()) {
                bindings.add(BindingGraphFactory.this.bindingFactory.syntheticOptionalBinding(requestKey, RequestKinds.getRequestKind(OptionalType.from(requestKey).valueType()), (ImmutableCollection<? extends Binding>)this.lookUpBindings(BindingGraphFactory.this.keyFactory.unwrapOptional(requestKey).get()).bindings()));
            }
            if (!subcomponentDeclarations.isEmpty()) {
                SubcomponentCreatorBinding binding2 = BindingGraphFactory.this.bindingFactory.subcomponentCreatorBinding((ImmutableSet<SubcomponentDeclaration>)ImmutableSet.copyOf(subcomponentDeclarations));
                bindings.add(binding2);
                this.addSubcomponentToOwningResolver(binding2);
            }
            if (XTypes.isTypeOf(requestKey.type().xprocessing(), TypeNames.MEMBERS_INJECTOR)) {
                BindingGraphFactory.this.injectBindingRegistry.getOrFindMembersInjectorBinding(requestKey).ifPresent(bindings::add);
            }
            if (XTypes.isDeclared(requestKey.type().xprocessing()) && AssistedInjectionAnnotations.isAssistedFactoryType((XElement)requestKey.type().xprocessing().getTypeElement())) {
                bindings.add(BindingGraphFactory.this.bindingFactory.assistedFactoryBinding(requestKey.type().xprocessing().getTypeElement(), Optional.of(requestKey.type().xprocessing())));
            }
            if (bindings.isEmpty()) {
                BindingGraphFactory.this.injectBindingRegistry.getOrFindInjectionBinding(requestKey).filter(this::isCorrectlyScopedInSubcomponent).ifPresent(bindings::add);
            }
            return ResolvedBindings.create(requestKey, (ImmutableSet<BindingNode>)((ImmutableSet)bindings.stream().map(binding -> BindingGraphFactory.this.bindingNodeFactory.forContributionBindings(this.getOwningComponentPath(requestKey, (ContributionBinding)binding), (ContributionBinding)binding, (Iterable<MultibindingDeclaration>)multibindingDeclarations, optionalBindingDeclarations, (Iterable<SubcomponentDeclaration>)subcomponentDeclarations)).collect(DaggerStreams.toImmutableSet())));
        }

        private boolean isCorrectlyScopedInSubcomponent(ContributionBinding binding) {
            Preconditions.checkArgument((binding.kind() == BindingKind.INJECTION || binding.kind() == BindingKind.ASSISTED_INJECTION ? 1 : 0) != 0);
            if (!this.rootComponent().isSubcomponent() || !binding.scope().isPresent() || binding.scope().get().isReusable()) {
                return true;
            }
            Resolver owningResolver = this.getOwningResolver(binding).orElse(this);
            ComponentDescriptor owningComponent = owningResolver.componentDescriptor;
            return owningComponent.scopes().contains((Object)binding.scope().get());
        }

        private ComponentDescriptor rootComponent() {
            return this.parentResolver.map(Resolver::rootComponent).orElse(this.componentDescriptor);
        }

        ResolvedBindings lookUpMembersInjectionBinding(Key requestKey) {
            Optional<MembersInjectionBinding> binding = BindingGraphFactory.this.injectBindingRegistry.getOrFindMembersInjectionBinding(requestKey);
            return binding.isPresent() ? ResolvedBindings.create(requestKey, BindingGraphFactory.this.bindingNodeFactory.forMembersInjectionBinding(this.componentPath, binding.get())) : ResolvedBindings.create(requestKey);
        }

        private void addSubcomponentToOwningResolver(ContributionBinding subcomponentCreatorBinding) {
            Preconditions.checkArgument((boolean)subcomponentCreatorBinding.kind().equals((Object)BindingKind.SUBCOMPONENT_CREATOR));
            Resolver owningResolver = this.getOwningResolver(subcomponentCreatorBinding).get();
            XTypeElement builderType = subcomponentCreatorBinding.key().type().xprocessing().getTypeElement();
            owningResolver.subcomponentsToResolve.add(owningResolver.componentDescriptor.getChildComponentWithBuilderType(builderType));
        }

        private ImmutableSet<Key> multibindingKeysMatchingRequest(Key requestKey) {
            return BindingGraphFactory.this.keysMatchingRequestCache.computeIfAbsent(requestKey, this::multibindingKeysMatchingRequestUncached);
        }

        private ImmutableSet<Key> multibindingKeysMatchingRequestUncached(Key requestKey) {
            ImmutableSet.Builder keys = ImmutableSet.builder();
            keys.add((Object)requestKey);
            BindingGraphFactory.this.keyFactory.unwrapSetKey(requestKey, TypeNames.PRODUCED).ifPresent(arg_0 -> ((ImmutableSet.Builder)keys).add(arg_0));
            BindingGraphFactory.this.keyFactory.rewrapMapKey(requestKey, TypeNames.PRODUCER, TypeNames.PROVIDER).ifPresent(arg_0 -> ((ImmutableSet.Builder)keys).add(arg_0));
            BindingGraphFactory.this.keyFactory.rewrapMapKey(requestKey, TypeNames.PROVIDER, TypeNames.PRODUCER).ifPresent(arg_0 -> ((ImmutableSet.Builder)keys).add(arg_0));
            keys.addAll(BindingGraphFactory.this.keyFactory.implicitFrameworkMapKeys(requestKey));
            return keys.build();
        }

        private ImmutableSet<ContributionBinding> createDelegateBindings(ImmutableSet<DelegateDeclaration> delegateDeclarations) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (DelegateDeclaration delegateDeclaration : delegateDeclarations) {
                builder.add((Object)this.createDelegateBinding(delegateDeclaration));
            }
            return builder.build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ContributionBinding createDelegateBinding(DelegateDeclaration delegateDeclaration) {
            ResolvedBindings resolvedDelegate;
            Key delegateKey = delegateDeclaration.delegateRequest().key();
            if (this.cycleStack.contains(delegateKey)) {
                return BindingGraphFactory.this.bindingFactory.unresolvedDelegateBinding(delegateDeclaration);
            }
            try {
                this.cycleStack.push(delegateKey);
                resolvedDelegate = this.lookUpBindings(delegateKey);
            }
            finally {
                this.cycleStack.pop();
            }
            if (resolvedDelegate.bindings().isEmpty()) {
                return BindingGraphFactory.this.bindingFactory.unresolvedDelegateBinding(delegateDeclaration);
            }
            ContributionBinding explicitDelegate = (ContributionBinding)resolvedDelegate.bindings().iterator().next();
            return BindingGraphFactory.this.bindingFactory.delegateBinding(delegateDeclaration, explicitDelegate);
        }

        private ComponentPath getOwningComponentPath(Key requestKey, ContributionBinding binding) {
            if (this.isResolvedInParent(requestKey, binding) && !this.requiresResolution(binding)) {
                ResolvedBindings parentResolvedBindings = this.parentResolver.get().resolvedContributionBindings.get(requestKey);
                return parentResolvedBindings.forBinding(binding).componentPath();
            }
            return this.componentPath;
        }

        private boolean isResolvedInParent(Key requestKey, ContributionBinding binding) {
            Optional<Resolver> owningResolver = this.getOwningResolver(binding);
            if (owningResolver.isPresent() && !owningResolver.get().equals(this)) {
                this.parentResolver.get().resolve(requestKey);
                return true;
            }
            return false;
        }

        private Optional<Resolver> getOwningResolver(ContributionBinding binding) {
            if (binding.scope().isPresent() && binding.scope().get().isProductionScope() || binding.bindingType().equals((Object)BindingType.PRODUCTION)) {
                for (Resolver requestResolver : this.getResolverLineage()) {
                    if (binding.kind().equals((Object)BindingKind.INJECTION) && requestResolver.componentDescriptor.isProduction()) {
                        return Optional.of(requestResolver);
                    }
                    if (!requestResolver.containsExplicitBinding(binding)) continue;
                    return Optional.of(requestResolver);
                }
            }
            if (binding.scope().isPresent() && binding.scope().get().isReusable()) {
                for (Resolver requestResolver : this.getResolverLineage().reverse()) {
                    ResolvedBindings resolvedBindings = requestResolver.resolvedContributionBindings.get(binding.key());
                    if (resolvedBindings == null || !resolvedBindings.bindings().contains((Object)binding)) continue;
                    return Optional.of(requestResolver);
                }
                return Optional.empty();
            }
            for (Resolver requestResolver : this.getResolverLineage().reverse()) {
                if (!requestResolver.containsExplicitBinding(binding)) continue;
                return Optional.of(requestResolver);
            }
            Optional<Scope> bindingScope = binding.scope();
            if (bindingScope.isPresent()) {
                for (Resolver requestResolver : this.getResolverLineage().reverse()) {
                    if (!requestResolver.componentDescriptor.scopes().contains((Object)bindingScope.get())) continue;
                    return Optional.of(requestResolver);
                }
            }
            return Optional.empty();
        }

        private boolean containsExplicitBinding(ContributionBinding binding) {
            return this.declarations.bindings(binding.key()).contains((Object)binding) || this.resolverContainsDelegateDeclarationForBinding(binding) || !this.declarations.subcomponents(binding.key()).isEmpty();
        }

        private boolean resolverContainsDelegateDeclarationForBinding(ContributionBinding binding) {
            if (!binding.kind().equals((Object)BindingKind.DELEGATE)) {
                return false;
            }
            Key bindingKey = binding.key();
            if (BindingGraphFactory.this.compilerOptions.strictMultibindingValidation() && binding.contributionType().equals((Object)ContributionType.MAP)) {
                bindingKey = BindingGraphFactory.this.keyFactory.unwrapMapValueType(bindingKey);
            }
            return this.declarations.delegates(bindingKey).stream().anyMatch(declaration -> declaration.contributingModule().equals(binding.contributingModule()) && declaration.bindingElement().equals(binding.bindingElement()));
        }

        private ImmutableList<Resolver> getResolverLineage() {
            ImmutableList.Builder resolverList = ImmutableList.builder();
            Optional<Resolver> currentResolver = Optional.of(this);
            while (currentResolver.isPresent()) {
                resolverList.add((Object)currentResolver.get());
                currentResolver = currentResolver.get().parentResolver;
            }
            return resolverList.build().reverse();
        }

        private ImmutableSet<ContributionBinding> getLocalExplicitBindings(Key key) {
            return ImmutableSet.builder().addAll(this.declarations.bindings(key)).addAll(this.createDelegateBindings(this.declarations.delegates(BindingGraphFactory.this.keyFactory.unwrapMapValueType(key)))).build();
        }

        private ImmutableSet<ContributionBinding> getLocalMultibindingContributions(Key key) {
            return ImmutableSet.builder().addAll(this.declarations.multibindingContributions(key)).addAll(this.createDelegateBindings(this.declarations.delegateMultibindingContributions(BindingGraphFactory.this.keyFactory.unwrapMapValueType(key)))).build();
        }

        private ImmutableSet<OptionalBindingDeclaration> getOptionalBindingDeclarations(Key key) {
            Optional<Key> unwrapped = BindingGraphFactory.this.keyFactory.unwrapOptional(key);
            if (unwrapped.isEmpty()) {
                return ImmutableSet.of();
            }
            ImmutableSet.Builder declarations = ImmutableSet.builder();
            for (Resolver resolver : this.getResolverLineage()) {
                declarations.addAll(resolver.declarations.optionalBindings(unwrapped.get()));
            }
            return declarations.build();
        }

        private Optional<ResolvedBindings> getPreviouslyResolvedBindings(Key key) {
            Optional<ResolvedBindings> result = Optional.ofNullable(this.resolvedContributionBindings.get(key));
            if (result.isPresent()) {
                return result;
            }
            if (this.parentResolver.isPresent()) {
                return this.parentResolver.get().getPreviouslyResolvedBindings(key);
            }
            return Optional.empty();
        }

        private void resolveMembersInjection(Key key) {
            ResolvedBindings bindings = this.lookUpMembersInjectionBinding(key);
            this.resolveDependencies(bindings);
            this.resolvedMembersInjectionBindings.put(key, bindings);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void resolve(Key key) {
            if (this.cycleStack.contains(key)) {
                return;
            }
            if (this.resolvedContributionBindings.containsKey(key)) {
                return;
            }
            if (this.getPreviouslyResolvedBindings(key).isPresent() && !Keys.isComponentOrCreator(key)) {
                this.parentResolver.get().resolve(key);
                ResolvedBindings previouslyResolvedBindings = this.getPreviouslyResolvedBindings(key).get();
                boolean isAssistedInjectionBinding = previouslyResolvedBindings.bindings().stream().anyMatch(binding -> binding.kind() == BindingKind.ASSISTED_INJECTION);
                if (!(isAssistedInjectionBinding || this.requiresResolution(key) || this.hasLocalExplicitBindings(key))) {
                    this.resolvedContributionBindings.put(key, previouslyResolvedBindings);
                    return;
                }
            }
            this.cycleStack.push(key);
            try {
                ResolvedBindings bindings = this.lookUpBindings(key);
                this.resolvedContributionBindings.put(key, bindings);
                this.resolveDependencies(bindings);
            }
            finally {
                this.cycleStack.pop();
            }
        }

        private void resolveDependencies(ResolvedBindings resolvedBindings) {
            for (BindingNode binding : resolvedBindings.bindingNodesOwnedBy(this.componentPath)) {
                for (DependencyRequest dependency : binding.dependencies()) {
                    this.resolve(dependency.key());
                }
            }
        }

        private ResolvedBindings getResolvedContributionBindings(Key key) {
            if (this.resolvedContributionBindings.containsKey(key)) {
                return this.resolvedContributionBindings.get(key);
            }
            if (this.parentResolver.isPresent()) {
                return this.parentResolver.get().getResolvedContributionBindings(key);
            }
            throw new AssertionError((Object)("No resolved bindings for key: " + key));
        }

        private ResolvedBindings getResolvedMembersInjectionBindings(Key key) {
            return this.resolvedMembersInjectionBindings.get(key);
        }

        private boolean requiresResolution(Key key) {
            return new LegacyRequiresResolutionChecker().requiresResolution(key);
        }

        private boolean requiresResolution(Binding binding) {
            return new LegacyRequiresResolutionChecker().requiresResolution(binding);
        }

        private boolean hasLocalBindings(Binding binding) {
            return this.hasLocalMultibindingContributions(binding.key()) || this.hasLocalOptionalBindingContribution(binding.key(), (ImmutableSet<? extends Binding>)ImmutableSet.of((Object)((ContributionBinding)binding)));
        }

        private boolean hasLocalBindings(ResolvedBindings resolvedBindings) {
            return this.hasLocalMultibindingContributions(resolvedBindings.key()) || this.hasLocalOptionalBindingContribution(resolvedBindings);
        }

        private boolean hasLocalMultibindingContributions(Key requestKey) {
            return this.multibindingKeysMatchingRequest(requestKey).stream().anyMatch(multibindingKey -> !this.declarations.multibindingContributions((Key)multibindingKey).isEmpty() || !this.declarations.delegateMultibindingContributions(BindingGraphFactory.this.keyFactory.unwrapMapValueType((Key)multibindingKey)).isEmpty());
        }

        private boolean hasLocalOptionalBindingContribution(ResolvedBindings resolvedBindings) {
            return this.hasLocalOptionalBindingContribution(resolvedBindings.key(), resolvedBindings.bindings());
        }

        private boolean hasLocalOptionalBindingContribution(Key key, ImmutableSet<? extends Binding> previouslyResolvedBindings) {
            if (previouslyResolvedBindings.stream().map(Binding::kind).anyMatch(Predicate.isEqual((Object)BindingKind.OPTIONAL))) {
                return this.hasLocalExplicitBindings(BindingGraphFactory.this.keyFactory.unwrapOptional(key).get());
            }
            return !this.getOptionalBindingDeclarations(key).isEmpty();
        }

        private boolean hasLocalExplicitBindings(Key requestKey) {
            return !this.declarations.bindings(requestKey).isEmpty() || !this.declarations.delegates(BindingGraphFactory.this.keyFactory.unwrapMapValueType(requestKey)).isEmpty();
        }

        private final class LegacyRequiresResolutionChecker {
            private final Set<Object> cycleChecker = new HashSet<Object>();

            private LegacyRequiresResolutionChecker() {
            }

            private boolean requiresResolution(Key key) {
                if (!this.cycleChecker.add(key)) {
                    return false;
                }
                return Util.reentrantComputeIfAbsent(Resolver.this.keyDependsOnLocalBindingsCache, key, this::requiresResolutionUncached);
            }

            private boolean requiresResolution(Binding binding) {
                if (!this.cycleChecker.add(binding)) {
                    return false;
                }
                return Util.reentrantComputeIfAbsent(Resolver.this.bindingDependsOnLocalBindingsCache, binding, this::requiresResolutionUncached);
            }

            private boolean requiresResolutionUncached(Key key) {
                Preconditions.checkArgument((boolean)Resolver.this.getPreviouslyResolvedBindings(key).isPresent(), (String)"no previously resolved bindings in %s for %s", (Object)Resolver.this, (Object)key);
                ResolvedBindings previouslyResolvedBindings = (ResolvedBindings)Resolver.this.getPreviouslyResolvedBindings(key).get();
                if (Resolver.this.hasLocalBindings(previouslyResolvedBindings)) {
                    return true;
                }
                for (Binding binding : previouslyResolvedBindings.bindings()) {
                    if (!this.requiresResolution(binding)) continue;
                    return true;
                }
                return false;
            }

            private boolean requiresResolutionUncached(Binding binding) {
                if (!(binding.scope().isPresent() && !binding.scope().get().isReusable() || binding.bindingType().equals((Object)BindingType.PRODUCTION))) {
                    for (DependencyRequest dependency : binding.dependencies()) {
                        if (!this.requiresResolution(dependency.key())) continue;
                        return true;
                    }
                }
                return false;
            }
        }
    }
}

