/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentMethodRequestRepresentation;
import dagger.internal.codegen.writing.ImmediateFutureRequestRepresentation;
import dagger.internal.codegen.writing.MethodRequestRepresentation;
import dagger.internal.codegen.writing.PrivateMethodRequestRepresentation;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.writing.UnscopedDirectInstanceRequestRepresentationFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

final class DirectInstanceBindingRepresentation {
    private final ContributionBinding binding;
    private final BindingGraph graph;
    private final ComponentImplementation componentImplementation;
    private final ComponentMethodRequestRepresentation.Factory componentMethodRequestRepresentationFactory;
    private final ImmediateFutureRequestRepresentation.Factory immediateFutureRequestRepresentationFactory;
    private final PrivateMethodRequestRepresentation.Factory privateMethodRequestRepresentationFactory;
    private final UnscopedDirectInstanceRequestRepresentationFactory unscopedDirectInstanceRequestRepresentationFactory;
    private final Map<BindingRequest, RequestRepresentation> requestRepresentations = new HashMap<BindingRequest, RequestRepresentation>();

    @AssistedInject
    DirectInstanceBindingRepresentation(@Assisted ContributionBinding binding, BindingGraph graph, ComponentImplementation componentImplementation, ComponentMethodRequestRepresentation.Factory componentMethodRequestRepresentationFactory, ImmediateFutureRequestRepresentation.Factory immediateFutureRequestRepresentationFactory, PrivateMethodRequestRepresentation.Factory privateMethodRequestRepresentationFactory, UnscopedDirectInstanceRequestRepresentationFactory unscopedDirectInstanceRequestRepresentationFactory) {
        this.binding = binding;
        this.graph = graph;
        this.componentImplementation = componentImplementation;
        this.componentMethodRequestRepresentationFactory = componentMethodRequestRepresentationFactory;
        this.immediateFutureRequestRepresentationFactory = immediateFutureRequestRepresentationFactory;
        this.privateMethodRequestRepresentationFactory = privateMethodRequestRepresentationFactory;
        this.unscopedDirectInstanceRequestRepresentationFactory = unscopedDirectInstanceRequestRepresentationFactory;
    }

    public RequestRepresentation getRequestRepresentation(BindingRequest request) {
        return Util.reentrantComputeIfAbsent(this.requestRepresentations, request, this::getRequestRepresentationUncached);
    }

    private RequestRepresentation getRequestRepresentationUncached(BindingRequest request) {
        switch (request.requestKind()) {
            case INSTANCE: {
                return DirectInstanceBindingRepresentation.requiresMethodEncapsulation(this.binding) ? this.wrapInMethod(this.unscopedDirectInstanceRequestRepresentationFactory.create(this.binding)) : this.unscopedDirectInstanceRequestRepresentationFactory.create(this.binding);
            }
            case FUTURE: {
                return this.immediateFutureRequestRepresentationFactory.create(this.getRequestRepresentation(BindingRequest.bindingRequest(this.binding.key(), RequestKind.INSTANCE)), this.binding.key().type().xprocessing());
            }
        }
        throw new AssertionError((Object)String.format("Invalid binding request kind: %s", new Object[]{request.requestKind()}));
    }

    RequestRepresentation wrapInMethod(RequestRepresentation bindingExpression) {
        if (bindingExpression instanceof MethodRequestRepresentation) {
            return bindingExpression;
        }
        BindingRequest request = BindingRequest.bindingRequest(this.binding.key(), RequestKind.INSTANCE);
        Optional<ComponentDescriptor.ComponentMethodDescriptor> matchingComponentMethod = this.graph.componentDescriptor().firstMatchingComponentMethod(request);
        ComponentImplementation.ShardImplementation shardImplementation = this.componentImplementation.shardImplementation(this.binding);
        if (matchingComponentMethod.isPresent() && shardImplementation.isComponentShard()) {
            ComponentDescriptor.ComponentMethodDescriptor componentMethod = matchingComponentMethod.get();
            return this.componentMethodRequestRepresentationFactory.create(bindingExpression, componentMethod);
        }
        return this.privateMethodRequestRepresentationFactory.create(request, this.binding, bindingExpression);
    }

    private static boolean requiresMethodEncapsulation(ContributionBinding binding) {
        switch (binding.kind()) {
            case COMPONENT: 
            case COMPONENT_PROVISION: 
            case SUBCOMPONENT_CREATOR: 
            case COMPONENT_DEPENDENCY: 
            case MULTIBOUND_SET: 
            case MULTIBOUND_MAP: 
            case BOUND_INSTANCE: 
            case ASSISTED_FACTORY: 
            case ASSISTED_INJECTION: 
            case INJECTION: 
            case PROVISION: {
                return !binding.dependencies().isEmpty();
            }
            case MEMBERS_INJECTOR: 
            case PRODUCTION: 
            case COMPONENT_PRODUCTION: 
            case OPTIONAL: 
            case DELEGATE: 
            case MEMBERS_INJECTION: {
                return false;
            }
        }
        throw new AssertionError((Object)String.format("No such binding kind: %s", new Object[]{binding.kind()}));
    }

    @AssistedFactory
    static interface Factory {
        public DirectInstanceBindingRepresentation create(ContributionBinding var1);
    }
}

