/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.writing.MemberSelect;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import java.util.Collection;

final class StaticMemberSelects {
    static MemberSelect emptyMapFactory(Binding binding) {
        BindingType bindingType = binding.bindingType();
        ImmutableList typeParameters = ImmutableList.copyOf((Collection)binding.key().type().xprocessing().getTypeArguments());
        return bindingType.equals((Object)BindingType.PRODUCTION) ? new ParameterizedStaticMethod(TypeNames.PRODUCERS, (ImmutableList<XType>)typeParameters, CodeBlock.of((String)"emptyMapProducer()", (Object[])new Object[0]), TypeNames.PRODUCER) : new ParameterizedStaticMethod(TypeNames.MAP_FACTORY, (ImmutableList<XType>)typeParameters, CodeBlock.of((String)"emptyMapProvider()", (Object[])new Object[0]), TypeNames.DAGGER_PROVIDER);
    }

    static MemberSelect emptySetFactory(ContributionBinding binding) {
        return new ParameterizedStaticMethod(SourceFiles.setFactoryClassName(binding), (ImmutableList<XType>)ImmutableList.of((Object)SetType.from(binding.key()).elementType()), CodeBlock.of((String)"empty()", (Object[])new Object[0]), TypeNames.FACTORY);
    }

    static MemberSelect factoryCreateNoArgumentMethod(Binding binding) {
        ImmutableList<TypeVariableName> typeVariables;
        Preconditions.checkArgument((boolean)binding.bindingType().equals((Object)BindingType.PROVISION), (String)"Invalid binding type: %s", (Object)((Object)binding.bindingType()));
        Preconditions.checkArgument((binding.dependencies().isEmpty() && !binding.scope().isPresent() ? 1 : 0) != 0, (String)"%s should have no dependencies and be unscoped to create a no argument factory.", (Object)binding);
        ClassName factoryName = SourceFiles.generatedClassNameForBinding(binding);
        XType keyType = binding.key().type().xprocessing();
        if (XTypes.isDeclared(keyType) && !(typeVariables = SourceFiles.bindingTypeElementTypeVariableNames(binding)).isEmpty()) {
            ImmutableList typeArguments = ImmutableList.copyOf((Collection)keyType.getTypeArguments());
            return new ParameterizedStaticMethod(factoryName, (ImmutableList<XType>)typeArguments, CodeBlock.of((String)"create()", (Object[])new Object[0]), TypeNames.FACTORY);
        }
        return new StaticMethod(factoryName, CodeBlock.of((String)"create()", (Object[])new Object[0]));
    }

    private StaticMemberSelects() {
    }

    private static final class ParameterizedStaticMethod
    extends MemberSelect {
        private final ImmutableList<XType> typeParameters;
        private final CodeBlock methodCodeBlock;
        private final ClassName rawReturnType;

        ParameterizedStaticMethod(ClassName owningClass, ImmutableList<XType> typeParameters, CodeBlock methodCodeBlock, ClassName rawReturnType) {
            super(owningClass, true);
            this.typeParameters = typeParameters;
            this.methodCodeBlock = methodCodeBlock;
            this.rawReturnType = rawReturnType;
        }

        @Override
        CodeBlock getExpressionFor(ClassName usingClass) {
            boolean isAccessible = this.typeParameters.stream().allMatch(t -> Accessibility.isTypeAccessibleFrom(t, usingClass.packageName()));
            if (isAccessible) {
                return CodeBlock.of((String)"$T.<$L>$L", (Object[])new Object[]{this.owningClass(), this.typeParameters.stream().map(CodeBlocks::type).collect(CodeBlocks.toParametersCodeBlock()), this.methodCodeBlock});
            }
            return CodeBlock.of((String)"(($T) $T.$L)", (Object[])new Object[]{this.rawReturnType, this.owningClass(), this.methodCodeBlock});
        }
    }

    private static final class StaticMethod
    extends MemberSelect {
        private final CodeBlock methodCodeBlock;

        StaticMethod(ClassName owningClass, CodeBlock methodCodeBlock) {
            super(owningClass, true);
            this.methodCodeBlock = (CodeBlock)Preconditions.checkNotNull((Object)methodCodeBlock);
        }

        @Override
        CodeBlock getExpressionFor(ClassName usingClass) {
            return this.owningClass().equals((Object)usingClass) ? this.methodCodeBlock : CodeBlock.of((String)"$T.$L", (Object[])new Object[]{this.owningClass(), this.methodCodeBlock});
        }
    }
}

