/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.processing.SymbolProcessorEnvironment;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import com.google.devtools.ksp.symbol.KSPropertyDeclaration;
import com.google.devtools.ksp.symbol.KSType;
import com.google.devtools.ksp.symbol.KSValueParameter;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.model.DaggerElement;
import dagger.spi.model.DaggerProcessingEnv;
import dagger.spi.model.DaggerType;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;

public final class DaggerElements {
    public static XElement toXProcessing(DaggerElement element, DaggerProcessingEnv daggerProcessingEnv) {
        XProcessingEnv processingEnv = DaggerElements.toXProcessing(daggerProcessingEnv);
        switch (element.backend()) {
            case JAVAC: {
                return XConverters.toXProcessing((Element)element.javac(), (XProcessingEnv)processingEnv);
            }
            case KSP: {
                if (element.ksp() instanceof KSFunctionDeclaration) {
                    return XConverters.toXProcessing((KSFunctionDeclaration)((KSFunctionDeclaration)element.ksp()), (XProcessingEnv)processingEnv);
                }
                if (element.ksp() instanceof KSClassDeclaration) {
                    return XConverters.toXProcessing((KSClassDeclaration)((KSClassDeclaration)element.ksp()), (XProcessingEnv)processingEnv);
                }
                if (element.ksp() instanceof KSValueParameter) {
                    return XConverters.toXProcessing((KSValueParameter)((KSValueParameter)element.ksp()), (XProcessingEnv)processingEnv);
                }
                if (element.ksp() instanceof KSPropertyDeclaration) {
                    return XConverters.toXProcessing((KSPropertyDeclaration)((KSPropertyDeclaration)element.ksp()), (XProcessingEnv)processingEnv);
                }
                throw new IllegalStateException(String.format("Unsupported ksp declaration %s.", element.ksp()));
            }
        }
        throw new IllegalStateException(String.format("Backend %s not supported yet.", element.backend()));
    }

    public static XType toXProcessing(DaggerType type, DaggerProcessingEnv daggerProcessingEnv) {
        XProcessingEnv processingEnv = DaggerElements.toXProcessing(daggerProcessingEnv);
        switch (type.backend()) {
            case JAVAC: {
                return XConverters.toXProcessing((TypeMirror)type.javac(), (XProcessingEnv)processingEnv);
            }
            case KSP: {
                return XConverters.toXProcessing((KSType)type.ksp(), (XProcessingEnv)processingEnv);
            }
        }
        throw new IllegalStateException(String.format("Backend %s not supported yet.", type.backend()));
    }

    public static XProcessingEnv toXProcessing(DaggerProcessingEnv processingEnv) {
        switch (processingEnv.backend()) {
            case JAVAC: {
                return XProcessingEnv.create((ProcessingEnvironment)processingEnv.javac());
            }
            case KSP: {
                return XProcessingEnv.create((SymbolProcessorEnvironment)processingEnv.ksp(), (Resolver)processingEnv.resolver());
            }
        }
        throw new IllegalStateException(String.format("Backend %s not supported yet.", processingEnv.backend()));
    }

    private DaggerElements() {
    }
}

