/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.AutoValue_MapType;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;

@AutoValue
public abstract class MapType {
    public static final ImmutableSet<RequestKind> VALID_FRAMEWORK_REQUEST_KINDS = ImmutableSet.of((Object)((Object)RequestKind.PROVIDER), (Object)((Object)RequestKind.PRODUCER), (Object)((Object)RequestKind.PRODUCED));
    private XType type;

    abstract TypeName typeName();

    private XType type() {
        return this.type;
    }

    public boolean isRawType() {
        return XTypes.isRawParameterizedType(this.type());
    }

    public XType keyType() {
        Preconditions.checkState((!this.isRawType() ? 1 : 0) != 0);
        return (XType)this.type().getTypeArguments().get(0);
    }

    public XType valueType() {
        Preconditions.checkState((!this.isRawType() ? 1 : 0) != 0);
        return (XType)this.type().getTypeArguments().get(1);
    }

    public boolean valuesAreTypeOf(ClassName className) {
        return !this.isRawType() && XTypes.isTypeOf(this.valueType(), className);
    }

    public boolean valuesAreFrameworkType() {
        return this.valueRequestKind() != RequestKind.INSTANCE;
    }

    public XType unwrappedFrameworkValueType() {
        return this.valuesAreFrameworkType() ? XTypes.unwrapType(this.valueType()) : this.valueType();
    }

    public RequestKind valueRequestKind() {
        Preconditions.checkArgument((!this.isRawType() ? 1 : 0) != 0);
        for (RequestKind frameworkRequestKind : VALID_FRAMEWORK_REQUEST_KINDS) {
            if (!this.valuesAreTypeOf(RequestKinds.frameworkClassName(frameworkRequestKind))) continue;
            return frameworkRequestKind;
        }
        return RequestKind.INSTANCE;
    }

    public static boolean isMap(XType type) {
        return XTypes.isTypeOf(type, TypeNames.MAP);
    }

    public static boolean isMap(Key key) {
        return MapType.isMap(key.type().xprocessing());
    }

    public static boolean isMapOfProvider(XType keyType) {
        if (MapType.isMap(keyType)) {
            return MapType.from(keyType).valuesAreTypeOf(TypeNames.PROVIDER);
        }
        return false;
    }

    public static MapType from(XType type) {
        Preconditions.checkArgument((boolean)MapType.isMap(type), (String)"%s is not a Map", (Object)type);
        AutoValue_MapType mapType = new AutoValue_MapType(type.getTypeName());
        mapType.type = type;
        return mapType;
    }

    public static MapType from(Key key) {
        return MapType.from(key.type().xprocessing());
    }
}

