/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.graph.Graph;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dagger.internal.codegen.base.Keys;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.base.TarjanSCCs;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingFactory;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingGraphTransformations;
import dagger.internal.codegen.binding.BindingNode;
import dagger.internal.codegen.binding.ChildFactoryMethodEdgeImpl;
import dagger.internal.codegen.binding.ComponentDeclarations;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentNodeImpl;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.DelegateDeclaration;
import dagger.internal.codegen.binding.DependencyEdgeImpl;
import dagger.internal.codegen.binding.InjectBindingRegistry;
import dagger.internal.codegen.binding.KeyFactory;
import dagger.internal.codegen.binding.LegacyBindingGraphFactory;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.MissingBindingImpl;
import dagger.internal.codegen.binding.MultibindingDeclaration;
import dagger.internal.codegen.binding.OptionalBindingDeclaration;
import dagger.internal.codegen.binding.ResolvedBindings;
import dagger.internal.codegen.binding.SubcomponentCreatorBinding;
import dagger.internal.codegen.binding.SubcomponentCreatorBindingEdgeImpl;
import dagger.internal.codegen.binding.SubcomponentDeclaration;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.extension.DaggerGraphs;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.model.BindingGraph;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.ComponentPath;
import dagger.internal.codegen.model.DaggerTypeElement;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.model.Scope;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.tools.Diagnostic;

public final class BindingGraphFactory {
    private final LegacyBindingGraphFactory legacyBindingGraphFactory;
    private final InjectBindingRegistry injectBindingRegistry;
    private final KeyFactory keyFactory;
    private final BindingFactory bindingFactory;
    private final BindingNode.Factory bindingNodeFactory;
    private final ComponentDeclarations.Factory componentDeclarationsFactory;
    private final CompilerOptions compilerOptions;

    @Inject
    BindingGraphFactory(LegacyBindingGraphFactory legacyBindingGraphFactory, InjectBindingRegistry injectBindingRegistry, KeyFactory keyFactory, BindingFactory bindingFactory, BindingNode.Factory bindingNodeFactory, ComponentDeclarations.Factory componentDeclarationsFactory, CompilerOptions compilerOptions) {
        this.legacyBindingGraphFactory = legacyBindingGraphFactory;
        this.injectBindingRegistry = injectBindingRegistry;
        this.keyFactory = keyFactory;
        this.bindingFactory = bindingFactory;
        this.bindingNodeFactory = bindingNodeFactory;
        this.componentDeclarationsFactory = componentDeclarationsFactory;
        this.compilerOptions = compilerOptions;
    }

    public BindingGraph create(ComponentDescriptor componentDescriptor, boolean createFullBindingGraph) {
        return LegacyBindingGraphFactory.useLegacyBindingGraphFactory(componentDescriptor) ? this.legacyBindingGraphFactory.create(componentDescriptor, createFullBindingGraph) : this.createBindingGraph(componentDescriptor, createFullBindingGraph);
    }

    private BindingGraph createBindingGraph(ComponentDescriptor componentDescriptor, boolean createFullBindingGraph) {
        Resolver resolver = new Resolver(componentDescriptor);
        resolver.resolve(createFullBindingGraph);
        MutableNetwork<BindingGraph.Node, BindingGraph.Edge> network = resolver.network;
        if (!createFullBindingGraph) {
            DaggerGraphs.unreachableNodes((Graph)network.asGraph(), (Object)resolver.componentNode).forEach(arg_0 -> network.removeNode(arg_0));
        }
        network = BindingGraphTransformations.withFixedBindingTypes(network);
        return BindingGraph.create((ImmutableNetwork<BindingGraph.Node, BindingGraph.Edge>)ImmutableNetwork.copyOf(network), createFullBindingGraph);
    }

    private final class Resolver {
        final ComponentPath componentPath;
        final Optional<Resolver> parentResolver;
        final BindingGraph.ComponentNode componentNode;
        final ComponentDescriptor componentDescriptor;
        final ComponentDeclarations declarations;
        final MutableNetwork<BindingGraph.Node, BindingGraph.Edge> network;
        final Map<Key, ResolvedBindings> resolvedContributionBindings = new LinkedHashMap<Key, ResolvedBindings>();
        final Map<Key, ResolvedBindings> resolvedMembersInjectionBindings = new LinkedHashMap<Key, ResolvedBindings>();
        final RequiresResolutionChecker requiresResolutionChecker = new RequiresResolutionChecker();
        final Queue<ComponentDescriptor> subcomponentsToResolve = new ArrayDeque<ComponentDescriptor>();

        Resolver(ComponentDescriptor componentDescriptor) {
            this(Optional.empty(), componentDescriptor);
        }

        Resolver(Resolver parentResolver, ComponentDescriptor componentDescriptor) {
            this(Optional.of(parentResolver), componentDescriptor);
        }

        private Resolver(Optional<Resolver> parentResolver, ComponentDescriptor componentDescriptor) {
            this.parentResolver = parentResolver;
            this.componentDescriptor = (ComponentDescriptor)Preconditions.checkNotNull((Object)componentDescriptor);
            DaggerTypeElement componentType = DaggerTypeElement.from(componentDescriptor.typeElement());
            this.componentPath = parentResolver.isPresent() ? parentResolver.get().componentPath.childPath(componentType) : ComponentPath.create((Iterable<DaggerTypeElement>)ImmutableList.of((Object)componentType));
            this.componentNode = ComponentNodeImpl.create(this.componentPath, componentDescriptor);
            this.network = parentResolver.isPresent() ? parentResolver.get().network : NetworkBuilder.directed().allowsParallelEdges(true).allowsSelfLoops(true).build();
            this.declarations = BindingGraphFactory.this.componentDeclarationsFactory.create(parentResolver.map(parent -> parent.componentDescriptor), componentDescriptor);
            this.subcomponentsToResolve.addAll((Collection<ComponentDescriptor>)componentDescriptor.childComponentsDeclaredByFactoryMethods().values());
            this.subcomponentsToResolve.addAll((Collection<ComponentDescriptor>)componentDescriptor.childComponentsDeclaredByBuilderEntryPoints().values());
        }

        void resolve(boolean createFullBindingGraph) {
            this.addNode(this.componentNode);
            this.componentDescriptor.entryPointMethods().stream().map(method -> method.dependencyRequest().get()).forEach(entryPoint -> {
                ResolvedBindings resolvedBindings = entryPoint.kind().equals((Object)RequestKind.MEMBERS_INJECTION) ? this.resolveMembersInjectionKey(entryPoint.key()) : this.resolveContributionKey(entryPoint.key());
                this.addDependencyEdges(this.componentNode, resolvedBindings, (DependencyRequest)entryPoint);
            });
            if (createFullBindingGraph) {
                this.declarations.allDeclarations().stream().filter(declaration -> declaration.contributingModule().isPresent()).map(declaration -> declaration instanceof OptionalBindingDeclaration ? BindingGraphFactory.this.keyFactory.optionalOf(declaration.key()) : declaration.key()).map(Key::withoutMultibindingContributionIdentifier).forEach(this::resolveContributionKey);
            }
            HashSet<ComponentDescriptor> resolvedSubcomponents = new HashSet<ComponentDescriptor>();
            for (ComponentDescriptor subcomponent : Iterables.consumingIterable(this.subcomponentsToResolve)) {
                if (!resolvedSubcomponents.add(subcomponent)) continue;
                Resolver subcomponentResolver = new Resolver(this, subcomponent);
                this.addChildFactoryMethodEdge(subcomponentResolver);
                subcomponentResolver.resolve(createFullBindingGraph);
            }
        }

        ResolvedBindings lookUpBindings(Key requestKey) {
            LinkedHashSet<ContributionBinding> bindings = new LinkedHashSet<ContributionBinding>();
            LinkedHashSet<ContributionBinding> multibindingContributions = new LinkedHashSet<ContributionBinding>();
            LinkedHashSet<MultibindingDeclaration> multibindingDeclarations = new LinkedHashSet<MultibindingDeclaration>();
            LinkedHashSet optionalBindingDeclarations = new LinkedHashSet();
            LinkedHashSet<SubcomponentDeclaration> subcomponentDeclarations = new LinkedHashSet<SubcomponentDeclaration>();
            for (Resolver resolver : this.getResolverLineage()) {
                bindings.addAll((Collection<ContributionBinding>)resolver.getLocalExplicitBindings(requestKey));
                multibindingContributions.addAll((Collection<ContributionBinding>)resolver.getLocalMultibindingContributions(requestKey));
                multibindingDeclarations.addAll((Collection<MultibindingDeclaration>)resolver.declarations.multibindings(requestKey));
                subcomponentDeclarations.addAll((Collection<SubcomponentDeclaration>)resolver.declarations.subcomponents(requestKey));
                BindingGraphFactory.this.keyFactory.unwrapOptional(requestKey).map(resolver.declarations::optionalBindings).ifPresent(optionalBindingDeclarations::addAll);
            }
            if (!multibindingContributions.isEmpty() || !multibindingDeclarations.isEmpty()) {
                if (MapType.isMap(requestKey)) {
                    bindings.add(BindingGraphFactory.this.bindingFactory.multiboundMap(requestKey, multibindingContributions));
                } else if (SetType.isSet(requestKey)) {
                    bindings.add(BindingGraphFactory.this.bindingFactory.multiboundSet(requestKey, multibindingContributions));
                } else {
                    throw new AssertionError((Object)("Unexpected type in multibinding key: " + requestKey));
                }
            }
            if (!optionalBindingDeclarations.isEmpty()) {
                ImmutableSet<Binding> optionalContributions = this.lookUpBindings(BindingGraphFactory.this.keyFactory.unwrapOptional(requestKey).get()).bindings();
                bindings.add(optionalContributions.isEmpty() ? BindingGraphFactory.this.bindingFactory.syntheticAbsentOptionalDeclaration(requestKey) : BindingGraphFactory.this.bindingFactory.syntheticPresentOptionalDeclaration(requestKey, (ImmutableCollection<Binding>)optionalContributions));
            }
            if (!subcomponentDeclarations.isEmpty()) {
                SubcomponentCreatorBinding binding2 = BindingGraphFactory.this.bindingFactory.subcomponentCreatorBinding((ImmutableSet<SubcomponentDeclaration>)ImmutableSet.copyOf(subcomponentDeclarations));
                bindings.add(binding2);
                this.addSubcomponentToOwningResolver(binding2);
            }
            if (XTypes.isTypeOf(requestKey.type().xprocessing(), TypeNames.MEMBERS_INJECTOR)) {
                BindingGraphFactory.this.injectBindingRegistry.getOrFindMembersInjectorBinding(requestKey).ifPresent(bindings::add);
            }
            if (XTypes.isDeclared(requestKey.type().xprocessing()) && AssistedInjectionAnnotations.isAssistedFactoryType((XElement)requestKey.type().xprocessing().getTypeElement())) {
                bindings.add(BindingGraphFactory.this.bindingFactory.assistedFactoryBinding(requestKey.type().xprocessing().getTypeElement(), Optional.of(requestKey.type().xprocessing())));
            }
            if (bindings.isEmpty()) {
                BindingGraphFactory.this.injectBindingRegistry.getOrFindInjectionBinding(requestKey).filter(this::isCorrectlyScopedInSubcomponent).ifPresent(bindings::add);
            }
            return ResolvedBindings.create(requestKey, (ImmutableSet<BindingNode>)((ImmutableSet)bindings.stream().map(binding -> {
                Optional<BindingNode> bindingNodeOwnedByAncestor = this.getBindingNodeOwnedByAncestor(requestKey, (ContributionBinding)binding);
                return bindingNodeOwnedByAncestor.isPresent() ? bindingNodeOwnedByAncestor.get() : BindingGraphFactory.this.bindingNodeFactory.forContributionBindings(this.componentPath, (ContributionBinding)binding, (Iterable<MultibindingDeclaration>)multibindingDeclarations, optionalBindingDeclarations, (Iterable<SubcomponentDeclaration>)subcomponentDeclarations);
            }).collect(DaggerStreams.toImmutableSet())));
        }

        private boolean isCorrectlyScopedInSubcomponent(ContributionBinding binding) {
            Preconditions.checkArgument((binding.kind() == BindingKind.INJECTION || binding.kind() == BindingKind.ASSISTED_INJECTION ? 1 : 0) != 0);
            if (!this.rootComponent().isSubcomponent() || !binding.scope().isPresent() || binding.scope().get().isReusable()) {
                return true;
            }
            Resolver owningResolver = this.getOwningResolver(binding).orElse(this);
            ComponentDescriptor owningComponent = owningResolver.componentDescriptor;
            return owningComponent.scopes().contains((Object)binding.scope().get());
        }

        private ComponentDescriptor rootComponent() {
            return this.parentResolver.map(Resolver::rootComponent).orElse(this.componentDescriptor);
        }

        ResolvedBindings lookUpMembersInjectionBinding(Key requestKey) {
            Optional<MembersInjectionBinding> binding = BindingGraphFactory.this.injectBindingRegistry.getOrFindMembersInjectionBinding(requestKey);
            return binding.isPresent() ? ResolvedBindings.create(requestKey, BindingGraphFactory.this.bindingNodeFactory.forMembersInjectionBinding(this.componentPath, binding.get())) : ResolvedBindings.create(requestKey);
        }

        private void addSubcomponentToOwningResolver(ContributionBinding subcomponentCreatorBinding) {
            Preconditions.checkArgument((boolean)subcomponentCreatorBinding.kind().equals((Object)BindingKind.SUBCOMPONENT_CREATOR));
            Resolver owningResolver = this.getOwningResolver(subcomponentCreatorBinding).get();
            XTypeElement builderType = subcomponentCreatorBinding.key().type().xprocessing().getTypeElement();
            owningResolver.subcomponentsToResolve.add(owningResolver.componentDescriptor.getChildComponentWithBuilderType(builderType));
        }

        private ImmutableSet<ContributionBinding> createDelegateBindings(ImmutableSet<DelegateDeclaration> delegateDeclarations) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (DelegateDeclaration delegateDeclaration : delegateDeclarations) {
                builder.add((Object)BindingGraphFactory.this.bindingFactory.delegateBinding(delegateDeclaration));
            }
            return builder.build();
        }

        private Optional<BindingNode> getBindingNodeOwnedByAncestor(Key requestKey, ContributionBinding binding) {
            if (this.canBeResolvedInParent(requestKey, binding)) {
                this.parentResolver.get().resolveContributionKey(requestKey);
                BindingNode previouslyResolvedBinding = this.getPreviouslyResolvedBindings(requestKey).get().forBinding(binding);
                if (!this.requiresResolutionChecker.requiresResolution(previouslyResolvedBinding)) {
                    return Optional.of(previouslyResolvedBinding);
                }
            }
            return Optional.empty();
        }

        private boolean canBeResolvedInParent(Key requestKey, ContributionBinding binding) {
            if (this.parentResolver.isEmpty()) {
                return false;
            }
            Optional<Resolver> owningResolver = this.getOwningResolver(binding);
            if (owningResolver.isPresent()) {
                return !owningResolver.get().equals(this);
            }
            return !Keys.isComponentOrCreator(requestKey) && binding.kind() != BindingKind.ASSISTED_INJECTION && this.getPreviouslyResolvedBindings(requestKey).isPresent() && this.getPreviouslyResolvedBindings(requestKey).get().bindings().contains((Object)binding);
        }

        private Optional<Resolver> getOwningResolver(ContributionBinding binding) {
            if (binding.scope().isPresent() && binding.scope().get().isProductionScope() || binding.kind().equals((Object)BindingKind.PRODUCTION)) {
                for (Resolver requestResolver : this.getResolverLineage()) {
                    if (binding.kind().equals((Object)BindingKind.INJECTION) && requestResolver.componentDescriptor.isProduction()) {
                        return Optional.of(requestResolver);
                    }
                    if (!requestResolver.containsExplicitBinding(binding)) continue;
                    return Optional.of(requestResolver);
                }
            }
            if (binding.scope().isPresent() && binding.scope().get().isReusable()) {
                for (Resolver requestResolver : this.getResolverLineage().reverse()) {
                    ResolvedBindings resolvedBindings = requestResolver.resolvedContributionBindings.get(binding.key());
                    if (resolvedBindings == null || !resolvedBindings.bindings().contains((Object)binding)) continue;
                    return Optional.of(requestResolver);
                }
                return Optional.empty();
            }
            for (Resolver requestResolver : this.getResolverLineage().reverse()) {
                if (!requestResolver.containsExplicitBinding(binding)) continue;
                return Optional.of(requestResolver);
            }
            Optional<Scope> bindingScope = binding.scope();
            if (bindingScope.isPresent()) {
                for (Resolver requestResolver : this.getResolverLineage().reverse()) {
                    if (!requestResolver.componentDescriptor.scopes().contains((Object)bindingScope.get())) continue;
                    return Optional.of(requestResolver);
                }
            }
            return Optional.empty();
        }

        private boolean containsExplicitBinding(ContributionBinding binding) {
            return this.declarations.bindings(binding.key()).contains((Object)binding) || this.resolverContainsDelegateDeclarationForBinding(binding) || !this.declarations.subcomponents(binding.key()).isEmpty();
        }

        private boolean resolverContainsDelegateDeclarationForBinding(ContributionBinding binding) {
            if (!binding.kind().equals((Object)BindingKind.DELEGATE)) {
                return false;
            }
            if (LegacyBindingGraphFactory.hasStrictMultibindingsExemption(BindingGraphFactory.this.compilerOptions, binding)) {
                return false;
            }
            return this.declarations.delegates(binding.key()).stream().anyMatch(declaration -> declaration.contributingModule().equals(binding.contributingModule()) && declaration.bindingElement().equals(binding.bindingElement()));
        }

        private ImmutableList<Resolver> getResolverLineage() {
            ImmutableList.Builder resolverList = ImmutableList.builder();
            Optional<Resolver> currentResolver = Optional.of(this);
            while (currentResolver.isPresent()) {
                resolverList.add((Object)currentResolver.get());
                currentResolver = currentResolver.get().parentResolver;
            }
            return resolverList.build().reverse();
        }

        private ImmutableSet<ContributionBinding> getLocalExplicitBindings(Key key) {
            return ImmutableSet.builder().addAll(this.declarations.bindings(key)).addAll(this.createDelegateBindings(this.declarations.delegates(key))).build();
        }

        private ImmutableSet<ContributionBinding> getLocalMultibindingContributions(Key key) {
            return ImmutableSet.builder().addAll(this.declarations.multibindingContributions(key)).addAll(this.createDelegateBindings(this.declarations.delegateMultibindingContributions(key))).build();
        }

        private ImmutableSet<OptionalBindingDeclaration> getOptionalBindingDeclarations(Key key) {
            Optional<Key> unwrapped = BindingGraphFactory.this.keyFactory.unwrapOptional(key);
            if (unwrapped.isEmpty()) {
                return ImmutableSet.of();
            }
            ImmutableSet.Builder declarations = ImmutableSet.builder();
            for (Resolver resolver : this.getResolverLineage()) {
                declarations.addAll(resolver.declarations.optionalBindings(unwrapped.get()));
            }
            return declarations.build();
        }

        private Optional<ResolvedBindings> getPreviouslyResolvedBindings(Key key) {
            if (this.parentResolver.isEmpty()) {
                return Optional.empty();
            }
            return this.parentResolver.get().resolvedContributionBindings.containsKey(key) ? Optional.of(this.parentResolver.get().resolvedContributionBindings.get(key)) : this.parentResolver.get().getPreviouslyResolvedBindings(key);
        }

        private ResolvedBindings resolveMembersInjectionKey(Key key) {
            if (this.resolvedMembersInjectionBindings.containsKey(key)) {
                return this.resolvedMembersInjectionBindings.get(key);
            }
            ResolvedBindings bindings = this.lookUpMembersInjectionBinding(key);
            this.addNodes(bindings);
            this.resolveDependencies(bindings);
            this.resolvedMembersInjectionBindings.put(key, bindings);
            return bindings;
        }

        @CanIgnoreReturnValue
        private ResolvedBindings resolveContributionKey(Key key) {
            if (this.resolvedContributionBindings.containsKey(key)) {
                return this.resolvedContributionBindings.get(key);
            }
            ResolvedBindings bindings = this.lookUpBindings(key);
            this.resolvedContributionBindings.put(key, bindings);
            this.addNodes(bindings);
            this.resolveDependencies(bindings);
            return bindings;
        }

        private void resolveDependencies(ResolvedBindings resolvedBindings) {
            for (BindingNode binding : resolvedBindings.bindingNodesOwnedBy(this.componentPath)) {
                for (DependencyRequest request : binding.dependencies()) {
                    ResolvedBindings dependencies = this.resolveContributionKey(request.key());
                    this.addDependencyEdges(binding, dependencies, request);
                }
            }
        }

        private void addNodes(ResolvedBindings resolvedBindings) {
            if (resolvedBindings.isEmpty()) {
                this.addNode(this.missingBinding(resolvedBindings.key()));
                return;
            }
            resolvedBindings.bindingNodesOwnedBy(this.componentPath).forEach(this::addNode);
        }

        private void addNode(BindingGraph.Node node) {
            this.network.addNode((Object)node);
            if (node instanceof BindingNode && ((BindingNode)node).kind() == BindingKind.SUBCOMPONENT_CREATOR) {
                this.addSubcomponentEdge((BindingNode)node);
            }
        }

        private void addDependencyEdges(BindingGraph.Node parent, ResolvedBindings dependencies, DependencyRequest request) {
            if (dependencies.isEmpty()) {
                this.addDependencyEdge(parent, this.missingBinding(request.key()), request);
            } else {
                dependencies.bindingNodes().forEach(dependency -> this.addDependencyEdge(parent, (BindingGraph.Node)dependency, request));
            }
        }

        private void addDependencyEdge(BindingGraph.Node source, BindingGraph.Node target, DependencyRequest request) {
            boolean isEntryPoint = source instanceof BindingGraph.ComponentNode;
            this.addEdge(source, target, new DependencyEdgeImpl(request, isEntryPoint));
        }

        private void addSubcomponentEdge(BindingNode binding) {
            Preconditions.checkState((binding.kind() == BindingKind.SUBCOMPONENT_CREATOR ? 1 : 0) != 0);
            Resolver owningResolver = (Resolver)this.getResolverLineage().reverse().stream().filter(resolver -> resolver.componentPath.equals(binding.componentPath())).collect(DaggerCollectors.onlyElement());
            ComponentDescriptor subcomponent = owningResolver.componentDescriptor.getChildComponentWithBuilderType(binding.key().type().xprocessing().getTypeElement());
            BindingGraph.ComponentNode subcomponentNode = ComponentNodeImpl.create(owningResolver.componentPath.childPath(DaggerTypeElement.from(subcomponent.typeElement())), subcomponent);
            this.addEdge(binding, subcomponentNode, new SubcomponentCreatorBindingEdgeImpl(binding.subcomponentDeclarations()));
        }

        private void addChildFactoryMethodEdge(Resolver subcomponentResolver) {
            this.componentDescriptor.getFactoryMethodForChildComponent(subcomponentResolver.componentDescriptor).ifPresent(childFactoryMethod -> this.addEdge(this.componentNode, subcomponentResolver.componentNode, new ChildFactoryMethodEdgeImpl(childFactoryMethod.methodElement())));
        }

        private void addEdge(BindingGraph.Node source, BindingGraph.Node target, BindingGraph.Edge edge) {
            this.network.addNode((Object)source);
            this.network.addNode((Object)target);
            this.network.addEdge((Object)source, (Object)target, (Object)edge);
        }

        private BindingGraph.MissingBinding missingBinding(Key key) {
            return MissingBindingImpl.create(this.rootResolver().componentPath, key);
        }

        private Resolver rootResolver() {
            return this.parentResolver.isPresent() ? this.parentResolver.get().rootResolver() : this;
        }

        private boolean hasLocalMultibindingContributions(BindingNode binding) {
            return !this.declarations.multibindingContributions(binding.key()).isEmpty() || !this.declarations.delegateMultibindingContributions(binding.key()).isEmpty();
        }

        private boolean hasLocalOptionalBindingContribution(BindingNode binding) {
            if (binding.kind() == BindingKind.OPTIONAL) {
                return this.hasLocalExplicitBindings(BindingGraphFactory.this.keyFactory.unwrapOptional(binding.key()).get());
            }
            return !this.getOptionalBindingDeclarations(binding.key()).isEmpty();
        }

        private boolean hasLocalExplicitBindings(Key requestKey) {
            return !this.declarations.bindings(requestKey).isEmpty() || !this.declarations.delegates(requestKey).isEmpty();
        }

        private boolean hasDuplicateExplicitBinding(BindingNode binding) {
            if (binding.kind() == BindingKind.INJECTION && !BindingGraphFactory.this.compilerOptions.explicitBindingConflictsWithInjectValidationType().diagnosticKind().equals(Optional.of(Diagnostic.Kind.ERROR))) {
                return false;
            }
            return this.hasLocalExplicitBindings(binding.key());
        }

        private final class RequiresResolutionChecker {
            private final Map<BindingGraph.Node, Boolean> dependsOnMissingBindingCache = new HashMap<BindingGraph.Node, Boolean>();
            private final Map<BindingGraph.Node, Boolean> dependsOnLocalBindingsCache = new HashMap<BindingGraph.Node, Boolean>();

            private RequiresResolutionChecker() {
            }

            boolean requiresResolution(BindingNode binding) {
                if (this.isNotAllowedToFloat(binding)) {
                    return false;
                }
                if (this.hasLocalBindings(binding)) {
                    return true;
                }
                return this.shouldCheckDependencies(binding) && (this.dependsOnLocalBinding(binding) || this.dependsOnMissingBinding(binding));
            }

            private boolean isNotAllowedToFloat(BindingNode binding) {
                return binding.kind() != BindingKind.INJECTION && binding.kind() != BindingKind.ASSISTED_INJECTION && this.dependsOnMissingBinding(binding);
            }

            private boolean dependsOnMissingBinding(BindingNode binding) {
                if (!this.dependsOnMissingBindingCache.containsKey(binding)) {
                    this.visitUncachedDependencies(binding);
                }
                return (Boolean)Preconditions.checkNotNull((Object)this.dependsOnMissingBindingCache.get(binding));
            }

            private boolean dependsOnLocalBinding(BindingNode binding) {
                if (!this.dependsOnLocalBindingsCache.containsKey(binding)) {
                    this.visitUncachedDependencies(binding);
                }
                return (Boolean)Preconditions.checkNotNull((Object)this.dependsOnLocalBindingsCache.get(binding));
            }

            /*
             * Unable to fully structure code
             */
            private void visitUncachedDependencies(BindingNode binding) {
                for (ImmutableSet cycleNodes : this.stronglyConnectedNodes(binding)) {
                    Preconditions.checkState((boolean)cycleNodes.stream().noneMatch((Predicate<BindingGraph.Node>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, containsKey(java.lang.Object ), (Ldagger/internal/codegen/model/BindingGraph$Node;)Z)(this.dependsOnLocalBindingsCache)));
                    Preconditions.checkState((boolean)cycleNodes.stream().noneMatch((Predicate<BindingGraph.Node>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, containsKey(java.lang.Object ), (Ldagger/internal/codegen/model/BindingGraph$Node;)Z)(this.dependsOnMissingBindingCache)));
                    if (cycleNodes.stream().anyMatch((Predicate<BindingGraph.Node>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isMissingBinding(dagger.internal.codegen.model.BindingGraph$Node ), (Ldagger/internal/codegen/model/BindingGraph$Node;)Z)((RequiresResolutionChecker)this))) ** GOTO lbl-1000
                    if (cycleNodes.stream().filter((Predicate<BindingGraph.Node>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, shouldCheckDependencies(dagger.internal.codegen.model.BindingGraph$Node ), (Ldagger/internal/codegen/model/BindingGraph$Node;)Z)((RequiresResolutionChecker)this)).flatMap((Function<BindingGraph.Node, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, dependencyStream(dagger.internal.codegen.model.BindingGraph$Node ), (Ldagger/internal/codegen/model/BindingGraph$Node;)Ljava/util/stream/Stream;)((RequiresResolutionChecker)this)).filter(Predicates.not((com.google.common.base.Predicate)(com.google.common.base.Predicate)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ldagger/internal/codegen/model/BindingGraph$Node;)Z)((ImmutableSet)cycleNodes))).anyMatch((Predicate<BindingGraph.Node>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, get(java.lang.Object ), (Ldagger/internal/codegen/model/BindingGraph$Node;)Z)(this.dependsOnMissingBindingCache))) lbl-1000:
                    // 2 sources

                    {
                        v0 = true;
                    } else {
                        v0 = false;
                    }
                    dependsOnMissingBinding = v0;
                    cycleNodes.forEach((Consumer<BindingGraph.Node>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$visitUncachedDependencies$0(boolean dagger.internal.codegen.model.BindingGraph$Node ), (Ldagger/internal/codegen/model/BindingGraph$Node;)V)((RequiresResolutionChecker)this, (boolean)dependsOnMissingBinding));
                    if (cycleNodes.stream().anyMatch((Predicate<BindingGraph.Node>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, hasLocalBindings(dagger.internal.codegen.model.BindingGraph$Node ), (Ldagger/internal/codegen/model/BindingGraph$Node;)Z)((RequiresResolutionChecker)this))) ** GOTO lbl-1000
                    if (cycleNodes.stream().filter((Predicate<BindingGraph.Node>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, shouldCheckDependencies(dagger.internal.codegen.model.BindingGraph$Node ), (Ldagger/internal/codegen/model/BindingGraph$Node;)Z)((RequiresResolutionChecker)this)).flatMap((Function<BindingGraph.Node, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, dependencyStream(dagger.internal.codegen.model.BindingGraph$Node ), (Ldagger/internal/codegen/model/BindingGraph$Node;)Ljava/util/stream/Stream;)((RequiresResolutionChecker)this)).filter(Predicates.not((com.google.common.base.Predicate)(com.google.common.base.Predicate)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ldagger/internal/codegen/model/BindingGraph$Node;)Z)((ImmutableSet)cycleNodes))).anyMatch((Predicate<BindingGraph.Node>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, get(java.lang.Object ), (Ldagger/internal/codegen/model/BindingGraph$Node;)Z)(this.dependsOnLocalBindingsCache))) lbl-1000:
                    // 2 sources

                    {
                        v1 = true;
                    } else {
                        v1 = false;
                    }
                    dependsOnLocalBindings = v1;
                    cycleNodes.forEach((Consumer<BindingGraph.Node>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$visitUncachedDependencies$1(boolean dagger.internal.codegen.model.BindingGraph$Node ), (Ldagger/internal/codegen/model/BindingGraph$Node;)V)((RequiresResolutionChecker)this, (boolean)dependsOnLocalBindings));
                }
            }

            private ImmutableList<ImmutableSet<BindingGraph.Node>> stronglyConnectedNodes(BindingNode rootNode) {
                return TarjanSCCs.compute(ImmutableSet.of((Object)rootNode), node -> this.shouldCheckDependencies((BindingGraph.Node)node) ? (Iterable)this.dependencyStream((BindingGraph.Node)node).filter(dep -> !this.dependsOnLocalBindingsCache.containsKey(dep)).collect(DaggerStreams.toImmutableSet()) : ImmutableSet.of());
            }

            private Stream<BindingGraph.Node> dependencyStream(BindingGraph.Node node) {
                return Resolver.this.network.successors((Object)node).stream();
            }

            private boolean shouldCheckDependencies(BindingGraph.Node node) {
                if (!(node instanceof BindingNode)) {
                    return false;
                }
                BindingNode binding = (BindingNode)node;
                return !this.isScopedToComponent(binding) && !binding.kind().equals((Object)BindingKind.PRODUCTION);
            }

            private boolean isScopedToComponent(BindingNode binding) {
                return binding.scope().isPresent() && !binding.scope().get().isReusable();
            }

            private boolean isMissingBinding(BindingGraph.Node binding) {
                return binding instanceof BindingGraph.MissingBinding;
            }

            private boolean hasLocalBindings(BindingGraph.Node node) {
                if (!(node instanceof BindingNode)) {
                    return false;
                }
                BindingNode binding = (BindingNode)node;
                return Resolver.this.hasLocalMultibindingContributions(binding) || Resolver.this.hasLocalOptionalBindingContribution(binding) || Resolver.this.hasDuplicateExplicitBinding(binding);
            }

            private /* synthetic */ void lambda$visitUncachedDependencies$1(boolean dependsOnLocalBindings, BindingGraph.Node cycleNode) {
                this.dependsOnLocalBindingsCache.put(cycleNode, dependsOnLocalBindings);
            }

            private /* synthetic */ void lambda$visitUncachedDependencies$0(boolean dependsOnMissingBinding, BindingGraph.Node cycleNode) {
                this.dependsOnMissingBindingCache.put(cycleNode, dependsOnMissingBinding);
            }
        }
    }
}

