/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.common.base.CaseFormat;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.binding.AutoValue_FrameworkField;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.KeyVariableNamer;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import java.util.Optional;

@AutoValue
public abstract class FrameworkField {
    public static FrameworkField create(String fieldName, ClassName frameworkClassName, XType type) {
        return FrameworkField.createInternal(fieldName, frameworkClassName, Optional.of(type));
    }

    public static FrameworkField forBinding(ContributionBinding binding, Optional<ClassName> frameworkClassName) {
        return FrameworkField.createInternal(FrameworkField.bindingName(binding), frameworkClassName.orElse(binding.frameworkType().frameworkClassName()), FrameworkField.bindingType(binding));
    }

    private static String bindingName(ContributionBinding binding) {
        if (binding.bindingElement().isPresent()) {
            String name = FrameworkField.bindingElementName(binding.bindingElement().get());
            return binding.kind().equals((Object)BindingKind.MEMBERS_INJECTOR) ? name + "MembersInjector" : name;
        }
        return KeyVariableNamer.name(binding.key());
    }

    private static Optional<XType> bindingType(ContributionBinding binding) {
        if (binding.contributionType().isMultibinding()) {
            return Optional.of(binding.contributedType());
        }
        if (MapType.isMapOfProvider(binding.contributedType())) {
            return Optional.empty();
        }
        return Optional.of(binding.key().type().xprocessing());
    }

    private static FrameworkField createInternal(String fieldName, ClassName frameworkClassName, Optional<XType> type) {
        return new AutoValue_FrameworkField(FrameworkField.frameworkFieldName(fieldName, frameworkClassName), (TypeName)(type.isPresent() ? ParameterizedTypeName.get((ClassName)frameworkClassName, (TypeName[])new TypeName[]{type.get().getTypeName()}) : frameworkClassName));
    }

    private static String frameworkFieldName(String fieldName, ClassName frameworkClassName) {
        String suffix = frameworkClassName.simpleName();
        return fieldName.endsWith(suffix) ? fieldName : fieldName + suffix;
    }

    private static String bindingElementName(XElement bindingElement) {
        if (XElementKt.isConstructor((XElement)bindingElement)) {
            return FrameworkField.bindingElementName(bindingElement.getEnclosingElement());
        }
        if (XElementKt.isMethod((XElement)bindingElement)) {
            return XElements.getSimpleName(bindingElement);
        }
        if (XElementKt.isTypeElement((XElement)bindingElement)) {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, XElements.getSimpleName(bindingElement));
        }
        if (XElementKt.isMethodParameter((XElement)bindingElement)) {
            return XElements.getSimpleName(bindingElement);
        }
        throw new IllegalArgumentException("Unexpected binding " + bindingElement);
    }

    public abstract String name();

    public abstract TypeName type();
}

