/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.DaggerGenerated;
import dagger.internal.codegen.binding.MapKeys;
import dagger.internal.codegen.javapoet.AnnotationSpecs;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

public final class LazyMapKeyProxyGenerator {
    private static final String GENERATED_COMMENTS = "https://dagger.dev";
    private final XProcessingEnv processingEnv;
    private final XFiler filer;

    @Inject
    LazyMapKeyProxyGenerator(XProcessingEnv processingEnv, XFiler filer) {
        this.processingEnv = processingEnv;
        this.filer = filer;
    }

    public void generate(XMethodElement element) {
        ClassName lazyClassKeyProxyClassName = MapKeys.lazyClassKeyProxyClassName(element);
        TypeSpec.Builder typeSpecBuilder = TypeSpec.classBuilder((ClassName)lazyClassKeyProxyClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(TypeNames.IDENTIFIER_NAME_STRING).addAnnotation(DaggerGenerated.class).addFields(LazyMapKeyProxyGenerator.lazyClassKeyFields(element));
        Optional<AnnotationSpec> generatedAnnotation = Optional.ofNullable(this.processingEnv.findGeneratedAnnotation()).map(annotation -> AnnotationSpec.builder((ClassName)annotation.getClassName()).addMember("value", "$S", new Object[]{"dagger.internal.codegen.LazyClassKeyProcessor"}).addMember("comments", "$S", new Object[]{GENERATED_COMMENTS}).build());
        generatedAnnotation.ifPresent(arg_0 -> ((TypeSpec.Builder)typeSpecBuilder).addAnnotation(arg_0));
        typeSpecBuilder.addAnnotation(AnnotationSpecs.suppressWarnings((ImmutableSet<AnnotationSpecs.Suppression>)ImmutableSet.builder().add((Object[])new AnnotationSpecs.Suppression[]{AnnotationSpecs.Suppression.UNCHECKED, AnnotationSpecs.Suppression.RAWTYPES, AnnotationSpecs.Suppression.KOTLIN_INTERNAL, AnnotationSpecs.Suppression.CAST, AnnotationSpecs.Suppression.DEPRECATION}).build()));
        this.filer.write(JavaFile.builder((String)lazyClassKeyProxyClassName.packageName(), (TypeSpec)typeSpecBuilder.build()).build(), XFiler.Mode.Isolating);
    }

    private static ImmutableList<FieldSpec> lazyClassKeyFields(XMethodElement element) {
        ClassName lazyClassMapKeyClassName = element.getAnnotation(TypeNames.LAZY_CLASS_KEY).getAsType("value").getTypeElement().getClassName();
        FieldSpec lazyClassKeyField = FieldSpec.builder((TypeName)TypeNames.STRING, (String)"lazyClassKeyName", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).initializer("$S", new Object[]{lazyClassMapKeyClassName.reflectionName()}).build();
        FieldSpec keepFieldTypeField = FieldSpec.builder((TypeName)lazyClassMapKeyClassName, (String)"keepFieldType", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.STATIC}).addAnnotation(TypeNames.KEEP_FIELD_TYPE).build();
        return ImmutableList.of((Object)keepFieldTypeField, (Object)lazyClassKeyField);
    }
}

