/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.AnnotationSpecs;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.model.DaggerAnnotation;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.writing.GwtCompatibility;
import dagger.internal.codegen.writing.InjectionMethods;
import dagger.internal.codegen.xprocessing.Nullability;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XVariableElement;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

public final class MembersInjectorGenerator
extends SourceFileGenerator<MembersInjectionBinding> {
    private final SourceFiles sourceFiles;

    @Inject
    MembersInjectorGenerator(XFiler filer, SourceFiles sourceFiles, XProcessingEnv processingEnv) {
        super(filer, processingEnv);
        this.sourceFiles = sourceFiles;
    }

    @Override
    public XElement originatingElement(MembersInjectionBinding binding) {
        return binding.membersInjectedType();
    }

    @Override
    public ImmutableList<TypeSpec.Builder> topLevelTypes(MembersInjectionBinding binding) {
        Preconditions.checkState((!binding.unresolved().isPresent() ? 1 : 0) != 0, (String)"tried to generate a MembersInjector for a binding of a resolved generic type: %s", (Object)binding);
        ClassName generatedTypeName = SourceFiles.membersInjectorNameForType(binding.membersInjectedType());
        ImmutableList<TypeVariableName> typeParameters = SourceFiles.bindingTypeElementTypeVariableNames(binding);
        ImmutableMap<DependencyRequest, FieldSpec> frameworkFields = MembersInjectorGenerator.frameworkFields(binding);
        TypeSpec.Builder injectorTypeBuilder = TypeSpec.classBuilder((ClassName)generatedTypeName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addTypeVariables(typeParameters).addAnnotation(this.qualifierMetadataAnnotation(binding)).addSuperinterface((TypeName)TypeNames.membersInjectorOf(binding.key().type().xprocessing().getTypeName())).addFields((Iterable)frameworkFields.values()).addMethod(this.constructor(frameworkFields)).addMethod(this.createMethod(binding, frameworkFields)).addMethod(this.injectMembersMethod(binding, frameworkFields)).addMethods((Iterable)binding.injectionSites().stream().filter(site -> site.enclosingTypeElement().equals((Object)binding.membersInjectedType())).map(MembersInjectorGenerator::membersInjectionMethod).collect(DaggerStreams.toImmutableList()));
        GwtCompatibility.gwtIncompatibleAnnotation(binding).ifPresent(arg_0 -> ((TypeSpec.Builder)injectorTypeBuilder).addAnnotation(arg_0));
        return ImmutableList.of((Object)injectorTypeBuilder);
    }

    private static MethodSpec membersInjectionMethod(MembersInjectionBinding.InjectionSite injectionSite) {
        String methodName = SourceFiles.membersInjectorMethodName(injectionSite);
        switch (injectionSite.kind()) {
            case METHOD: {
                return MembersInjectorGenerator.methodInjectionMethod(XElements.asMethod(injectionSite.element()), methodName);
            }
            case FIELD: {
                Optional<XAnnotation> qualifier = ((DependencyRequest)Iterables.getOnlyElement(injectionSite.dependencies())).key().qualifier().map(DaggerAnnotation::xprocessing);
                return MembersInjectorGenerator.fieldInjectionMethod(XElements.asField(injectionSite.element()), methodName, qualifier);
            }
        }
        throw new AssertionError(injectionSite);
    }

    private static MethodSpec methodInjectionMethod(XMethodElement method, String methodName) {
        XTypeElement enclosingType = XElements.asTypeElement((XElement)method.getEnclosingElement());
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).varargs(method.isVarArgs()).addTypeVariables(XTypeElements.typeVariableNames(enclosingType)).addExceptions(MembersInjectorGenerator.getThrownTypes((XExecutableElement)method));
        UniqueNameSet parameterNameSet = new UniqueNameSet();
        CodeBlock instance = MembersInjectorGenerator.copyInstance(builder, parameterNameSet, enclosingType.getType());
        CodeBlock arguments = InjectionMethods.copyParameters(builder, parameterNameSet, method.getParameters());
        return builder.addStatement("$L.$L($L)", new Object[]{instance, method.getJvmName(), arguments}).build();
    }

    private static MethodSpec fieldInjectionMethod(XFieldElement field, String methodName, Optional<XAnnotation> qualifier) {
        XTypeElement enclosingType = XElements.asTypeElement((XElement)field.getEnclosingElement());
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addAnnotation(AnnotationSpec.builder((ClassName)TypeNames.INJECTED_FIELD_SIGNATURE).addMember("value", "$S", new Object[]{SourceFiles.memberInjectedFieldSignatureForVariable(field)}).build()).addTypeVariables(XTypeElements.typeVariableNames(enclosingType));
        qualifier.map(XAnnotations::getAnnotationSpec).ifPresent(arg_0 -> ((MethodSpec.Builder)builder).addAnnotation(arg_0));
        UniqueNameSet parameterNameSet = new UniqueNameSet();
        CodeBlock instance = MembersInjectorGenerator.copyInstance(builder, parameterNameSet, enclosingType.getType());
        CodeBlock argument = InjectionMethods.copyParameters(builder, parameterNameSet, (List<? extends XVariableElement>)ImmutableList.of((Object)field));
        return builder.addStatement("$L.$L = $L", new Object[]{instance, XElements.getSimpleName((XElement)field), argument}).build();
    }

    private static ImmutableList<TypeName> getThrownTypes(XExecutableElement executable) {
        return (ImmutableList)executable.getThrownTypes().stream().map(XType::getTypeName).collect(DaggerStreams.toImmutableList());
    }

    private static CodeBlock copyInstance(MethodSpec.Builder methodBuilder, UniqueNameSet parameterNameSet, XType type) {
        boolean useObject = !Accessibility.isRawTypePubliclyAccessible(type);
        CodeBlock instance = InjectionMethods.copyParameter(methodBuilder, type, parameterNameSet.getUniqueName("instance"), useObject, Nullability.NOT_NULLABLE);
        return useObject ? CodeBlock.of((String)"($L)", (Object[])new Object[]{instance}) : instance;
    }

    private MethodSpec constructor(ImmutableMap<DependencyRequest, FieldSpec> frameworkFields) {
        ImmutableList dependencyParameters = (ImmutableList)frameworkFields.values().stream().map(field -> ParameterSpec.builder((TypeName)field.type, (String)field.name, (Modifier[])new Modifier[0]).addAnnotations((Iterable)field.annotations).build()).collect(DaggerStreams.toImmutableList());
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameters((Iterable)dependencyParameters).addCode(dependencyParameters.stream().map(parameter -> CodeBlock.of((String)"this.$1N = $1N;", (Object[])new Object[]{parameter})).collect(CodeBlocks.toConcatenatedCodeBlock())).build();
    }

    private MethodSpec createMethod(MembersInjectionBinding binding, ImmutableMap<DependencyRequest, FieldSpec> frameworkFields) {
        MethodSpec constructor = this.constructor(frameworkFields);
        return MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addTypeVariables(SourceFiles.bindingTypeElementTypeVariableNames(binding)).returns((TypeName)TypeNames.membersInjectorOf(binding.key().type().xprocessing().getTypeName())).addParameters((Iterable)constructor.parameters).addStatement("return new $T($L)", new Object[]{SourceFiles.parameterizedGeneratedTypeNameForBinding(binding), CodeBlocks.parameterNames(constructor.parameters)}).build();
    }

    private MethodSpec injectMembersMethod(MembersInjectionBinding binding, ImmutableMap<DependencyRequest, FieldSpec> frameworkFields) {
        XType instanceType = binding.key().type().xprocessing();
        ImmutableMap<DependencyRequest, CodeBlock> dependencyCodeBlocks = this.sourceFiles.frameworkFieldUsages(binding.dependencies(), frameworkFields);
        return MethodSpec.methodBuilder((String)"injectMembers").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(instanceType.getTypeName(), "instance", new Modifier[0]).addCode(InjectionMethods.InjectionSiteMethod.invokeAll(binding.injectionSites(), SourceFiles.membersInjectorNameForType(binding.membersInjectedType()), CodeBlock.of((String)"instance", (Object[])new Object[0]), instanceType, arg_0 -> dependencyCodeBlocks.get(arg_0))).build();
    }

    private AnnotationSpec qualifierMetadataAnnotation(MembersInjectionBinding binding) {
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)TypeNames.QUALIFIER_METADATA);
        binding.injectionSites().stream().filter(injectionSite -> injectionSite.enclosingTypeElement().equals((Object)binding.membersInjectedType())).flatMap(injectionSite -> injectionSite.dependencies().stream()).map(DependencyRequest::key).map(Key::qualifier).flatMap(DaggerStreams.presentValues()).map(DaggerAnnotation::className).map(ClassName::canonicalName).distinct().forEach(qualifier -> builder.addMember("value", "$S", new Object[]{qualifier}));
        return builder.build();
    }

    private static ImmutableMap<DependencyRequest, FieldSpec> frameworkFields(MembersInjectionBinding binding) {
        UniqueNameSet fieldNames = new UniqueNameSet();
        ClassName membersInjectorTypeName = SourceFiles.membersInjectorNameForType(binding.membersInjectedType());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        SourceFiles.generateBindingFieldsForDependencies(binding).forEach((request, bindingField) -> {
            boolean useRawFrameworkType = !Accessibility.isTypeAccessibleFrom(request.key().type().xprocessing(), membersInjectorTypeName.packageName());
            TypeName fieldType = useRawFrameworkType ? TypeNames.rawTypeName(bindingField.type()) : bindingField.type();
            String fieldName = fieldNames.getUniqueName(bindingField.name());
            FieldSpec field = useRawFrameworkType ? FieldSpec.builder((TypeName)fieldType, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.RAWTYPES, new AnnotationSpecs.Suppression[0])).build() : FieldSpec.builder((TypeName)fieldType, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
            builder.put(request, (Object)field);
        });
        return builder.buildOrThrow();
    }
}

