/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.CodeBlock;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.MultiboundSetBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.MultibindingFactoryCreationExpression;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeNameKt;

final class SetFactoryCreationExpression
extends MultibindingFactoryCreationExpression {
    private final BindingGraph graph;
    private final MultiboundSetBinding binding;

    @AssistedInject
    SetFactoryCreationExpression(@Assisted MultiboundSetBinding binding, ComponentImplementation componentImplementation, ComponentRequestRepresentations componentRequestRepresentations, BindingGraph graph) {
        super(binding, componentImplementation, componentRequestRepresentations);
        this.binding = (MultiboundSetBinding)Preconditions.checkNotNull((Object)binding);
        this.graph = graph;
    }

    @Override
    public CodeBlock creationExpression() {
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.", new Object[]{XTypeNameKt.toJavaPoet((XClassName)SourceFiles.setFactoryClassName(this.binding))});
        if (!this.useRawType()) {
            SetType setType = SetType.from(this.binding.key());
            builder.add("<$T>", new Object[]{setType.elementsAreTypeOf(TypeNames.PRODUCED) ? setType.unwrappedElementType(TypeNames.PRODUCED).getTypeName() : setType.elementType().getTypeName()});
        }
        int individualProviders = 0;
        int setProviders = 0;
        CodeBlock.Builder builderMethodCalls = CodeBlock.builder();
        String methodNameSuffix = this.binding.bindingType().equals((Object)BindingType.PROVISION) ? "Provider" : "Producer";
        for (DependencyRequest dependency : this.binding.dependencies()) {
            String methodNamePrefix;
            ContributionType contributionType = this.graph.contributionBinding(dependency.key()).contributionType();
            switch (contributionType) {
                case SET: {
                    ++individualProviders;
                    methodNamePrefix = "add";
                    break;
                }
                case SET_VALUES: {
                    ++setProviders;
                    methodNamePrefix = "addCollection";
                    break;
                }
                default: {
                    throw new AssertionError((Object)(dependency + " is not a set multibinding"));
                }
            }
            builderMethodCalls.add(".$N$N($L)", new Object[]{methodNamePrefix, methodNameSuffix, this.multibindingDependencyExpression(dependency)});
        }
        builder.add("builder($L, $L)", new Object[]{individualProviders, setProviders});
        builder.add(builderMethodCalls.build());
        return builder.add(".build()", new Object[0]).build();
    }

    @AssistedFactory
    static interface Factory {
        public SetFactoryCreationExpression create(MultiboundSetBinding var1);
    }
}

