/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.BindsTypeChecker;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.DelegateBinding;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.xprocessing.XExpression;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;

final class DelegateRequestRepresentation
extends RequestRepresentation {
    private final DelegateBinding binding;
    private final RequestKind requestKind;
    private final ComponentRequestRepresentations componentRequestRepresentations;
    private final XProcessingEnv processingEnv;
    private final BindsTypeChecker bindsTypeChecker;

    @AssistedInject
    DelegateRequestRepresentation(@Assisted DelegateBinding binding, @Assisted RequestKind requestKind, ComponentRequestRepresentations componentRequestRepresentations, BindsTypeChecker bindsTypeChecker, XProcessingEnv processingEnv) {
        this.binding = (DelegateBinding)Preconditions.checkNotNull((Object)binding);
        this.requestKind = (RequestKind)((Object)Preconditions.checkNotNull((Object)((Object)requestKind)));
        this.componentRequestRepresentations = componentRequestRepresentations;
        this.processingEnv = processingEnv;
        this.bindsTypeChecker = bindsTypeChecker;
    }

    static boolean isBindsScopeStrongerThanDependencyScope(DelegateBinding bindsBinding, BindingGraph graph) {
        ContributionBinding dependencyBinding = graph.contributionBinding(((DependencyRequest)Iterables.getOnlyElement(bindsBinding.dependencies())).key());
        ScopeKind bindsScope = ScopeKind.get(bindsBinding);
        ScopeKind dependencyScope = ScopeKind.get(dependencyBinding);
        return bindsScope.isStrongerScopeThan(dependencyScope);
    }

    @Override
    XExpression getDependencyExpression(XClassName requestingClass) {
        XExpression delegateExpression = this.componentRequestRepresentations.getDependencyExpression(BindingRequest.bindingRequest(((DependencyRequest)Iterables.getOnlyElement(this.binding.dependencies())).key(), this.requestKind), requestingClass);
        XType contributedType = this.binding.contributedType();
        switch (this.requestKind) {
            case INSTANCE: {
                return DelegateRequestRepresentation.instanceRequiresCast(this.binding, delegateExpression, requestingClass, this.bindsTypeChecker) ? delegateExpression.castTo(contributedType) : delegateExpression;
            }
        }
        XType requestedType = RequestKinds.requestType(this.requestKind, contributedType, this.processingEnv);
        if (XTypes.isTypeOf(requestedType, XTypeNames.PROVIDER)) {
            requestedType = XTypes.rewrapType(requestedType, XTypeNames.DAGGER_PROVIDER);
        }
        return this.castToRawTypeIfNecessary(delegateExpression, requestedType);
    }

    static boolean instanceRequiresCast(DelegateBinding binding, XExpression delegateExpression, XClassName requestingClass, BindsTypeChecker bindsTypeChecker) {
        XType contributedType = binding.contributedType();
        return !bindsTypeChecker.isAssignable(delegateExpression.type(), contributedType, binding.contributionType()) && Accessibility.isTypeAccessibleFrom(contributedType, requestingClass.getPackageName());
    }

    private XExpression castToRawTypeIfNecessary(XExpression delegateExpression, XType desiredType) {
        if (delegateExpression.type().isAssignableTo(desiredType)) {
            return delegateExpression;
        }
        XExpression castedExpression = delegateExpression.castTo(desiredType.getRawType());
        return XExpression.create(castedExpression.type(), XCodeBlock.of((String)"(%L)", (Object[])new Object[]{castedExpression.codeBlock()}));
    }

    private static enum ScopeKind {
        UNSCOPED,
        SINGLE_CHECK,
        DOUBLE_CHECK;


        static ScopeKind get(Binding binding) {
            return binding.scope().map(scope -> scope.isReusable() ? SINGLE_CHECK : DOUBLE_CHECK).orElse(UNSCOPED);
        }

        boolean isStrongerScopeThan(ScopeKind other) {
            return this.ordinal() > other.ordinal();
        }
    }

    @AssistedFactory
    static interface Factory {
        public DelegateRequestRepresentation create(DelegateBinding var1, RequestKind var2);
    }
}

