/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.binding.AssistedInjectionBinding;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.InjectionBinding;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.InjectionMethods;
import dagger.internal.codegen.writing.PerComponentImplementation;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XExpression;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMemberContainer;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

@PerComponentImplementation
final class MembersInjectionMethods {
    private final Map<Key, XExpression> injectMethodExpressions = new LinkedHashMap<Key, XExpression>();
    private final ComponentImplementation componentImplementation;
    private final ComponentRequestRepresentations bindingExpressions;
    private final BindingGraph graph;
    private final XProcessingEnv processingEnv;

    @Inject
    MembersInjectionMethods(ComponentImplementation componentImplementation, ComponentRequestRepresentations bindingExpressions, BindingGraph graph, XProcessingEnv processingEnv) {
        this.componentImplementation = componentImplementation;
        this.bindingExpressions = bindingExpressions;
        this.graph = graph;
        this.processingEnv = processingEnv;
    }

    XExpression getInjectExpression(Key key, CodeBlock instance, XClassName requestingClass) {
        Binding binding = this.graph.localMembersInjectionBinding(key).isPresent() ? this.graph.localMembersInjectionBinding(key).get() : this.graph.localContributionBinding(key).get();
        XExpression expression = Util.reentrantComputeIfAbsent(this.injectMethodExpressions, key, k -> this.injectMethodExpression(binding));
        ComponentImplementation.ShardImplementation shardImplementation = this.componentImplementation.shardImplementation(binding);
        return XExpression.create(expression.type(), shardImplementation.name().equals((Object)requestingClass) ? XCodeBlock.of((String)"%L(%L)", (Object[])new Object[]{expression.codeBlock(), XCodeBlocks.toXPoet(instance)}) : XCodeBlock.of((String)"%L.%L(%L)", (Object[])new Object[]{XCodeBlocks.toXPoet(shardImplementation.shardFieldReference()), expression.codeBlock(), XCodeBlocks.toXPoet(instance)}));
    }

    private XExpression injectMethodExpression(Binding binding) {
        ComponentImplementation.ShardImplementation shardImplementation = this.componentImplementation.shardImplementation(binding);
        XType keyType = binding.key().type().xprocessing();
        XType membersInjectedType = Accessibility.isTypeAccessibleFrom(keyType, shardImplementation.name().getPackageName()) ? keyType : this.processingEnv.requireType((TypeName)TypeName.OBJECT);
        String bindingTypeName = XElements.getSimpleName((XMemberContainer)binding.bindingTypeElement().get());
        String methodName = shardImplementation.getUniqueMethodName("inject" + bindingTypeName);
        ParameterSpec parameter = ParameterSpec.builder((TypeName)membersInjectedType.getTypeName(), (String)shardImplementation.getUniqueFieldName("instance"), (Modifier[])new Modifier[0]).build();
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(membersInjectedType.getTypeName()).addParameter(parameter);
        XTypeElement canIgnoreReturnValue = this.processingEnv.findTypeElement("com.google.errorprone.annotations.CanIgnoreReturnValue");
        if (canIgnoreReturnValue != null) {
            methodBuilder.addAnnotation(canIgnoreReturnValue.getClassName());
        }
        XCodeBlock instance = XCodeBlock.of((String)"%N", (Object[])new Object[]{parameter.name});
        XCodeBlock invokeInjectionSites = InjectionMethods.InjectionSiteMethod.invokeAll(MembersInjectionMethods.injectionSites(binding), shardImplementation.name(), instance, membersInjectedType, request -> this.bindingExpressions.getDependencyArgumentExpression((DependencyRequest)request, shardImplementation.name()).codeBlock());
        methodBuilder.addCode(XConverters.toJavaPoet((XCodeBlock)invokeInjectionSites)).addStatement("return $L", new Object[]{XConverters.toJavaPoet((XCodeBlock)instance)});
        MethodSpec method = methodBuilder.build();
        shardImplementation.addMethod(ComponentImplementation.MethodSpecKind.MEMBERS_INJECTION_METHOD, method);
        return XExpression.create(membersInjectedType, CodeBlock.of((String)"$N", (Object[])new Object[]{method}));
    }

    private static ImmutableSet<MembersInjectionBinding.InjectionSite> injectionSites(Binding binding) {
        switch (binding.kind()) {
            case INJECTION: {
                return ((InjectionBinding)binding).injectionSites();
            }
            case ASSISTED_INJECTION: {
                return ((AssistedInjectionBinding)binding).injectionSites();
            }
            case MEMBERS_INJECTION: {
                return ((MembersInjectionBinding)binding).injectionSites();
            }
        }
        throw new IllegalArgumentException("Unexpected binding kind: " + (Object)((Object)binding.kind()));
    }
}

