/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.base.DaggerSuperficialValidation;
import dagger.internal.codegen.base.ElementFormatter;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.model.DaggerAnnotation;
import dagger.internal.codegen.model.Scope;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;

public final class InjectionAnnotations {
    private final XProcessingEnv processingEnv;
    private final KotlinMetadataUtil kotlinMetadataUtil;
    private final DaggerSuperficialValidation superficialValidation;
    private final CompilerOptions compilerOptions;

    @Inject
    InjectionAnnotations(XProcessingEnv processingEnv, KotlinMetadataUtil kotlinMetadataUtil, DaggerSuperficialValidation superficialValidation, CompilerOptions compilerOptions) {
        this.processingEnv = processingEnv;
        this.kotlinMetadataUtil = kotlinMetadataUtil;
        this.superficialValidation = superficialValidation;
        this.compilerOptions = compilerOptions;
    }

    public Optional<Scope> getScope(XElement element) {
        return (Optional)this.getScopes(element).stream().collect(DaggerCollectors.toOptional());
    }

    public ImmutableSet<Scope> getScopes(XElement element) {
        this.superficialValidation.validateTypeOf(element);
        ImmutableSet scopes = this.getScopesWithMetadata(element).orElseGet(() -> this.getScopesWithoutMetadata(element));
        scopes.stream().map(scope -> scope.scopeAnnotation().xprocessing()).forEach(scope -> this.superficialValidation.validateAnnotationOf(element, (XAnnotation)scope));
        return scopes;
    }

    private ImmutableSet<Scope> getScopesWithoutMetadata(XElement element) {
        this.superficialValidation.validateAnnotationTypesOf(element);
        return (ImmutableSet)element.getAllAnnotations().stream().filter(InjectionAnnotations::hasScopeAnnotation).map(DaggerAnnotation::from).map(Scope::scope).collect(DaggerStreams.toImmutableSet());
    }

    private Optional<ImmutableSet<Scope>> getScopesWithMetadata(XElement element) {
        Optional<XAnnotation> scopeMetadata = this.getScopeMetadata(element);
        if (!scopeMetadata.isPresent()) {
            return Optional.empty();
        }
        String scopeName = scopeMetadata.get().getAsString("value");
        if (scopeName.isEmpty()) {
            return Optional.of(ImmutableSet.of());
        }
        ImmutableList scopeAnnotations = (ImmutableList)element.getAllAnnotations().stream().filter(annotation -> scopeName.contentEquals(annotation.getType().getTypeElement().getQualifiedName())).collect(DaggerStreams.toImmutableList());
        Preconditions.checkState((scopeAnnotations.size() == 1 ? 1 : 0) != 0, (String)"Expected %s to have a scope annotation for %s but found: %s", (Object)ElementFormatter.elementToString(element), (Object)scopeName, scopeAnnotations.stream().map(XAnnotations::toStableString).collect(DaggerStreams.toImmutableList()));
        XAnnotation scopeAnnotation = (XAnnotation)Iterables.getOnlyElement((Iterable)scopeAnnotations);
        this.superficialValidation.validateAnnotationTypeOf(element, scopeAnnotation);
        if (this.compilerOptions.strictSuperficialValidation()) {
            return Optional.of(ImmutableSet.of((Object)Scope.scope(DaggerAnnotation.from(scopeAnnotation))));
        }
        return Scope.isScope(DaggerAnnotation.from(scopeAnnotation)) ? Optional.of(ImmutableSet.of((Object)Scope.scope(DaggerAnnotation.from(scopeAnnotation)))) : Optional.empty();
    }

    private Optional<XAnnotation> getScopeMetadata(XElement element) {
        return this.getGeneratedNameForScopeMetadata(element).flatMap(factoryName -> Optional.ofNullable(this.processingEnv.findTypeElement((XTypeName)factoryName))).flatMap(factory -> Optional.ofNullable(factory.getAnnotation(XTypeNames.SCOPE_METADATA)));
    }

    private Optional<XClassName> getGeneratedNameForScopeMetadata(XElement element) {
        if (XElementKt.isTypeElement((XElement)element)) {
            return XElements.asTypeElement(element).getConstructors().stream().filter(InjectionAnnotations::hasInjectOrAssistedInjectAnnotation).findFirst().map(SourceFiles::factoryNameForElement);
        }
        if (XElementKt.isMethod((XElement)element) && element.hasAnnotation(XTypeNames.PROVIDES)) {
            return Optional.of(SourceFiles.factoryNameForElement((XExecutableElement)XElements.asMethod(element)));
        }
        return Optional.empty();
    }

    public Optional<XAnnotation> getQualifier(XElement element) {
        Preconditions.checkNotNull((Object)element);
        ImmutableSet<XAnnotation> qualifierAnnotations = this.getQualifiers(element);
        switch (qualifierAnnotations.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of((XAnnotation)Iterables.getOnlyElement(qualifierAnnotations));
            }
        }
        throw new IllegalArgumentException(element + " was annotated with more than one @Qualifier annotation");
    }

    public ImmutableSet<XAnnotation> getQualifiers(XElement element) {
        XFieldElement field;
        this.superficialValidation.validateTypeOf(element);
        ImmutableSet qualifiers = this.getQualifiersWithMetadata(element).orElseGet(() -> this.getQualifiersWithoutMetadata(element));
        if (XElementKt.isField((XElement)element) && !(field = XElements.asField(element)).isStatic() && XElementKt.isTypeElement((XElement)field.getEnclosingElement()) && InjectionAnnotations.hasInjectAnnotation((XElement)field) && this.kotlinMetadataUtil.hasMetadata((XElement)field)) {
            qualifiers = (ImmutableSet)Stream.concat(qualifiers.stream(), this.getQualifiersForKotlinProperty(field).stream()).map(DaggerAnnotation::from).distinct().map(DaggerAnnotation::xprocessing).collect(DaggerStreams.toImmutableSet());
        }
        qualifiers.forEach(qualifier -> this.superficialValidation.validateAnnotationOf(element, (XAnnotation)qualifier));
        return qualifiers;
    }

    private ImmutableSet<XAnnotation> getQualifiersWithoutMetadata(XElement element) {
        this.superficialValidation.validateAnnotationTypesOf(element);
        return (ImmutableSet)element.getAllAnnotations().stream().filter(InjectionAnnotations::hasQualifierAnnotation).collect(DaggerStreams.toImmutableSet());
    }

    private Optional<ImmutableSet<XAnnotation>> getQualifiersWithMetadata(XElement element) {
        Optional<XAnnotation> qualifierMetadata = this.getQualifierMetadata(element);
        if (!qualifierMetadata.isPresent()) {
            return Optional.empty();
        }
        ImmutableSet qualifierNames = ImmutableSet.copyOf((Collection)qualifierMetadata.get().getAsStringList("value"));
        if (qualifierNames.isEmpty()) {
            return Optional.of(ImmutableSet.of());
        }
        ImmutableSet qualifierAnnotations = (ImmutableSet)element.getAllAnnotations().stream().filter(annotation -> qualifierNames.contains((Object)annotation.getType().getTypeElement().getQualifiedName())).collect(DaggerStreams.toImmutableSet());
        if (qualifierAnnotations.isEmpty()) {
            return Optional.of(ImmutableSet.of());
        }
        XAnnotation qualifierAnnotation = (XAnnotation)Iterables.getOnlyElement((Iterable)qualifierAnnotations);
        this.superficialValidation.validateAnnotationTypeOf(element, qualifierAnnotation);
        if (this.compilerOptions.strictSuperficialValidation()) {
            return Optional.of(ImmutableSet.of((Object)qualifierAnnotation));
        }
        return InjectionAnnotations.hasQualifierAnnotation(qualifierAnnotation) ? Optional.of(ImmutableSet.of((Object)qualifierAnnotation)) : Optional.empty();
    }

    private Optional<XAnnotation> getQualifierMetadata(XElement element) {
        return this.getGeneratedNameForQualifierMetadata(element).flatMap(name -> Optional.ofNullable(this.processingEnv.findTypeElement((XTypeName)name))).flatMap(type -> Optional.ofNullable(type.getAnnotation(XTypeNames.QUALIFIER_METADATA)));
    }

    private Optional<XClassName> getGeneratedNameForQualifierMetadata(XElement element) {
        if (XElementKt.isField((XElement)element) && InjectionAnnotations.hasInjectAnnotation(element)) {
            return Optional.of(SourceFiles.membersInjectorNameForType(XElements.closestEnclosingTypeElement(element)));
        }
        if (XElementKt.isMethod((XElement)element) && element.hasAnnotation(XTypeNames.PROVIDES)) {
            return Optional.of(SourceFiles.factoryNameForElement((XExecutableElement)XElements.asMethod(element)));
        }
        if (XElementKt.isMethodParameter((XElement)element)) {
            XExecutableElement executableElement = XElements.asMethodParameter(element).getEnclosingElement();
            if (XElementKt.isConstructor((XElement)executableElement) && InjectionAnnotations.hasInjectOrAssistedInjectAnnotation((XElement)executableElement)) {
                return Optional.of(SourceFiles.factoryNameForElement(executableElement));
            }
            if (XElementKt.isMethod((XElement)executableElement) && InjectionAnnotations.hasInjectAnnotation((XElement)executableElement)) {
                return Optional.of(SourceFiles.membersInjectorNameForType(XElements.closestEnclosingTypeElement(element)));
            }
            if (XElementKt.isMethod((XElement)executableElement) && executableElement.hasAnnotation(XTypeNames.PROVIDES)) {
                return Optional.of(SourceFiles.factoryNameForElement(executableElement));
            }
        }
        return Optional.empty();
    }

    public static ImmutableSet<XConstructorElement> injectedConstructors(XTypeElement type) {
        return (ImmutableSet)type.getConstructors().stream().filter(InjectionAnnotations::hasInjectAnnotation).collect(DaggerStreams.toImmutableSet());
    }

    private static boolean hasQualifierAnnotation(XAnnotation annotation) {
        return annotation.getType().getTypeElement().hasAnyAnnotation(new XClassName[]{XTypeNames.QUALIFIER, XTypeNames.QUALIFIER_JAVAX});
    }

    private static boolean hasScopeAnnotation(XAnnotation annotation) {
        return annotation.getType().getTypeElement().hasAnyAnnotation(new XClassName[]{XTypeNames.SCOPE, XTypeNames.SCOPE_JAVAX});
    }

    public static boolean hasInjectAnnotation(XElement element) {
        return element.hasAnyAnnotation(new XClassName[]{XTypeNames.INJECT, XTypeNames.INJECT_JAVAX});
    }

    private static boolean hasInjectOrAssistedInjectAnnotation(XElement element) {
        return element.hasAnyAnnotation(new XClassName[]{XTypeNames.INJECT, XTypeNames.INJECT_JAVAX, XTypeNames.ASSISTED_INJECT});
    }

    private ImmutableSet<XAnnotation> getQualifiersForKotlinProperty(XFieldElement field) {
        if (this.kotlinMetadataUtil.isMissingSyntheticPropertyForAnnotations(field)) {
            XTypeElement membersInjector = this.processingEnv.findTypeElement((XTypeName)SourceFiles.membersInjectorNameForType(XElements.asTypeElement((XElement)field.getEnclosingElement())));
            if (membersInjector != null) {
                String memberInjectedFieldSignature = SourceFiles.memberInjectedFieldSignatureForVariable(field);
                return ((Optional)membersInjector.getDeclaredMethods().stream().filter(method -> Optional.ofNullable(method.getAnnotation(XTypeNames.INJECTED_FIELD_SIGNATURE)).map(annotation -> annotation.getAsString("value")).map(memberInjectedFieldSignature::equals).orElse(false)).collect(DaggerCollectors.toOptional())).map(this::getQualifiers).orElseThrow(() -> new IllegalStateException(String.format("No matching InjectedFieldSignature for %1$s. This likely means that %1$s was compiled with an older, incompatible version of Dagger. Please update all Dagger dependencies to the same version.", memberInjectedFieldSignature)));
            }
            throw new IllegalStateException("No MembersInjector found for " + field.getEnclosingElement());
        }
        return (ImmutableSet)Stream.concat(this.kotlinMetadataUtil.getSyntheticPropertyAnnotations(field, XTypeNames.QUALIFIER).stream(), this.kotlinMetadataUtil.getSyntheticPropertyAnnotations(field, XTypeNames.QUALIFIER_JAVAX).stream()).collect(DaggerStreams.toImmutableSet());
    }
}

