package dagger.internal.codegen.binding;

import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XTypeElement;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.model.Scope;
import dagger.internal.codegen.xprocessing.Nullability;
import java.util.Optional;

// Generated by com.google.auto.value.processor.AutoValueProcessor
abstract class $AutoValue_DelegateBinding extends DelegateBinding {

  private final ContributionType contributionType;

  private final Key key;

  private final Optional<XElement> bindingElement;

  private final Optional<XTypeElement> contributingModule;

  private final Optional<? extends Binding> unresolved;

  private final Optional<Scope> scope;

  private final Optional<BindingType> optionalBindingType;

  private final Nullability nullability;

  private final DependencyRequest delegateRequest;

  $AutoValue_DelegateBinding(
      ContributionType contributionType,
      Key key,
      Optional<XElement> bindingElement,
      Optional<XTypeElement> contributingModule,
      Optional<? extends Binding> unresolved,
      Optional<Scope> scope,
      Optional<BindingType> optionalBindingType,
      Nullability nullability,
      DependencyRequest delegateRequest) {
    if (contributionType == null) {
      throw new NullPointerException("Null contributionType");
    }
    this.contributionType = contributionType;
    if (key == null) {
      throw new NullPointerException("Null key");
    }
    this.key = key;
    if (bindingElement == null) {
      throw new NullPointerException("Null bindingElement");
    }
    this.bindingElement = bindingElement;
    if (contributingModule == null) {
      throw new NullPointerException("Null contributingModule");
    }
    this.contributingModule = contributingModule;
    if (unresolved == null) {
      throw new NullPointerException("Null unresolved");
    }
    this.unresolved = unresolved;
    if (scope == null) {
      throw new NullPointerException("Null scope");
    }
    this.scope = scope;
    if (optionalBindingType == null) {
      throw new NullPointerException("Null optionalBindingType");
    }
    this.optionalBindingType = optionalBindingType;
    if (nullability == null) {
      throw new NullPointerException("Null nullability");
    }
    this.nullability = nullability;
    if (delegateRequest == null) {
      throw new NullPointerException("Null delegateRequest");
    }
    this.delegateRequest = delegateRequest;
  }

  @Override
  public ContributionType contributionType() {
    return contributionType;
  }

  @Override
  public Key key() {
    return key;
  }

  @Override
  public Optional<XElement> bindingElement() {
    return bindingElement;
  }

  @Override
  public Optional<XTypeElement> contributingModule() {
    return contributingModule;
  }

  @Override
  public Optional<? extends Binding> unresolved() {
    return unresolved;
  }

  @Override
  public Optional<Scope> scope() {
    return scope;
  }

  @Override
  Optional<BindingType> optionalBindingType() {
    return optionalBindingType;
  }

  @Override
  public Nullability nullability() {
    return nullability;
  }

  @Override
  DependencyRequest delegateRequest() {
    return delegateRequest;
  }

  @Override
  public String toString() {
    return "DelegateBinding{"
        + "contributionType=" + contributionType + ", "
        + "key=" + key + ", "
        + "bindingElement=" + bindingElement + ", "
        + "contributingModule=" + contributingModule + ", "
        + "unresolved=" + unresolved + ", "
        + "scope=" + scope + ", "
        + "optionalBindingType=" + optionalBindingType + ", "
        + "nullability=" + nullability + ", "
        + "delegateRequest=" + delegateRequest
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof DelegateBinding) {
      DelegateBinding that = (DelegateBinding) o;
      return this.contributionType.equals(that.contributionType())
          && this.key.equals(that.key())
          && this.bindingElement.equals(that.bindingElement())
          && this.contributingModule.equals(that.contributingModule())
          && this.unresolved.equals(that.unresolved())
          && this.scope.equals(that.scope())
          && this.optionalBindingType.equals(that.optionalBindingType())
          && this.nullability.equals(that.nullability())
          && this.delegateRequest.equals(that.delegateRequest());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= contributionType.hashCode();
    h$ *= 1000003;
    h$ ^= key.hashCode();
    h$ *= 1000003;
    h$ ^= bindingElement.hashCode();
    h$ *= 1000003;
    h$ ^= contributingModule.hashCode();
    h$ *= 1000003;
    h$ ^= unresolved.hashCode();
    h$ *= 1000003;
    h$ ^= scope.hashCode();
    h$ *= 1000003;
    h$ ^= optionalBindingType.hashCode();
    h$ *= 1000003;
    h$ ^= nullability.hashCode();
    h$ *= 1000003;
    h$ ^= delegateRequest.hashCode();
    return h$;
  }

  @Override
  public DelegateBinding.Builder toBuilder() {
    return new Builder(this);
  }

  static class Builder extends DelegateBinding.Builder {
    private ContributionType contributionType;
    private Key key;
    private Optional<XElement> bindingElement = Optional.empty();
    private Optional<XTypeElement> contributingModule = Optional.empty();
    private Optional<? extends Binding> unresolved = Optional.empty();
    private Optional<Scope> scope = Optional.empty();
    private Optional<BindingType> optionalBindingType = Optional.empty();
    private Nullability nullability;
    private DependencyRequest delegateRequest;
    Builder() {
    }
    private Builder(DelegateBinding source) {
      this.contributionType = source.contributionType();
      this.key = source.key();
      this.bindingElement = source.bindingElement();
      this.contributingModule = source.contributingModule();
      this.unresolved = source.unresolved();
      this.scope = source.scope();
      this.optionalBindingType = source.optionalBindingType();
      this.nullability = source.nullability();
      this.delegateRequest = source.delegateRequest();
    }
    @Override
    DelegateBinding.Builder contributionType(ContributionType contributionType) {
      if (contributionType == null) {
        throw new NullPointerException("Null contributionType");
      }
      this.contributionType = contributionType;
      return this;
    }
    @Override
    DelegateBinding.Builder key(Key key) {
      if (key == null) {
        throw new NullPointerException("Null key");
      }
      this.key = key;
      return this;
    }
    @Override
    DelegateBinding.Builder bindingElement(XElement bindingElement) {
      this.bindingElement = Optional.of(bindingElement);
      return this;
    }
    @Override
    DelegateBinding.Builder bindingElement(Optional<XElement> bindingElement) {
      if (bindingElement == null) {
        throw new NullPointerException("Null bindingElement");
      }
      this.bindingElement = bindingElement;
      return this;
    }
    @Override
    DelegateBinding.Builder contributingModule(XTypeElement contributingModule) {
      this.contributingModule = Optional.of(contributingModule);
      return this;
    }
    @Override
    DelegateBinding.Builder unresolved(Optional<? extends Binding> unresolved) {
      if (unresolved == null) {
        throw new NullPointerException("Null unresolved");
      }
      this.unresolved = unresolved;
      return this;
    }
    @Override
    DelegateBinding.Builder scope(Optional<Scope> scope) {
      if (scope == null) {
        throw new NullPointerException("Null scope");
      }
      this.scope = scope;
      return this;
    }
    @Override
    DelegateBinding.Builder optionalBindingType(Optional<BindingType> optionalBindingType) {
      if (optionalBindingType == null) {
        throw new NullPointerException("Null optionalBindingType");
      }
      this.optionalBindingType = optionalBindingType;
      return this;
    }
    @Override
    DelegateBinding.Builder nullability(Nullability nullability) {
      if (nullability == null) {
        throw new NullPointerException("Null nullability");
      }
      this.nullability = nullability;
      return this;
    }
    @Override
    DelegateBinding.Builder delegateRequest(DependencyRequest delegateRequest) {
      if (delegateRequest == null) {
        throw new NullPointerException("Null delegateRequest");
      }
      this.delegateRequest = delegateRequest;
      return this;
    }
    @Override
    DelegateBinding build() {
      if (this.contributionType == null
          || this.key == null
          || this.nullability == null
          || this.delegateRequest == null) {
        StringBuilder missing = new StringBuilder();
        if (this.contributionType == null) {
          missing.append(" contributionType");
        }
        if (this.key == null) {
          missing.append(" key");
        }
        if (this.nullability == null) {
          missing.append(" nullability");
        }
        if (this.delegateRequest == null) {
          missing.append(" delegateRequest");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_DelegateBinding(
          this.contributionType,
          this.key,
          this.bindingElement,
          this.contributingModule,
          this.unresolved,
          this.scope,
          this.optionalBindingType,
          this.nullability,
          this.delegateRequest);
    }
  }

}
