package dagger.internal.codegen.binding;

import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XTypeElement;
import com.google.common.collect.ImmutableSortedSet;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.model.Scope;
import java.util.Optional;

// Generated by com.google.auto.value.processor.AutoValueProcessor
abstract class $AutoValue_MembersInjectorBinding extends MembersInjectorBinding {

  private final Key key;

  private final Optional<XElement> bindingElement;

  private final Optional<XTypeElement> contributingModule;

  private final Optional<? extends Binding> unresolved;

  private final Optional<Scope> scope;

  private final ImmutableSortedSet<MembersInjectionBinding.InjectionSite> injectionSites;

  $AutoValue_MembersInjectorBinding(
      Key key,
      Optional<XElement> bindingElement,
      Optional<XTypeElement> contributingModule,
      Optional<? extends Binding> unresolved,
      Optional<Scope> scope,
      ImmutableSortedSet<MembersInjectionBinding.InjectionSite> injectionSites) {
    if (key == null) {
      throw new NullPointerException("Null key");
    }
    this.key = key;
    if (bindingElement == null) {
      throw new NullPointerException("Null bindingElement");
    }
    this.bindingElement = bindingElement;
    if (contributingModule == null) {
      throw new NullPointerException("Null contributingModule");
    }
    this.contributingModule = contributingModule;
    if (unresolved == null) {
      throw new NullPointerException("Null unresolved");
    }
    this.unresolved = unresolved;
    if (scope == null) {
      throw new NullPointerException("Null scope");
    }
    this.scope = scope;
    if (injectionSites == null) {
      throw new NullPointerException("Null injectionSites");
    }
    this.injectionSites = injectionSites;
  }

  @Override
  public Key key() {
    return key;
  }

  @Override
  public Optional<XElement> bindingElement() {
    return bindingElement;
  }

  @Override
  public Optional<XTypeElement> contributingModule() {
    return contributingModule;
  }

  @Override
  public Optional<? extends Binding> unresolved() {
    return unresolved;
  }

  @Override
  public Optional<Scope> scope() {
    return scope;
  }

  @Override
  public ImmutableSortedSet<MembersInjectionBinding.InjectionSite> injectionSites() {
    return injectionSites;
  }

  @Override
  public String toString() {
    return "MembersInjectorBinding{"
        + "key=" + key + ", "
        + "bindingElement=" + bindingElement + ", "
        + "contributingModule=" + contributingModule + ", "
        + "unresolved=" + unresolved + ", "
        + "scope=" + scope + ", "
        + "injectionSites=" + injectionSites
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof MembersInjectorBinding) {
      MembersInjectorBinding that = (MembersInjectorBinding) o;
      return this.key.equals(that.key())
          && this.bindingElement.equals(that.bindingElement())
          && this.contributingModule.equals(that.contributingModule())
          && this.unresolved.equals(that.unresolved())
          && this.scope.equals(that.scope())
          && this.injectionSites.equals(that.injectionSites());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= key.hashCode();
    h$ *= 1000003;
    h$ ^= bindingElement.hashCode();
    h$ *= 1000003;
    h$ ^= contributingModule.hashCode();
    h$ *= 1000003;
    h$ ^= unresolved.hashCode();
    h$ *= 1000003;
    h$ ^= scope.hashCode();
    h$ *= 1000003;
    h$ ^= injectionSites.hashCode();
    return h$;
  }

  @Override
  public MembersInjectorBinding.Builder toBuilder() {
    return new Builder(this);
  }

  static class Builder extends MembersInjectorBinding.Builder {
    private Key key;
    private Optional<XElement> bindingElement = Optional.empty();
    private Optional<XTypeElement> contributingModule = Optional.empty();
    private Optional<? extends Binding> unresolved = Optional.empty();
    private Optional<Scope> scope = Optional.empty();
    private ImmutableSortedSet<MembersInjectionBinding.InjectionSite> injectionSites;
    Builder() {
    }
    private Builder(MembersInjectorBinding source) {
      this.key = source.key();
      this.bindingElement = source.bindingElement();
      this.contributingModule = source.contributingModule();
      this.unresolved = source.unresolved();
      this.scope = source.scope();
      this.injectionSites = source.injectionSites();
    }
    @Override
    MembersInjectorBinding.Builder key(Key key) {
      if (key == null) {
        throw new NullPointerException("Null key");
      }
      this.key = key;
      return this;
    }
    @Override
    MembersInjectorBinding.Builder bindingElement(XElement bindingElement) {
      this.bindingElement = Optional.of(bindingElement);
      return this;
    }
    @Override
    MembersInjectorBinding.Builder bindingElement(Optional<XElement> bindingElement) {
      if (bindingElement == null) {
        throw new NullPointerException("Null bindingElement");
      }
      this.bindingElement = bindingElement;
      return this;
    }
    @Override
    MembersInjectorBinding.Builder contributingModule(XTypeElement contributingModule) {
      this.contributingModule = Optional.of(contributingModule);
      return this;
    }
    @Override
    MembersInjectorBinding.Builder unresolved(Optional<? extends Binding> unresolved) {
      if (unresolved == null) {
        throw new NullPointerException("Null unresolved");
      }
      this.unresolved = unresolved;
      return this;
    }
    @Override
    MembersInjectorBinding.Builder scope(Optional<Scope> scope) {
      if (scope == null) {
        throw new NullPointerException("Null scope");
      }
      this.scope = scope;
      return this;
    }
    @Override
    MembersInjectorBinding.Builder injectionSites(ImmutableSortedSet<MembersInjectionBinding.InjectionSite> injectionSites) {
      if (injectionSites == null) {
        throw new NullPointerException("Null injectionSites");
      }
      this.injectionSites = injectionSites;
      return this;
    }
    @Override
    MembersInjectorBinding build() {
      if (this.key == null
          || this.injectionSites == null) {
        StringBuilder missing = new StringBuilder();
        if (this.key == null) {
          missing.append(" key");
        }
        if (this.injectionSites == null) {
          missing.append(" injectionSites");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_MembersInjectorBinding(
          this.key,
          this.bindingElement,
          this.contributingModule,
          this.unresolved,
          this.scope,
          this.injectionSites);
    }
  }

}
