package dagger.internal.codegen.binding;

import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XTypeElement;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.model.Scope;
import java.util.Optional;

// Generated by com.google.auto.value.processor.AutoValueProcessor
abstract class $AutoValue_MultiboundMapBinding extends MultiboundMapBinding {

  private final Key key;

  private final Optional<XElement> bindingElement;

  private final Optional<XTypeElement> contributingModule;

  private final ImmutableSet<DependencyRequest> dependencies;

  private final Optional<? extends Binding> unresolved;

  private final Optional<Scope> scope;

  private final Optional<BindingType> optionalBindingType;

  $AutoValue_MultiboundMapBinding(
      Key key,
      Optional<XElement> bindingElement,
      Optional<XTypeElement> contributingModule,
      ImmutableSet<DependencyRequest> dependencies,
      Optional<? extends Binding> unresolved,
      Optional<Scope> scope,
      Optional<BindingType> optionalBindingType) {
    if (key == null) {
      throw new NullPointerException("Null key");
    }
    this.key = key;
    if (bindingElement == null) {
      throw new NullPointerException("Null bindingElement");
    }
    this.bindingElement = bindingElement;
    if (contributingModule == null) {
      throw new NullPointerException("Null contributingModule");
    }
    this.contributingModule = contributingModule;
    if (dependencies == null) {
      throw new NullPointerException("Null dependencies");
    }
    this.dependencies = dependencies;
    if (unresolved == null) {
      throw new NullPointerException("Null unresolved");
    }
    this.unresolved = unresolved;
    if (scope == null) {
      throw new NullPointerException("Null scope");
    }
    this.scope = scope;
    if (optionalBindingType == null) {
      throw new NullPointerException("Null optionalBindingType");
    }
    this.optionalBindingType = optionalBindingType;
  }

  @Override
  public Key key() {
    return key;
  }

  @Override
  public Optional<XElement> bindingElement() {
    return bindingElement;
  }

  @Override
  public Optional<XTypeElement> contributingModule() {
    return contributingModule;
  }

  @Override
  public ImmutableSet<DependencyRequest> dependencies() {
    return dependencies;
  }

  @Override
  public Optional<? extends Binding> unresolved() {
    return unresolved;
  }

  @Override
  public Optional<Scope> scope() {
    return scope;
  }

  @Override
  Optional<BindingType> optionalBindingType() {
    return optionalBindingType;
  }

  @Override
  public String toString() {
    return "MultiboundMapBinding{"
        + "key=" + key + ", "
        + "bindingElement=" + bindingElement + ", "
        + "contributingModule=" + contributingModule + ", "
        + "dependencies=" + dependencies + ", "
        + "unresolved=" + unresolved + ", "
        + "scope=" + scope + ", "
        + "optionalBindingType=" + optionalBindingType
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof MultiboundMapBinding) {
      MultiboundMapBinding that = (MultiboundMapBinding) o;
      return this.key.equals(that.key())
          && this.bindingElement.equals(that.bindingElement())
          && this.contributingModule.equals(that.contributingModule())
          && this.dependencies.equals(that.dependencies())
          && this.unresolved.equals(that.unresolved())
          && this.scope.equals(that.scope())
          && this.optionalBindingType.equals(that.optionalBindingType());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= key.hashCode();
    h$ *= 1000003;
    h$ ^= bindingElement.hashCode();
    h$ *= 1000003;
    h$ ^= contributingModule.hashCode();
    h$ *= 1000003;
    h$ ^= dependencies.hashCode();
    h$ *= 1000003;
    h$ ^= unresolved.hashCode();
    h$ *= 1000003;
    h$ ^= scope.hashCode();
    h$ *= 1000003;
    h$ ^= optionalBindingType.hashCode();
    return h$;
  }

  @Override
  public MultiboundMapBinding.Builder toBuilder() {
    return new Builder(this);
  }

  static class Builder extends MultiboundMapBinding.Builder {
    private Key key;
    private Optional<XElement> bindingElement = Optional.empty();
    private Optional<XTypeElement> contributingModule = Optional.empty();
    private ImmutableSet<DependencyRequest> dependencies;
    private Optional<? extends Binding> unresolved = Optional.empty();
    private Optional<Scope> scope = Optional.empty();
    private Optional<BindingType> optionalBindingType = Optional.empty();
    Builder() {
    }
    private Builder(MultiboundMapBinding source) {
      this.key = source.key();
      this.bindingElement = source.bindingElement();
      this.contributingModule = source.contributingModule();
      this.dependencies = source.dependencies();
      this.unresolved = source.unresolved();
      this.scope = source.scope();
      this.optionalBindingType = source.optionalBindingType();
    }
    @Override
    MultiboundMapBinding.Builder key(Key key) {
      if (key == null) {
        throw new NullPointerException("Null key");
      }
      this.key = key;
      return this;
    }
    @Override
    MultiboundMapBinding.Builder bindingElement(XElement bindingElement) {
      this.bindingElement = Optional.of(bindingElement);
      return this;
    }
    @Override
    MultiboundMapBinding.Builder bindingElement(Optional<XElement> bindingElement) {
      if (bindingElement == null) {
        throw new NullPointerException("Null bindingElement");
      }
      this.bindingElement = bindingElement;
      return this;
    }
    @Override
    MultiboundMapBinding.Builder contributingModule(XTypeElement contributingModule) {
      this.contributingModule = Optional.of(contributingModule);
      return this;
    }
    @Override
    MultiboundMapBinding.Builder dependencies(ImmutableSet<DependencyRequest> dependencies) {
      if (dependencies == null) {
        throw new NullPointerException("Null dependencies");
      }
      this.dependencies = dependencies;
      return this;
    }
    @Override
    MultiboundMapBinding.Builder unresolved(Optional<? extends Binding> unresolved) {
      if (unresolved == null) {
        throw new NullPointerException("Null unresolved");
      }
      this.unresolved = unresolved;
      return this;
    }
    @Override
    MultiboundMapBinding.Builder scope(Optional<Scope> scope) {
      if (scope == null) {
        throw new NullPointerException("Null scope");
      }
      this.scope = scope;
      return this;
    }
    @Override
    MultiboundMapBinding.Builder optionalBindingType(Optional<BindingType> optionalBindingType) {
      if (optionalBindingType == null) {
        throw new NullPointerException("Null optionalBindingType");
      }
      this.optionalBindingType = optionalBindingType;
      return this;
    }
    @Override
    MultiboundMapBinding build() {
      if (this.key == null
          || this.dependencies == null) {
        StringBuilder missing = new StringBuilder();
        if (this.key == null) {
          missing.append(" key");
        }
        if (this.dependencies == null) {
          missing.append(" dependencies");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_MultiboundMapBinding(
          this.key,
          this.bindingElement,
          this.contributingModule,
          this.dependencies,
          this.unresolved,
          this.scope,
          this.optionalBindingType);
    }
  }

}
