package dagger.internal.codegen.binding;

import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XTypeElement;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.model.Scope;
import java.util.Optional;

// Generated by com.google.auto.value.processor.AutoValueProcessor
abstract class $AutoValue_OptionalBinding extends OptionalBinding {

  private final Key key;

  private final Optional<XElement> bindingElement;

  private final Optional<XTypeElement> contributingModule;

  private final Optional<? extends Binding> unresolved;

  private final Optional<Scope> scope;

  private final Optional<BindingType> optionalBindingType;

  private final Optional<DependencyRequest> delegateRequest;

  $AutoValue_OptionalBinding(
      Key key,
      Optional<XElement> bindingElement,
      Optional<XTypeElement> contributingModule,
      Optional<? extends Binding> unresolved,
      Optional<Scope> scope,
      Optional<BindingType> optionalBindingType,
      Optional<DependencyRequest> delegateRequest) {
    if (key == null) {
      throw new NullPointerException("Null key");
    }
    this.key = key;
    if (bindingElement == null) {
      throw new NullPointerException("Null bindingElement");
    }
    this.bindingElement = bindingElement;
    if (contributingModule == null) {
      throw new NullPointerException("Null contributingModule");
    }
    this.contributingModule = contributingModule;
    if (unresolved == null) {
      throw new NullPointerException("Null unresolved");
    }
    this.unresolved = unresolved;
    if (scope == null) {
      throw new NullPointerException("Null scope");
    }
    this.scope = scope;
    if (optionalBindingType == null) {
      throw new NullPointerException("Null optionalBindingType");
    }
    this.optionalBindingType = optionalBindingType;
    if (delegateRequest == null) {
      throw new NullPointerException("Null delegateRequest");
    }
    this.delegateRequest = delegateRequest;
  }

  @Override
  public Key key() {
    return key;
  }

  @Override
  public Optional<XElement> bindingElement() {
    return bindingElement;
  }

  @Override
  public Optional<XTypeElement> contributingModule() {
    return contributingModule;
  }

  @Override
  public Optional<? extends Binding> unresolved() {
    return unresolved;
  }

  @Override
  public Optional<Scope> scope() {
    return scope;
  }

  @Override
  Optional<BindingType> optionalBindingType() {
    return optionalBindingType;
  }

  @Override
  Optional<DependencyRequest> delegateRequest() {
    return delegateRequest;
  }

  @Override
  public String toString() {
    return "OptionalBinding{"
        + "key=" + key + ", "
        + "bindingElement=" + bindingElement + ", "
        + "contributingModule=" + contributingModule + ", "
        + "unresolved=" + unresolved + ", "
        + "scope=" + scope + ", "
        + "optionalBindingType=" + optionalBindingType + ", "
        + "delegateRequest=" + delegateRequest
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof OptionalBinding) {
      OptionalBinding that = (OptionalBinding) o;
      return this.key.equals(that.key())
          && this.bindingElement.equals(that.bindingElement())
          && this.contributingModule.equals(that.contributingModule())
          && this.unresolved.equals(that.unresolved())
          && this.scope.equals(that.scope())
          && this.optionalBindingType.equals(that.optionalBindingType())
          && this.delegateRequest.equals(that.delegateRequest());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= key.hashCode();
    h$ *= 1000003;
    h$ ^= bindingElement.hashCode();
    h$ *= 1000003;
    h$ ^= contributingModule.hashCode();
    h$ *= 1000003;
    h$ ^= unresolved.hashCode();
    h$ *= 1000003;
    h$ ^= scope.hashCode();
    h$ *= 1000003;
    h$ ^= optionalBindingType.hashCode();
    h$ *= 1000003;
    h$ ^= delegateRequest.hashCode();
    return h$;
  }

  @Override
  public OptionalBinding.Builder toBuilder() {
    return new Builder(this);
  }

  static class Builder extends OptionalBinding.Builder {
    private Key key;
    private Optional<XElement> bindingElement = Optional.empty();
    private Optional<XTypeElement> contributingModule = Optional.empty();
    private Optional<? extends Binding> unresolved = Optional.empty();
    private Optional<Scope> scope = Optional.empty();
    private Optional<BindingType> optionalBindingType = Optional.empty();
    private Optional<DependencyRequest> delegateRequest = Optional.empty();
    Builder() {
    }
    private Builder(OptionalBinding source) {
      this.key = source.key();
      this.bindingElement = source.bindingElement();
      this.contributingModule = source.contributingModule();
      this.unresolved = source.unresolved();
      this.scope = source.scope();
      this.optionalBindingType = source.optionalBindingType();
      this.delegateRequest = source.delegateRequest();
    }
    @Override
    OptionalBinding.Builder key(Key key) {
      if (key == null) {
        throw new NullPointerException("Null key");
      }
      this.key = key;
      return this;
    }
    @Override
    OptionalBinding.Builder bindingElement(XElement bindingElement) {
      this.bindingElement = Optional.of(bindingElement);
      return this;
    }
    @Override
    OptionalBinding.Builder bindingElement(Optional<XElement> bindingElement) {
      if (bindingElement == null) {
        throw new NullPointerException("Null bindingElement");
      }
      this.bindingElement = bindingElement;
      return this;
    }
    @Override
    OptionalBinding.Builder contributingModule(XTypeElement contributingModule) {
      this.contributingModule = Optional.of(contributingModule);
      return this;
    }
    @Override
    OptionalBinding.Builder unresolved(Optional<? extends Binding> unresolved) {
      if (unresolved == null) {
        throw new NullPointerException("Null unresolved");
      }
      this.unresolved = unresolved;
      return this;
    }
    @Override
    OptionalBinding.Builder scope(Optional<Scope> scope) {
      if (scope == null) {
        throw new NullPointerException("Null scope");
      }
      this.scope = scope;
      return this;
    }
    @Override
    OptionalBinding.Builder optionalBindingType(Optional<BindingType> optionalBindingType) {
      if (optionalBindingType == null) {
        throw new NullPointerException("Null optionalBindingType");
      }
      this.optionalBindingType = optionalBindingType;
      return this;
    }
    @Override
    OptionalBinding.Builder delegateRequest(DependencyRequest delegateRequest) {
      this.delegateRequest = Optional.of(delegateRequest);
      return this;
    }
    @Override
    OptionalBinding build() {
      if (this.key == null) {
        String missing = " key";
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_OptionalBinding(
          this.key,
          this.bindingElement,
          this.contributingModule,
          this.unresolved,
          this.scope,
          this.optionalBindingType,
          this.delegateRequest);
    }
  }

}
