package dagger.internal.codegen.binding;

import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XTypeElement;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.model.Scope;
import java.util.Optional;

// Generated by com.google.auto.value.processor.AutoValueProcessor
abstract class $AutoValue_ProductionBinding extends ProductionBinding {

  private final Key key;

  private final Optional<XElement> bindingElement;

  private final Optional<XTypeElement> contributingModule;

  private final Optional<? extends Binding> unresolved;

  private final Optional<Scope> scope;

  private final ImmutableSet<DependencyRequest> explicitDependencies;

  private final DependencyRequest executorRequest;

  private final DependencyRequest monitorRequest;

  $AutoValue_ProductionBinding(
      Key key,
      Optional<XElement> bindingElement,
      Optional<XTypeElement> contributingModule,
      Optional<? extends Binding> unresolved,
      Optional<Scope> scope,
      ImmutableSet<DependencyRequest> explicitDependencies,
      DependencyRequest executorRequest,
      DependencyRequest monitorRequest) {
    if (key == null) {
      throw new NullPointerException("Null key");
    }
    this.key = key;
    if (bindingElement == null) {
      throw new NullPointerException("Null bindingElement");
    }
    this.bindingElement = bindingElement;
    if (contributingModule == null) {
      throw new NullPointerException("Null contributingModule");
    }
    this.contributingModule = contributingModule;
    if (unresolved == null) {
      throw new NullPointerException("Null unresolved");
    }
    this.unresolved = unresolved;
    if (scope == null) {
      throw new NullPointerException("Null scope");
    }
    this.scope = scope;
    if (explicitDependencies == null) {
      throw new NullPointerException("Null explicitDependencies");
    }
    this.explicitDependencies = explicitDependencies;
    if (executorRequest == null) {
      throw new NullPointerException("Null executorRequest");
    }
    this.executorRequest = executorRequest;
    if (monitorRequest == null) {
      throw new NullPointerException("Null monitorRequest");
    }
    this.monitorRequest = monitorRequest;
  }

  @Override
  public Key key() {
    return key;
  }

  @Override
  public Optional<XElement> bindingElement() {
    return bindingElement;
  }

  @Override
  public Optional<XTypeElement> contributingModule() {
    return contributingModule;
  }

  @Override
  public Optional<? extends Binding> unresolved() {
    return unresolved;
  }

  @Override
  public Optional<Scope> scope() {
    return scope;
  }

  @Override
  public ImmutableSet<DependencyRequest> explicitDependencies() {
    return explicitDependencies;
  }

  @Override
  public DependencyRequest executorRequest() {
    return executorRequest;
  }

  @Override
  public DependencyRequest monitorRequest() {
    return monitorRequest;
  }

  @Override
  public String toString() {
    return "ProductionBinding{"
        + "key=" + key + ", "
        + "bindingElement=" + bindingElement + ", "
        + "contributingModule=" + contributingModule + ", "
        + "unresolved=" + unresolved + ", "
        + "scope=" + scope + ", "
        + "explicitDependencies=" + explicitDependencies + ", "
        + "executorRequest=" + executorRequest + ", "
        + "monitorRequest=" + monitorRequest
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ProductionBinding) {
      ProductionBinding that = (ProductionBinding) o;
      return this.key.equals(that.key())
          && this.bindingElement.equals(that.bindingElement())
          && this.contributingModule.equals(that.contributingModule())
          && this.unresolved.equals(that.unresolved())
          && this.scope.equals(that.scope())
          && this.explicitDependencies.equals(that.explicitDependencies())
          && this.executorRequest.equals(that.executorRequest())
          && this.monitorRequest.equals(that.monitorRequest());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= key.hashCode();
    h$ *= 1000003;
    h$ ^= bindingElement.hashCode();
    h$ *= 1000003;
    h$ ^= contributingModule.hashCode();
    h$ *= 1000003;
    h$ ^= unresolved.hashCode();
    h$ *= 1000003;
    h$ ^= scope.hashCode();
    h$ *= 1000003;
    h$ ^= explicitDependencies.hashCode();
    h$ *= 1000003;
    h$ ^= executorRequest.hashCode();
    h$ *= 1000003;
    h$ ^= monitorRequest.hashCode();
    return h$;
  }

  @Override
  public ProductionBinding.Builder toBuilder() {
    return new Builder(this);
  }

  static class Builder extends ProductionBinding.Builder {
    private Key key;
    private Optional<XElement> bindingElement = Optional.empty();
    private Optional<XTypeElement> contributingModule = Optional.empty();
    private Optional<? extends Binding> unresolved = Optional.empty();
    private Optional<Scope> scope = Optional.empty();
    private ImmutableSet<DependencyRequest> explicitDependencies;
    private DependencyRequest executorRequest;
    private DependencyRequest monitorRequest;
    Builder() {
    }
    private Builder(ProductionBinding source) {
      this.key = source.key();
      this.bindingElement = source.bindingElement();
      this.contributingModule = source.contributingModule();
      this.unresolved = source.unresolved();
      this.scope = source.scope();
      this.explicitDependencies = source.explicitDependencies();
      this.executorRequest = source.executorRequest();
      this.monitorRequest = source.monitorRequest();
    }
    @Override
    ProductionBinding.Builder key(Key key) {
      if (key == null) {
        throw new NullPointerException("Null key");
      }
      this.key = key;
      return this;
    }
    @Override
    ProductionBinding.Builder bindingElement(XElement bindingElement) {
      this.bindingElement = Optional.of(bindingElement);
      return this;
    }
    @Override
    ProductionBinding.Builder bindingElement(Optional<XElement> bindingElement) {
      if (bindingElement == null) {
        throw new NullPointerException("Null bindingElement");
      }
      this.bindingElement = bindingElement;
      return this;
    }
    @Override
    ProductionBinding.Builder contributingModule(XTypeElement contributingModule) {
      this.contributingModule = Optional.of(contributingModule);
      return this;
    }
    @Override
    ProductionBinding.Builder unresolved(Optional<? extends Binding> unresolved) {
      if (unresolved == null) {
        throw new NullPointerException("Null unresolved");
      }
      this.unresolved = unresolved;
      return this;
    }
    @Override
    ProductionBinding.Builder scope(Optional<Scope> scope) {
      if (scope == null) {
        throw new NullPointerException("Null scope");
      }
      this.scope = scope;
      return this;
    }
    @Override
    ProductionBinding.Builder explicitDependencies(Iterable<DependencyRequest> explicitDependencies) {
      this.explicitDependencies = ImmutableSet.copyOf(explicitDependencies);
      return this;
    }
    @Override
    ProductionBinding.Builder executorRequest(DependencyRequest executorRequest) {
      if (executorRequest == null) {
        throw new NullPointerException("Null executorRequest");
      }
      this.executorRequest = executorRequest;
      return this;
    }
    @Override
    ProductionBinding.Builder monitorRequest(DependencyRequest monitorRequest) {
      if (monitorRequest == null) {
        throw new NullPointerException("Null monitorRequest");
      }
      this.monitorRequest = monitorRequest;
      return this;
    }
    @Override
    ProductionBinding build() {
      if (this.key == null
          || this.explicitDependencies == null
          || this.executorRequest == null
          || this.monitorRequest == null) {
        StringBuilder missing = new StringBuilder();
        if (this.key == null) {
          missing.append(" key");
        }
        if (this.explicitDependencies == null) {
          missing.append(" explicitDependencies");
        }
        if (this.executorRequest == null) {
          missing.append(" executorRequest");
        }
        if (this.monitorRequest == null) {
          missing.append(" monitorRequest");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ProductionBinding(
          this.key,
          this.bindingElement,
          this.contributingModule,
          this.unresolved,
          this.scope,
          this.explicitDependencies,
          this.executorRequest,
          this.monitorRequest);
    }
  }

}
