package dagger.internal.codegen.binding;

import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XTypeElement;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.concurrent.LazyInit;
import dagger.internal.codegen.base.ComponentAnnotation;
import dagger.internal.codegen.model.Scope;
import java.lang.Object;
import java.lang.Override;
import java.lang.SuppressWarnings;
import java.util.Optional;

final class AutoValue_ComponentDescriptor extends $AutoValue_ComponentDescriptor {
  @LazyInit
  @SuppressWarnings("Immutable")
  private transient volatile ImmutableSet<ComponentRequirement> requirements;

  @LazyInit
  @SuppressWarnings("Immutable")
  private transient volatile ImmutableMap<XMethodElement, ComponentRequirement> dependenciesByDependencyMethod;

  @LazyInit
  @SuppressWarnings("Immutable")
  private transient volatile ImmutableMap<XTypeElement, ComponentDescriptor> childComponentsByElement;

  @LazyInit
  @SuppressWarnings("Immutable")
  private transient volatile ImmutableSet<ContributionBinding> bindings;

  @LazyInit
  @SuppressWarnings("Immutable")
  private transient volatile Optional<ContributionBinding> componentBinding;

  @LazyInit
  @SuppressWarnings("Immutable")
  private transient volatile ImmutableSet<ContributionBinding> componentDependencyBindings;

  @LazyInit
  @SuppressWarnings("Immutable")
  private transient volatile ImmutableSet<ContributionBinding> boundInstanceBindings;

  @LazyInit
  @SuppressWarnings("Immutable")
  private transient volatile ImmutableSet<ContributionBinding> subcomponentCreatorBindings;

  @LazyInit
  @SuppressWarnings("Immutable")
  private transient volatile ImmutableSet<ContributionBinding> moduleBindings;

  @LazyInit
  @SuppressWarnings("Immutable")
  private transient volatile ImmutableSet<DelegateDeclaration> delegateDeclarations;

  @LazyInit
  @SuppressWarnings("Immutable")
  private transient volatile ImmutableSet<MultibindingDeclaration> multibindingDeclarations;

  @LazyInit
  @SuppressWarnings("Immutable")
  private transient volatile ImmutableSet<OptionalBindingDeclaration> optionalBindingDeclarations;

  @LazyInit
  @SuppressWarnings("Immutable")
  private transient volatile ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations;

  @LazyInit
  @SuppressWarnings("Immutable")
  private transient volatile int hashCode;

  @LazyInit
  @SuppressWarnings("Immutable")
  private transient volatile boolean hashCode$Memoized;

  AutoValue_ComponentDescriptor(ComponentAnnotation annotation$, XTypeElement typeElement$,
      ImmutableSet<ComponentRequirement> dependencies$, ImmutableSet<ModuleDescriptor> modules$,
      ImmutableSet<Scope> scopes$,
      ImmutableSet<ComponentDescriptor> childComponentsDeclaredByModules$,
      ImmutableBiMap<ComponentDescriptor.ComponentMethodDescriptor, ComponentDescriptor> childComponentsDeclaredByFactoryMethods$,
      ImmutableMap<ComponentDescriptor.ComponentMethodDescriptor, ComponentDescriptor> childComponentsDeclaredByBuilderEntryPoints$,
      ImmutableSet<ComponentDescriptor.ComponentMethodDescriptor> componentMethods$,
      Optional<ComponentCreatorDescriptor> creatorDescriptor$) {
    super(annotation$, typeElement$, dependencies$, modules$, scopes$, childComponentsDeclaredByModules$, childComponentsDeclaredByFactoryMethods$, childComponentsDeclaredByBuilderEntryPoints$, componentMethods$, creatorDescriptor$);
  }

  @Override
  ImmutableSet<ComponentRequirement> requirements() {
    if (requirements == null) {
      synchronized (this) {
        if (requirements == null) {
          requirements = super.requirements();
          if (requirements == null) {
            throw new NullPointerException("requirements() cannot return null");
          }
        }
      }
    }
    return requirements;
  }

  @Override
  public ImmutableMap<XMethodElement, ComponentRequirement> dependenciesByDependencyMethod() {
    if (dependenciesByDependencyMethod == null) {
      synchronized (this) {
        if (dependenciesByDependencyMethod == null) {
          dependenciesByDependencyMethod = super.dependenciesByDependencyMethod();
          if (dependenciesByDependencyMethod == null) {
            throw new NullPointerException("dependenciesByDependencyMethod() cannot return null");
          }
        }
      }
    }
    return dependenciesByDependencyMethod;
  }

  @Override
  public ImmutableMap<XTypeElement, ComponentDescriptor> childComponentsByElement() {
    if (childComponentsByElement == null) {
      synchronized (this) {
        if (childComponentsByElement == null) {
          childComponentsByElement = super.childComponentsByElement();
          if (childComponentsByElement == null) {
            throw new NullPointerException("childComponentsByElement() cannot return null");
          }
        }
      }
    }
    return childComponentsByElement;
  }

  @Override
  public ImmutableSet<ContributionBinding> bindings() {
    if (bindings == null) {
      synchronized (this) {
        if (bindings == null) {
          bindings = super.bindings();
          if (bindings == null) {
            throw new NullPointerException("bindings() cannot return null");
          }
        }
      }
    }
    return bindings;
  }

  @Override
  Optional<ContributionBinding> componentBinding() {
    if (componentBinding == null) {
      synchronized (this) {
        if (componentBinding == null) {
          componentBinding = super.componentBinding();
          if (componentBinding == null) {
            throw new NullPointerException("componentBinding() cannot return null");
          }
        }
      }
    }
    return componentBinding;
  }

  @Override
  ImmutableSet<ContributionBinding> componentDependencyBindings() {
    if (componentDependencyBindings == null) {
      synchronized (this) {
        if (componentDependencyBindings == null) {
          componentDependencyBindings = super.componentDependencyBindings();
          if (componentDependencyBindings == null) {
            throw new NullPointerException("componentDependencyBindings() cannot return null");
          }
        }
      }
    }
    return componentDependencyBindings;
  }

  @Override
  ImmutableSet<ContributionBinding> boundInstanceBindings() {
    if (boundInstanceBindings == null) {
      synchronized (this) {
        if (boundInstanceBindings == null) {
          boundInstanceBindings = super.boundInstanceBindings();
          if (boundInstanceBindings == null) {
            throw new NullPointerException("boundInstanceBindings() cannot return null");
          }
        }
      }
    }
    return boundInstanceBindings;
  }

  @Override
  ImmutableSet<ContributionBinding> subcomponentCreatorBindings() {
    if (subcomponentCreatorBindings == null) {
      synchronized (this) {
        if (subcomponentCreatorBindings == null) {
          subcomponentCreatorBindings = super.subcomponentCreatorBindings();
          if (subcomponentCreatorBindings == null) {
            throw new NullPointerException("subcomponentCreatorBindings() cannot return null");
          }
        }
      }
    }
    return subcomponentCreatorBindings;
  }

  @Override
  ImmutableSet<ContributionBinding> moduleBindings() {
    if (moduleBindings == null) {
      synchronized (this) {
        if (moduleBindings == null) {
          moduleBindings = super.moduleBindings();
          if (moduleBindings == null) {
            throw new NullPointerException("moduleBindings() cannot return null");
          }
        }
      }
    }
    return moduleBindings;
  }

  @Override
  public ImmutableSet<DelegateDeclaration> delegateDeclarations() {
    if (delegateDeclarations == null) {
      synchronized (this) {
        if (delegateDeclarations == null) {
          delegateDeclarations = super.delegateDeclarations();
          if (delegateDeclarations == null) {
            throw new NullPointerException("delegateDeclarations() cannot return null");
          }
        }
      }
    }
    return delegateDeclarations;
  }

  @Override
  public ImmutableSet<MultibindingDeclaration> multibindingDeclarations() {
    if (multibindingDeclarations == null) {
      synchronized (this) {
        if (multibindingDeclarations == null) {
          multibindingDeclarations = super.multibindingDeclarations();
          if (multibindingDeclarations == null) {
            throw new NullPointerException("multibindingDeclarations() cannot return null");
          }
        }
      }
    }
    return multibindingDeclarations;
  }

  @Override
  public ImmutableSet<OptionalBindingDeclaration> optionalBindingDeclarations() {
    if (optionalBindingDeclarations == null) {
      synchronized (this) {
        if (optionalBindingDeclarations == null) {
          optionalBindingDeclarations = super.optionalBindingDeclarations();
          if (optionalBindingDeclarations == null) {
            throw new NullPointerException("optionalBindingDeclarations() cannot return null");
          }
        }
      }
    }
    return optionalBindingDeclarations;
  }

  @Override
  public ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations() {
    if (subcomponentDeclarations == null) {
      synchronized (this) {
        if (subcomponentDeclarations == null) {
          subcomponentDeclarations = super.subcomponentDeclarations();
          if (subcomponentDeclarations == null) {
            throw new NullPointerException("subcomponentDeclarations() cannot return null");
          }
        }
      }
    }
    return subcomponentDeclarations;
  }

  @Override
  public int hashCode() {
    if (!hashCode$Memoized) {
      synchronized (this) {
        if (!hashCode$Memoized) {
          hashCode = super.hashCode();
          hashCode$Memoized = true;
        }
      }
    }
    return hashCode;
  }

  @Override
  public boolean equals(Object that) {
    if (this == that) {
      return true;
    }
    return that instanceof AutoValue_ComponentDescriptor && this.hashCode() == that.hashCode() && super.equals(that);
  }
}
