/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.xprocessing.XAnnotationValues;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeNameKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotationValue;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMemberContainer;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeKt;

public final class AnnotationExpression {
    private final XAnnotation annotation;
    private final XClassName creatorClass;

    AnnotationExpression(XAnnotation annotation) {
        this.annotation = annotation;
        this.creatorClass = AnnotationExpression.getAnnotationCreatorClassName(annotation.getType().getTypeElement());
    }

    CodeBlock getAnnotationInstanceExpression() {
        return this.getAnnotationInstanceExpression(this.annotation);
    }

    private CodeBlock getAnnotationInstanceExpression(XAnnotation annotation) {
        return CodeBlock.of((String)"$T.$L($L)", (Object[])new Object[]{XTypeNameKt.toJavaPoet((XClassName)this.creatorClass), AnnotationExpression.createMethodName(annotation.getType().getTypeElement()), CodeBlocks.makeParametersCodeBlock((Iterable)annotation.getAnnotationValues().stream().map(this::getValueExpression).collect(DaggerStreams.toImmutableList()))});
    }

    public static XClassName getAnnotationCreatorClassName(XTypeElement annotationType) {
        XClassName annotationTypeName = annotationType.asClassName();
        return XClassName.Companion.get(annotationTypeName.getPackageName(), new String[]{SourceFiles.classFileName(annotationTypeName) + "Creator"});
    }

    public static String createMethodName(XTypeElement annotationType) {
        return "create" + XElements.getSimpleName((XMemberContainer)annotationType);
    }

    CodeBlock getValueExpression(XAnnotationValue value) {
        if (XTypeKt.isArray((XType)value.getValueType())) {
            XType componentType = XTypes.asArray(value.getValueType()).getComponentType();
            return CodeBlock.of((String)"new $T[] {$L}", (Object[])new Object[]{XTypeNameKt.toJavaPoet((XTypeName)(XTypes.isTypeOf(componentType, XTypeNames.KCLASS) ? XTypeNames.CLASS : componentType.getRawType().asTypeName())), value.asAnnotationValueList().stream().map(this::getValueExpression).collect(CodeBlocks.toParametersCodeBlock())});
        }
        if (value.hasEnumValue()) {
            return CodeBlock.of((String)"$T.$L", (Object[])new Object[]{value.asEnum().getEnclosingElement().getClassName(), XElements.getSimpleName((XElement)value.asEnum())});
        }
        if (value.hasAnnotationValue()) {
            return this.getAnnotationInstanceExpression(value.asAnnotation());
        }
        if (value.hasTypeValue()) {
            return CodeBlock.of((String)"$T.class", (Object[])new Object[]{value.asType().getTypeElement().getClassName()});
        }
        if (value.hasStringValue()) {
            return CodeBlock.of((String)"$S", (Object[])new Object[]{value.asString()});
        }
        if (value.hasByteValue()) {
            return CodeBlock.of((String)"(byte) $L", (Object[])new Object[]{value.asByte()});
        }
        if (value.hasCharValue()) {
            return CodeBlock.of((String)"$L", (Object[])new Object[]{XAnnotationValues.characterLiteralWithSingleQuotes(value.asChar())});
        }
        if (value.hasDoubleValue()) {
            return CodeBlock.of((String)"$LD", (Object[])new Object[]{value.asDouble()});
        }
        if (value.hasFloatValue()) {
            return CodeBlock.of((String)"$LF", (Object[])new Object[]{Float.valueOf(value.asFloat())});
        }
        if (value.hasLongValue()) {
            return CodeBlock.of((String)"$LL", (Object[])new Object[]{value.asLong()});
        }
        if (value.hasShortValue()) {
            return CodeBlock.of((String)"(short) $L", (Object[])new Object[]{value.asShort()});
        }
        return CodeBlock.of((String)"$L", (Object[])new Object[]{value.getValue()});
    }
}

