/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Supplier;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentNames;
import dagger.internal.codegen.writing.GeneratedImplementation;
import dagger.internal.codegen.writing.PerGeneratedFile;
import dagger.internal.codegen.writing.TopLevel;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeNameKt;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

@PerGeneratedFile
public final class ComponentWrapperImplementation
implements GeneratedImplementation {
    private final BindingGraph graph;
    private final XClassName name;
    private final UniqueNameSet componentClassNames = new UniqueNameSet();
    private final ListMultimap<ComponentImplementation.FieldSpecKind, FieldSpec> fieldSpecsMap = MultimapBuilder.enumKeys(ComponentImplementation.FieldSpecKind.class).arrayListValues().build();
    private final ListMultimap<ComponentImplementation.MethodSpecKind, MethodSpec> methodSpecsMap = MultimapBuilder.enumKeys(ComponentImplementation.MethodSpecKind.class).arrayListValues().build();
    private final ListMultimap<ComponentImplementation.TypeSpecKind, TypeSpec> typeSpecsMap = MultimapBuilder.enumKeys(ComponentImplementation.TypeSpecKind.class).arrayListValues().build();
    private final List<Supplier<TypeSpec>> typeSuppliers = new ArrayList<Supplier<TypeSpec>>();

    @Inject
    ComponentWrapperImplementation(@TopLevel BindingGraph graph) {
        this.graph = graph;
        this.name = ComponentNames.getTopLevelClassName(graph.componentDescriptor());
    }

    @Override
    public XClassName name() {
        return this.name;
    }

    @Override
    public String getUniqueClassName(String name) {
        return this.componentClassNames.getUniqueName(name);
    }

    @Override
    public void addField(ComponentImplementation.FieldSpecKind fieldKind, FieldSpec fieldSpec) {
        this.fieldSpecsMap.put((Object)fieldKind, (Object)fieldSpec);
    }

    @Override
    public void addMethod(ComponentImplementation.MethodSpecKind methodKind, MethodSpec methodSpec) {
        this.methodSpecsMap.put((Object)methodKind, (Object)methodSpec);
    }

    @Override
    public void addType(ComponentImplementation.TypeSpecKind typeKind, TypeSpec typeSpec) {
        this.typeSpecsMap.put((Object)typeKind, (Object)typeSpec);
    }

    @Override
    public void addTypeSupplier(Supplier<TypeSpec> typeSpecSupplier) {
        this.typeSuppliers.add(typeSpecSupplier);
    }

    @Override
    public TypeSpec generate() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)XTypeNameKt.toJavaPoet((XClassName)ComponentNames.getTopLevelClassName(this.graph.componentDescriptor()))).addModifiers(new Modifier[]{Modifier.FINAL});
        if (this.graph.componentTypeElement().isPublic()) {
            builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        }
        this.fieldSpecsMap.asMap().values().forEach(arg_0 -> ((TypeSpec.Builder)builder).addFields(arg_0));
        this.methodSpecsMap.asMap().values().forEach(arg_0 -> ((TypeSpec.Builder)builder).addMethods(arg_0));
        this.typeSpecsMap.asMap().values().forEach(arg_0 -> ((TypeSpec.Builder)builder).addTypes(arg_0));
        this.typeSuppliers.stream().map(Supplier::get).forEach(arg_0 -> ((TypeSpec.Builder)builder).addType(arg_0));
        return builder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build()).build();
    }
}

