/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.binding.BindsTypeChecker;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.DelegateBinding;
import dagger.internal.codegen.binding.FrameworkType;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.DelegateRequestRepresentation;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;

final class DerivedFromFrameworkInstanceRequestRepresentation
extends RequestRepresentation {
    private final ContributionBinding binding;
    private final RequestRepresentation frameworkRequestRepresentation;
    private final RequestKind requestKind;
    private final FrameworkType frameworkType;
    private final XProcessingEnv processingEnv;
    private final BindsTypeChecker bindsTypeChecker;

    @AssistedInject
    DerivedFromFrameworkInstanceRequestRepresentation(@Assisted ContributionBinding binding, @Assisted RequestRepresentation frameworkRequestRepresentation, @Assisted RequestKind requestKind, @Assisted FrameworkType frameworkType, XProcessingEnv processingEnv, BindsTypeChecker bindsTypeChecker) {
        this.binding = binding;
        this.frameworkRequestRepresentation = (RequestRepresentation)Preconditions.checkNotNull((Object)frameworkRequestRepresentation);
        this.requestKind = requestKind;
        this.frameworkType = (FrameworkType)((Object)Preconditions.checkNotNull((Object)((Object)frameworkType)));
        this.processingEnv = processingEnv;
        this.bindsTypeChecker = bindsTypeChecker;
    }

    @Override
    Expression getDependencyExpression(XClassName requestingClass) {
        return this.getDependencyExpressionFromFrameworkExpression(this.frameworkRequestRepresentation.getDependencyExpression(requestingClass), requestingClass);
    }

    @Override
    Expression getDependencyExpressionForComponentMethod(ComponentDescriptor.ComponentMethodDescriptor componentMethod, ComponentImplementation component) {
        return this.getDependencyExpressionFromFrameworkExpression(this.frameworkRequestRepresentation.getDependencyExpressionForComponentMethod(componentMethod, component), component.name());
    }

    private Expression getDependencyExpressionFromFrameworkExpression(Expression frameworkExpression, XClassName requestingClass) {
        Expression expression = this.frameworkType.to(this.requestKind, frameworkExpression, this.processingEnv);
        if (MapType.isMapOfProvider(this.binding.contributedType())) {
            return this.castMapOfProvider(expression, this.binding);
        }
        return this.requiresTypeCast(expression, requestingClass) ? expression.castTo(this.binding.contributedType()) : expression;
    }

    private Expression castMapOfProvider(Expression expression, ContributionBinding binding) {
        switch (this.requestKind) {
            case INSTANCE: {
                return expression.castTo(binding.contributedType());
            }
            case PROVIDER: 
            case PROVIDER_OF_LAZY: {
                return expression.castTo(this.processingEnv.requireType((XTypeName)XTypeNames.DAGGER_PROVIDER).getRawType());
            }
            case LAZY: {
                return expression.castTo(this.processingEnv.requireType((XTypeName)XTypeNames.LAZY).getRawType());
            }
            case PRODUCER: 
            case FUTURE: {
                return expression.castTo(this.processingEnv.requireType((XTypeName)XTypeNames.PRODUCER).getRawType());
            }
            case PRODUCED: {
                return expression.castTo(this.processingEnv.requireType((XTypeName)XTypeNames.PRODUCED).getRawType());
            }
        }
        throw new IllegalStateException("Unexpected request kind: " + (Object)((Object)this.requestKind));
    }

    private boolean requiresTypeCast(Expression expression, XClassName requestingClass) {
        return this.binding.kind().equals((Object)BindingKind.DELEGATE) && this.requestKind.equals((Object)RequestKind.INSTANCE) && DelegateRequestRepresentation.instanceRequiresCast((DelegateBinding)this.binding, expression, requestingClass, this.bindsTypeChecker);
    }

    @AssistedFactory
    static interface Factory {
        public DerivedFromFrameworkInstanceRequestRepresentation create(ContributionBinding var1, RequestRepresentation var2, RequestKind var3, FrameworkType var4);
    }
}

