/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.AssistedInjectionBinding;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.InjectionBinding;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.xprocessing.Nullability;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeNameKt;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XVariableElement;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.lang.model.element.Modifier;

final class InjectionMethods {
    InjectionMethods() {
    }

    private static CodeBlock invokeMethod(String methodName, ImmutableList<CodeBlock> parameters, XClassName enclosingClass, XClassName requestingClass) {
        CodeBlock parameterBlock = CodeBlocks.makeParametersCodeBlock(parameters);
        return enclosingClass.equals((Object)requestingClass) ? CodeBlock.of((String)"$L($L)", (Object[])new Object[]{methodName, parameterBlock}) : CodeBlock.of((String)"$T.$L($L)", (Object[])new Object[]{XTypeNameKt.toJavaPoet((XClassName)enclosingClass), methodName, parameterBlock});
    }

    static CodeBlock copyParameters(MethodSpec.Builder methodBuilder, UniqueNameSet parameterNameSet, List<? extends XVariableElement> parameters) {
        return parameters.stream().map(parameter -> {
            String name = parameterNameSet.getUniqueName(XElementKt.isMethodParameter((XElement)parameter) ? XElements.asMethodParameter((XElement)parameter).getJvmName() : XElements.getSimpleName((XElement)parameter));
            boolean useObject = !Accessibility.isRawTypePubliclyAccessible(parameter.getType());
            return InjectionMethods.copyParameter(methodBuilder, parameter.getType(), name, useObject, Nullability.of((XElement)parameter));
        }).collect(CodeBlocks.toParametersCodeBlock());
    }

    static CodeBlock copyParameter(MethodSpec.Builder methodBuilder, XType type, String name, boolean useObject, Nullability nullability) {
        ClassName typeName = useObject ? TypeName.OBJECT : type.getTypeName();
        nullability.typeUseNullableAnnotations().stream().map(XConverters::toJavaPoet).map(it -> AnnotationSpec.builder((ClassName)it).build()).forEach(arg_0 -> InjectionMethods.lambda$copyParameter$2((TypeName)typeName, arg_0));
        methodBuilder.addParameter(ParameterSpec.builder((TypeName)typeName, (String)name, (Modifier[])new Modifier[0]).addAnnotations((Iterable)nullability.nonTypeUseNullableAnnotations().stream().map(XConverters::toJavaPoet).map(it -> AnnotationSpec.builder((ClassName)it).build()).collect(DaggerStreams.toImmutableList())).build());
        return useObject ? CodeBlock.of((String)"($T) $L", (Object[])new Object[]{type.getTypeName(), name}) : CodeBlock.of((String)"$L", (Object[])new Object[]{name});
    }

    private static /* synthetic */ void lambda$copyParameter$2(TypeName rec$, AnnotationSpec xva$0) {
        rec$.annotated(new AnnotationSpec[]{xva$0});
    }

    static final class InjectionSiteMethod {
        InjectionSiteMethod() {
        }

        static CodeBlock invokeAll(ImmutableSet<MembersInjectionBinding.InjectionSite> injectionSites, XClassName generatedTypeName, CodeBlock instanceCodeBlock, XType instanceType, Function<DependencyRequest, CodeBlock> dependencyUsage) {
            return injectionSites.stream().map(injectionSite -> {
                XType injectSiteType = injectionSite.enclosingTypeElement().getType();
                CodeBlock maybeCastedInstance = instanceType.getTypeName().equals((Object)TypeName.OBJECT) && Accessibility.isRawTypeAccessible(injectSiteType, generatedTypeName.getPackageName()) ? CodeBlock.of((String)"($T) $L", (Object[])new Object[]{XTypes.erasedTypeName(injectSiteType), instanceCodeBlock}) : instanceCodeBlock;
                return CodeBlock.of((String)"$L;", (Object[])new Object[]{InjectionSiteMethod.invoke(injectionSite, generatedTypeName, maybeCastedInstance, dependencyUsage)});
            }).collect(CodeBlocks.toConcatenatedCodeBlock());
        }

        private static CodeBlock invoke(MembersInjectionBinding.InjectionSite injectionSite, XClassName generatedTypeName, CodeBlock instanceCodeBlock, Function<DependencyRequest, CodeBlock> dependencyUsage) {
            ImmutableList arguments = ImmutableList.builder().add((Object)instanceCodeBlock).addAll((Iterable)injectionSite.dependencies().stream().map(dependencyUsage).collect(DaggerStreams.toImmutableList())).build();
            XClassName enclosingClass = SourceFiles.membersInjectorNameForType(injectionSite.enclosingTypeElement());
            String methodName = SourceFiles.membersInjectorMethodName(injectionSite);
            return InjectionMethods.invokeMethod(methodName, (ImmutableList<CodeBlock>)arguments, enclosingClass, generatedTypeName);
        }
    }

    static final class ProvisionMethod {
        ProvisionMethod() {
        }

        static CodeBlock invoke(ContributionBinding binding, Function<DependencyRequest, CodeBlock> dependencyUsage, Function<XExecutableParameterElement, String> uniqueAssistedParameterName, XClassName requestingClass, Optional<CodeBlock> moduleReference, CompilerOptions compilerOptions) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            moduleReference.ifPresent(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
            ProvisionMethod.invokeArguments(binding, dependencyUsage, uniqueAssistedParameterName).forEach(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
            XClassName enclosingClass = SourceFiles.generatedClassNameForBinding(binding);
            String methodName = SourceFiles.generatedProxyMethodName(binding);
            return InjectionMethods.invokeMethod(methodName, (ImmutableList<CodeBlock>)arguments.build(), enclosingClass, requestingClass);
        }

        static ImmutableList<CodeBlock> invokeArguments(ContributionBinding binding, Function<DependencyRequest, CodeBlock> dependencyUsage, Function<XExecutableParameterElement, String> uniqueAssistedParameterName) {
            ImmutableMap dependencyRequestMap = (ImmutableMap)ProvisionMethod.provisionDependencies(binding).stream().collect(DaggerStreams.toImmutableMap(request -> XElements.asMethodParameter(request.requestElement().get().xprocessing()), request -> request));
            ImmutableList.Builder arguments = ImmutableList.builder();
            XExecutableElement method = XElements.asExecutable(binding.bindingElement().get());
            for (XExecutableParameterElement parameter : method.getParameters()) {
                if (AssistedInjectionAnnotations.isAssistedParameter((XVariableElement)parameter)) {
                    arguments.add((Object)CodeBlock.of((String)"$L", (Object[])new Object[]{uniqueAssistedParameterName.apply(parameter)}));
                    continue;
                }
                if (dependencyRequestMap.containsKey((Object)parameter)) {
                    DependencyRequest request2 = (DependencyRequest)dependencyRequestMap.get((Object)parameter);
                    arguments.add((Object)dependencyUsage.apply(request2));
                    continue;
                }
                throw new AssertionError((Object)("Unexpected parameter: " + parameter));
            }
            return arguments.build();
        }

        private static ImmutableSet<DependencyRequest> provisionDependencies(ContributionBinding binding) {
            switch (binding.kind()) {
                case INJECTION: {
                    return ((InjectionBinding)binding).constructorDependencies();
                }
                case ASSISTED_INJECTION: {
                    return ((AssistedInjectionBinding)binding).constructorDependencies();
                }
                case PROVISION: {
                    return ((ProvisionBinding)binding).dependencies();
                }
            }
            throw new AssertionError((Object)("Unexpected binding kind: " + (Object)((Object)binding.kind())));
        }
    }
}

