/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.collect.Iterables;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.base.OptionalType;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.OptionalBinding;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.xprocessing.XProcessingEnvs;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;

final class OptionalRequestRepresentation
extends RequestRepresentation {
    private final OptionalBinding binding;
    private final ComponentRequestRepresentations componentRequestRepresentations;
    private final XProcessingEnv processingEnv;

    @AssistedInject
    OptionalRequestRepresentation(@Assisted OptionalBinding binding, ComponentImplementation componentImplementation, ComponentRequestRepresentations componentRequestRepresentations, XProcessingEnv processingEnv) {
        this.binding = binding;
        this.componentRequestRepresentations = componentRequestRepresentations;
        this.processingEnv = processingEnv;
    }

    @Override
    Expression getDependencyExpression(XClassName requestingClass) {
        OptionalType optionalType = OptionalType.from(this.binding.key());
        OptionalType.OptionalKind optionalKind = optionalType.kind();
        if (this.binding.dependencies().isEmpty()) {
            if (XProcessingEnvs.isPreJava8SourceVersion(this.processingEnv) && Accessibility.isTypeAccessibleFrom(this.binding.key().type().xprocessing(), requestingClass.getPackageName())) {
                return Expression.create(this.binding.key().type().xprocessing(), optionalKind.parameterizedAbsentValueExpression(optionalType));
            }
            return Expression.create(this.binding.key().type().xprocessing(), optionalKind.absentValueExpression());
        }
        DependencyRequest dependency = (DependencyRequest)Iterables.getOnlyElement(this.binding.dependencies());
        CodeBlock dependencyExpression = this.componentRequestRepresentations.getDependencyExpression(BindingRequest.bindingRequest(dependency), requestingClass).codeBlock();
        boolean needsObjectExpression = !Accessibility.isTypeAccessibleFrom(dependency.key().type().xprocessing(), requestingClass.getPackageName()) || XProcessingEnvs.isPreJava8SourceVersion(this.processingEnv) && dependency.kind() == RequestKind.PROVIDER;
        return !needsObjectExpression ? Expression.create(this.binding.key().type().xprocessing(), optionalKind.presentExpression(dependencyExpression)) : Expression.create(this.processingEnv.getDeclaredType(this.processingEnv.findTypeElement((XTypeName)optionalKind.className()), new XType[]{this.processingEnv.findType((TypeName)TypeName.OBJECT)}), optionalKind.presentObjectExpression(dependencyExpression));
    }

    @AssistedFactory
    static interface Factory {
        public OptionalRequestRepresentation create(OptionalBinding var1);
    }
}

