/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.graph.Graph;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingNode;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ChildFactoryMethodEdgeImpl;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentNodeImpl;
import dagger.internal.codegen.binding.DependencyEdgeImpl;
import dagger.internal.codegen.binding.LegacyBindingGraphFactory;
import dagger.internal.codegen.binding.MissingBindingImpl;
import dagger.internal.codegen.binding.SubcomponentCreatorBindingEdgeImpl;
import dagger.internal.codegen.extension.DaggerGraphs;
import dagger.internal.codegen.model.BindingGraph;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.ComponentPath;
import dagger.internal.codegen.model.DaggerTypeElement;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;

final class LegacyBindingGraphConverter {
    @Inject
    LegacyBindingGraphConverter() {
    }

    BindingGraph convert(LegacyBindingGraphFactory.LegacyBindingGraph legacyBindingGraph, boolean isFullBindingGraph) {
        MutableNetwork<BindingGraph.Node, BindingGraph.Edge> network = Converter.convertToNetwork(legacyBindingGraph);
        BindingGraph.ComponentNode rootNode = legacyBindingGraph.componentNode();
        if (!isFullBindingGraph) {
            DaggerGraphs.unreachableNodes((Graph)network.asGraph(), (Object)rootNode).forEach(arg_0 -> network.removeNode(arg_0));
        }
        return BindingGraph.create((ImmutableNetwork<BindingGraph.Node, BindingGraph.Edge>)ImmutableNetwork.copyOf(network), isFullBindingGraph);
    }

    private static final class Converter {
        private final Deque<LegacyBindingGraphFactory.LegacyBindingGraph> bindingGraphPath = new ArrayDeque<LegacyBindingGraphFactory.LegacyBindingGraph>();
        private final MutableNetwork<BindingGraph.Node, BindingGraph.Edge> network = NetworkBuilder.directed().allowsParallelEdges(true).allowsSelfLoops(true).build();
        private final Set<BindingNode> bindings = new HashSet<BindingNode>();

        private Converter() {
        }

        static MutableNetwork<BindingGraph.Node, BindingGraph.Edge> convertToNetwork(LegacyBindingGraphFactory.LegacyBindingGraph graph) {
            Converter converter = new Converter();
            converter.visitRootComponent(graph);
            return converter.network;
        }

        private void visitRootComponent(LegacyBindingGraphFactory.LegacyBindingGraph graph) {
            this.visitComponent(graph);
        }

        private void visitComponent(LegacyBindingGraphFactory.LegacyBindingGraph graph) {
            this.bindingGraphPath.addLast(graph);
            this.network.addNode((Object)graph.componentNode());
            for (ComponentDescriptor.ComponentMethodDescriptor entryPointMethod : graph.componentDescriptor().entryPointMethods()) {
                this.addDependencyEdges(graph.componentNode(), entryPointMethod.dependencyRequest().get());
            }
            for (LegacyBindingGraphFactory.LegacyResolvedBindings resolvedBindings : graph.resolvedBindings()) {
                for (BindingNode binding : resolvedBindings.bindingNodes()) {
                    if (this.bindings.add(binding)) {
                        this.network.addNode((Object)binding);
                        for (DependencyRequest dependencyRequest : binding.dependencies()) {
                            this.addDependencyEdges(binding, dependencyRequest);
                        }
                    }
                    if (!binding.kind().equals((Object)BindingKind.SUBCOMPONENT_CREATOR) || !binding.componentPath().equals(graph.componentPath())) continue;
                    this.network.addEdge((Object)binding, (Object)this.subcomponentNode(binding.key().type().xprocessing(), graph), (Object)new SubcomponentCreatorBindingEdgeImpl(binding.subcomponentDeclarations()));
                }
            }
            for (LegacyBindingGraphFactory.LegacyBindingGraph childGraph : graph.subgraphs()) {
                this.visitComponent(childGraph);
                graph.componentDescriptor().getFactoryMethodForChildComponent(childGraph.componentDescriptor()).ifPresent(childFactoryMethod -> this.network.addEdge((Object)graph.componentNode(), (Object)childGraph.componentNode(), (Object)new ChildFactoryMethodEdgeImpl(childFactoryMethod.methodElement())));
            }
            Verify.verify((boolean)this.bindingGraphPath.removeLast().equals(graph));
        }

        private ComponentPath componentPath() {
            return this.bindingGraphPath.getLast().componentPath();
        }

        private LegacyBindingGraphFactory.LegacyBindingGraph graphForAncestor(XTypeElement ancestor) {
            for (LegacyBindingGraphFactory.LegacyBindingGraph graph : this.bindingGraphPath) {
                if (!graph.componentDescriptor().typeElement().equals(ancestor)) continue;
                return graph;
            }
            throw new IllegalArgumentException(String.format("%s is not in the current path: %s", ancestor.getQualifiedName(), this.componentPath()));
        }

        private void addDependencyEdges(BindingGraph.Node source, DependencyRequest dependencyRequest) {
            LegacyBindingGraphFactory.LegacyResolvedBindings dependencies = this.resolvedDependencies(source, dependencyRequest);
            if (dependencies.isEmpty()) {
                this.addDependencyEdge(source, dependencyRequest, this.missingBindingNode(dependencies));
            } else {
                for (BindingNode dependency : dependencies.bindingNodes()) {
                    this.addDependencyEdge(source, dependencyRequest, dependency);
                }
            }
        }

        private void addDependencyEdge(BindingGraph.Node source, DependencyRequest dependencyRequest, BindingGraph.Node dependency) {
            this.network.addNode((Object)dependency);
            if (!this.hasDependencyEdge(source, dependency, dependencyRequest)) {
                this.network.addEdge((Object)source, (Object)dependency, (Object)new DependencyEdgeImpl(dependencyRequest, source instanceof BindingGraph.ComponentNode));
            }
        }

        private boolean hasDependencyEdge(BindingGraph.Node source, BindingGraph.Node dependency, DependencyRequest dependencyRequest) {
            for (BindingGraph.Edge edge : this.network.edgesConnecting((Object)source, (Object)dependency)) {
                if (!(edge instanceof BindingGraph.DependencyEdge) || !((BindingGraph.DependencyEdge)edge).dependencyRequest().equals(dependencyRequest)) continue;
                return true;
            }
            return false;
        }

        private LegacyBindingGraphFactory.LegacyResolvedBindings resolvedDependencies(BindingGraph.Node source, DependencyRequest dependencyRequest) {
            return this.graphForAncestor(source.componentPath().currentComponent().xprocessing()).resolvedBindings(BindingRequest.bindingRequest(dependencyRequest));
        }

        private BindingGraph.MissingBinding missingBindingNode(LegacyBindingGraphFactory.LegacyResolvedBindings dependencies) {
            return MissingBindingImpl.create(ComponentPath.create((Iterable<DaggerTypeElement>)ImmutableList.of((Object)this.componentPath().rootComponent())), dependencies.key());
        }

        private BindingGraph.ComponentNode subcomponentNode(XType subcomponentBuilderType, LegacyBindingGraphFactory.LegacyBindingGraph graph) {
            XTypeElement subcomponentBuilderElement = subcomponentBuilderType.getTypeElement();
            ComponentDescriptor subcomponent = graph.componentDescriptor().getChildComponentWithBuilderType(subcomponentBuilderElement);
            return ComponentNodeImpl.create(this.componentPath().childPath(DaggerTypeElement.from(subcomponent.typeElement())), subcomponent);
        }
    }
}

