package dagger.internal.codegen.binding;

import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XTypeElement;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.model.Scope;
import dagger.internal.codegen.xprocessing.Nullability;
import java.util.Optional;

// Generated by com.google.auto.value.processor.AutoValueProcessor
abstract class $AutoValue_BoundInstanceBinding extends BoundInstanceBinding {

  private final Key key;

  private final Optional<XElement> bindingElement;

  private final Optional<XTypeElement> contributingModule;

  private final Optional<? extends Binding> unresolved;

  private final Optional<Scope> scope;

  private final Nullability nullability;

  $AutoValue_BoundInstanceBinding(
      Key key,
      Optional<XElement> bindingElement,
      Optional<XTypeElement> contributingModule,
      Optional<? extends Binding> unresolved,
      Optional<Scope> scope,
      Nullability nullability) {
    if (key == null) {
      throw new NullPointerException("Null key");
    }
    this.key = key;
    if (bindingElement == null) {
      throw new NullPointerException("Null bindingElement");
    }
    this.bindingElement = bindingElement;
    if (contributingModule == null) {
      throw new NullPointerException("Null contributingModule");
    }
    this.contributingModule = contributingModule;
    if (unresolved == null) {
      throw new NullPointerException("Null unresolved");
    }
    this.unresolved = unresolved;
    if (scope == null) {
      throw new NullPointerException("Null scope");
    }
    this.scope = scope;
    if (nullability == null) {
      throw new NullPointerException("Null nullability");
    }
    this.nullability = nullability;
  }

  @Override
  public Key key() {
    return key;
  }

  @Override
  public Optional<XElement> bindingElement() {
    return bindingElement;
  }

  @Override
  public Optional<XTypeElement> contributingModule() {
    return contributingModule;
  }

  @Override
  public Optional<? extends Binding> unresolved() {
    return unresolved;
  }

  @Override
  public Optional<Scope> scope() {
    return scope;
  }

  @Override
  public Nullability nullability() {
    return nullability;
  }

  @Override
  public String toString() {
    return "BoundInstanceBinding{"
        + "key=" + key + ", "
        + "bindingElement=" + bindingElement + ", "
        + "contributingModule=" + contributingModule + ", "
        + "unresolved=" + unresolved + ", "
        + "scope=" + scope + ", "
        + "nullability=" + nullability
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof BoundInstanceBinding) {
      BoundInstanceBinding that = (BoundInstanceBinding) o;
      return this.key.equals(that.key())
          && this.bindingElement.equals(that.bindingElement())
          && this.contributingModule.equals(that.contributingModule())
          && this.unresolved.equals(that.unresolved())
          && this.scope.equals(that.scope())
          && this.nullability.equals(that.nullability());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= key.hashCode();
    h$ *= 1000003;
    h$ ^= bindingElement.hashCode();
    h$ *= 1000003;
    h$ ^= contributingModule.hashCode();
    h$ *= 1000003;
    h$ ^= unresolved.hashCode();
    h$ *= 1000003;
    h$ ^= scope.hashCode();
    h$ *= 1000003;
    h$ ^= nullability.hashCode();
    return h$;
  }

  @Override
  public BoundInstanceBinding.Builder toBuilder() {
    return new Builder(this);
  }

  static class Builder extends BoundInstanceBinding.Builder {
    private Key key;
    private Optional<XElement> bindingElement = Optional.empty();
    private Optional<XTypeElement> contributingModule = Optional.empty();
    private Optional<? extends Binding> unresolved = Optional.empty();
    private Optional<Scope> scope = Optional.empty();
    private Nullability nullability;
    Builder() {
    }
    private Builder(BoundInstanceBinding source) {
      this.key = source.key();
      this.bindingElement = source.bindingElement();
      this.contributingModule = source.contributingModule();
      this.unresolved = source.unresolved();
      this.scope = source.scope();
      this.nullability = source.nullability();
    }
    @Override
    BoundInstanceBinding.Builder key(Key key) {
      if (key == null) {
        throw new NullPointerException("Null key");
      }
      this.key = key;
      return this;
    }
    @Override
    BoundInstanceBinding.Builder bindingElement(XElement bindingElement) {
      this.bindingElement = Optional.of(bindingElement);
      return this;
    }
    @Override
    BoundInstanceBinding.Builder bindingElement(Optional<XElement> bindingElement) {
      if (bindingElement == null) {
        throw new NullPointerException("Null bindingElement");
      }
      this.bindingElement = bindingElement;
      return this;
    }
    @Override
    BoundInstanceBinding.Builder contributingModule(XTypeElement contributingModule) {
      this.contributingModule = Optional.of(contributingModule);
      return this;
    }
    @Override
    BoundInstanceBinding.Builder unresolved(Optional<? extends Binding> unresolved) {
      if (unresolved == null) {
        throw new NullPointerException("Null unresolved");
      }
      this.unresolved = unresolved;
      return this;
    }
    @Override
    BoundInstanceBinding.Builder scope(Optional<Scope> scope) {
      if (scope == null) {
        throw new NullPointerException("Null scope");
      }
      this.scope = scope;
      return this;
    }
    @Override
    BoundInstanceBinding.Builder nullability(Nullability nullability) {
      if (nullability == null) {
        throw new NullPointerException("Null nullability");
      }
      this.nullability = nullability;
      return this;
    }
    @Override
    BoundInstanceBinding build() {
      if (this.key == null
          || this.nullability == null) {
        StringBuilder missing = new StringBuilder();
        if (this.key == null) {
          missing.append(" key");
        }
        if (this.nullability == null) {
          missing.append(" nullability");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_BoundInstanceBinding(
          this.key,
          this.bindingElement,
          this.contributingModule,
          this.unresolved,
          this.scope,
          this.nullability);
    }
  }

}
