/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.AutoValue_Nullability;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotated;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XNullability;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import java.util.List;
import java.util.Optional;
import java.util.Set;

@AutoValue
public abstract class Nullability {
    public static final Nullability NOT_NULLABLE = new AutoValue_Nullability((ImmutableSet<XClassName>)ImmutableSet.of(), (ImmutableSet<XClassName>)ImmutableSet.of(), false);

    public static Nullability of(XElement element) {
        ImmutableSet<XClassName> nonTypeUseNullableAnnotations = Nullability.getNullableAnnotations(element);
        Optional<XType> type = Nullability.getType(element);
        ImmutableSet typeUseNullableAnnotations = ImmutableSet.of();
        boolean isKotlinTypeNullable = !element.getClosestMemberContainer().isFromJava() && type.isPresent() && type.get().getNullability() == XNullability.NULLABLE;
        return new AutoValue_Nullability(nonTypeUseNullableAnnotations, (ImmutableSet<XClassName>)Sets.difference((Set)typeUseNullableAnnotations, nonTypeUseNullableAnnotations).immutableCopy(), isKotlinTypeNullable);
    }

    static XTypeName getTypeNameWithNullableAnnotations(XType type) {
        return type.asTypeName();
    }

    private static TypeName getAnnotatedTypeName(XType type, TypeName typeName) {
        if (typeName instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
            if (type.getTypeArguments().size() != parameterizedTypeName.typeArguments.size()) {
                throw new IllegalStateException(String.format("%s has %s type arguments but %s has %s type arguments", type, type.getTypeArguments().size(), parameterizedTypeName, parameterizedTypeName.typeArguments.size()));
            }
            TypeName[] typeArguments = new TypeName[parameterizedTypeName.typeArguments.size()];
            for (int i = 0; i < parameterizedTypeName.typeArguments.size(); ++i) {
                typeArguments[i] = Nullability.getAnnotatedTypeName(type.getTypeArguments().get(i), (TypeName)parameterizedTypeName.typeArguments.get(i));
            }
            typeName = ParameterizedTypeName.get((ClassName)parameterizedTypeName.rawType, (TypeName[])typeArguments);
        }
        return typeName.annotated((List)Nullability.getNullableAnnotations(type).stream().map(XConverters::toJavaPoet).map(AnnotationSpec::builder).map(AnnotationSpec.Builder::build).collect(DaggerStreams.toImmutableList()));
    }

    static ImmutableSet<XClassName> getNullableAnnotations(XAnnotated annotated) {
        return (ImmutableSet)annotated.getAllAnnotations().stream().map(XAnnotations::asClassName).filter(annotation -> annotation.getSimpleName().contentEquals("Nullable")).collect(DaggerStreams.toImmutableSet());
    }

    private static Optional<XType> getType(XElement element) {
        if (XElementKt.isMethod(element)) {
            return Optional.of(XElements.asMethod(element).getReturnType());
        }
        if (XElementKt.isVariableElement(element)) {
            return Optional.of(XElements.asVariable(element).getType());
        }
        return Optional.empty();
    }

    public abstract ImmutableSet<XClassName> nonTypeUseNullableAnnotations();

    public abstract ImmutableSet<XClassName> typeUseNullableAnnotations();

    public abstract boolean isKotlinTypeNullable();

    public ImmutableSet<XClassName> nullableAnnotations() {
        return ImmutableSet.builder().addAll(this.nonTypeUseNullableAnnotations()).addAll(this.typeUseNullableAnnotations()).build();
    }

    public final boolean isNullable() {
        return this.isKotlinTypeNullable() || !this.nullableAnnotations().isEmpty();
    }

    Nullability() {
    }
}

