/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import dagger.internal.codegen.AnnotationExpression;
import dagger.internal.codegen.AnnotationSpecs;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.FrameworkDependency;
import dagger.internal.codegen.FrameworkField;
import dagger.internal.codegen.HasBindingMembers;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.MemberSelect;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.MethodSignature;
import dagger.internal.codegen.MoreAnnotationMirrors;
import dagger.internal.codegen.OptionalFactories;
import dagger.internal.codegen.RequestFulfillment;
import dagger.internal.codegen.RequestFulfillmentRegistry;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.Scope;
import dagger.internal.codegen.SetType;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.SubcomponentWriter;
import dagger.internal.codegen.TypeNames;
import dagger.internal.codegen.TypeSpecs;
import dagger.internal.codegen.UniqueNameSet;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.releasablereferences.ForReleasableReferences;
import dagger.releasablereferences.ReleasableReferenceManager;
import dagger.releasablereferences.TypedReleasableReferenceManager;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

abstract class AbstractComponentWriter
implements HasBindingMembers {
    private static final String NOOP_BUILDER_METHOD_JAVADOC = "This module is declared, but an instance is not used in the component. This method is a no-op. For more, see https://google.github.io/dagger/unused-modules.\n";
    protected final Elements elements;
    protected final Types types;
    protected final Key.Factory keyFactory;
    protected final CompilerOptions compilerOptions;
    protected final ClassName name;
    protected final BindingGraph graph;
    protected final ImmutableMap<ComponentDescriptor, String> subcomponentNames;
    private final Map<BindingKey, InitializationState> initializationStates = new HashMap<BindingKey, InitializationState>();
    protected final TypeSpec.Builder component;
    private final UniqueNameSet componentFieldNames = new UniqueNameSet();
    private final Map<BindingKey, MemberSelect> memberSelects = new HashMap<BindingKey, MemberSelect>();
    private final Map<BindingKey, MemberSelect> producerFromProviderMemberSelects = new HashMap<BindingKey, MemberSelect>();
    private final RequestFulfillmentRegistry requestFulfillmentRegistry;
    protected final MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE);
    protected Optional<ClassName> builderName = Optional.empty();
    private final OptionalFactories optionalFactories;
    private boolean done;
    private ImmutableMap<ComponentRequirement, FieldSpec> builderFields = ImmutableMap.of();
    protected final Map<ComponentRequirement, MemberSelect> componentContributionFields = Maps.newHashMap();
    private ImmutableMap<Scope, MemberSelect> referenceReleasingProviderManagerFields;
    private static final int INITIALIZATIONS_PER_INITIALIZE_METHOD = 100;

    AbstractComponentWriter(Types types, Elements elements, Key.Factory keyFactory, CompilerOptions compilerOptions, ClassName name, BindingGraph graph, ImmutableMap<ComponentDescriptor, String> subcomponentNames, OptionalFactories optionalFactories) {
        this.types = types;
        this.elements = elements;
        this.keyFactory = keyFactory;
        this.compilerOptions = compilerOptions;
        this.component = TypeSpec.classBuilder(name);
        this.name = name;
        this.graph = graph;
        this.subcomponentNames = subcomponentNames;
        this.optionalFactories = optionalFactories;
        this.requestFulfillmentRegistry = new RequestFulfillmentRegistry(graph.resolvedBindings(), this);
    }

    protected AbstractComponentWriter(AbstractComponentWriter parent, ClassName name, BindingGraph graph) {
        this(parent.types, parent.elements, parent.keyFactory, parent.compilerOptions, name, graph, parent.subcomponentNames, parent.optionalFactories);
    }

    protected final ClassName componentDefinitionTypeName() {
        return ClassName.get(this.graph.componentType());
    }

    private CodeBlock getComponentContributionExpression(ComponentRequirement componentRequirement) {
        if (this.builderFields.containsKey((Object)componentRequirement)) {
            return CodeBlock.of("builder.$N", this.builderFields.get((Object)componentRequirement));
        }
        Optional<CodeBlock> codeBlock = this.getOrCreateComponentRequirementFieldExpression(componentRequirement);
        com.google.common.base.Preconditions.checkState((boolean)codeBlock.isPresent(), (String)"no builder or component field for %s", (Object)componentRequirement);
        return codeBlock.get();
    }

    protected Optional<CodeBlock> getOrCreateComponentRequirementFieldExpression(ComponentRequirement componentRequirement) {
        MemberSelect fieldSelect = this.componentContributionFields.get(componentRequirement);
        if (fieldSelect == null) {
            if (!this.builderFields.containsKey((Object)componentRequirement)) {
                return Optional.empty();
            }
            FieldSpec componentField = this.componentField(TypeName.get(componentRequirement.type()), SourceFiles.simpleVariableName(componentRequirement.typeElement())).addModifiers(Modifier.PRIVATE, Modifier.FINAL).build();
            this.component.addField(componentField);
            this.constructor.addCode("this.$N = builder.$N;", componentField, this.builderFields.get((Object)componentRequirement));
            fieldSelect = MemberSelect.localField(this.name, componentField.name);
            this.componentContributionFields.put(componentRequirement, fieldSelect);
        }
        return Optional.of(fieldSelect.getExpressionFor(this.name));
    }

    protected final FieldSpec.Builder componentField(TypeName type, String name) {
        return FieldSpec.builder(type, this.componentFieldNames.getUniqueName(name), new Modifier[0]);
    }

    private CodeBlock getMemberSelectExpression(BindingKey key) {
        return this.getMemberSelect(key).getExpressionFor(this.name);
    }

    @Override
    public MemberSelect getMemberSelect(BindingKey key) {
        return this.memberSelects.get(key);
    }

    protected InitializationState getInitializationState(BindingKey bindingKey) {
        return this.initializationStates.containsKey(bindingKey) ? this.initializationStates.get(bindingKey) : InitializationState.UNINITIALIZED;
    }

    private void setInitializationState(BindingKey bindingKey, InitializationState state) {
        this.initializationStates.put(bindingKey, state);
    }

    protected CodeBlock getReferenceReleasingProviderManagerExpression(Scope scope) {
        return ((MemberSelect)this.referenceReleasingProviderManagerFields.get((Object)scope)).getExpressionFor(this.name);
    }

    final TypeSpec.Builder write() {
        com.google.common.base.Preconditions.checkState((!this.done ? 1 : 0) != 0, (Object)"ComponentWriter has already been generated.");
        this.decorateComponent();
        this.addBuilder();
        this.addFactoryMethods();
        this.addReferenceReleasingProviderManagerFields();
        this.addFrameworkFields();
        this.initializeFrameworkTypes();
        this.implementInterfaceMethods();
        this.addSubcomponents();
        this.component.addMethod(this.constructor.build());
        if (this.graph.componentDescriptor().kind().isTopLevel()) {
            this.optionalFactories.addMembers(this.component);
        }
        this.done = true;
        return this.component;
    }

    protected abstract void decorateComponent();

    protected void addBuilder() {
        this.builderName = Optional.of(this.builderName());
        TypeSpec.Builder componentBuilder = this.createBuilder(this.builderName.get().simpleName()).addModifiers(Modifier.FINAL);
        Optional<ComponentDescriptor.BuilderSpec> builderSpec = this.graph.componentDescriptor().builderSpec();
        if (builderSpec.isPresent()) {
            componentBuilder.addModifiers(Modifier.PRIVATE);
            TypeSpecs.addSupertype(componentBuilder, builderSpec.get().builderDefinitionType());
        } else {
            componentBuilder.addModifiers(Modifier.PUBLIC).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).build());
        }
        this.builderFields = this.addBuilderFields(componentBuilder);
        this.addBuildMethod(componentBuilder, builderSpec);
        this.addBuilderMethods(componentBuilder, builderSpec);
        this.addBuilderClass(componentBuilder.build());
        this.constructor.addParameter(this.builderName.get(), "builder", new Modifier[0]);
        this.constructor.addStatement("assert builder != null", new Object[0]);
    }

    protected abstract void addBuilderClass(TypeSpec var1);

    private ImmutableMap<ComponentRequirement, FieldSpec> addBuilderFields(TypeSpec.Builder componentBuilder) {
        UniqueNameSet builderFieldNames = new UniqueNameSet();
        ImmutableMap.Builder builderFields = ImmutableMap.builder();
        for (ComponentRequirement componentRequirement : this.graph.componentRequirements()) {
            String contributionName = builderFieldNames.getUniqueName(componentRequirement.variableName());
            FieldSpec builderField = FieldSpec.builder(TypeName.get(componentRequirement.type()), contributionName, Modifier.PRIVATE).build();
            componentBuilder.addField(builderField);
            builderFields.put((Object)componentRequirement, (Object)builderField);
        }
        return builderFields.build();
    }

    private void addBuildMethod(TypeSpec.Builder componentBuilder, Optional<ComponentDescriptor.BuilderSpec> builderSpec) {
        MethodSpec.Builder buildMethod;
        if (builderSpec.isPresent()) {
            ExecutableElement specBuildMethod = builderSpec.get().buildMethod();
            buildMethod = MethodSpec.methodBuilder(specBuildMethod.getSimpleName().toString()).addAnnotation(Override.class);
        } else {
            buildMethod = MethodSpec.methodBuilder("build");
        }
        buildMethod.returns(this.componentDefinitionTypeName()).addModifiers(Modifier.PUBLIC);
        block5: for (Map.Entry builderFieldEntry : this.builderFields.entrySet()) {
            FieldSpec builderField = (FieldSpec)builderFieldEntry.getValue();
            switch (((ComponentRequirement)builderFieldEntry.getKey()).nullPolicy(this.elements, this.types)) {
                case NEW: {
                    buildMethod.addCode("if ($1N == null) { this.$1N = new $2T(); }", builderField, builderField.type);
                    continue block5;
                }
                case THROW: {
                    buildMethod.addCode("if ($N == null) { throw new $T($T.class.getCanonicalName() + $S); }", builderField, IllegalStateException.class, TypeNames.rawTypeName(builderField.type), " must be set");
                    continue block5;
                }
                case ALLOW: {
                    continue block5;
                }
            }
            throw new AssertionError(builderFieldEntry.getKey());
        }
        buildMethod.addStatement("return new $T(this)", this.name);
        componentBuilder.addMethod(buildMethod.build());
    }

    private void addBuilderMethods(TypeSpec.Builder componentBuilder, Optional<ComponentDescriptor.BuilderSpec> builderSpec) {
        ImmutableSet<ComponentRequirement> componentRequirements = this.graph.componentRequirements();
        if (builderSpec.isPresent()) {
            UniqueNameSet parameterNames = new UniqueNameSet();
            for (ComponentDescriptor.BuilderRequirementMethod requirementMethod : builderSpec.get().requirementMethods()) {
                ComponentRequirement builderRequirement = requirementMethod.requirement();
                ExecutableElement specMethod = requirementMethod.method();
                MethodSpec.Builder builderMethod = this.addBuilderMethodFromSpec(specMethod);
                VariableElement parameterElement = (VariableElement)Iterables.getOnlyElement(specMethod.getParameters());
                String parameterName = parameterNames.getUniqueName(parameterElement.getSimpleName());
                TypeName argType = parameterElement.asType().getKind().isPrimitive() ? TypeName.get(parameterElement.asType()) : TypeName.get(builderRequirement.type());
                builderMethod.addParameter(argType, parameterName, new Modifier[0]);
                if (componentRequirements.contains((Object)builderRequirement)) {
                    builderMethod.addStatement("this.$N = $L", this.builderFields.get((Object)builderRequirement), builderRequirement.nullPolicy(this.elements, this.types).equals((Object)ComponentRequirement.NullPolicy.ALLOW) ? parameterName : CodeBlock.of("$T.checkNotNull($L)", Preconditions.class, parameterName));
                    this.addBuilderMethodReturnStatementForSpec(specMethod, builderMethod);
                } else if (this.graph.ownedModuleTypes().contains((Object)builderRequirement.typeElement())) {
                    builderMethod.addJavadoc(NOOP_BUILDER_METHOD_JAVADOC, new Object[0]);
                    this.addBuilderMethodReturnStatementForSpec(specMethod, builderMethod);
                } else {
                    builderMethod.addStatement("throw new $T($T.format($S, $T.class.getCanonicalName()))", UnsupportedOperationException.class, String.class, "%s cannot be set because it is inherited from the enclosing component", TypeNames.rawTypeName(TypeName.get(builderRequirement.type())));
                }
                componentBuilder.addMethod(builderMethod.build());
            }
        } else {
            for (ComponentRequirement componentRequirement : this.graph.availableDependencies()) {
                String componentRequirementName = SourceFiles.simpleVariableName(componentRequirement.typeElement());
                MethodSpec.Builder builderMethod = MethodSpec.methodBuilder(componentRequirementName).returns(this.builderName.get()).addModifiers(Modifier.PUBLIC).addParameter(ClassName.get(componentRequirement.type()), componentRequirementName, new Modifier[0]);
                if (componentRequirements.contains((Object)componentRequirement)) {
                    builderMethod.addStatement("this.$N = $T.checkNotNull($L)", this.builderFields.get((Object)componentRequirement), Preconditions.class, componentRequirementName);
                } else {
                    builderMethod.addStatement("$T.checkNotNull($L)", Preconditions.class, componentRequirementName);
                    builderMethod.addJavadoc("@deprecated This module is declared, but an instance is not used in the component. This method is a no-op. For more, see https://google.github.io/dagger/unused-modules.\n", new Object[0]);
                    builderMethod.addAnnotation(Deprecated.class);
                }
                builderMethod.addStatement("return this", new Object[0]);
                componentBuilder.addMethod(builderMethod.build());
            }
        }
    }

    private void addBuilderMethodReturnStatementForSpec(ExecutableElement specMethod, MethodSpec.Builder builderMethod) {
        if (!specMethod.getReturnType().getKind().equals((Object)TypeKind.VOID)) {
            builderMethod.addStatement("return this", new Object[0]);
        }
    }

    private MethodSpec.Builder addBuilderMethodFromSpec(ExecutableElement method) {
        TypeMirror returnType = method.getReturnType();
        MethodSpec.Builder builderMethod = MethodSpec.methodBuilder(method.getSimpleName().toString()).addAnnotation(Override.class).addModifiers((Iterable<Modifier>)Sets.difference(method.getModifiers(), (Set)ImmutableSet.of((Object)((Object)Modifier.ABSTRACT))));
        if (!returnType.getKind().equals((Object)TypeKind.VOID)) {
            builderMethod.returns(this.builderName.get());
        }
        return builderMethod;
    }

    protected abstract TypeSpec.Builder createBuilder(String var1);

    protected abstract ClassName builderName();

    protected abstract void addFactoryMethods();

    private void addReferenceReleasingProviderManagerFields() {
        ImmutableMap.Builder fields = ImmutableMap.builder();
        for (Scope scope : this.graph.componentDescriptor().releasableReferencesScopes()) {
            if (!this.requiresReleasableReferences(scope)) continue;
            FieldSpec field = this.referenceReleasingProxyManagerField(scope);
            this.component.addField(field);
            fields.put((Object)scope, (Object)MemberSelect.localField(this.name, field.name));
        }
        this.referenceReleasingProviderManagerFields = fields.build();
    }

    private boolean requiresReleasableReferences(Scope scope) {
        if (!scope.canReleaseReferences()) {
            return false;
        }
        if (this.graphHasContributionBinding(this.keyFactory.forReleasableReferenceManager(scope)) || this.graphHasContributionBinding(this.keyFactory.forSetOfReleasableReferenceManagers())) {
            return true;
        }
        for (AnnotationMirror metadata : scope.releasableReferencesMetadata()) {
            if (!this.graphHasContributionBinding(this.keyFactory.forTypedReleasableReferenceManager(scope, metadata.getAnnotationType())) && !this.graphHasContributionBinding(this.keyFactory.forSetOfTypedReleasableReferenceManagers(metadata.getAnnotationType()))) continue;
            return true;
        }
        return false;
    }

    private boolean graphHasContributionBinding(Key key) {
        return this.graph.resolvedBindings().containsKey((Object)BindingKey.contribution(key));
    }

    private FieldSpec referenceReleasingProxyManagerField(Scope scope) {
        return this.componentField(TypeNames.REFERENCE_RELEASING_PROVIDER_MANAGER, CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, scope.scopeAnnotationElement().getSimpleName() + "References")).addModifiers(Modifier.PRIVATE, Modifier.FINAL).initializer("new $T($T.class)", TypeNames.REFERENCE_RELEASING_PROVIDER_MANAGER, scope.scopeAnnotationElement()).addJavadoc("The manager that releases references for the {@link $T} scope.\n", scope.scopeAnnotationElement()).build();
    }

    private void addFrameworkFields() {
        this.graph.resolvedBindings().values().forEach(this::addField);
    }

    private void addField(ResolvedBindings resolvedBindings) {
        BindingKey bindingKey = resolvedBindings.bindingKey();
        Optional<MemberSelect> staticMemberSelect = AbstractComponentWriter.staticMemberSelect(resolvedBindings);
        if (staticMemberSelect.isPresent()) {
            this.memberSelects.put(bindingKey, staticMemberSelect.get());
            return;
        }
        if (resolvedBindings.ownedBindings().isEmpty()) {
            return;
        }
        FieldSpec frameworkField = this.addFrameworkField(resolvedBindings, Optional.empty());
        this.memberSelects.put(bindingKey, MemberSelect.localField(this.name, frameworkField.name));
    }

    private FieldSpec addFrameworkField(ResolvedBindings resolvedBindings, Optional<ClassName> frameworkClass) {
        boolean useRawType = this.useRawType(resolvedBindings);
        FrameworkField contributionBindingField = FrameworkField.forResolvedBindings(resolvedBindings, frameworkClass);
        FieldSpec.Builder contributionField = this.componentField(useRawType ? contributionBindingField.type().rawType : contributionBindingField.type(), contributionBindingField.name());
        contributionField.addModifiers(Modifier.PRIVATE);
        if (useRawType) {
            contributionField.addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.RAWTYPES, new AnnotationSpecs.Suppression[0]));
        }
        FieldSpec field = contributionField.build();
        this.component.addField(field);
        return field;
    }

    private boolean useRawType(ResolvedBindings resolvedBindings) {
        return this.useRawType(resolvedBindings.bindingPackage());
    }

    private boolean useRawType(Binding binding) {
        return this.useRawType(binding.bindingPackage());
    }

    private boolean useRawType(Optional<String> bindingPackage) {
        return bindingPackage.isPresent() && !bindingPackage.get().equals(this.name.packageName());
    }

    private static Optional<MemberSelect> staticMemberSelect(ResolvedBindings resolvedBindings) {
        BindingKey bindingKey = resolvedBindings.bindingKey();
        switch (bindingKey.kind()) {
            case CONTRIBUTION: {
                ContributionBinding contributionBinding = resolvedBindings.contributionBinding();
                if (!contributionBinding.factoryCreationStrategy().equals((Object)ContributionBinding.FactoryCreationStrategy.SINGLETON_INSTANCE) || contributionBinding.scope().isPresent()) break;
                switch (contributionBinding.bindingKind()) {
                    case SYNTHETIC_MULTIBOUND_MAP: {
                        BindingType bindingType = contributionBinding.bindingType();
                        MapType mapType = MapType.from(contributionBinding.key());
                        return Optional.of(MemberSelect.emptyFrameworkMapFactory(bindingType, mapType.keyType(), mapType.unwrappedValueType(bindingType.frameworkClass())));
                    }
                    case SYNTHETIC_MULTIBOUND_SET: {
                        return Optional.of(AbstractComponentWriter.emptySetFactoryStaticMemberSelect(contributionBinding.bindingType(), contributionBinding.key()));
                    }
                    case INJECTION: 
                    case PROVISION: {
                        ImmutableList<TypeVariableName> typeVariables;
                        if (!bindingKey.key().type().getKind().equals((Object)TypeKind.DECLARED) || (typeVariables = SourceFiles.bindingTypeElementTypeVariableNames(contributionBinding)).isEmpty()) break;
                        List<? extends TypeMirror> typeArguments = ((DeclaredType)bindingKey.key().type()).getTypeArguments();
                        return Optional.of(MemberSelect.parameterizedFactoryCreateMethod(SourceFiles.generatedClassNameForBinding(contributionBinding), typeArguments));
                    }
                }
                return Optional.of(MemberSelect.staticMethod(SourceFiles.generatedClassNameForBinding(contributionBinding), CodeBlock.of("create()", new Object[0])));
            }
            case MEMBERS_INJECTION: {
                Optional<MembersInjectionBinding> membersInjectionBinding = resolvedBindings.membersInjectionBinding();
                if (!membersInjectionBinding.isPresent() || !membersInjectionBinding.get().injectionSites().isEmpty()) break;
                return Optional.of(MemberSelect.noOpMembersInjector(membersInjectionBinding.get().key().type()));
            }
            default: {
                throw new AssertionError();
            }
        }
        return Optional.empty();
    }

    private static MemberSelect emptySetFactoryStaticMemberSelect(BindingType bindingType, Key key) {
        return MemberSelect.emptySetProvider(AbstractComponentWriter.setFactoryClassName(bindingType, key), SetType.from(key));
    }

    private static ClassName setFactoryClassName(BindingType bindingType, Key key) {
        if (bindingType.equals((Object)BindingType.PROVISION)) {
            return TypeNames.SET_FACTORY;
        }
        SetType setType = SetType.from(key);
        return setType.elementsAreTypeOf(Produced.class) ? TypeNames.SET_OF_PRODUCED_PRODUCER : TypeNames.SET_PRODUCER;
    }

    private static ClassName mapFactoryClassName(ContributionBinding binding) {
        switch (binding.bindingType()) {
            case PRODUCTION: {
                return MapType.from(binding.key()).valuesAreTypeOf(Produced.class) ? TypeNames.MAP_OF_PRODUCED_PRODUCER : TypeNames.MAP_PRODUCER;
            }
            case PROVISION: 
            case MEMBERS_INJECTION: {
                return TypeNames.MAP_FACTORY;
            }
        }
        throw new AssertionError((Object)binding.toString());
    }

    private static ClassName frameworkMapFactoryClassName(BindingType bindingType) {
        return bindingType.equals((Object)BindingType.PRODUCTION) ? TypeNames.MAP_OF_PRODUCER_PRODUCER : TypeNames.MAP_PROVIDER_FACTORY;
    }

    private void implementInterfaceMethods() {
        HashSet interfaceMethods = Sets.newHashSet();
        for (ComponentDescriptor.ComponentMethodDescriptor componentMethod : this.graph.componentDescriptor().componentMethods()) {
            if (!componentMethod.dependencyRequest().isPresent()) continue;
            DependencyRequest interfaceRequest = componentMethod.dependencyRequest().get();
            ExecutableElement methodElement = MoreElements.asExecutable(componentMethod.methodElement());
            ExecutableType requestType = MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(this.graph.componentType().asType()), methodElement));
            MethodSignature signature = MethodSignature.fromExecutableType(methodElement.getSimpleName().toString(), requestType);
            if (interfaceMethods.contains(signature)) continue;
            interfaceMethods.add(signature);
            MethodSpec.Builder interfaceMethod = this.methodSpecForComponentMethod(methodElement, requestType);
            RequestFulfillment fulfillment = this.requestFulfillmentRegistry.getRequestFulfillment(interfaceRequest.bindingKey());
            CodeBlock codeBlock = fulfillment.getSnippetForDependencyRequest(interfaceRequest, this.name);
            switch (interfaceRequest.kind()) {
                case MEMBERS_INJECTOR: {
                    List<? extends VariableElement> parameters = methodElement.getParameters();
                    if (!parameters.isEmpty()) {
                        Name parameterName = ((VariableElement)Iterables.getOnlyElement(methodElement.getParameters())).getSimpleName();
                        interfaceMethod.addStatement("$L.injectMembers($L)", codeBlock, parameterName);
                        if (requestType.getReturnType().getKind().equals((Object)TypeKind.VOID)) break;
                        interfaceMethod.addStatement("return $L", parameterName);
                        break;
                    }
                }
                default: {
                    interfaceMethod.addStatement("return $L", codeBlock);
                }
            }
            this.component.addMethod(interfaceMethod.build());
        }
    }

    private MethodSpec.Builder methodSpecForComponentMethod(ExecutableElement method, ExecutableType methodType) {
        String methodName = method.getSimpleName().toString();
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder(methodName);
        methodBuilder.addAnnotation(Override.class);
        EnumSet<Modifier> modifiers = EnumSet.copyOf(method.getModifiers());
        modifiers.remove((Object)Modifier.ABSTRACT);
        methodBuilder.addModifiers(modifiers);
        methodBuilder.returns(TypeName.get(methodType.getReturnType()));
        List<? extends VariableElement> parameters = method.getParameters();
        List<? extends TypeMirror> resolvedParameterTypes = methodType.getParameterTypes();
        Verify.verify((parameters.size() == resolvedParameterTypes.size() ? 1 : 0) != 0);
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement variableElement = parameters.get(i);
            TypeName type = TypeName.get(resolvedParameterTypes.get(i));
            String name = variableElement.getSimpleName().toString();
            Set<Modifier> parameterModifiers = variableElement.getModifiers();
            ParameterSpec.Builder parameterBuilder = ParameterSpec.builder(type, name, new Modifier[0]).addModifiers(parameterModifiers.toArray(new Modifier[0]));
            methodBuilder.addParameter(parameterBuilder.build());
        }
        for (TypeMirror typeMirror : method.getThrownTypes()) {
            methodBuilder.addException(TypeName.get(typeMirror));
        }
        return methodBuilder;
    }

    private void addSubcomponents() {
        for (BindingGraph subgraph : this.graph.subgraphs()) {
            ComponentDescriptor.ComponentMethodDescriptor componentMethodDescriptor = (ComponentDescriptor.ComponentMethodDescriptor)this.graph.componentDescriptor().subcomponentsByFactoryMethod().inverse().get((Object)subgraph.componentDescriptor());
            SubcomponentWriter subcomponent = new SubcomponentWriter(this, Optional.ofNullable(componentMethodDescriptor), subgraph);
            this.component.addType(subcomponent.write().build());
        }
    }

    private void initializeFrameworkTypes() {
        ImmutableList.Builder codeBlocks = ImmutableList.builder();
        for (BindingKey bindingKey : this.graph.resolvedBindings().keySet()) {
            this.initializeFrameworkType(bindingKey).ifPresent(arg_0 -> ((ImmutableList.Builder)codeBlocks).add(arg_0));
        }
        List partitions = Lists.partition((List)codeBlocks.build(), (int)100);
        UniqueNameSet methodNames = new UniqueNameSet();
        for (List partition : partitions) {
            String methodName = methodNames.getUniqueName("initialize");
            MethodSpec.Builder initializeMethod = MethodSpec.methodBuilder(methodName).addModifiers(Modifier.PRIVATE).addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.UNCHECKED, new AnnotationSpecs.Suppression[0])).addCode(CodeBlocks.concat(partition));
            if (this.builderName.isPresent()) {
                initializeMethod.addParameter(this.builderName.get(), "builder", Modifier.FINAL);
                this.constructor.addStatement("$L(builder)", methodName);
            } else {
                this.constructor.addStatement("$L()", methodName);
            }
            this.component.addMethod(initializeMethod.build());
        }
    }

    private Optional<CodeBlock> initializeFrameworkType(BindingKey bindingKey) {
        MemberSelect memberSelect = this.getMemberSelect(bindingKey);
        if (memberSelect.staticMember() || !memberSelect.owningClass().equals(this.name)) {
            return Optional.empty();
        }
        switch (bindingKey.kind()) {
            case CONTRIBUTION: {
                return this.initializeContributionBinding(bindingKey);
            }
            case MEMBERS_INJECTION: {
                return this.initializeMembersInjectionBinding(bindingKey);
            }
        }
        throw new AssertionError();
    }

    private Optional<CodeBlock> initializeContributionBinding(BindingKey bindingKey) {
        ContributionBinding binding = ((ResolvedBindings)this.graph.resolvedBindings().get((Object)bindingKey)).contributionBinding();
        switch (binding.factoryCreationStrategy()) {
            case DELEGATE: {
                CodeBlock delegatingCodeBlock = CodeBlock.of("($T) $L", binding.bindingType().frameworkClass(), this.getMemberSelect(((DependencyRequest)Iterables.getOnlyElement(binding.explicitDependencies())).bindingKey()).getExpressionFor(this.name));
                return Optional.of(CodeBlocks.concat((Iterable<CodeBlock>)ImmutableList.of((Object)this.initializeDeferredDependencies(binding), (Object)this.initializeMember(bindingKey, binding.scope().isPresent() ? this.decorateForScope(delegatingCodeBlock, binding.scope().get()) : delegatingCodeBlock))));
            }
            case SINGLETON_INSTANCE: {
                if (!binding.scope().isPresent()) {
                    return Optional.empty();
                }
            }
            case CLASS_CONSTRUCTOR: {
                return Optional.of(CodeBlocks.concat((Iterable<CodeBlock>)ImmutableList.of((Object)this.initializeDeferredDependencies(binding), (Object)this.initializeMember(bindingKey, this.initializeFactoryForContributionBinding(binding)))));
            }
        }
        throw new AssertionError();
    }

    private Optional<CodeBlock> initializeMembersInjectionBinding(BindingKey bindingKey) {
        MembersInjectionBinding binding = ((ResolvedBindings)this.graph.resolvedBindings().get((Object)bindingKey)).membersInjectionBinding().get();
        if (binding.injectionSites().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(CodeBlocks.concat((Iterable<CodeBlock>)ImmutableList.of((Object)this.initializeDeferredDependencies(binding), (Object)this.initializeMember(bindingKey, this.initializeMembersInjectorForBinding(binding)))));
    }

    private CodeBlock initializeDeferredDependencies(Binding binding) {
        return CodeBlocks.concat((Iterable<CodeBlock>)ImmutableList.of((Object)this.initializeDelegateFactoriesForUninitializedDependencies(binding), (Object)this.initializeProducersFromProviderDependencies(binding)));
    }

    private CodeBlock initializeDelegateFactoriesForUninitializedDependencies(Binding binding) {
        ImmutableList.Builder initializations = ImmutableList.builder();
        for (BindingKey dependencyKey : FluentIterable.from(binding.dependencies()).transform(DependencyRequest::bindingKey).toSet()) {
            if (this.getMemberSelect(dependencyKey).staticMember() || !this.getInitializationState(dependencyKey).equals((Object)InitializationState.UNINITIALIZED)) continue;
            initializations.add((Object)CodeBlock.of("this.$L = new $T();", this.getMemberSelectExpression(dependencyKey), TypeNames.DELEGATE_FACTORY));
            this.setInitializationState(dependencyKey, InitializationState.DELEGATED);
        }
        return CodeBlocks.concat((Iterable<CodeBlock>)initializations.build());
    }

    private CodeBlock initializeProducersFromProviderDependencies(Binding binding) {
        ImmutableList.Builder initializations = ImmutableList.builder();
        for (FrameworkDependency frameworkDependency : binding.frameworkDependencies()) {
            MemberSelect memberSelect;
            ResolvedBindings resolvedBindings = (ResolvedBindings)this.graph.resolvedBindings().get((Object)frameworkDependency.bindingKey());
            if (!resolvedBindings.frameworkClass().equals(Provider.class) || !frameworkDependency.frameworkClass().equals(Producer.class) || (memberSelect = this.producerFromProviderMemberSelects.get(frameworkDependency.bindingKey())) != null) continue;
            FieldSpec frameworkField = this.addFrameworkField(resolvedBindings, Optional.of(TypeNames.PRODUCER));
            memberSelect = MemberSelect.localField(this.name, frameworkField.name);
            this.producerFromProviderMemberSelects.put(frameworkDependency.bindingKey(), memberSelect);
            initializations.add((Object)CodeBlock.of("this.$L = $L;", memberSelect.getExpressionFor(this.name), this.requestFulfillmentRegistry.getRequestFulfillment(frameworkDependency.bindingKey()).getSnippetForFrameworkDependency(frameworkDependency, this.name)));
        }
        return CodeBlocks.concat((Iterable<CodeBlock>)initializations.build());
    }

    private CodeBlock initializeMember(BindingKey bindingKey, CodeBlock initializationCodeBlock) {
        ImmutableList.Builder initializations = ImmutableList.builder();
        CodeBlock memberSelect = this.getMemberSelectExpression(bindingKey);
        CodeBlock delegateFactoryVariable = this.delegateFactoryVariableExpression(bindingKey);
        if (this.getInitializationState(bindingKey).equals((Object)InitializationState.DELEGATED)) {
            initializations.add((Object)CodeBlock.of("$1T $2L = ($1T) $3L;", TypeNames.DELEGATE_FACTORY, delegateFactoryVariable, memberSelect));
        }
        initializations.add((Object)CodeBlock.of("this.$L = $L;", memberSelect, initializationCodeBlock));
        if (this.getInitializationState(bindingKey).equals((Object)InitializationState.DELEGATED)) {
            initializations.add((Object)CodeBlock.of("$L.setDelegatedProvider($L);", delegateFactoryVariable, memberSelect));
        }
        this.setInitializationState(bindingKey, InitializationState.INITIALIZED);
        return CodeBlocks.concat((Iterable<CodeBlock>)initializations.build());
    }

    private CodeBlock delegateFactoryVariableExpression(BindingKey key) {
        return CodeBlock.of("$LDelegate", this.getMemberSelectExpression(key).toString().replace('.', '_'));
    }

    private CodeBlock initializeFactoryForContributionBinding(ContributionBinding binding) {
        TypeName bindingKeyTypeName = TypeName.get(binding.key().type());
        switch (binding.bindingKind()) {
            case COMPONENT: {
                return CodeBlock.of("$T.<$T>create($L)", TypeNames.INSTANCE_FACTORY, bindingKeyTypeName, bindingKeyTypeName.equals(this.componentDefinitionTypeName()) ? "this" : this.getComponentContributionExpression(ComponentRequirement.forDependency(binding.key().type())));
            }
            case COMPONENT_PROVISION: {
                TypeElement dependencyType = this.dependencyTypeForBinding(binding);
                String dependencyVariable = SourceFiles.simpleVariableName(dependencyType);
                CodeBlock callFactoryMethod = CodeBlock.of("$L.$L()", dependencyVariable, binding.bindingElement().get().getSimpleName());
                CodeBlock getMethodBody = binding.nullableType().isPresent() || this.compilerOptions.nullableValidationKind().equals((Object)Diagnostic.Kind.WARNING) ? CodeBlock.of("return $L;", callFactoryMethod) : CodeBlock.of("return $T.checkNotNull($L, $S);", Preconditions.class, callFactoryMethod, "Cannot return null from a non-@Nullable component method");
                return CodeBlock.of(Joiner.on((char)'\n').join((Object)"new $1T<$2T>() {", (Object)"  private final $5T $6L = $3L;", new Object[]{"  $4L@Override public $2T get() {", "    $7L", "  }", "}"}), TypeNames.FACTORY, bindingKeyTypeName, this.getComponentContributionExpression(ComponentRequirement.forDependency(dependencyType.asType())), this.nullableAnnotation(binding.nullableType()), TypeName.get(dependencyType.asType()), dependencyVariable, getMethodBody);
            }
            case SUBCOMPONENT_BUILDER: {
                String subcomponentName = (String)this.subcomponentNames.get(this.graph.componentDescriptor().subcomponentsByBuilderType().get((Object)MoreTypes.asTypeElement(binding.key().type())));
                return CodeBlock.of(Joiner.on((char)'\n').join((Object)"new $1T<$2T>() {", (Object)"  @Override public $2T get() {", new Object[]{"    return new $3LBuilder();", "  }", "}"}), TypeNames.FACTORY, bindingKeyTypeName, subcomponentName);
            }
            case BUILDER_BINDING: {
                return CodeBlock.of("$T.$L($L)", InstanceFactory.class, binding.nullableType().isPresent() ? "createNullable" : "create", this.getComponentContributionExpression(ComponentRequirement.forBinding(binding)));
            }
            case INJECTION: 
            case PROVISION: {
                ArrayList arguments = Lists.newArrayListWithCapacity((int)(binding.explicitDependencies().size() + 1));
                if (binding.requiresModuleInstance()) {
                    arguments.add(this.getComponentContributionExpression(ComponentRequirement.forModule(binding.contributingModule().get().asType())));
                }
                arguments.addAll(this.getDependencyArguments(binding));
                CodeBlock factoryCreate = CodeBlock.of("$T.create($L)", SourceFiles.generatedClassNameForBinding(binding), CodeBlocks.makeParametersCodeBlock(arguments));
                return binding.scope().isPresent() ? this.decorateForScope(factoryCreate, binding.scope().get()) : factoryCreate;
            }
            case COMPONENT_PRODUCTION: {
                TypeElement dependencyType = this.dependencyTypeForBinding(binding);
                return CodeBlock.of(Joiner.on((char)'\n').join((Object)"new $1T<$2T>() {", (Object)"  private final $6T $7L = $4L;", new Object[]{"  @Override public $3T<$2T> get() {", "    return $7L.$5L();", "  }", "}"}), TypeNames.PRODUCER, TypeName.get(binding.key().type()), TypeNames.LISTENABLE_FUTURE, this.getComponentContributionExpression(ComponentRequirement.forDependency(dependencyType.asType())), binding.bindingElement().get().getSimpleName(), TypeName.get(dependencyType.asType()), SourceFiles.simpleVariableName(dependencyType));
            }
            case PRODUCTION: {
                ArrayList arguments = Lists.newArrayListWithCapacity((int)(binding.dependencies().size() + 2));
                if (binding.requiresModuleInstance()) {
                    arguments.add(this.getComponentContributionExpression(ComponentRequirement.forModule(binding.contributingModule().get().asType())));
                }
                arguments.addAll(this.getDependencyArguments(binding));
                return CodeBlock.of("new $T($L)", SourceFiles.generatedClassNameForBinding(binding), CodeBlocks.makeParametersCodeBlock(arguments));
            }
            case SYNTHETIC_MAP: {
                FrameworkDependency frameworkDependency = (FrameworkDependency)Iterables.getOnlyElement(binding.frameworkDependencies());
                return CodeBlock.of("$T.create($L)", AbstractComponentWriter.mapFactoryClassName(binding), this.requestFulfillmentRegistry.getRequestFulfillment(frameworkDependency.bindingKey()).getSnippetForFrameworkDependency(frameworkDependency, this.name));
            }
            case SYNTHETIC_MULTIBOUND_SET: {
                return this.initializeFactoryForSetMultibinding(binding);
            }
            case SYNTHETIC_MULTIBOUND_MAP: {
                return this.initializeFactoryForMapMultibinding(binding);
            }
            case SYNTHETIC_RELEASABLE_REFERENCE_MANAGER: {
                return this.initializeFactoryForSyntheticReleasableReferenceManagerBinding(binding);
            }
            case SYNTHETIC_RELEASABLE_REFERENCE_MANAGERS: {
                return this.initializeFactoryForSyntheticSetOfReleasableReferenceManagers(binding);
            }
            case SYNTHETIC_OPTIONAL_BINDING: {
                return this.initializeFactoryForSyntheticOptionalBinding(binding);
            }
        }
        throw new AssertionError(binding);
    }

    private TypeElement dependencyTypeForBinding(ContributionBinding binding) {
        return (TypeElement)this.graph.componentDescriptor().dependencyMethodIndex().get((Object)binding.bindingElement().get());
    }

    private CodeBlock decorateForScope(CodeBlock factoryCreate, Scope scope) {
        if (this.requiresReleasableReferences(scope)) {
            return CodeBlock.of("$T.create($L, $L)", TypeNames.REFERENCE_RELEASING_PROVIDER, factoryCreate, this.getReferenceReleasingProviderManagerExpression(scope));
        }
        return CodeBlock.of("$T.provider($L)", scope.equals(Scope.reusableScope(this.elements)) ? TypeNames.SINGLE_CHECK : TypeNames.DOUBLE_CHECK, factoryCreate);
    }

    private CodeBlock nullableAnnotation(Optional<DeclaredType> nullableType) {
        return nullableType.isPresent() ? CodeBlock.of("@$T ", TypeName.get(nullableType.get())) : CodeBlock.of("", new Object[0]);
    }

    private CodeBlock initializeMembersInjectorForBinding(MembersInjectionBinding binding) {
        return binding.injectionSites().isEmpty() ? CodeBlock.of("$T.noOp()", TypeNames.MEMBERS_INJECTORS) : CodeBlock.of("$T.create($L)", SourceFiles.membersInjectorNameForType(binding.membersInjectedType()), CodeBlocks.makeParametersCodeBlock(this.getDependencyArguments(binding)));
    }

    private ImmutableList<CodeBlock> getDependencyArguments(Binding binding) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (FrameworkDependency frameworkDependency : binding.frameworkDependencies()) {
            parameters.add((Object)this.getDependencyArgument(frameworkDependency));
        }
        return parameters.build();
    }

    private CodeBlock getDependencyArgument(FrameworkDependency frameworkDependency) {
        BindingKey requestedKey = frameworkDependency.bindingKey();
        ResolvedBindings resolvedBindings = (ResolvedBindings)this.graph.resolvedBindings().get((Object)requestedKey);
        if (resolvedBindings.frameworkClass().equals(Provider.class) && frameworkDependency.frameworkClass().equals(Producer.class)) {
            return this.producerFromProviderMemberSelects.get(requestedKey).getExpressionFor(this.name);
        }
        RequestFulfillment requestFulfillment = this.requestFulfillmentRegistry.getRequestFulfillment(requestedKey);
        return requestFulfillment.getSnippetForFrameworkDependency(frameworkDependency, this.name);
    }

    private CodeBlock initializeFactoryForSetMultibinding(ContributionBinding binding) {
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.", AbstractComponentWriter.setFactoryClassName(binding.bindingType(), binding.key()));
        boolean useRawTypes = this.useRawType(binding);
        if (!useRawTypes) {
            SetType setType = SetType.from(binding.key());
            builder.add("<$T>", setType.elementsAreTypeOf(Produced.class) ? setType.unwrappedElementType(Produced.class) : setType.elementType());
        }
        int individualProviders = 0;
        int setProviders = 0;
        CodeBlock.Builder builderMethodCalls = CodeBlock.builder();
        for (FrameworkDependency frameworkDependency : binding.frameworkDependencies()) {
            String methodName;
            ContributionType contributionType = ((ResolvedBindings)this.graph.resolvedBindings().get((Object)frameworkDependency.bindingKey())).contributionType();
            String methodNameSuffix = frameworkDependency.frameworkClass().getSimpleName();
            switch (contributionType) {
                case SET: {
                    ++individualProviders;
                    methodName = "add" + methodNameSuffix;
                    break;
                }
                case SET_VALUES: {
                    ++setProviders;
                    methodName = "addCollection" + methodNameSuffix;
                    break;
                }
                default: {
                    throw new AssertionError((Object)(frameworkDependency + " is not a set multibinding"));
                }
            }
            builderMethodCalls.add(".$L($L)", methodName, this.potentiallyCast(useRawTypes, frameworkDependency.frameworkClass(), this.getDependencyArgument(frameworkDependency)));
        }
        builder.add("builder($L, $L)", individualProviders, setProviders);
        builder.add(builderMethodCalls.build());
        return builder.add(".build()", new Object[0]).build();
    }

    private CodeBlock initializeFactoryForMapMultibinding(ContributionBinding binding) {
        ImmutableList<FrameworkDependency> frameworkDependencies = binding.frameworkDependencies();
        ImmutableList.Builder codeBlocks = ImmutableList.builder();
        MapType mapType = MapType.from(binding.key().type());
        CodeBlock.Builder builderCall = CodeBlock.builder().add("$T.", AbstractComponentWriter.frameworkMapFactoryClassName(binding.bindingType()));
        boolean useRawTypes = this.useRawType(binding);
        if (!useRawTypes) {
            builderCall.add("<$T, $T>", TypeName.get(mapType.keyType()), TypeName.get(mapType.unwrappedValueType(binding.bindingType().frameworkClass())));
        }
        builderCall.add("builder($L)", frameworkDependencies.size());
        codeBlocks.add((Object)builderCall.build());
        for (FrameworkDependency frameworkDependency : frameworkDependencies) {
            BindingKey bindingKey = frameworkDependency.bindingKey();
            ContributionBinding contributionBinding = ((ResolvedBindings)this.graph.resolvedBindings().get((Object)bindingKey)).contributionBinding();
            CodeBlock value = this.potentiallyCast(useRawTypes, frameworkDependency.frameworkClass(), this.getDependencyArgument(frameworkDependency));
            codeBlocks.add((Object)CodeBlock.of(".put($L, $L)", MapKeys.getMapKeyExpression(contributionBinding.mapKey().get()), value));
        }
        codeBlocks.add((Object)CodeBlock.of(".build()", new Object[0]));
        return CodeBlocks.concat((Iterable<CodeBlock>)codeBlocks.build());
    }

    private CodeBlock potentiallyCast(boolean shouldCast, Class<?> classToCast, CodeBlock notCasted) {
        if (!shouldCast) {
            return notCasted;
        }
        return CodeBlock.of("($T) $L", classToCast, notCasted);
    }

    private CodeBlock initializeFactoryForSyntheticReleasableReferenceManagerBinding(ContributionBinding binding) {
        CodeBlock managerExpression;
        Scope scope = this.forReleasableReferencesAnnotationValue(binding.key().qualifier().get());
        if (MoreTypes.isTypeOf(TypedReleasableReferenceManager.class, binding.key().type())) {
            TypeMirror metadataType = MoreTypes.asDeclared(binding.key().type()).getTypeArguments().get(0);
            managerExpression = this.typedReleasableReferenceManagerDecoratorExpression(this.getReferenceReleasingProviderManagerExpression(scope), scope.releasableReferencesMetadata(metadataType).get());
        } else {
            managerExpression = this.getReferenceReleasingProviderManagerExpression(scope);
        }
        TypeName keyType = TypeName.get(binding.key().type());
        return CodeBlock.of("$L", TypeSpec.anonymousClassBuilder("", new Object[0]).addSuperinterface(TypeNames.providerOf(keyType)).addMethod(MethodSpec.methodBuilder("get").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(keyType).addCode("return $L;", managerExpression).build()).build());
    }

    private CodeBlock initializeFactoryForSyntheticSetOfReleasableReferenceManagers(ContributionBinding binding) {
        Key key = binding.key();
        SetType keyType = SetType.from(key);
        ImmutableList.Builder managerExpressions = ImmutableList.builder();
        for (Map.Entry entry : this.referenceReleasingProviderManagerFields.entrySet()) {
            Scope scope = (Scope)entry.getKey();
            CodeBlock releasableReferenceManagerExpression = ((MemberSelect)entry.getValue()).getExpressionFor(this.name);
            if (keyType.elementsAreTypeOf(ReleasableReferenceManager.class)) {
                managerExpressions.add((Object)releasableReferenceManagerExpression);
                continue;
            }
            if (keyType.elementsAreTypeOf(TypedReleasableReferenceManager.class)) {
                TypeMirror metadataType = keyType.unwrappedElementType(TypedReleasableReferenceManager.class);
                Optional<AnnotationMirror> metadata = scope.releasableReferencesMetadata(metadataType);
                if (!metadata.isPresent()) continue;
                managerExpressions.add((Object)this.typedReleasableReferenceManagerDecoratorExpression(releasableReferenceManagerExpression, metadata.get()));
                continue;
            }
            throw new IllegalArgumentException("inappropriate key: " + binding);
        }
        TypeName keyTypeName = TypeName.get(key.type());
        return CodeBlock.of("$L", TypeSpec.anonymousClassBuilder("", new Object[0]).addSuperinterface(TypeNames.providerOf(keyTypeName)).addMethod(MethodSpec.methodBuilder("get").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(keyTypeName).addCode("return new $T($T.asList($L));", HashSet.class, Arrays.class, CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)managerExpressions.build())).build()).build());
    }

    private CodeBlock typedReleasableReferenceManagerDecoratorExpression(CodeBlock managerExpression, AnnotationMirror metadata) {
        return CodeBlock.of("new $T($L, $L)", ParameterizedTypeName.get(TypeNames.TYPED_RELEASABLE_REFERENCE_MANAGER_DECORATOR, TypeName.get(metadata.getAnnotationType())), managerExpression, new AnnotationExpression(metadata).getAnnotationInstanceExpression());
    }

    private Scope forReleasableReferencesAnnotationValue(AnnotationMirror annotation) {
        com.google.common.base.Preconditions.checkArgument((boolean)MoreTypes.isTypeOf(ForReleasableReferences.class, annotation.getAnnotationType()));
        return Scope.scope(MoreElements.asType(MoreTypes.asDeclared(MoreAnnotationMirrors.getTypeValue(annotation, "value")).asElement()));
    }

    private CodeBlock initializeFactoryForSyntheticOptionalBinding(ContributionBinding binding) {
        if (binding.explicitDependencies().isEmpty()) {
            Verify.verify((boolean)binding.bindingType().equals((Object)BindingType.PROVISION), (String)"Absent optional bindings should be provisions: %s", (Object[])new Object[]{binding});
            return this.optionalFactories.absentOptionalProvider(binding);
        }
        return this.optionalFactories.presentOptionalFactory(binding, (CodeBlock)Iterables.getOnlyElement(this.getDependencyArguments(binding)));
    }

    static enum InitializationState {
        UNINITIALIZED,
        DELEGATED,
        INITIALIZED;

    }
}

