/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import dagger.internal.codegen.AutoValue_Binding_DependencyAssociation;
import dagger.internal.codegen.BindingDeclaration;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.BindingTypeMapper;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.FrameworkDependency;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.Scope;
import dagger.internal.codegen.SourceFiles;
import dagger.shaded.auto.common.MoreElements;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;

abstract class Binding
extends BindingDeclaration
implements BindingType.HasBindingType {
    Binding() {
    }

    @Override
    public abstract Key key();

    abstract ImmutableSet<DependencyRequest> explicitDependencies();

    Set<DependencyRequest> implicitDependencies() {
        return ImmutableSet.of();
    }

    final Set<DependencyRequest> dependencies() {
        Set<DependencyRequest> implicitDependencies = this.implicitDependencies();
        return implicitDependencies.isEmpty() ? this.explicitDependencies() : Sets.union(implicitDependencies, this.explicitDependencies());
    }

    ImmutableList<FrameworkDependency> frameworkDependencies() {
        return ImmutableList.copyOf((Collection)this.dependencyAssociations().stream().map(DependencyAssociation::frameworkDependency).collect(Collectors.toList()));
    }

    ImmutableList<DependencyAssociation> dependencyAssociations() {
        BindingTypeMapper bindingTypeMapper = BindingTypeMapper.forBindingType(this.bindingType());
        ImmutableList.Builder frameworkDependencies = ImmutableList.builder();
        for (Collection requests : this.groupByUnresolvedKey()) {
            frameworkDependencies.add((Object)DependencyAssociation.create(FrameworkDependency.create((BindingKey)Iterables.getOnlyElement((Iterable)FluentIterable.from((Iterable)requests).transform(DependencyRequest::bindingKey).toSet()), bindingTypeMapper.getBindingType(requests)), requests));
        }
        return frameworkDependencies.build();
    }

    ImmutableMap<DependencyRequest, FrameworkDependency> dependenciesToFrameworkDependenciesMap() {
        ImmutableMap.Builder frameworkDependencyMap = ImmutableMap.builder();
        for (DependencyAssociation dependencyAssociation : this.dependencyAssociations()) {
            for (DependencyRequest dependencyRequest : dependencyAssociation.dependencyRequests()) {
                frameworkDependencyMap.put((Object)dependencyRequest, (Object)dependencyAssociation.frameworkDependency());
            }
        }
        return frameworkDependencyMap.build();
    }

    private ImmutableList<Collection<DependencyRequest>> groupByUnresolvedKey() {
        ImmutableSetMultimap.Builder dependenciesByKeyBuilder = ImmutableSetMultimap.builder();
        Iterator<DependencyRequest> dependencies = this.dependencies().iterator();
        Binding unresolved = this.unresolved().isPresent() ? this.unresolved().get() : this;
        Iterator<DependencyRequest> unresolvedDependencies = unresolved.dependencies().iterator();
        while (dependencies.hasNext()) {
            dependenciesByKeyBuilder.put((Object)unresolvedDependencies.next().bindingKey(), (Object)dependencies.next());
        }
        return ImmutableList.copyOf((Collection)dependenciesByKeyBuilder.orderValuesBy(SourceFiles.DEPENDENCY_ORDERING).build().asMap().values());
    }

    final Optional<String> bindingPackage() {
        Set<String> packages = Binding.nonPublicPackageUse(this.key().type());
        switch (packages.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of(packages.iterator().next());
            }
        }
        throw new IllegalStateException();
    }

    private static Set<String> nonPublicPackageUse(TypeMirror typeMirror) {
        ImmutableSet.Builder packages = ImmutableSet.builder();
        typeMirror.accept(new SimpleTypeVisitor6<Void, ImmutableSet.Builder<String>>(){

            @Override
            public Void visitArray(ArrayType t, ImmutableSet.Builder<String> p) {
                return t.getComponentType().accept(this, p);
            }

            @Override
            public Void visitDeclared(DeclaredType t, ImmutableSet.Builder<String> p) {
                for (TypeMirror typeMirror : t.getTypeArguments()) {
                    typeMirror.accept(this, p);
                }
                TypeElement typeElement = MoreElements.asType(t.asElement());
                if (!typeElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    PackageElement packageElement = MoreElements.getPackage(typeElement);
                    Name qualifiedName = packageElement.getQualifiedName();
                    p.add((Object)qualifiedName.toString());
                }
                typeElement.getEnclosingElement().asType().accept(this, p);
                return null;
            }

            @Override
            public Void visitWildcard(WildcardType t, ImmutableSet.Builder<String> p) {
                if (t.getExtendsBound() != null) {
                    t.getExtendsBound().accept(this, p);
                }
                if (t.getSuperBound() != null) {
                    t.getSuperBound().accept(this, p);
                }
                return null;
            }
        }, packages);
        return packages.build();
    }

    abstract Optional<? extends Binding> unresolved();

    Optional<Scope> scope() {
        return Optional.empty();
    }

    /*
     * WARNING - void declaration
     */
    static boolean hasNonDefaultTypeParameters(TypeElement element, TypeMirror type, Types types) {
        void var5_7;
        if (element.getTypeParameters().isEmpty()) {
            return false;
        }
        ArrayList defaultTypes = Lists.newArrayList();
        for (TypeParameterElement typeParameterElement : element.getTypeParameters()) {
            defaultTypes.add(typeParameterElement.asType());
        }
        List<TypeMirror> actualTypes = type.accept(new SimpleTypeVisitor6<List<TypeMirror>, Void>(){

            @Override
            protected List<TypeMirror> defaultAction(TypeMirror e, Void p) {
                return ImmutableList.of();
            }

            @Override
            public List<TypeMirror> visitDeclared(DeclaredType t, Void p) {
                return ImmutableList.copyOf(t.getTypeArguments());
            }
        }, null);
        if (defaultTypes.size() != actualTypes.size()) {
            return true;
        }
        boolean bl = false;
        while (var5_7 < defaultTypes.size()) {
            if (!types.isSameType((TypeMirror)defaultTypes.get((int)var5_7), actualTypes.get((int)var5_7))) {
                return true;
            }
            ++var5_7;
        }
        return false;
    }

    static abstract class DependencyAssociation {
        DependencyAssociation() {
        }

        abstract FrameworkDependency frameworkDependency();

        abstract ImmutableSet<DependencyRequest> dependencyRequests();

        static DependencyAssociation create(FrameworkDependency frameworkDependency, Iterable<DependencyRequest> dependencyRequests) {
            return new AutoValue_Binding_DependencyAssociation(frameworkDependency, (ImmutableSet<DependencyRequest>)ImmutableSet.copyOf(dependencyRequests));
        }
    }
}

