/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeTraverser;
import dagger.internal.codegen.AutoValue_BindingGraph;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DelegateDeclaration;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.InjectBindingRegistry;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.ModuleDescriptor;
import dagger.internal.codegen.MultibindingDeclaration;
import dagger.internal.codegen.OptionalBindingDeclaration;
import dagger.internal.codegen.ProductionBinding;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.Scope;
import dagger.internal.codegen.SetType;
import dagger.internal.codegen.SubcomponentDeclaration;
import dagger.internal.codegen.Util;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;

abstract class BindingGraph {
    private static final TreeTraverser<BindingGraph> SUBGRAPH_TRAVERSER = new TreeTraverser<BindingGraph>(){

        public Iterable<BindingGraph> children(BindingGraph node) {
            return node.subgraphs();
        }
    };

    BindingGraph() {
    }

    abstract ComponentDescriptor componentDescriptor();

    abstract ImmutableMap<BindingKey, ResolvedBindings> resolvedBindings();

    abstract ImmutableSet<BindingGraph> subgraphs();

    ImmutableSet<ResolvedBindings> resolvedDependencies(ContributionBinding binding) {
        return binding.dependencies().stream().map(dependencyRequest -> (ResolvedBindings)this.resolvedBindings().getOrDefault((Object)dependencyRequest.bindingKey(), (Object)ResolvedBindings.noBindings(dependencyRequest.bindingKey(), this.componentDescriptor()))).collect(Util.toImmutableSet());
    }

    TypeElement componentType() {
        return this.componentDescriptor().componentDefinitionType();
    }

    abstract ImmutableSet<ModuleDescriptor> ownedModules();

    ImmutableSet<TypeElement> ownedModuleTypes() {
        return FluentIterable.from(this.ownedModules()).transform(ModuleDescriptor::moduleElement).toSet();
    }

    ImmutableSet<ComponentRequirement> componentRequirements() {
        ImmutableSet.Builder requirements = ImmutableSet.builder();
        StreamSupport.stream(SUBGRAPH_TRAVERSER.preOrderTraversal((Object)this).spliterator(), false).flatMap(graph -> graph.resolvedBindings().values().stream()).flatMap(bindings -> bindings.contributionBindings().stream()).filter(ContributionBinding::requiresModuleInstance).map(bindingDeclaration -> bindingDeclaration.contributingModule()).filter(Optional::isPresent).map(Optional::get).filter(module -> this.ownedModuleTypes().contains(module)).map(module -> ComponentRequirement.forModule(module.asType())).forEach(arg_0 -> ((ImmutableSet.Builder)requirements).add(arg_0));
        this.componentDescriptor().dependencies().stream().map(dep -> ComponentRequirement.forDependency(dep.asType())).forEach(arg_0 -> ((ImmutableSet.Builder)requirements).add(arg_0));
        if (this.componentDescriptor().builderSpec().isPresent()) {
            this.componentDescriptor().builderSpec().get().requirementMethods().stream().map(ComponentDescriptor.BuilderRequirementMethod::requirement).filter(req -> req.kind().equals((Object)ComponentRequirement.Kind.BINDING)).forEach(arg_0 -> ((ImmutableSet.Builder)requirements).add(arg_0));
        }
        return requirements.build();
    }

    ImmutableSet<ComponentDescriptor> componentDescriptors() {
        return SUBGRAPH_TRAVERSER.preOrderTraversal((Object)this).transform(BindingGraph::componentDescriptor).toSet();
    }

    ImmutableSet<ComponentRequirement> availableDependencies() {
        return Stream.concat(this.componentDescriptor().transitiveModuleTypes().stream().filter(dep -> !dep.getModifiers().contains((Object)Modifier.ABSTRACT)).map(module -> ComponentRequirement.forModule(module.asType())), this.componentDescriptor().dependencies().stream().map(dep -> ComponentRequirement.forDependency(dep.asType()))).collect(Util.toImmutableSet());
    }

    static final class Factory {
        private final Elements elements;
        private final InjectBindingRegistry injectBindingRegistry;
        private final Key.Factory keyFactory;
        private final ProvisionBinding.Factory provisionBindingFactory;
        private final ProductionBinding.Factory productionBindingFactory;

        Factory(Elements elements, InjectBindingRegistry injectBindingRegistry, Key.Factory keyFactory, ProvisionBinding.Factory provisionBindingFactory, ProductionBinding.Factory productionBindingFactory) {
            this.elements = elements;
            this.injectBindingRegistry = injectBindingRegistry;
            this.keyFactory = keyFactory;
            this.provisionBindingFactory = provisionBindingFactory;
            this.productionBindingFactory = productionBindingFactory;
        }

        BindingGraph create(ComponentDescriptor componentDescriptor) {
            return this.create(Optional.empty(), componentDescriptor);
        }

        private BindingGraph create(Optional<Resolver> parentResolver, ComponentDescriptor componentDescriptor) {
            ImmutableSet.Builder explicitBindingsBuilder = ImmutableSet.builder();
            ImmutableSet.Builder delegatesBuilder = ImmutableSet.builder();
            ImmutableSet.Builder optionalsBuilder = ImmutableSet.builder();
            explicitBindingsBuilder.add((Object)this.provisionBindingFactory.forComponent(componentDescriptor.componentDefinitionType()));
            for (TypeElement componentDependency : componentDescriptor.dependencies()) {
                explicitBindingsBuilder.add((Object)this.provisionBindingFactory.forComponent(componentDependency));
                List<ExecutableElement> dependencyMethods = ElementFilter.methodsIn(this.elements.getAllMembers(componentDependency));
                for (ExecutableElement method : dependencyMethods) {
                    if (!ComponentDescriptor.isComponentContributionMethod(this.elements, method)) continue;
                    explicitBindingsBuilder.add((Object)(componentDescriptor.kind().equals((Object)ComponentDescriptor.Kind.PRODUCTION_COMPONENT) && ComponentDescriptor.isComponentProductionMethod(this.elements, method) ? this.productionBindingFactory.forComponentMethod(method) : this.provisionBindingFactory.forComponentMethod(method)));
                }
            }
            if (componentDescriptor.builderSpec().isPresent()) {
                for (ComponentDescriptor.BuilderRequirementMethod method : componentDescriptor.builderSpec().get().requirementMethods()) {
                    if (!method.requirement().kind().equals((Object)ComponentRequirement.Kind.BINDING)) continue;
                    explicitBindingsBuilder.add((Object)this.provisionBindingFactory.forBuilderBinding(method));
                }
            }
            for (Map.Entry componentMethodAndSubcomponent : componentDescriptor.subcomponentsByBuilderMethod().entrySet()) {
                ComponentDescriptor.ComponentMethodDescriptor componentMethod = (ComponentDescriptor.ComponentMethodDescriptor)componentMethodAndSubcomponent.getKey();
                ComponentDescriptor subcomponentDescriptor = (ComponentDescriptor)componentMethodAndSubcomponent.getValue();
                if (componentDescriptor.subcomponentsFromModules().contains((Object)subcomponentDescriptor)) continue;
                explicitBindingsBuilder.add((Object)this.provisionBindingFactory.forSubcomponentBuilderMethod(componentMethod.methodElement(), componentDescriptor.componentDefinitionType()));
            }
            ImmutableSet.Builder multibindingDeclarations = ImmutableSet.builder();
            ImmutableSet.Builder subcomponentDeclarations = ImmutableSet.builder();
            for (ModuleDescriptor moduleDescriptor : componentDescriptor.transitiveModules()) {
                explicitBindingsBuilder.addAll(moduleDescriptor.bindings());
                multibindingDeclarations.addAll(moduleDescriptor.multibindingDeclarations());
                subcomponentDeclarations.addAll(moduleDescriptor.subcomponentDeclarations());
                delegatesBuilder.addAll(moduleDescriptor.delegateDeclarations());
                optionalsBuilder.addAll(moduleDescriptor.optionalDeclarations());
            }
            for (Scope scope : componentDescriptor.releasableReferencesScopes()) {
                explicitBindingsBuilder.add((Object)this.provisionBindingFactory.provideReleasableReferenceManager(scope));
                explicitBindingsBuilder.add((Object)this.provisionBindingFactory.provideSetOfReleasableReferenceManagers());
                for (AnnotationMirror metadata : scope.releasableReferencesMetadata()) {
                    explicitBindingsBuilder.add((Object)this.provisionBindingFactory.provideTypedReleasableReferenceManager(scope, metadata.getAnnotationType()));
                    explicitBindingsBuilder.add((Object)this.provisionBindingFactory.provideSetOfTypedReleasableReferenceManagers(metadata.getAnnotationType()));
                }
            }
            Resolver requestResolver = new Resolver(parentResolver, componentDescriptor, Key.indexByKey(explicitBindingsBuilder.build()), Key.indexByKey(multibindingDeclarations.build()), Key.indexByKey(subcomponentDeclarations.build()), Key.indexByKey(delegatesBuilder.build()), Key.indexByKey(optionalsBuilder.build()));
            for (ComponentDescriptor.ComponentMethodDescriptor componentMethod : componentDescriptor.componentMethods()) {
                Optional<DependencyRequest> componentMethodRequest = componentMethod.dependencyRequest();
                if (!componentMethodRequest.isPresent()) continue;
                requestResolver.resolve(componentMethodRequest.get().bindingKey());
            }
            HashSet<ComponentDescriptor> resolvedSubcomponents = new HashSet<ComponentDescriptor>();
            ImmutableSet.Builder subgraphs = ImmutableSet.builder();
            for (ComponentDescriptor subcomponent : Iterables.consumingIterable(requestResolver.subcomponentsToResolve)) {
                if (!resolvedSubcomponents.add(subcomponent)) continue;
                subgraphs.add((Object)this.create(Optional.of(requestResolver), subcomponent));
            }
            for (ResolvedBindings resolvedBindings : requestResolver.getResolvedBindings().values()) {
                Verify.verify((boolean)resolvedBindings.owningComponent().equals(componentDescriptor), (String)"%s is not owned by %s", (Object[])new Object[]{resolvedBindings, componentDescriptor});
            }
            return new AutoValue_BindingGraph(componentDescriptor, requestResolver.getResolvedBindings(), (ImmutableSet<BindingGraph>)subgraphs.build(), requestResolver.getOwnedModules());
        }

        static <T extends Key.HasKey> ImmutableSetMultimap<Key, T> multibindingContributionsByMultibindingKey(Iterable<T> declarations) {
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            for (Key.HasKey declaration : declarations) {
                if (!declaration.key().multibindingContributionIdentifier().isPresent()) continue;
                builder.put((Object)declaration.key().withoutMultibindingContributionIdentifier(), (Object)declaration);
            }
            return builder.build();
        }

        private final class Resolver {
            final Optional<Resolver> parentResolver;
            final ComponentDescriptor componentDescriptor;
            final ImmutableSetMultimap<Key, ContributionBinding> explicitBindings;
            final ImmutableSet<ContributionBinding> explicitBindingsSet;
            final ImmutableSetMultimap<Key, ContributionBinding> explicitMultibindings;
            final ImmutableSetMultimap<Key, MultibindingDeclaration> multibindingDeclarations;
            final ImmutableSetMultimap<Key, SubcomponentDeclaration> subcomponentDeclarations;
            final ImmutableSetMultimap<Key, DelegateDeclaration> delegateDeclarations;
            final ImmutableSetMultimap<Key, OptionalBindingDeclaration> optionalBindingDeclarations;
            final ImmutableSetMultimap<Key, DelegateDeclaration> delegateMultibindingDeclarations;
            final Map<BindingKey, ResolvedBindings> resolvedBindings;
            final Deque<BindingKey> cycleStack = new ArrayDeque<BindingKey>();
            final Cache<BindingKey, Boolean> bindingKeyDependsOnLocalBindingsCache = CacheBuilder.newBuilder().build();
            final Cache<Binding, Boolean> bindingDependsOnLocalBindingsCache = CacheBuilder.newBuilder().build();
            final Queue<ComponentDescriptor> subcomponentsToResolve = new ArrayDeque<ComponentDescriptor>();

            Resolver(Optional<Resolver> parentResolver, ComponentDescriptor componentDescriptor, ImmutableSetMultimap<Key, ContributionBinding> explicitBindings, ImmutableSetMultimap<Key, MultibindingDeclaration> multibindingDeclarations, ImmutableSetMultimap<Key, SubcomponentDeclaration> subcomponentDeclarations, ImmutableSetMultimap<Key, DelegateDeclaration> delegateDeclarations, ImmutableSetMultimap<Key, OptionalBindingDeclaration> optionalBindingDeclarations) {
                this.parentResolver = (Optional)Preconditions.checkNotNull(parentResolver);
                this.componentDescriptor = (ComponentDescriptor)Preconditions.checkNotNull((Object)componentDescriptor);
                this.explicitBindings = (ImmutableSetMultimap)Preconditions.checkNotNull(explicitBindings);
                this.explicitBindingsSet = ImmutableSet.copyOf((Collection)explicitBindings.values());
                this.multibindingDeclarations = (ImmutableSetMultimap)Preconditions.checkNotNull(multibindingDeclarations);
                this.subcomponentDeclarations = (ImmutableSetMultimap)Preconditions.checkNotNull(subcomponentDeclarations);
                this.delegateDeclarations = (ImmutableSetMultimap)Preconditions.checkNotNull(delegateDeclarations);
                this.optionalBindingDeclarations = (ImmutableSetMultimap)Preconditions.checkNotNull(optionalBindingDeclarations);
                this.resolvedBindings = Maps.newLinkedHashMap();
                this.explicitMultibindings = Factory.multibindingContributionsByMultibindingKey(this.explicitBindingsSet);
                this.delegateMultibindingDeclarations = Factory.multibindingContributionsByMultibindingKey(delegateDeclarations.values());
                this.subcomponentsToResolve.addAll((Collection<ComponentDescriptor>)componentDescriptor.subcomponentsFromEntryPoints());
            }

            ResolvedBindings lookUpBindings(BindingKey bindingKey) {
                Key requestKey = bindingKey.key();
                switch (bindingKey.kind()) {
                    case CONTRIBUTION: {
                        LinkedHashSet<ContributionBinding> contributionBindings = new LinkedHashSet<ContributionBinding>();
                        ImmutableSet.Builder multibindingContributionsBuilder = ImmutableSet.builder();
                        ImmutableSet.Builder multibindingDeclarationsBuilder = ImmutableSet.builder();
                        ImmutableSet.Builder subcomponentDeclarationsBuilder = ImmutableSet.builder();
                        ImmutableSet.Builder optionalBindingDeclarationsBuilder = ImmutableSet.builder();
                        for (Key key : this.keysMatchingRequest(requestKey)) {
                            contributionBindings.addAll((Collection<ContributionBinding>)this.getExplicitBindings(key));
                            multibindingContributionsBuilder.addAll(this.getExplicitMultibindings(key));
                            multibindingDeclarationsBuilder.addAll(this.getMultibindingDeclarations(key));
                            subcomponentDeclarationsBuilder.addAll(this.getSubcomponentDeclarations(key));
                            optionalBindingDeclarationsBuilder.addAll(this.getOptionalBindingDeclarations(key));
                        }
                        ImmutableSet multibindingContributions = multibindingContributionsBuilder.build();
                        ImmutableSet multibindingDeclarations = multibindingDeclarationsBuilder.build();
                        ImmutableSet subcomponentDeclarations = subcomponentDeclarationsBuilder.build();
                        ImmutableSet optionalBindingDeclarations = optionalBindingDeclarationsBuilder.build();
                        ImmutableSet.Builder maybeContributionBindings = ImmutableSet.builder();
                        maybeContributionBindings.add(this.syntheticMapOfValuesBinding(requestKey));
                        maybeContributionBindings.add(this.syntheticMultibinding(requestKey, (Iterable<ContributionBinding>)multibindingContributions, (Iterable<MultibindingDeclaration>)multibindingDeclarations));
                        this.syntheticSubcomponentBuilderBinding((ImmutableSet<SubcomponentDeclaration>)subcomponentDeclarations).ifPresent(binding -> {
                            contributionBindings.add((ContributionBinding)binding);
                            this.addSubcomponentToOwningResolver((ProvisionBinding)binding);
                        });
                        maybeContributionBindings.add(this.syntheticOptionalBinding(requestKey, (ImmutableSet<OptionalBindingDeclaration>)optionalBindingDeclarations));
                        if (contributionBindings.isEmpty()) {
                            maybeContributionBindings.add(Factory.this.injectBindingRegistry.getOrFindProvisionBinding(requestKey).map(b -> b));
                        }
                        maybeContributionBindings.build().stream().filter(Optional::isPresent).map(Optional::get).forEach(contributionBindings::add);
                        return ResolvedBindings.forContributionBindings(bindingKey, this.componentDescriptor, this.indexBindingsByOwningComponent(bindingKey, (Iterable<? extends ContributionBinding>)ImmutableSet.copyOf(contributionBindings)), (Iterable<MultibindingDeclaration>)multibindingDeclarations, (Iterable<SubcomponentDeclaration>)subcomponentDeclarations, (Iterable<OptionalBindingDeclaration>)optionalBindingDeclarations);
                    }
                    case MEMBERS_INJECTION: {
                        Optional<MembersInjectionBinding> binding2 = Factory.this.injectBindingRegistry.getOrFindMembersInjectionBinding(requestKey);
                        return binding2.isPresent() ? ResolvedBindings.forMembersInjectionBinding(bindingKey, this.componentDescriptor, binding2.get()) : ResolvedBindings.noBindings(bindingKey, this.componentDescriptor);
                    }
                }
                throw new AssertionError();
            }

            private void addSubcomponentToOwningResolver(ProvisionBinding subcomponentBuilderBinding) {
                Preconditions.checkArgument((boolean)subcomponentBuilderBinding.bindingKind().equals((Object)ContributionBinding.Kind.SUBCOMPONENT_BUILDER));
                Resolver owningResolver = this.getOwningResolver(subcomponentBuilderBinding).get();
                TypeElement builderType = MoreTypes.asTypeElement(subcomponentBuilderBinding.key().type());
                owningResolver.subcomponentsToResolve.add((ComponentDescriptor)owningResolver.componentDescriptor.subcomponentsByBuilderType().get((Object)builderType));
            }

            private Iterable<Key> keysMatchingRequest(Key requestKey) {
                ImmutableSet.Builder keys = ImmutableSet.builder();
                keys.add((Object)requestKey);
                Factory.this.keyFactory.unwrapSetKey(requestKey, Produced.class).ifPresent(arg_0 -> ((ImmutableSet.Builder)keys).add(arg_0));
                Factory.this.keyFactory.rewrapMapKey(requestKey, Producer.class, Provider.class).ifPresent(arg_0 -> ((ImmutableSet.Builder)keys).add(arg_0));
                Factory.this.keyFactory.rewrapMapKey(requestKey, Provider.class, Producer.class).ifPresent(arg_0 -> ((ImmutableSet.Builder)keys).add(arg_0));
                return keys.build();
            }

            private Optional<ContributionBinding> syntheticMapOfValuesBinding(Key key) {
                return this.syntheticMultibinding(key, (Iterable<ContributionBinding>)this.multibindingContributionsForValueMap(key), (Iterable<MultibindingDeclaration>)this.multibindingDeclarationsForValueMap(key)).map(syntheticMultibinding -> {
                    switch (syntheticMultibinding.bindingType()) {
                        case PROVISION: {
                            return Factory.this.provisionBindingFactory.syntheticMapOfValuesBinding(key);
                        }
                        case PRODUCTION: {
                            return Factory.this.productionBindingFactory.syntheticMapOfValuesOrProducedBinding(key);
                        }
                    }
                    throw new VerifyException(syntheticMultibinding.toString());
                });
            }

            private ImmutableSet<ContributionBinding> multibindingContributionsForValueMap(Key key) {
                return Factory.this.keyFactory.implicitFrameworkMapKeys(key).stream().flatMap(mapKey -> this.getExplicitMultibindings((Key)mapKey).stream()).collect(Util.toImmutableSet());
            }

            private ImmutableSet<MultibindingDeclaration> multibindingDeclarationsForValueMap(Key key) {
                return Factory.this.keyFactory.implicitFrameworkMapKeys(key).stream().flatMap(mapKey -> this.getMultibindingDeclarations((Key)mapKey).stream()).collect(Util.toImmutableSet());
            }

            private Optional<ContributionBinding> syntheticMultibinding(Key key, Iterable<ContributionBinding> multibindingContributions, Iterable<MultibindingDeclaration> multibindingDeclarations) {
                if (Iterables.isEmpty(multibindingContributions) && Iterables.isEmpty(multibindingDeclarations)) {
                    return Optional.empty();
                }
                if (this.multibindingsRequireProduction(multibindingContributions, key)) {
                    return Optional.of(Factory.this.productionBindingFactory.syntheticMultibinding(key, multibindingContributions));
                }
                return Optional.of(Factory.this.provisionBindingFactory.syntheticMultibinding(key, multibindingContributions));
            }

            private boolean multibindingsRequireProduction(Iterable<ContributionBinding> multibindingContributions, Key key) {
                MapType mapType;
                if (MapType.isMap(key) ? (mapType = MapType.from(key)).valuesAreTypeOf(Producer.class) || mapType.valuesAreTypeOf(Produced.class) : SetType.isSet(key) && SetType.from(key).elementsAreTypeOf(Produced.class)) {
                    return true;
                }
                return Iterables.any(multibindingContributions, hasBindingType -> hasBindingType.bindingType().equals((Object)BindingType.PRODUCTION));
            }

            private Optional<ProvisionBinding> syntheticSubcomponentBuilderBinding(ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations) {
                return subcomponentDeclarations.isEmpty() ? Optional.empty() : Optional.of(Factory.this.provisionBindingFactory.syntheticSubcomponentBuilder(subcomponentDeclarations));
            }

            private Optional<ContributionBinding> syntheticOptionalBinding(Key key, ImmutableSet<OptionalBindingDeclaration> optionalBindingDeclarations) {
                if (optionalBindingDeclarations.isEmpty()) {
                    return Optional.empty();
                }
                ResolvedBindings underlyingKeyBindings = this.lookUpBindings(BindingKey.contribution(Factory.this.keyFactory.unwrapOptional(key).get()));
                if (underlyingKeyBindings.isEmpty()) {
                    return Optional.of(Factory.this.provisionBindingFactory.syntheticAbsentBinding(key));
                }
                if (underlyingKeyBindings.bindingTypes().contains((Object)BindingType.PRODUCTION)) {
                    return Optional.of(Factory.this.productionBindingFactory.syntheticPresentBinding(key));
                }
                return Optional.of(Factory.this.provisionBindingFactory.syntheticPresentBinding(key));
            }

            private ImmutableSet<ContributionBinding> createDelegateBindings(ImmutableSet<DelegateDeclaration> delegateDeclarations) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                for (DelegateDeclaration delegateDeclaration : delegateDeclarations) {
                    builder.add((Object)this.createDelegateBinding(delegateDeclaration));
                }
                return builder.build();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private ContributionBinding createDelegateBinding(DelegateDeclaration delegateDeclaration) {
                ResolvedBindings resolvedDelegate;
                BindingKey delegateBindingKey = delegateDeclaration.delegateRequest().bindingKey();
                if (this.cycleStack.contains(delegateBindingKey)) {
                    return Factory.this.provisionBindingFactory.missingDelegate(delegateDeclaration);
                }
                try {
                    this.cycleStack.push(delegateBindingKey);
                    resolvedDelegate = this.lookUpBindings(delegateBindingKey);
                }
                finally {
                    this.cycleStack.pop();
                }
                if (resolvedDelegate.contributionBindings().isEmpty()) {
                    return Factory.this.provisionBindingFactory.missingDelegate(delegateDeclaration);
                }
                ContributionBinding explicitDelegate = (ContributionBinding)resolvedDelegate.contributionBindings().iterator().next();
                switch (explicitDelegate.bindingType()) {
                    case PRODUCTION: {
                        return Factory.this.productionBindingFactory.delegate(delegateDeclaration, (ProductionBinding)explicitDelegate);
                    }
                    case PROVISION: {
                        return Factory.this.provisionBindingFactory.delegate(delegateDeclaration, (ProvisionBinding)explicitDelegate);
                    }
                }
                throw new AssertionError((Object)("bindingType: " + explicitDelegate));
            }

            private ImmutableSetMultimap<ComponentDescriptor, ContributionBinding> indexBindingsByOwningComponent(BindingKey bindingKey, Iterable<? extends ContributionBinding> bindings) {
                ImmutableSetMultimap.Builder index = ImmutableSetMultimap.builder();
                for (ContributionBinding contributionBinding : bindings) {
                    index.put((Object)this.getOwningComponent(bindingKey, contributionBinding), (Object)contributionBinding);
                }
                return index.build();
            }

            private ComponentDescriptor getOwningComponent(BindingKey bindingKey, ContributionBinding binding) {
                if (this.isResolvedInParent(bindingKey, binding) && !new LocalDependencyChecker().dependsOnLocalBindings(binding)) {
                    ResolvedBindings parentResolvedBindings = this.parentResolver.get().resolvedBindings.get(bindingKey);
                    return parentResolvedBindings.owningComponent(binding);
                }
                return this.componentDescriptor;
            }

            private boolean isResolvedInParent(BindingKey bindingKey, ContributionBinding binding) {
                Optional<Resolver> owningResolver = this.getOwningResolver(binding);
                if (owningResolver.isPresent() && !owningResolver.get().equals(this)) {
                    this.parentResolver.get().resolve(bindingKey);
                    return true;
                }
                return false;
            }

            private Optional<Resolver> getOwningResolver(ContributionBinding binding) {
                if (binding.scope().isPresent() && binding.scope().get().equals(Scope.reusableScope(Factory.this.elements))) {
                    for (Resolver requestResolver : this.getResolverLineage().reverse()) {
                        if (!requestResolver.resolvedBindings.containsKey(BindingKey.contribution(binding.key()))) continue;
                        return Optional.of(requestResolver);
                    }
                    return Optional.empty();
                }
                for (Resolver requestResolver : this.getResolverLineage().reverse()) {
                    if (!requestResolver.explicitBindingsSet.contains((Object)binding) && !requestResolver.subcomponentDeclarations.containsKey((Object)binding.key())) continue;
                    return Optional.of(requestResolver);
                }
                Optional<Scope> bindingScope = binding.scope();
                if (bindingScope.isPresent()) {
                    for (Resolver requestResolver : this.getResolverLineage().reverse()) {
                        if (!requestResolver.componentDescriptor.scopes().contains((Object)bindingScope.get())) continue;
                        return Optional.of(requestResolver);
                    }
                }
                return Optional.empty();
            }

            private ImmutableList<Resolver> getResolverLineage() {
                ArrayList resolverList = Lists.newArrayList();
                Optional<Resolver> currentResolver = Optional.of(this);
                while (currentResolver.isPresent()) {
                    resolverList.add(currentResolver.get());
                    currentResolver = currentResolver.get().parentResolver;
                }
                return ImmutableList.copyOf((Collection)Lists.reverse((List)resolverList));
            }

            private ImmutableSet<ContributionBinding> getExplicitBindings(Key key) {
                ImmutableSet.Builder bindings = ImmutableSet.builder();
                for (Resolver resolver : this.getResolverLineage()) {
                    bindings.addAll(resolver.getLocalExplicitBindings(key));
                }
                return bindings.build();
            }

            private ImmutableSet<ContributionBinding> getLocalExplicitBindings(Key key) {
                return new ImmutableSet.Builder().addAll((Iterable)this.explicitBindings.get((Object)key)).addAll(this.createDelegateBindings((ImmutableSet<DelegateDeclaration>)this.delegateDeclarations.get((Object)Factory.this.keyFactory.convertToDelegateKey(key)))).build();
            }

            private ImmutableSet<ContributionBinding> getExplicitMultibindings(Key key) {
                ImmutableSet.Builder multibindings = ImmutableSet.builder();
                for (Resolver resolver : this.getResolverLineage()) {
                    multibindings.addAll(resolver.getLocalExplicitMultibindings(key));
                }
                return multibindings.build();
            }

            private ImmutableSet<ContributionBinding> getLocalExplicitMultibindings(Key key) {
                ImmutableSet.Builder multibindings = ImmutableSet.builder();
                multibindings.addAll((Iterable)this.explicitMultibindings.get((Object)key));
                if (!MapType.isMap(key) || MapType.from(key).valuesAreFrameworkType()) {
                    multibindings.addAll(this.createDelegateBindings((ImmutableSet<DelegateDeclaration>)this.delegateMultibindingDeclarations.get((Object)Factory.this.keyFactory.convertToDelegateKey(key))));
                }
                return multibindings.build();
            }

            private ImmutableSet<MultibindingDeclaration> getMultibindingDeclarations(Key key) {
                ImmutableSet.Builder multibindingDeclarations = ImmutableSet.builder();
                for (Resolver resolver : this.getResolverLineage()) {
                    multibindingDeclarations.addAll((Iterable)resolver.multibindingDeclarations.get((Object)key));
                }
                return multibindingDeclarations.build();
            }

            private ImmutableSet<SubcomponentDeclaration> getSubcomponentDeclarations(Key key) {
                ImmutableSet.Builder subcomponentDeclarations = ImmutableSet.builder();
                for (Resolver resolver : this.getResolverLineage()) {
                    subcomponentDeclarations.addAll((Iterable)resolver.subcomponentDeclarations.get((Object)key));
                }
                return subcomponentDeclarations.build();
            }

            private ImmutableSet<OptionalBindingDeclaration> getOptionalBindingDeclarations(Key key) {
                Optional<Key> unwrapped = Factory.this.keyFactory.unwrapOptional(key);
                if (!unwrapped.isPresent()) {
                    return ImmutableSet.of();
                }
                ImmutableSet.Builder declarations = ImmutableSet.builder();
                for (Resolver resolver : this.getResolverLineage()) {
                    declarations.addAll((Iterable)resolver.optionalBindingDeclarations.get((Object)unwrapped.get()));
                }
                return declarations.build();
            }

            private Optional<ResolvedBindings> getPreviouslyResolvedBindings(BindingKey bindingKey) {
                Optional<ResolvedBindings> result = Optional.ofNullable(this.resolvedBindings.get(bindingKey));
                if (result.isPresent()) {
                    return result;
                }
                if (this.parentResolver.isPresent()) {
                    return this.parentResolver.get().getPreviouslyResolvedBindings(bindingKey);
                }
                return Optional.empty();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void resolve(BindingKey bindingKey) {
                if (this.cycleStack.contains(bindingKey)) {
                    return;
                }
                if (this.resolvedBindings.containsKey(bindingKey)) {
                    return;
                }
                if (this.getPreviouslyResolvedBindings(bindingKey).isPresent()) {
                    this.parentResolver.get().resolve(bindingKey);
                    if (!new LocalDependencyChecker().dependsOnLocalBindings(bindingKey) && this.getLocalExplicitBindings(bindingKey.key()).isEmpty()) {
                        ResolvedBindings inheritedBindings = this.getPreviouslyResolvedBindings(bindingKey).get().asInheritedIn(this.componentDescriptor);
                        this.resolvedBindings.put(bindingKey, inheritedBindings);
                        return;
                    }
                }
                this.cycleStack.push(bindingKey);
                try {
                    ResolvedBindings bindings = this.lookUpBindings(bindingKey);
                    for (Binding binding : bindings.ownedBindings()) {
                        for (DependencyRequest dependency : binding.dependencies()) {
                            this.resolve(dependency.bindingKey());
                        }
                    }
                    this.resolvedBindings.put(bindingKey, bindings);
                }
                finally {
                    this.cycleStack.pop();
                }
            }

            ImmutableMap<BindingKey, ResolvedBindings> getResolvedBindings() {
                ImmutableMap.Builder resolvedBindingsBuilder = ImmutableMap.builder();
                resolvedBindingsBuilder.putAll(this.resolvedBindings);
                if (this.parentResolver.isPresent()) {
                    Collection bindingsResolvedInParent = Maps.difference(this.parentResolver.get().getResolvedBindings(), this.resolvedBindings).entriesOnlyOnLeft().values();
                    for (ResolvedBindings resolvedInParent : bindingsResolvedInParent) {
                        resolvedBindingsBuilder.put((Object)resolvedInParent.bindingKey(), (Object)resolvedInParent.asInheritedIn(this.componentDescriptor));
                    }
                }
                return resolvedBindingsBuilder.build();
            }

            ImmutableSet<ModuleDescriptor> getInheritedModules() {
                return this.parentResolver.isPresent() ? Sets.union(this.parentResolver.get().getInheritedModules(), this.parentResolver.get().componentDescriptor.transitiveModules()).immutableCopy() : ImmutableSet.of();
            }

            ImmutableSet<ModuleDescriptor> getOwnedModules() {
                return Sets.difference(this.componentDescriptor.transitiveModules(), this.getInheritedModules()).immutableCopy();
            }

            private final class LocalDependencyChecker {
                private final Set<Object> cycleChecker = new HashSet<Object>();

                private LocalDependencyChecker() {
                }

                boolean dependsOnLocalBindings(BindingKey bindingKey) {
                    Preconditions.checkArgument((boolean)Resolver.this.getPreviouslyResolvedBindings(bindingKey).isPresent(), (String)"no previously resolved bindings in %s for %s", (Object)Resolver.this, (Object)bindingKey);
                    if (!this.cycleChecker.add(bindingKey)) {
                        return false;
                    }
                    try {
                        return (Boolean)Resolver.this.bindingKeyDependsOnLocalBindingsCache.get((Object)bindingKey, () -> {
                            ResolvedBindings previouslyResolvedBindings = (ResolvedBindings)Resolver.this.getPreviouslyResolvedBindings(bindingKey).get();
                            if (this.hasLocalMultibindingContributions(previouslyResolvedBindings) || this.hasLocallyPresentOptionalBinding(previouslyResolvedBindings)) {
                                return true;
                            }
                            for (Binding binding : previouslyResolvedBindings.bindings()) {
                                if (!this.dependsOnLocalBindings(binding)) continue;
                                return true;
                            }
                            return false;
                        });
                    }
                    catch (ExecutionException e) {
                        throw new AssertionError((Object)e);
                    }
                }

                boolean dependsOnLocalBindings(Binding binding) {
                    if (!this.cycleChecker.add(binding)) {
                        return false;
                    }
                    try {
                        return (Boolean)Resolver.this.bindingDependsOnLocalBindingsCache.get((Object)binding, () -> {
                            if (!(binding.scope().isPresent() && !binding.scope().get().equals(Scope.reusableScope(Factory.this.elements)) || binding.bindingType().equals((Object)BindingType.PRODUCTION))) {
                                for (DependencyRequest dependency : binding.dependencies()) {
                                    if (!this.dependsOnLocalBindings(dependency.bindingKey())) continue;
                                    return true;
                                }
                            }
                            return false;
                        });
                    }
                    catch (ExecutionException e) {
                        throw new AssertionError((Object)e);
                    }
                }

                private boolean hasLocalMultibindingContributions(ResolvedBindings resolvedBindings) {
                    return resolvedBindings.contributionBindings().stream().map(ContributionBinding::bindingKind).anyMatch(arg_0 -> ContributionBinding.Kind.SYNTHETIC_MULTIBOUND_KINDS.contains(arg_0)) && !Resolver.this.getLocalExplicitMultibindings(resolvedBindings.key()).isEmpty();
                }

                private boolean hasLocallyPresentOptionalBinding(ResolvedBindings resolvedBindings) {
                    return resolvedBindings.contributionBindings().stream().map(ContributionBinding::bindingKind).anyMatch(Predicate.isEqual((Object)ContributionBinding.Kind.SYNTHETIC_OPTIONAL_BINDING)) && !Resolver.this.getLocalExplicitBindings(Factory.this.keyFactory.unwrapOptional(resolvedBindings.key()).get()).isEmpty();
                }
            }
        }
    }
}

