/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

class BuilderValidator {
    private final Elements elements;
    private final Types types;

    BuilderValidator(Elements elements, Types types) {
        this.elements = elements;
        this.types = types;
    }

    public ValidationReport<TypeElement> validate(TypeElement subject) {
        Set<Modifier> modifiers;
        ValidationReport.Builder<TypeElement> builder = ValidationReport.about(subject);
        ComponentDescriptor.Kind componentKind = ComponentDescriptor.Kind.forAnnotatedBuilderElement(subject).get();
        Element componentElement = subject.getEnclosingElement();
        ErrorMessages.ComponentBuilderMessages msgs = ErrorMessages.builderMsgsFor(componentKind);
        Class<? extends Annotation> componentAnnotation = componentKind.annotationType();
        Class<? extends Annotation> builderAnnotation = componentKind.builderAnnotationType();
        Preconditions.checkArgument((subject.getAnnotation(builderAnnotation) != null ? 1 : 0) != 0);
        if (!MoreElements.isAnnotationPresent(componentElement, componentAnnotation)) {
            builder.addError(msgs.mustBeInComponent(), subject);
        }
        switch (subject.getKind()) {
            case CLASS: {
                List<? extends Element> allElements = subject.getEnclosedElements();
                List<ExecutableElement> cxtors = ElementFilter.constructorsIn(allElements);
                if (cxtors.size() == 1 && ((ExecutableElement)Iterables.getOnlyElement(cxtors)).getParameters().size() == 0) break;
                builder.addError(msgs.cxtorOnlyOneAndNoArgs(), subject);
                break;
            }
            case INTERFACE: {
                break;
            }
            default: {
                builder.addError(msgs.mustBeClassOrInterface(), subject);
                return builder.build();
            }
        }
        if (!subject.getTypeParameters().isEmpty()) {
            builder.addError(msgs.generics(), subject);
        }
        if ((modifiers = subject.getModifiers()).contains((Object)Modifier.PRIVATE)) {
            builder.addError(msgs.isPrivate(), subject);
        }
        if (!modifiers.contains((Object)Modifier.STATIC)) {
            builder.addError(msgs.mustBeStatic(), subject);
        }
        if (!modifiers.contains((Object)Modifier.ABSTRACT)) {
            builder.addError(msgs.mustBeAbstract(), subject);
        }
        ExecutableElement buildMethod = null;
        for (ExecutableElement method : DaggerElements.getUnimplementedMethods(this.elements, this.types, subject)) {
            ExecutableType resolvedMethodType = MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(subject.asType()), method));
            TypeMirror returnType = resolvedMethodType.getReturnType();
            if (method.getParameters().size() == 0) {
                if (this.types.isSameType(returnType, componentElement.asType())) {
                    if (buildMethod != null) {
                        this.error(builder, method, msgs.twoBuildMethods(), msgs.inheritedTwoBuildMethods(), buildMethod);
                    }
                } else {
                    this.error(builder, method, msgs.buildMustReturnComponentType(), msgs.inheritedBuildMustReturnComponentType(), new Object[0]);
                }
                buildMethod = method;
                continue;
            }
            if (method.getParameters().size() > 1) {
                this.error(builder, method, msgs.methodsMustTakeOneArg(), msgs.inheritedMethodsMustTakeOneArg(), new Object[0]);
                continue;
            }
            if (returnType.getKind() != TypeKind.VOID && !this.types.isSubtype(subject.asType(), returnType)) {
                this.error(builder, method, msgs.methodsMustReturnVoidOrBuilder(), msgs.inheritedMethodsMustReturnVoidOrBuilder(), new Object[0]);
                continue;
            }
            if (method.getTypeParameters().isEmpty()) continue;
            this.error(builder, method, msgs.methodsMayNotHaveTypeParameters(), msgs.inheritedMethodsMayNotHaveTypeParameters(), new Object[0]);
        }
        if (buildMethod == null) {
            builder.addError(msgs.missingBuildMethod(), subject);
        }
        return builder.build();
    }

    private void error(ValidationReport.Builder<TypeElement> builder, ExecutableElement method, String enclosedError, String inheritedError, Object ... extraArgs) {
        if (method.getEnclosingElement().equals(builder.getSubject())) {
            builder.addError(String.format(enclosedError, extraArgs), method);
        } else {
            Object[] newArgs = new Object[extraArgs.length + 1];
            newArgs[0] = method;
            System.arraycopy(extraArgs, 0, newArgs, 1, extraArgs.length);
            builder.addError(String.format(inheritedError, newArgs));
        }
    }
}

