/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.TypeNames;
import java.util.stream.Collector;
import java.util.stream.StreamSupport;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

final class CodeBlocks {
    static Collector<CodeBlock, ?, CodeBlock> joiningCodeBlocks(String delimiter) {
        return Collector.of(() -> new CodeBlockJoiner(delimiter, CodeBlock.builder()), CodeBlockJoiner::add, CodeBlockJoiner::merge, CodeBlockJoiner::join, new Collector.Characteristics[0]);
    }

    static Collector<CodeBlock, ?, CodeBlock> toParametersCodeBlock() {
        return CodeBlocks.joiningCodeBlocks(", ");
    }

    static Collector<TypeName, ?, CodeBlock> toTypeNamesCodeBlock() {
        return CodeBlocks.typeNamesIntoCodeBlock(CodeBlock.builder());
    }

    static Collector<TypeName, ?, CodeBlock> typeNamesIntoCodeBlock(CodeBlock.Builder builder) {
        return Collector.of(() -> new CodeBlockJoiner(", ", builder), CodeBlockJoiner::addTypeName, CodeBlockJoiner::merge, CodeBlockJoiner::join, new Collector.Characteristics[0]);
    }

    static Collector<CodeBlock, ?, CodeBlock> toConcatenatedCodeBlock() {
        return CodeBlocks.joiningCodeBlocks("\n");
    }

    static CodeBlock makeParametersCodeBlock(Iterable<CodeBlock> codeBlocks) {
        return StreamSupport.stream(codeBlocks.spliterator(), false).collect(CodeBlocks.toParametersCodeBlock());
    }

    static CodeBlock concat(Iterable<CodeBlock> codeBlocks) {
        return StreamSupport.stream(codeBlocks.spliterator(), false).collect(CodeBlocks.toConcatenatedCodeBlock());
    }

    static CodeBlock stringLiteral(String toWrap) {
        return CodeBlock.of("$S", toWrap);
    }

    static CodeBlock javadocLinkTo(ExecutableElement executableElement) {
        CodeBlock.Builder builder = CodeBlock.builder().add("{@link $T#", executableElement.getEnclosingElement());
        switch (executableElement.getKind()) {
            case METHOD: {
                builder.add("$L", executableElement.getSimpleName());
                break;
            }
            case CONSTRUCTOR: {
                builder.add("$L", executableElement.getEnclosingElement().getSimpleName());
                break;
            }
            case STATIC_INIT: 
            case INSTANCE_INIT: {
                throw new IllegalArgumentException("cannot create a javadoc link to an initializer: " + executableElement);
            }
            default: {
                throw new AssertionError((Object)executableElement.toString());
            }
        }
        builder.add("(", new Object[0]);
        executableElement.getParameters().stream().map(Element::asType).map(TypeName::get).map(TypeNames::rawTypeName).collect(CodeBlocks.typeNamesIntoCodeBlock(builder));
        return builder.add(")}", new Object[0]).build();
    }

    private CodeBlocks() {
    }

    private static final class CodeBlockJoiner {
        private final String delimiter;
        private final CodeBlock.Builder builder;
        private boolean first = true;

        CodeBlockJoiner(String delimiter, CodeBlock.Builder builder) {
            this.delimiter = delimiter;
            this.builder = builder;
        }

        @CanIgnoreReturnValue
        CodeBlockJoiner add(CodeBlock codeBlock) {
            this.maybeAddDelimiter();
            this.builder.add(codeBlock);
            return this;
        }

        @CanIgnoreReturnValue
        CodeBlockJoiner addTypeName(TypeName typeName) {
            this.maybeAddDelimiter();
            this.builder.add("$T", typeName);
            return this;
        }

        private void maybeAddDelimiter() {
            if (!this.first) {
                this.builder.add(this.delimiter, new Object[0]);
            }
            this.first = false;
        }

        @CanIgnoreReturnValue
        CodeBlockJoiner merge(CodeBlockJoiner other) {
            CodeBlock otherBlock = other.builder.build();
            if (!otherBlock.isEmpty()) {
                this.add(otherBlock);
            }
            return this;
        }

        CodeBlock join() {
            return this.builder.build();
        }
    }
}

