/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeTraverser;
import com.google.common.util.concurrent.ListenableFuture;
import com.squareup.javapoet.ClassName;
import dagger.BindsInstance;
import dagger.Component;
import dagger.Lazy;
import dagger.MembersInjector;
import dagger.Subcomponent;
import dagger.internal.codegen.AutoValue_ComponentDescriptor;
import dagger.internal.codegen.AutoValue_ComponentDescriptor_BuilderRequirementMethod;
import dagger.internal.codegen.AutoValue_ComponentDescriptor_BuilderSpec;
import dagger.internal.codegen.AutoValue_ComponentDescriptor_ComponentMethodDescriptor;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.ModuleDescriptor;
import dagger.internal.codegen.Scope;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.SubcomponentDeclaration;
import dagger.internal.codegen.Util;
import dagger.producers.ProductionComponent;
import dagger.producers.ProductionSubcomponent;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

abstract class ComponentDescriptor {
    private static final TreeTraverser<ComponentDescriptor> SUBCOMPONENT_TRAVERSER = new TreeTraverser<ComponentDescriptor>(){

        public Iterable<ComponentDescriptor> children(ComponentDescriptor node) {
            return node.subcomponents();
        }
    };

    ComponentDescriptor() {
    }

    abstract Kind kind();

    abstract AnnotationMirror componentAnnotation();

    abstract TypeElement componentDefinitionType();

    abstract ImmutableSet<TypeElement> dependencies();

    abstract ImmutableSet<ModuleDescriptor> modules();

    abstract ImmutableSet<ModuleDescriptor> transitiveModules();

    ImmutableSet<TypeElement> transitiveModuleTypes() {
        return FluentIterable.from(this.transitiveModules()).transform(ModuleDescriptor::moduleElement).toSet();
    }

    private static ImmutableSet<ModuleDescriptor> transitiveModules(Iterable<ModuleDescriptor> topLevelModules) {
        LinkedHashSet<ModuleDescriptor> transitiveModules = new LinkedHashSet<ModuleDescriptor>();
        for (ModuleDescriptor module : topLevelModules) {
            ComponentDescriptor.addTransitiveModules(transitiveModules, module);
        }
        return ImmutableSet.copyOf(transitiveModules);
    }

    private static void addTransitiveModules(Set<ModuleDescriptor> transitiveModules, ModuleDescriptor module) {
        if (transitiveModules.add(module)) {
            for (ModuleDescriptor includedModule : module.includedModules()) {
                ComponentDescriptor.addTransitiveModules(transitiveModules, includedModule);
            }
        }
    }

    abstract ImmutableMap<ExecutableElement, TypeElement> dependencyMethodIndex();

    abstract ImmutableSet<Scope> scopes();

    ImmutableSet<ComponentDescriptor> subcomponents() {
        return ImmutableSet.builder().addAll((Iterable)this.subcomponentsByFactoryMethod().values()).addAll((Iterable)this.subcomponentsByBuilderMethod().values()).addAll(this.subcomponentsFromModules()).build();
    }

    abstract ImmutableSet<ComponentDescriptor> subcomponentsFromModules();

    abstract ImmutableBiMap<ComponentMethodDescriptor, ComponentDescriptor> subcomponentsByFactoryMethod();

    abstract ImmutableBiMap<ComponentMethodDescriptor, ComponentDescriptor> subcomponentsByBuilderMethod();

    ImmutableSet<ComponentDescriptor> subcomponentsFromEntryPoints() {
        return ImmutableSet.builder().addAll((Iterable)this.subcomponentsByFactoryMethod().values()).addAll((Iterable)this.subcomponentsByBuilderMethod().values()).build();
    }

    ImmutableBiMap<TypeElement, ComponentDescriptor> subcomponentsByBuilderType() {
        ImmutableBiMap.Builder subcomponentsByBuilderType = ImmutableBiMap.builder();
        for (ComponentDescriptor subcomponent : this.subcomponents()) {
            if (!subcomponent.builderSpec().isPresent()) continue;
            subcomponentsByBuilderType.put((Object)subcomponent.builderSpec().get().builderDefinitionType(), (Object)subcomponent);
        }
        return subcomponentsByBuilderType.build();
    }

    abstract ImmutableSet<ComponentMethodDescriptor> componentMethods();

    ImmutableSet<DependencyRequest> entryPoints() {
        return this.componentMethods().stream().map(ComponentMethodDescriptor::dependencyRequest).filter(Optional::isPresent).map(Optional::get).collect(Util.toImmutableSet());
    }

    abstract Optional<BuilderSpec> builderSpec();

    ImmutableSet<Scope> releasableReferencesScopes() {
        return this.kind().equals((Object)Kind.COMPONENT) ? SUBCOMPONENT_TRAVERSER.breadthFirstTraversal((Object)this).transformAndConcat(ComponentDescriptor::scopes).filter(Scope::canReleaseReferences).toSet() : ImmutableSet.of();
    }

    static boolean isComponentContributionMethod(Elements elements, ExecutableElement method) {
        return method.getParameters().isEmpty() && !method.getReturnType().getKind().equals((Object)TypeKind.VOID) && !elements.getTypeElement(Object.class.getCanonicalName()).equals(method.getEnclosingElement());
    }

    static boolean isComponentProductionMethod(Elements elements, ExecutableElement method) {
        return ComponentDescriptor.isComponentContributionMethod(elements, method) && MoreTypes.isTypeOf(ListenableFuture.class, method.getReturnType());
    }

    static final class Factory {
        private final Elements elements;
        private final Types types;
        private final DependencyRequest.Factory dependencyRequestFactory;
        private final ModuleDescriptor.Factory moduleDescriptorFactory;

        Factory(Elements elements, Types types, DependencyRequest.Factory dependencyRequestFactory, ModuleDescriptor.Factory moduleDescriptorFactory) {
            this.elements = elements;
            this.types = types;
            this.dependencyRequestFactory = dependencyRequestFactory;
            this.moduleDescriptorFactory = moduleDescriptorFactory;
        }

        ComponentDescriptor forComponent(TypeElement componentDefinitionType) {
            Optional<Kind> kind = Kind.forAnnotatedElement(componentDefinitionType);
            Preconditions.checkArgument((kind.isPresent() && kind.get().isTopLevel() ? 1 : 0) != 0, (String)"%s must be annotated with @Component or @ProductionComponent", (Object)componentDefinitionType);
            return this.create(componentDefinitionType, kind.get(), Optional.empty());
        }

        private ComponentDescriptor create(TypeElement componentDefinitionType, Kind kind, Optional<Kind> parentKind) {
            DeclaredType declaredComponentType = MoreTypes.asDeclared(componentDefinitionType.asType());
            AnnotationMirror componentMirror = DaggerElements.getAnnotationMirror(componentDefinitionType, kind.annotationType()).get();
            ImmutableSet<TypeElement> componentDependencyTypes = kind.isTopLevel() ? MoreTypes.asTypeElements(ConfigurationAnnotations.getComponentDependencies(componentMirror)) : ImmutableSet.of();
            ImmutableMap.Builder dependencyMethodIndex = ImmutableMap.builder();
            for (TypeElement componentDependency : componentDependencyTypes) {
                List<ExecutableElement> dependencyMethods = ElementFilter.methodsIn(this.elements.getAllMembers(componentDependency));
                for (ExecutableElement dependencyMethod : dependencyMethods) {
                    if (!ComponentDescriptor.isComponentContributionMethod(this.elements, dependencyMethod)) continue;
                    dependencyMethodIndex.put((Object)dependencyMethod, (Object)componentDependency);
                }
            }
            ImmutableSet.Builder modulesBuilder = ImmutableSet.builder();
            for (TypeMirror componentModulesType : ConfigurationAnnotations.getComponentModules(componentMirror)) {
                modulesBuilder.add((Object)this.moduleDescriptorFactory.create(MoreTypes.asTypeElement(componentModulesType)));
            }
            if (kind.equals((Object)Kind.PRODUCTION_COMPONENT) || kind.equals((Object)Kind.PRODUCTION_SUBCOMPONENT) && parentKind.isPresent() && (parentKind.get().equals((Object)Kind.COMPONENT) || parentKind.get().equals((Object)Kind.SUBCOMPONENT))) {
                modulesBuilder.add((Object)this.descriptorForMonitoringModule(componentDefinitionType));
                modulesBuilder.add((Object)this.descriptorForProductionExecutorModule(componentDefinitionType));
            }
            ImmutableSet modules = modulesBuilder.build();
            ImmutableSet transitiveModules = ComponentDescriptor.transitiveModules((Iterable)modules);
            ImmutableSet.Builder subcomponentsFromModules = ImmutableSet.builder();
            for (ModuleDescriptor module : transitiveModules) {
                for (SubcomponentDeclaration subcomponentDeclaration : module.subcomponentDeclarations()) {
                    TypeElement subcomponent = subcomponentDeclaration.subcomponentType();
                    subcomponentsFromModules.add((Object)this.create(subcomponent, Kind.forAnnotatedElement(subcomponent).get(), Optional.of(kind)));
                }
            }
            ImmutableSet<ExecutableElement> unimplementedMethods = DaggerElements.getUnimplementedMethods(this.elements, this.types, componentDefinitionType);
            ImmutableSet.Builder componentMethodsBuilder = ImmutableSet.builder();
            ImmutableBiMap.Builder subcomponentsByFactoryMethod = ImmutableBiMap.builder();
            ImmutableBiMap.Builder subcomponentsByBuilderMethod = ImmutableBiMap.builder();
            for (ExecutableElement componentMethod : unimplementedMethods) {
                ExecutableType resolvedMethod = MoreTypes.asExecutable(this.types.asMemberOf(declaredComponentType, componentMethod));
                ComponentMethodDescriptor componentMethodDescriptor = this.getDescriptorForComponentMethod(componentDefinitionType, kind, componentMethod);
                componentMethodsBuilder.add((Object)componentMethodDescriptor);
                switch (componentMethodDescriptor.kind()) {
                    case SUBCOMPONENT: 
                    case PRODUCTION_SUBCOMPONENT: {
                        subcomponentsByFactoryMethod.put((Object)componentMethodDescriptor, (Object)this.create(MoreElements.asType(MoreTypes.asElement(resolvedMethod.getReturnType())), componentMethodDescriptor.kind().componentKind(), Optional.of(kind)));
                        break;
                    }
                    case SUBCOMPONENT_BUILDER: 
                    case PRODUCTION_SUBCOMPONENT_BUILDER: {
                        subcomponentsByBuilderMethod.put((Object)componentMethodDescriptor, (Object)this.create(MoreElements.asType(MoreTypes.asElement(resolvedMethod.getReturnType()).getEnclosingElement()), componentMethodDescriptor.kind().componentKind(), Optional.of(kind)));
                        break;
                    }
                }
            }
            ImmutableList<DeclaredType> enclosedBuilders = kind.builderAnnotationType() == null ? ImmutableList.of() : ConfigurationAnnotations.enclosedBuilders(componentDefinitionType, kind.builderAnnotationType());
            Optional<Object> builderType = Optional.ofNullable(Iterables.getOnlyElement(enclosedBuilders, null));
            Optional<BuilderSpec> builderSpec = this.createBuilderSpec(builderType);
            ImmutableSet scopes = Scope.scopesOf(componentDefinitionType);
            if (kind.isProducer()) {
                scopes = FluentIterable.from(scopes).append((Object[])new Scope[]{Scope.productionScope(this.elements)}).toSet();
            }
            return new AutoValue_ComponentDescriptor(kind, componentMirror, componentDefinitionType, componentDependencyTypes, (ImmutableSet<ModuleDescriptor>)modules, (ImmutableSet<ModuleDescriptor>)transitiveModules, (ImmutableMap<ExecutableElement, TypeElement>)dependencyMethodIndex.build(), (ImmutableSet<Scope>)scopes, (ImmutableSet<ComponentDescriptor>)subcomponentsFromModules.build(), (ImmutableBiMap<ComponentMethodDescriptor, ComponentDescriptor>)subcomponentsByFactoryMethod.build(), (ImmutableBiMap<ComponentMethodDescriptor, ComponentDescriptor>)subcomponentsByBuilderMethod.build(), (ImmutableSet<ComponentMethodDescriptor>)componentMethodsBuilder.build(), builderSpec);
        }

        private ComponentMethodDescriptor getDescriptorForComponentMethod(TypeElement componentElement, Kind componentKind, ExecutableElement componentMethod) {
            ExecutableType resolvedComponentMethod = MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(componentElement.asType()), componentMethod));
            TypeMirror returnType = resolvedComponentMethod.getReturnType();
            if (returnType.getKind().equals((Object)TypeKind.DECLARED)) {
                if (MoreTypes.isTypeOf(Provider.class, returnType) || MoreTypes.isTypeOf(Lazy.class, returnType)) {
                    return ComponentMethodDescriptor.forProvision(componentMethod, this.dependencyRequestFactory.forComponentProvisionMethod(componentMethod, resolvedComponentMethod));
                }
                if (MoreTypes.isTypeOf(MembersInjector.class, returnType)) {
                    return ComponentMethodDescriptor.forMembersInjection(componentMethod, this.dependencyRequestFactory.forComponentMembersInjectionMethod(componentMethod, resolvedComponentMethod));
                }
                if (!InjectionAnnotations.getQualifier(componentMethod).isPresent()) {
                    Element returnTypeElement = MoreTypes.asElement(returnType);
                    if (ConfigurationAnnotations.isSubcomponent(returnTypeElement)) {
                        return ComponentMethodDescriptor.forSubcomponent(MoreElements.isAnnotationPresent(returnTypeElement, Subcomponent.class) ? ComponentMethodKind.SUBCOMPONENT : ComponentMethodKind.PRODUCTION_SUBCOMPONENT, componentMethod);
                    }
                    if (ConfigurationAnnotations.isSubcomponentBuilder(returnTypeElement)) {
                        DependencyRequest dependencyRequest = this.dependencyRequestFactory.forComponentProvisionMethod(componentMethod, resolvedComponentMethod);
                        return ComponentMethodDescriptor.forSubcomponentBuilder(MoreElements.isAnnotationPresent(returnTypeElement, Subcomponent.Builder.class) ? ComponentMethodKind.SUBCOMPONENT_BUILDER : ComponentMethodKind.PRODUCTION_SUBCOMPONENT_BUILDER, dependencyRequest, componentMethod);
                    }
                }
            }
            if (componentMethod.getParameters().isEmpty() && !componentMethod.getReturnType().getKind().equals((Object)TypeKind.VOID)) {
                switch (componentKind) {
                    case COMPONENT: 
                    case SUBCOMPONENT: {
                        return ComponentMethodDescriptor.forProvision(componentMethod, this.dependencyRequestFactory.forComponentProvisionMethod(componentMethod, resolvedComponentMethod));
                    }
                    case PRODUCTION_COMPONENT: 
                    case PRODUCTION_SUBCOMPONENT: {
                        return ComponentMethodDescriptor.forProvision(componentMethod, this.dependencyRequestFactory.forComponentProductionMethod(componentMethod, resolvedComponentMethod));
                    }
                }
                throw new AssertionError();
            }
            List<? extends TypeMirror> parameterTypes = resolvedComponentMethod.getParameterTypes();
            if (parameterTypes.size() == 1 && (returnType.getKind().equals((Object)TypeKind.VOID) || MoreTypes.equivalence().equivalent((Object)returnType, (Object)parameterTypes.get(0)))) {
                return ComponentMethodDescriptor.forMembersInjection(componentMethod, this.dependencyRequestFactory.forComponentMembersInjectionMethod(componentMethod, resolvedComponentMethod));
            }
            throw new IllegalArgumentException("not a valid component method: " + componentMethod);
        }

        private Optional<BuilderSpec> createBuilderSpec(Optional<DeclaredType> builderType) {
            if (!builderType.isPresent()) {
                return Optional.empty();
            }
            TypeElement element = MoreTypes.asTypeElement(builderType.get());
            ImmutableSet<ExecutableElement> methods = DaggerElements.getUnimplementedMethods(this.elements, this.types, element);
            ImmutableSet.Builder requirementMethods = ImmutableSet.builder();
            ExecutableElement buildMethod = null;
            for (ExecutableElement method : methods) {
                if (method.getParameters().isEmpty()) {
                    buildMethod = method;
                    continue;
                }
                ExecutableType resolved = MoreTypes.asExecutable(this.types.asMemberOf(builderType.get(), method));
                requirementMethods.add((Object)new AutoValue_ComponentDescriptor_BuilderRequirementMethod(method, this.requirementForBuilderMethod(method, resolved)));
            }
            Verify.verify((buildMethod != null ? 1 : 0) != 0);
            return Optional.of(new AutoValue_ComponentDescriptor_BuilderSpec(element, (ImmutableSet<BuilderRequirementMethod>)requirementMethods.build(), buildMethod, element.getEnclosingElement().asType()));
        }

        private ComponentRequirement requirementForBuilderMethod(ExecutableElement method, ExecutableType resolvedType) {
            Preconditions.checkArgument((method.getParameters().size() == 1 ? 1 : 0) != 0);
            if (MoreElements.isAnnotationPresent(method, BindsInstance.class)) {
                DependencyRequest request = this.dependencyRequestFactory.forRequiredResolvedVariable((VariableElement)Iterables.getOnlyElement(method.getParameters()), (TypeMirror)Iterables.getOnlyElement(resolvedType.getParameterTypes()));
                return ComponentRequirement.forBinding(request.key(), request.isNullable(), method.getSimpleName().toString());
            }
            TypeMirror type = (TypeMirror)Iterables.getOnlyElement(resolvedType.getParameterTypes());
            return ConfigurationAnnotations.getModuleAnnotation(MoreTypes.asTypeElement(type)).isPresent() ? ComponentRequirement.forModule(type) : ComponentRequirement.forDependency(type);
        }

        private ModuleDescriptor descriptorForMonitoringModule(TypeElement componentDefinitionType) {
            ClassName monitoringModuleName = SourceFiles.generatedMonitoringModuleName(componentDefinitionType);
            String generatedMonitorModuleName = monitoringModuleName.toString();
            TypeElement monitoringModule = this.elements.getTypeElement(generatedMonitorModuleName);
            if (monitoringModule == null) {
                throw new TypeNotPresentException(generatedMonitorModuleName, null);
            }
            return this.moduleDescriptorFactory.create(monitoringModule);
        }

        private ModuleDescriptor descriptorForProductionExecutorModule(TypeElement componentDefinitionType) {
            ClassName productionExecutorModuleName = SourceFiles.generatedProductionExecutorModuleName(componentDefinitionType);
            String generatedProductionExecutorModuleName = productionExecutorModuleName.toString();
            TypeElement productionExecutorModule = this.elements.getTypeElement(generatedProductionExecutorModuleName);
            if (productionExecutorModule == null) {
                throw new TypeNotPresentException(generatedProductionExecutorModuleName, null);
            }
            return this.moduleDescriptorFactory.create(productionExecutorModule);
        }
    }

    static abstract class BuilderSpec {
        BuilderSpec() {
        }

        abstract TypeElement builderDefinitionType();

        abstract ImmutableSet<BuilderRequirementMethod> requirementMethods();

        abstract ExecutableElement buildMethod();

        abstract TypeMirror componentType();
    }

    static abstract class BuilderRequirementMethod {
        BuilderRequirementMethod() {
        }

        abstract ExecutableElement method();

        abstract ComponentRequirement requirement();
    }

    static enum ComponentMethodKind {
        PROVISION,
        PRODUCTION,
        MEMBERS_INJECTION,
        SUBCOMPONENT,
        SUBCOMPONENT_BUILDER,
        PRODUCTION_SUBCOMPONENT,
        PRODUCTION_SUBCOMPONENT_BUILDER;


        boolean isSubcomponentKind() {
            return this == SUBCOMPONENT || this == PRODUCTION_SUBCOMPONENT;
        }

        Kind componentKind() {
            switch (this) {
                case SUBCOMPONENT: 
                case SUBCOMPONENT_BUILDER: {
                    return Kind.SUBCOMPONENT;
                }
                case PRODUCTION_SUBCOMPONENT: 
                case PRODUCTION_SUBCOMPONENT_BUILDER: {
                    return Kind.PRODUCTION_SUBCOMPONENT;
                }
            }
            throw new IllegalStateException("no component associated with method " + (Object)((Object)this));
        }
    }

    static abstract class ComponentMethodDescriptor {
        ComponentMethodDescriptor() {
        }

        abstract ComponentMethodKind kind();

        abstract Optional<DependencyRequest> dependencyRequest();

        abstract ExecutableElement methodElement();

        static ComponentMethodDescriptor create(ComponentMethodKind kind, Optional<DependencyRequest> dependencyRequest, ExecutableElement methodElement) {
            return new AutoValue_ComponentDescriptor_ComponentMethodDescriptor(kind, dependencyRequest, methodElement);
        }

        static ComponentMethodDescriptor forProvision(ExecutableElement methodElement, DependencyRequest dependencyRequest) {
            return ComponentMethodDescriptor.create(ComponentMethodKind.PROVISION, Optional.of(dependencyRequest), methodElement);
        }

        static ComponentMethodDescriptor forMembersInjection(ExecutableElement methodElement, DependencyRequest dependencyRequest) {
            return ComponentMethodDescriptor.create(ComponentMethodKind.MEMBERS_INJECTION, Optional.of(dependencyRequest), methodElement);
        }

        static ComponentMethodDescriptor forSubcomponent(ComponentMethodKind kind, ExecutableElement methodElement) {
            return ComponentMethodDescriptor.create(kind, Optional.empty(), methodElement);
        }

        static ComponentMethodDescriptor forSubcomponentBuilder(ComponentMethodKind kind, DependencyRequest dependencyRequestForBuilder, ExecutableElement methodElement) {
            return ComponentMethodDescriptor.create(kind, Optional.of(dependencyRequestForBuilder), methodElement);
        }
    }

    static enum Kind {
        COMPONENT(Component.class, Component.Builder.class, true),
        SUBCOMPONENT(Subcomponent.class, Subcomponent.Builder.class, false),
        PRODUCTION_COMPONENT(ProductionComponent.class, ProductionComponent.Builder.class, true),
        PRODUCTION_SUBCOMPONENT(ProductionSubcomponent.class, ProductionSubcomponent.Builder.class, false);

        private final Class<? extends Annotation> annotationType;
        private final Class<? extends Annotation> builderType;
        private final boolean isTopLevel;

        static Optional<Kind> forAnnotatedElement(TypeElement element) {
            EnumSet<Kind> kinds = EnumSet.noneOf(Kind.class);
            for (Kind kind : Kind.values()) {
                if (!MoreElements.isAnnotationPresent(element, kind.annotationType())) continue;
                kinds.add(kind);
            }
            Preconditions.checkArgument((kinds.size() <= 1 ? 1 : 0) != 0, (String)"%s cannot be annotated with more than one of %s", (Object)element, kinds);
            return Optional.ofNullable(Iterables.getOnlyElement(kinds, null));
        }

        static Optional<Kind> forAnnotatedBuilderElement(TypeElement element) {
            EnumSet<Kind> kinds = EnumSet.noneOf(Kind.class);
            for (Kind kind : Kind.values()) {
                if (!MoreElements.isAnnotationPresent(element, kind.builderAnnotationType())) continue;
                kinds.add(kind);
            }
            Preconditions.checkArgument((kinds.size() <= 1 ? 1 : 0) != 0, (String)"%s cannot be annotated with more than one of %s", (Object)element, kinds);
            return Optional.ofNullable(Iterables.getOnlyElement(kinds, null));
        }

        private Kind(Class<? extends Annotation> annotationType, Class<? extends Annotation> builderType, boolean isTopLevel) {
            this.annotationType = annotationType;
            this.builderType = builderType;
            this.isTopLevel = isTopLevel;
        }

        Class<? extends Annotation> annotationType() {
            return this.annotationType;
        }

        Class<? extends Annotation> builderAnnotationType() {
            return this.builderType;
        }

        ImmutableSet<ModuleDescriptor.Kind> moduleKinds() {
            switch (this) {
                case COMPONENT: 
                case SUBCOMPONENT: {
                    return Sets.immutableEnumSet((Enum)ModuleDescriptor.Kind.MODULE, (Enum[])new ModuleDescriptor.Kind[0]);
                }
                case PRODUCTION_COMPONENT: 
                case PRODUCTION_SUBCOMPONENT: {
                    return Sets.immutableEnumSet((Enum)ModuleDescriptor.Kind.MODULE, (Enum[])new ModuleDescriptor.Kind[]{ModuleDescriptor.Kind.PRODUCER_MODULE});
                }
            }
            throw new AssertionError((Object)this);
        }

        ImmutableSet<Kind> subcomponentKinds() {
            switch (this) {
                case COMPONENT: 
                case SUBCOMPONENT: {
                    return ImmutableSet.of((Object)((Object)SUBCOMPONENT), (Object)((Object)PRODUCTION_SUBCOMPONENT));
                }
                case PRODUCTION_COMPONENT: 
                case PRODUCTION_SUBCOMPONENT: {
                    return ImmutableSet.of((Object)((Object)PRODUCTION_SUBCOMPONENT));
                }
            }
            throw new AssertionError();
        }

        boolean isTopLevel() {
            return this.isTopLevel;
        }

        boolean isProducer() {
            switch (this) {
                case COMPONENT: 
                case SUBCOMPONENT: {
                    return false;
                }
                case PRODUCTION_COMPONENT: 
                case PRODUCTION_SUBCOMPONENT: {
                    return true;
                }
            }
            throw new AssertionError();
        }
    }
}

