/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import dagger.internal.codegen.AutoValue_ComponentRequirement;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.Util;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Optional;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

abstract class ComponentRequirement {
    ComponentRequirement() {
    }

    abstract Kind kind();

    abstract Equivalence.Wrapper<TypeMirror> wrappedType();

    TypeMirror type() {
        return (TypeMirror)this.wrappedType().get();
    }

    TypeElement typeElement() {
        return MoreTypes.asTypeElement(this.type());
    }

    abstract Optional<NullPolicy> overrideNullPolicy();

    NullPolicy nullPolicy(Elements elements, Types types) {
        if (this.overrideNullPolicy().isPresent()) {
            return this.overrideNullPolicy().get();
        }
        switch (this.kind()) {
            case DEPENDENCY: {
                return NullPolicy.THROW;
            }
            case MODULE: {
                return Util.componentCanMakeNewInstances(this.typeElement()) ? NullPolicy.NEW : (Util.requiresAPassedInstance(elements, types, this.typeElement()) ? NullPolicy.THROW : NullPolicy.ALLOW);
            }
            case BINDING: {
                return NullPolicy.THROW;
            }
        }
        throw new AssertionError();
    }

    abstract Optional<Key> key();

    abstract String variableName();

    static ComponentRequirement forDependency(TypeMirror type) {
        return new AutoValue_ComponentRequirement(Kind.DEPENDENCY, (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap(Preconditions.checkNotNull((Object)type)), Optional.empty(), Optional.empty(), SourceFiles.simpleVariableName(MoreTypes.asTypeElement(type)));
    }

    static ComponentRequirement forModule(TypeMirror type) {
        return new AutoValue_ComponentRequirement(Kind.MODULE, (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap(Preconditions.checkNotNull((Object)type)), Optional.empty(), Optional.empty(), SourceFiles.simpleVariableName(MoreTypes.asTypeElement(type)));
    }

    static ComponentRequirement forBinding(Key key, boolean nullable, String variableName) {
        return new AutoValue_ComponentRequirement(Kind.BINDING, key.wrappedType(), nullable ? Optional.of(NullPolicy.ALLOW) : Optional.empty(), Optional.of(key), variableName);
    }

    static ComponentRequirement forBinding(ContributionBinding binding) {
        Preconditions.checkArgument((boolean)binding.bindingKind().equals((Object)ContributionBinding.Kind.BUILDER_BINDING));
        return ComponentRequirement.forBinding(binding.key(), binding.nullableType().isPresent(), binding.bindingElement().get().getSimpleName().toString());
    }

    static enum NullPolicy {
        NEW,
        THROW,
        ALLOW;

    }

    static enum Kind {
        DEPENDENCY,
        MODULE,
        BINDING;

    }
}

