/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.TypeName;
import dagger.Lazy;
import dagger.MembersInjector;
import dagger.internal.codegen.AutoValue_DependencyRequest;
import dagger.internal.codegen.AutoValue_DependencyRequest_KindAndType;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.OptionalType;
import dagger.internal.codegen.Optionals;
import dagger.internal.codegen.TypeNames;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.shaded.auto.common.MoreTypes;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor7;

abstract class DependencyRequest {
    DependencyRequest() {
    }

    abstract Kind kind();

    abstract Key key();

    BindingKey bindingKey() {
        switch (this.kind()) {
            case INSTANCE: 
            case PROVIDER: 
            case LAZY: 
            case PROVIDER_OF_LAZY: 
            case PRODUCER: 
            case PRODUCED: 
            case FUTURE: {
                return BindingKey.contribution(this.key());
            }
            case MEMBERS_INJECTOR: {
                return BindingKey.membersInjection(this.key());
            }
        }
        throw new AssertionError(this);
    }

    abstract Optional<Element> requestElement();

    abstract boolean isNullable();

    abstract Optional<String> overriddenVariableName();

    private static Builder builder() {
        return new AutoValue_DependencyRequest.Builder().isNullable(false);
    }

    static KindAndType extractKindAndType(TypeMirror type) {
        return type.accept(new SimpleTypeVisitor7<KindAndType, Void>(){

            @Override
            public KindAndType visitError(ErrorType errorType, Void p) {
                throw new TypeNotPresentException(errorType.toString(), null);
            }

            @Override
            public KindAndType visitExecutable(ExecutableType executableType, Void p) {
                return executableType.getReturnType().accept(this, null);
            }

            @Override
            public KindAndType visitDeclared(DeclaredType declaredType, Void p) {
                return KindAndType.from(declaredType).orElse(this.defaultAction((TypeMirror)declaredType, p));
            }

            @Override
            protected KindAndType defaultAction(TypeMirror otherType, Void p) {
                return Kind.INSTANCE.ofType(otherType);
            }
        }, null);
    }

    static final class Factory {
        private final Key.Factory keyFactory;

        Factory(Key.Factory keyFactory) {
            this.keyFactory = keyFactory;
        }

        ImmutableSet<DependencyRequest> forRequiredResolvedVariables(List<? extends VariableElement> variables, List<? extends TypeMirror> resolvedTypes) {
            Preconditions.checkState((resolvedTypes.size() == variables.size() ? 1 : 0) != 0);
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (int i = 0; i < variables.size(); ++i) {
                builder.add((Object)this.forRequiredResolvedVariable(variables.get(i), resolvedTypes.get(i)));
            }
            return builder.build();
        }

        DependencyRequest providerForImplicitMapBinding(Key mapOfFactoryKey) {
            return DependencyRequest.builder().kind(Kind.PROVIDER).key(mapOfFactoryKey).build();
        }

        DependencyRequest producerForImplicitMapBinding(Key mapOfFactoryKey) {
            return DependencyRequest.builder().kind(Kind.PRODUCER).key(mapOfFactoryKey).build();
        }

        private DependencyRequest forMultibindingContribution(ContributionBinding multibindingContribution) {
            Preconditions.checkArgument((boolean)multibindingContribution.key().multibindingContributionIdentifier().isPresent(), (String)"multibindingContribution's key must have a multibinding contribution identifier: %s", (Object)multibindingContribution);
            return DependencyRequest.builder().kind(this.multibindingContributionRequestKind(multibindingContribution)).key(multibindingContribution.key()).build();
        }

        private Kind multibindingContributionRequestKind(ContributionBinding multibindingContribution) {
            switch (multibindingContribution.contributionType()) {
                case MAP: {
                    return multibindingContribution.bindingType().equals((Object)BindingType.PRODUCTION) ? Kind.PRODUCER : Kind.PROVIDER;
                }
                case SET: 
                case SET_VALUES: {
                    return Kind.INSTANCE;
                }
                case UNIQUE: {
                    throw new IllegalArgumentException("multibindingContribution must be a multibinding: " + multibindingContribution);
                }
            }
            throw new AssertionError((Object)multibindingContribution.toString());
        }

        ImmutableSet<DependencyRequest> forMultibindingContributions(Iterable<ContributionBinding> multibindingContributions) {
            ImmutableSet.Builder requests = ImmutableSet.builder();
            for (ContributionBinding multibindingContribution : multibindingContributions) {
                requests.add((Object)this.forMultibindingContribution(multibindingContribution));
            }
            return requests.build();
        }

        DependencyRequest forRequiredVariable(VariableElement variableElement) {
            return this.forRequiredVariable(variableElement, Optional.empty());
        }

        DependencyRequest forRequiredVariable(VariableElement variableElement, Optional<String> name) {
            Preconditions.checkNotNull((Object)variableElement);
            TypeMirror type = variableElement.asType();
            Optional<AnnotationMirror> qualifier = InjectionAnnotations.getQualifier(variableElement);
            return this.newDependencyRequest(variableElement, type, qualifier, name);
        }

        DependencyRequest forRequiredResolvedVariable(VariableElement variableElement, TypeMirror resolvedType) {
            Preconditions.checkNotNull((Object)variableElement);
            Preconditions.checkNotNull((Object)resolvedType);
            Optional<AnnotationMirror> qualifier = InjectionAnnotations.getQualifier(variableElement);
            return this.newDependencyRequest(variableElement, resolvedType, qualifier, Optional.empty());
        }

        DependencyRequest forComponentProvisionMethod(ExecutableElement provisionMethod, ExecutableType provisionMethodType) {
            Preconditions.checkNotNull((Object)provisionMethod);
            Preconditions.checkNotNull((Object)provisionMethodType);
            Preconditions.checkArgument((boolean)provisionMethod.getParameters().isEmpty(), (String)"Component provision methods must be empty: %s", (Object)provisionMethod);
            Optional<AnnotationMirror> qualifier = InjectionAnnotations.getQualifier(provisionMethod);
            return this.newDependencyRequest(provisionMethod, provisionMethodType.getReturnType(), qualifier, Optional.empty());
        }

        DependencyRequest forComponentProductionMethod(ExecutableElement productionMethod, ExecutableType productionMethodType) {
            Preconditions.checkNotNull((Object)productionMethod);
            Preconditions.checkNotNull((Object)productionMethodType);
            Preconditions.checkArgument((boolean)productionMethod.getParameters().isEmpty(), (String)"Component production methods must be empty: %s", (Object)productionMethod);
            TypeMirror type = productionMethodType.getReturnType();
            Optional<AnnotationMirror> qualifier = InjectionAnnotations.getQualifier(productionMethod);
            if (MoreTypes.isTypeOf(ListenableFuture.class, type)) {
                return DependencyRequest.builder().kind(Kind.FUTURE).key(this.keyFactory.forQualifiedType(qualifier, (TypeMirror)Iterables.getOnlyElement(((DeclaredType)type).getTypeArguments()))).requestElement(productionMethod).build();
            }
            return this.newDependencyRequest(productionMethod, type, qualifier, Optional.empty());
        }

        DependencyRequest forComponentMembersInjectionMethod(ExecutableElement membersInjectionMethod, ExecutableType membersInjectionMethodType) {
            Preconditions.checkNotNull((Object)membersInjectionMethod);
            Preconditions.checkNotNull((Object)membersInjectionMethodType);
            Optional<AnnotationMirror> qualifier = InjectionAnnotations.getQualifier(membersInjectionMethod);
            Preconditions.checkArgument((!qualifier.isPresent() ? 1 : 0) != 0);
            TypeMirror returnType = membersInjectionMethodType.getReturnType();
            TypeMirror membersInjectedType = MoreTypes.isType(returnType) && MoreTypes.isTypeOf(MembersInjector.class, returnType) ? (TypeMirror)Iterables.getOnlyElement(MoreTypes.asDeclared(returnType).getTypeArguments()) : (TypeMirror)Iterables.getOnlyElement(membersInjectionMethodType.getParameterTypes());
            return DependencyRequest.builder().kind(Kind.MEMBERS_INJECTOR).key(this.keyFactory.forMembersInjectedType(membersInjectedType)).requestElement(membersInjectionMethod).build();
        }

        DependencyRequest forMembersInjectedType(DeclaredType type) {
            return DependencyRequest.builder().kind(Kind.MEMBERS_INJECTOR).key(this.keyFactory.forMembersInjectedType(type)).requestElement(type.asElement()).build();
        }

        DependencyRequest forProductionImplementationExecutor() {
            Key key = this.keyFactory.forProductionImplementationExecutor();
            return DependencyRequest.builder().kind(Kind.PROVIDER).key(key).requestElement(MoreTypes.asElement(key.type())).build();
        }

        DependencyRequest forProductionComponentMonitor() {
            Key key = this.keyFactory.forProductionComponentMonitor();
            return DependencyRequest.builder().kind(Kind.PROVIDER).key(key).requestElement(MoreTypes.asElement(key.type())).overriddenVariableName(Optional.of("monitor")).build();
        }

        DependencyRequest forSyntheticPresentOptionalBinding(Key requestKey, Kind kind) {
            Optional<Key> key = this.keyFactory.unwrapOptional(requestKey);
            Preconditions.checkArgument((boolean)key.isPresent(), (String)"not a request for optional: %s", (Object)requestKey);
            return DependencyRequest.builder().kind(kind).key(key.get()).isNullable(this.allowsNull(DependencyRequest.extractKindAndType(OptionalType.from(requestKey).valueType()).kind(), Optional.empty())).build();
        }

        private DependencyRequest newDependencyRequest(Element requestElement, TypeMirror type, Optional<AnnotationMirror> qualifier, Optional<String> name) {
            KindAndType kindAndType = DependencyRequest.extractKindAndType(type);
            if (kindAndType.kind().equals((Object)Kind.MEMBERS_INJECTOR)) {
                Preconditions.checkArgument((!qualifier.isPresent() ? 1 : 0) != 0);
            }
            return DependencyRequest.builder().kind(kindAndType.kind()).key(this.keyFactory.forQualifiedType(qualifier, kindAndType.type())).requestElement(requestElement).isNullable(this.allowsNull(kindAndType.kind(), ConfigurationAnnotations.getNullableType(requestElement))).overriddenVariableName(name).build();
        }

        private boolean allowsNull(Kind kind, Optional<DeclaredType> nullableType) {
            return kind.equals((Object)Kind.INSTANCE) ? nullableType.isPresent() : true;
        }
    }

    @CanIgnoreReturnValue
    static abstract class Builder {
        Builder() {
        }

        abstract Builder kind(Kind var1);

        abstract Builder key(Key var1);

        abstract Builder requestElement(Element var1);

        abstract Builder isNullable(boolean var1);

        abstract Builder overriddenVariableName(Optional<String> var1);

        @CheckReturnValue
        abstract DependencyRequest build();
    }

    static abstract class KindAndType {
        KindAndType() {
        }

        abstract Kind kind();

        abstract TypeMirror type();

        static Optional<KindAndType> from(TypeMirror type) {
            for (Kind kind : Kind.values()) {
                Optional<KindAndType> kindAndType = kind.from(type);
                if (!kindAndType.isPresent()) continue;
                return Optionals.firstPresent(kindAndType.get().maybeProviderOfLazy(), kindAndType, new Optional[0]);
            }
            return Optional.empty();
        }

        private Optional<KindAndType> maybeProviderOfLazy() {
            Optional<KindAndType> providedKindAndType;
            if (this.kind().equals((Object)Kind.PROVIDER) && (providedKindAndType = KindAndType.from(this.type())).isPresent() && providedKindAndType.get().kind().equals((Object)Kind.LAZY)) {
                return Optional.of(Kind.PROVIDER_OF_LAZY.ofType(providedKindAndType.get().type()));
            }
            return Optional.empty();
        }
    }

    static enum Kind {
        INSTANCE,
        PROVIDER(Provider.class),
        LAZY(Lazy.class),
        PROVIDER_OF_LAZY,
        MEMBERS_INJECTOR(MembersInjector.class),
        PRODUCER(Producer.class),
        PRODUCED(Produced.class),
        FUTURE;

        final Optional<Class<?>> frameworkClass;

        private Kind(Class<?> frameworkClass) {
            this.frameworkClass = Optional.of(frameworkClass);
        }

        private Kind() {
            this.frameworkClass = Optional.empty();
        }

        Optional<KindAndType> from(TypeMirror type) {
            if (this.frameworkClass.isPresent() && MoreTypes.isType(type) && MoreTypes.isTypeOf(this.frameworkClass.get(), type)) {
                List<? extends TypeMirror> typeArguments = MoreTypes.asDeclared(type).getTypeArguments();
                if (typeArguments.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(this.ofType((TypeMirror)Iterables.getOnlyElement(typeArguments)));
            }
            return Optional.empty();
        }

        KindAndType ofType(TypeMirror type) {
            return new AutoValue_DependencyRequest_KindAndType(this, type);
        }

        TypeName typeName(TypeName keyType) {
            switch (this) {
                case INSTANCE: {
                    return keyType;
                }
                case PROVIDER: {
                    return TypeNames.providerOf(keyType);
                }
                case LAZY: {
                    return TypeNames.lazyOf(keyType);
                }
                case PROVIDER_OF_LAZY: {
                    return TypeNames.providerOf(TypeNames.lazyOf(keyType));
                }
                case PRODUCER: {
                    return TypeNames.producerOf(keyType);
                }
                case PRODUCED: {
                    return TypeNames.producedOf(keyType);
                }
                case FUTURE: {
                    return TypeNames.listenableFutureOf(keyType);
                }
            }
            throw new AssertionError((Object)this);
        }
    }
}

