/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.AutoValue_FrameworkField;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.BindingVariableNamer;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.SetType;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor6;

abstract class FrameworkField {
    private static final ElementVisitor<String, Binding> BINDING_ELEMENT_NAME = new ElementKindVisitor6<String, Binding>(){

        @Override
        protected String defaultAction(Element e, Binding p) {
            throw new IllegalArgumentException("Unexpected binding " + p);
        }

        @Override
        public String visitExecutableAsConstructor(ExecutableElement e, Binding p) {
            return (String)this.visit(e.getEnclosingElement(), p);
        }

        @Override
        public String visitExecutableAsMethod(ExecutableElement e, Binding p) {
            return e.getSimpleName().toString();
        }

        @Override
        public String visitType(TypeElement e, Binding p) {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, e.getSimpleName().toString());
        }
    };

    FrameworkField() {
    }

    static FrameworkField create(ClassName frameworkClassName, TypeName valueTypeName, String fieldName) {
        String suffix = frameworkClassName.simpleName();
        return new AutoValue_FrameworkField(ParameterizedTypeName.get(frameworkClassName, valueTypeName), fieldName.endsWith(suffix) ? fieldName : fieldName + suffix);
    }

    static FrameworkField forResolvedBindings(ResolvedBindings resolvedBindings, Optional<ClassName> frameworkClass) {
        return FrameworkField.create(frameworkClass.orElse(ClassName.get(resolvedBindings.frameworkClass())), TypeName.get(FrameworkField.fieldValueType(resolvedBindings)), FrameworkField.frameworkFieldName(resolvedBindings));
    }

    private static TypeMirror fieldValueType(ResolvedBindings resolvedBindings) {
        if (resolvedBindings.isMultibindingContribution()) {
            switch (resolvedBindings.contributionType()) {
                case MAP: {
                    return MapType.from(resolvedBindings.key()).unwrappedValueType(resolvedBindings.frameworkClass());
                }
                case SET: {
                    return SetType.from(resolvedBindings.key()).elementType();
                }
            }
        }
        return resolvedBindings.key().type();
    }

    private static String frameworkFieldName(ResolvedBindings resolvedBindings) {
        ContributionBinding binding;
        if (resolvedBindings.bindingKey().kind().equals((Object)BindingKey.Kind.CONTRIBUTION) && (binding = resolvedBindings.contributionBinding()).bindingElement().isPresent()) {
            return BINDING_ELEMENT_NAME.visit(binding.bindingElement().get(), binding);
        }
        return BindingVariableNamer.name(resolvedBindings.binding());
    }

    abstract ParameterizedTypeName type();

    abstract String name();
}

