/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableListMultimap;
import dagger.Module;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.KeyFormatter;
import dagger.internal.codegen.MethodSignatureFormatter;
import dagger.internal.codegen.MultibindingsMethodValidator;
import dagger.internal.codegen.ValidationReport;
import dagger.producers.ProducerModule;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class MultibindingsValidator {
    private final Elements elements;
    private final Types types;
    private final Key.Factory keyFactory;
    private final KeyFormatter keyFormatter;
    private final MethodSignatureFormatter methodSignatureFormatter;
    private final TypeElement objectElement;
    private final MultibindingsMethodValidator multibindingsMethodValidator;
    private final Map<TypeElement, ValidationReport<TypeElement>> reports = new HashMap<TypeElement, ValidationReport<TypeElement>>();

    MultibindingsValidator(Elements elements, Types types, Key.Factory keyFactory, KeyFormatter keyFormatter, MethodSignatureFormatter methodSignatureFormatter, MultibindingsMethodValidator multibindingsMethodValidator) {
        this.elements = elements;
        this.types = types;
        this.keyFactory = keyFactory;
        this.keyFormatter = keyFormatter;
        this.methodSignatureFormatter = methodSignatureFormatter;
        this.multibindingsMethodValidator = multibindingsMethodValidator;
        this.objectElement = elements.getTypeElement(Object.class.getCanonicalName());
    }

    public ValidationReport<TypeElement> validate(TypeElement multibindingsType) {
        return this.reports.computeIfAbsent(multibindingsType, this::validateUncached);
    }

    boolean wasAlreadyValidated(TypeElement multibindingsType) {
        return this.reports.containsKey(multibindingsType);
    }

    private ValidationReport<TypeElement> validateUncached(TypeElement multibindingsType) {
        Optional<BindingType> bindingType;
        ValidationReport.Builder<TypeElement> validation = ValidationReport.about(multibindingsType);
        if (!multibindingsType.getKind().equals((Object)ElementKind.INTERFACE)) {
            validation.addError("@Multibindings can be applied only to interfaces", multibindingsType);
        }
        if (!multibindingsType.getTypeParameters().isEmpty()) {
            validation.addError("@Multibindings types must not have type parameters", multibindingsType);
        }
        if (!(bindingType = MultibindingsValidator.bindingType(multibindingsType)).isPresent()) {
            validation.addError("@Multibindings types must be nested within a @Module or @ProducerModule", multibindingsType);
        }
        ImmutableListMultimap.Builder methodsByKey = ImmutableListMultimap.builder();
        for (ExecutableElement method : MoreElements.getLocalAndInheritedMethods(multibindingsType, this.types, this.elements)) {
            if (method.getEnclosingElement().equals(this.objectElement)) continue;
            ValidationReport<ExecutableElement> methodReport = this.multibindingsMethodValidator.validate(method);
            validation.addItems((Iterable<ValidationReport.Item>)methodReport.items());
            if (!methodReport.isClean() || !bindingType.isPresent()) continue;
            methodsByKey.put((Object)this.keyFactory.forMultibindsMethod(bindingType.get(), MoreTypes.asExecutable(method.asType()), method), (Object)method);
        }
        for (Map.Entry entry : methodsByKey.build().asMap().entrySet()) {
            Collection methods = (Collection)entry.getValue();
            if (methods.size() <= 1) continue;
            Key key = (Key)entry.getKey();
            validation.addError(this.tooManyMultibindingsMethodsForKey(key, methods), multibindingsType);
        }
        return validation.build();
    }

    private String tooManyMultibindingsMethodsForKey(Key key, Collection<ExecutableElement> methods) {
        StringBuilder builder = new StringBuilder(ErrorMessages.MultibindingsMessages.tooManyMethodsForKey(this.keyFormatter.format(key)));
        builder.append(':');
        this.methodSignatureFormatter.formatIndentedList(builder, methods, 1, 10);
        return builder.toString();
    }

    private static Optional<BindingType> bindingType(TypeElement multibindingsType) {
        if (MoreElements.isAnnotationPresent(multibindingsType.getEnclosingElement(), Module.class)) {
            return Optional.of(BindingType.PROVISION);
        }
        if (MoreElements.isAnnotationPresent(multibindingsType.getEnclosingElement(), ProducerModule.class)) {
            return Optional.of(BindingType.PRODUCTION);
        }
        return Optional.empty();
    }
}

