/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.Optional;

final class Optionals {
    static <C extends Comparable<C>> Comparator<Optional<C>> optionalComparator() {
        return Comparator.comparing(optional -> optional.isPresent()).thenComparing(Optional::get);
    }

    @SafeVarargs
    static <T> Optional<T> firstPresent(Optional<T> first, Optional<T> second, Optional<T> ... rest) {
        return Lists.asList(first, second, (Object[])rest).stream().filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    private Optionals() {
    }
}

