/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.AnnotationSpecs;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.FrameworkDependency;
import dagger.internal.codegen.FrameworkField;
import dagger.internal.codegen.ProductionBinding;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.TypeNames;
import dagger.internal.codegen.UniqueNameSet;
import dagger.producers.Producer;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

final class ProducerFactoryGenerator
extends SourceFileGenerator<ProductionBinding> {
    private final CompilerOptions compilerOptions;

    ProducerFactoryGenerator(Filer filer, Elements elements, CompilerOptions compilerOptions) {
        super(filer, elements);
        this.compilerOptions = compilerOptions;
    }

    @Override
    ClassName nameGeneratedType(ProductionBinding binding) {
        return SourceFiles.generatedClassNameForBinding(binding);
    }

    @Override
    Optional<? extends Element> getElementForErrorReporting(ProductionBinding binding) {
        return binding.bindingElement();
    }

    @Override
    Optional<TypeSpec.Builder> write(ClassName generatedTypeName, ProductionBinding binding) {
        Preconditions.checkArgument((boolean)binding.bindingElement().isPresent());
        TypeName providedTypeName = TypeName.get(binding.contributedType());
        ParameterizedTypeName futureTypeName = TypeNames.listenableFutureOf(providedTypeName);
        TypeSpec.Builder factoryBuilder = TypeSpec.classBuilder(generatedTypeName).addModifiers(Modifier.PUBLIC, Modifier.FINAL).superclass(TypeNames.abstractProducerOf(providedTypeName));
        UniqueNameSet uniqueFieldNames = new UniqueNameSet();
        ImmutableMap.Builder fieldsBuilder = ImmutableMap.builder();
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC);
        Optional moduleField = binding.requiresModuleInstance() ? Optional.of(ProducerFactoryGenerator.addFieldAndConstructorParameter(factoryBuilder, constructorBuilder, uniqueFieldNames.getUniqueName("module"), TypeName.get(binding.bindingTypeElement().get().asType()))) : Optional.empty();
        for (Map.Entry entry : SourceFiles.generateBindingFieldsForDependencies(binding).entrySet()) {
            BindingKey bindingKey = (BindingKey)entry.getKey();
            FrameworkField bindingField = (FrameworkField)entry.getValue();
            FieldSpec field = ProducerFactoryGenerator.addFieldAndConstructorParameter(factoryBuilder, constructorBuilder, uniqueFieldNames.getUniqueName(bindingField.name()), bindingField.type());
            fieldsBuilder.put((Object)bindingKey, (Object)field);
        }
        ImmutableMap fields = fieldsBuilder.build();
        constructorBuilder.addStatement("super($N, $L)", fields.get((Object)binding.monitorRequest().get().bindingKey()), this.producerTokenConstruction(generatedTypeName, binding));
        if (binding.requiresModuleInstance()) {
            ProducerFactoryGenerator.assignField(constructorBuilder, (FieldSpec)moduleField.get());
        }
        for (FieldSpec field : fields.values()) {
            ProducerFactoryGenerator.assignField(constructorBuilder, field);
        }
        MethodSpec.Builder computeMethodBuilder = MethodSpec.methodBuilder("compute").returns(futureTypeName).addAnnotation(Override.class).addModifiers(Modifier.PROTECTED);
        ImmutableList<DependencyRequest> asyncDependencies = ProducerFactoryGenerator.asyncDependencies(binding);
        for (DependencyRequest dependency : asyncDependencies) {
            ParameterizedTypeName futureType = TypeNames.listenableFutureOf(ProducerFactoryGenerator.asyncDependencyType(dependency));
            CodeBlock futureAccess = CodeBlock.of("$N.get()", fields.get((Object)dependency.bindingKey()));
            computeMethodBuilder.addStatement("$T $L = $L", futureType, ProducerFactoryGenerator.dependencyFutureName(dependency), dependency.kind().equals((Object)DependencyRequest.Kind.PRODUCED) ? CodeBlock.of("$T.createFutureProduced($L)", TypeNames.PRODUCERS, futureAccess) : futureAccess);
        }
        FutureTransform futureTransform = FutureTransform.create((ImmutableMap<BindingKey, FieldSpec>)fields, binding, asyncDependencies);
        computeMethodBuilder.addStatement("return $T.transformAsync($L, this, this)", TypeNames.FUTURES, futureTransform.futureCodeBlock());
        factoryBuilder.addSuperinterface(ParameterizedTypeName.get(TypeNames.ASYNC_FUNCTION, futureTransform.applyArgType(), providedTypeName)).addSuperinterface(TypeNames.EXECUTOR);
        MethodSpec.Builder applyMethodBuilder = MethodSpec.methodBuilder("apply").returns(futureTypeName).addJavadoc("@deprecated this may only be called from the internal {@link #compute()}", new Object[0]).addAnnotation(Deprecated.class).addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).addParameter(futureTransform.applyArgType(), futureTransform.applyArgName(), new Modifier[0]).addExceptions((Iterable<? extends TypeName>)this.getThrownTypeNames((Iterable<? extends TypeMirror>)binding.thrownTypes())).addStatement("assert monitor != null : $S", "apply() may only be called internally from compute(); if it's called explicitly, the monitor might be null").addCode(this.getInvocationCodeBlock(generatedTypeName, binding, providedTypeName, futureTransform.parameterCodeBlocks()));
        if (futureTransform.hasUncheckedCast()) {
            applyMethodBuilder.addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.UNCHECKED, new AnnotationSpecs.Suppression[0]));
        }
        MethodSpec.Builder executeMethodBuilder = MethodSpec.methodBuilder("execute").addModifiers(Modifier.PUBLIC).addJavadoc("@deprecated this may only be called from the internal {@link #compute()}", new Object[0]).addAnnotation(Deprecated.class).addAnnotation(Override.class).addParameter(TypeNames.RUNNABLE, "runnable", new Modifier[0]).addStatement("assert monitor != null : $S", "execute() may only be called internally from compute(); if it's called explicitly, the monitor might be null").addStatement("monitor.ready()", new Object[0]).addStatement("executorProvider.get().execute(runnable)", new Object[0]);
        factoryBuilder.addMethod(constructorBuilder.build());
        factoryBuilder.addMethod(computeMethodBuilder.build());
        factoryBuilder.addMethod(applyMethodBuilder.build());
        factoryBuilder.addMethod(executeMethodBuilder.build());
        return Optional.of(factoryBuilder);
    }

    private static FieldSpec addFieldAndConstructorParameter(TypeSpec.Builder typeBuilder, MethodSpec.Builder constructorBuilder, String variableName, TypeName variableType) {
        FieldSpec field = FieldSpec.builder(variableType, variableName, Modifier.PRIVATE, Modifier.FINAL).build();
        typeBuilder.addField(field);
        constructorBuilder.addParameter(field.type, field.name, new Modifier[0]);
        return field;
    }

    private static void assignField(MethodSpec.Builder constructorBuilder, FieldSpec field) {
        constructorBuilder.addStatement("assert $N != null", field).addStatement("this.$1N = $1N", field);
    }

    private static ImmutableList<DependencyRequest> asyncDependencies(Binding binding) {
        ImmutableMap<DependencyRequest, FrameworkDependency> frameworkDependencies = binding.dependenciesToFrameworkDependenciesMap();
        return FluentIterable.from(binding.dependencies()).filter(dependency -> ProducerFactoryGenerator.isAsyncDependency(dependency) && ((FrameworkDependency)frameworkDependencies.get(dependency)).frameworkClass().equals(Producer.class)).toList();
    }

    private CodeBlock producerTokenConstruction(ClassName generatedTypeName, ProductionBinding binding) {
        CodeBlock producerTokenArgs = this.compilerOptions.writeProducerNameInToken() ? CodeBlock.of("$S", String.format("%s#%s", ClassName.get(binding.bindingTypeElement().get()), binding.bindingElement().get().getSimpleName())) : CodeBlock.of("$T.class", generatedTypeName);
        return CodeBlock.of("$T.create($L)", TypeNames.PRODUCER_TOKEN, producerTokenArgs);
    }

    private static String dependencyFutureName(DependencyRequest dependency) {
        return dependency.requestElement().get().getSimpleName() + "Future";
    }

    private static boolean isAsyncDependency(DependencyRequest dependency) {
        switch (dependency.kind()) {
            case INSTANCE: 
            case PRODUCED: {
                return true;
            }
        }
        return false;
    }

    private static TypeName asyncDependencyType(DependencyRequest dependency) {
        TypeName keyName = TypeName.get(dependency.key().type());
        switch (dependency.kind()) {
            case INSTANCE: {
                return keyName;
            }
            case PRODUCED: {
                return TypeNames.producedOf(keyName);
            }
        }
        throw new AssertionError();
    }

    private static ImmutableList<CodeBlock> getParameterCodeBlocks(ProductionBinding binding, ImmutableMap<BindingKey, FieldSpec> fields, String listArgName) {
        int argIndex = 0;
        ImmutableList.Builder codeBlocks = ImmutableList.builder();
        for (DependencyRequest dependency : binding.explicitDependencies()) {
            if (ProducerFactoryGenerator.isAsyncDependency(dependency)) {
                codeBlocks.add((Object)CodeBlock.of("($T) $L.get($L)", ProducerFactoryGenerator.asyncDependencyType(dependency), listArgName, argIndex));
                ++argIndex;
                continue;
            }
            codeBlocks.add((Object)SourceFiles.frameworkTypeUsageStatement(CodeBlock.of("$N", fields.get((Object)dependency.bindingKey())), dependency.kind()));
        }
        return codeBlocks.build();
    }

    private CodeBlock getInvocationCodeBlock(ClassName generatedTypeName, ProductionBinding binding, TypeName providedTypeName, ImmutableList<CodeBlock> parameterCodeBlocks) {
        CodeBlock returnCodeBlock;
        CodeBlock moduleCodeBlock = CodeBlock.of("$L.$L($L)", binding.requiresModuleInstance() ? CodeBlock.of("$T.this.module", generatedTypeName) : CodeBlock.of("$T", ClassName.get(binding.bindingTypeElement().get())), binding.bindingElement().get().getSimpleName(), CodeBlocks.makeParametersCodeBlock(parameterCodeBlocks));
        ImmutableList.Builder codeBlocks = ImmutableList.builder();
        codeBlocks.add((Object)CodeBlock.of("monitor.methodStarting();", new Object[0]));
        switch (binding.productionKind().get()) {
            case IMMEDIATE: {
                returnCodeBlock = CodeBlock.of("$T.<$T>immediateFuture($L)", TypeNames.FUTURES, providedTypeName, moduleCodeBlock);
                break;
            }
            case FUTURE: {
                returnCodeBlock = moduleCodeBlock;
                break;
            }
            case SET_OF_FUTURE: {
                returnCodeBlock = CodeBlock.of("$T.allAsSet($L)", TypeNames.PRODUCERS, moduleCodeBlock);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return CodeBlock.of(Joiner.on((char)'\n').join((Object)"monitor.methodStarting();", (Object)"try {", new Object[]{"  return $L;", "} finally {", "  monitor.methodFinished();", "}"}), returnCodeBlock);
    }

    private FluentIterable<? extends TypeName> getThrownTypeNames(Iterable<? extends TypeMirror> thrownTypes) {
        return FluentIterable.from(thrownTypes).transform(TypeName::get);
    }

    static final class MultiArgFutureTransform
    extends FutureTransform {
        private final ImmutableList<DependencyRequest> asyncDependencies;

        MultiArgFutureTransform(ImmutableMap<BindingKey, FieldSpec> fields, ProductionBinding binding, ImmutableList<DependencyRequest> asyncDependencies) {
            super(fields, binding);
            this.asyncDependencies = asyncDependencies;
        }

        @Override
        CodeBlock futureCodeBlock() {
            return CodeBlock.of("$T.<$T>allAsList($L)", TypeNames.FUTURES, ClassName.OBJECT, this.asyncDependencies.stream().map(x$0 -> ProducerFactoryGenerator.dependencyFutureName(x$0)).collect(Collectors.joining(", ")));
        }

        @Override
        TypeName applyArgType() {
            return TypeNames.listOf(ClassName.OBJECT);
        }

        @Override
        String applyArgName() {
            return "args";
        }

        @Override
        ImmutableList<CodeBlock> parameterCodeBlocks() {
            return ProducerFactoryGenerator.getParameterCodeBlocks(this.binding, (ImmutableMap<BindingKey, FieldSpec>)this.fields, this.applyArgName());
        }

        @Override
        boolean hasUncheckedCast() {
            return true;
        }
    }

    static final class SingleArgFutureTransform
    extends FutureTransform {
        private final DependencyRequest asyncDependency;

        SingleArgFutureTransform(ImmutableMap<BindingKey, FieldSpec> fields, ProductionBinding binding, DependencyRequest asyncDependency) {
            super(fields, binding);
            this.asyncDependency = asyncDependency;
        }

        @Override
        CodeBlock futureCodeBlock() {
            return CodeBlock.of("$L", ProducerFactoryGenerator.dependencyFutureName(this.asyncDependency));
        }

        @Override
        TypeName applyArgType() {
            return ProducerFactoryGenerator.asyncDependencyType(this.asyncDependency);
        }

        @Override
        String applyArgName() {
            return this.asyncDependency.requestElement().get().getSimpleName().toString();
        }

        @Override
        ImmutableList<CodeBlock> parameterCodeBlocks() {
            ImmutableList.Builder parameterCodeBlocks = ImmutableList.builder();
            for (DependencyRequest dependency : this.binding.explicitDependencies()) {
                if (dependency == this.asyncDependency) {
                    parameterCodeBlocks.add((Object)CodeBlock.of("$L", this.applyArgName()));
                    continue;
                }
                parameterCodeBlocks.add((Object)SourceFiles.frameworkTypeUsageStatement(CodeBlock.of("$N", this.fields.get((Object)dependency.bindingKey())), dependency.kind()));
            }
            return parameterCodeBlocks.build();
        }
    }

    static final class NoArgFutureTransform
    extends FutureTransform {
        NoArgFutureTransform(ImmutableMap<BindingKey, FieldSpec> fields, ProductionBinding binding) {
            super(fields, binding);
        }

        @Override
        CodeBlock futureCodeBlock() {
            return CodeBlock.of("$T.<$T>immediateFuture(null)", TypeNames.FUTURES, TypeNames.VOID_CLASS);
        }

        @Override
        TypeName applyArgType() {
            return TypeNames.VOID_CLASS;
        }

        @Override
        String applyArgName() {
            return "ignoredVoidArg";
        }

        @Override
        ImmutableList<CodeBlock> parameterCodeBlocks() {
            ImmutableList.Builder parameterCodeBlocks = ImmutableList.builder();
            for (DependencyRequest dependency : this.binding.explicitDependencies()) {
                parameterCodeBlocks.add((Object)SourceFiles.frameworkTypeUsageStatement(CodeBlock.of("$N", this.fields.get((Object)dependency.bindingKey())), dependency.kind()));
            }
            return parameterCodeBlocks.build();
        }
    }

    static abstract class FutureTransform {
        protected final ImmutableMap<BindingKey, FieldSpec> fields;
        protected final ProductionBinding binding;

        FutureTransform(ImmutableMap<BindingKey, FieldSpec> fields, ProductionBinding binding) {
            this.fields = fields;
            this.binding = binding;
        }

        abstract CodeBlock futureCodeBlock();

        abstract TypeName applyArgType();

        abstract String applyArgName();

        abstract ImmutableList<CodeBlock> parameterCodeBlocks();

        boolean hasUncheckedCast() {
            return false;
        }

        static FutureTransform create(ImmutableMap<BindingKey, FieldSpec> fields, ProductionBinding binding, ImmutableList<DependencyRequest> asyncDependencies) {
            if (asyncDependencies.isEmpty()) {
                return new NoArgFutureTransform(fields, binding);
            }
            if (asyncDependencies.size() == 1) {
                return new SingleArgFutureTransform(fields, binding, (DependencyRequest)Iterables.getOnlyElement(asyncDependencies));
            }
            return new MultiArgFutureTransform(fields, binding, asyncDependencies);
        }
    }
}

