/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.FrameworkDependency;
import dagger.internal.codegen.FrameworkType;
import dagger.internal.codegen.MemberSelect;
import dagger.internal.codegen.RequestFulfillment;
import dagger.producers.internal.Producers;

final class ProviderFieldRequestFulfillment
extends RequestFulfillment {
    private final MemberSelect providerFieldSelect;

    ProviderFieldRequestFulfillment(BindingKey bindingKey, MemberSelect frameworkFieldSelect) {
        super(bindingKey);
        Preconditions.checkArgument((boolean)bindingKey.kind().equals((Object)BindingKey.Kind.CONTRIBUTION));
        this.providerFieldSelect = frameworkFieldSelect;
    }

    @Override
    public CodeBlock getSnippetForDependencyRequest(DependencyRequest request, ClassName requestingClass) {
        return FrameworkType.PROVIDER.to(request.kind(), this.providerFieldSelect.getExpressionFor(requestingClass));
    }

    @Override
    CodeBlock getSnippetForFrameworkDependency(FrameworkDependency frameworkDependency, ClassName requestingClass) {
        switch (frameworkDependency.bindingType()) {
            case PROVISION: {
                return this.providerFieldSelect.getExpressionFor(requestingClass);
            }
            case MEMBERS_INJECTION: {
                throw new IllegalArgumentException();
            }
            case PRODUCTION: {
                return CodeBlock.of("$T.producerFromProvider($L)", Producers.class, this.providerFieldSelect.getExpressionFor(requestingClass));
            }
        }
        throw new AssertionError();
    }
}

