/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.UnmodifiableIterator;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.DependencyVariableNamer;
import dagger.internal.codegen.FrameworkDependency;
import dagger.internal.codegen.FrameworkField;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.Optionals;
import dagger.internal.codegen.TypeNames;
import java.util.Comparator;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;

class SourceFiles {
    private static final Joiner CLASS_FILE_NAME_JOINER = Joiner.on((char)'_');
    static final Comparator<DependencyRequest> DEPENDENCY_ORDERING = Comparator.comparing(request -> request.requestElement().map(Element::getKind), Optionals.optionalComparator()).thenComparing(DependencyRequest::kind).thenComparing(request -> request.requestElement().map(element -> element.getSimpleName().toString()), Optionals.optionalComparator());

    static ImmutableMap<BindingKey, FrameworkField> generateBindingFieldsForDependencies(Binding binding) {
        Preconditions.checkArgument((!binding.unresolved().isPresent() ? 1 : 0) != 0, (String)"binding must be unresolved: %s", (Object)binding);
        ImmutableMap.Builder bindingFields = ImmutableMap.builder();
        for (Binding.DependencyAssociation dependencyAssociation : binding.dependencyAssociations()) {
            FrameworkDependency frameworkDependency = dependencyAssociation.frameworkDependency();
            bindingFields.put((Object)frameworkDependency.bindingKey(), (Object)FrameworkField.create(ClassName.get(frameworkDependency.frameworkClass()), TypeName.get(frameworkDependency.bindingKey().key().type()), SourceFiles.fieldNameForDependency(dependencyAssociation.dependencyRequests())));
        }
        return bindingFields.build();
    }

    private static String fieldNameForDependency(ImmutableSet<DependencyRequest> dependencyRequests) {
        ImmutableSet dependencyNames = FluentIterable.from(dependencyRequests).transform((Function)new DependencyVariableNamer()).toSet();
        if (dependencyNames.size() == 1) {
            return (String)Iterables.getOnlyElement((Iterable)dependencyNames);
        }
        UnmodifiableIterator namesIterator = dependencyNames.iterator();
        String first = (String)namesIterator.next();
        StringBuilder compositeNameBuilder = new StringBuilder(first);
        while (namesIterator.hasNext()) {
            compositeNameBuilder.append("And").append(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, (String)namesIterator.next()));
        }
        return compositeNameBuilder.toString();
    }

    static CodeBlock frameworkTypeUsageStatement(CodeBlock frameworkTypeMemberSelect, DependencyRequest.Kind dependencyKind) {
        switch (dependencyKind) {
            case LAZY: {
                return CodeBlock.of("$T.lazy($L)", TypeNames.DOUBLE_CHECK, frameworkTypeMemberSelect);
            }
            case INSTANCE: 
            case FUTURE: {
                return CodeBlock.of("$L.get()", frameworkTypeMemberSelect);
            }
            case PROVIDER: 
            case PRODUCER: 
            case MEMBERS_INJECTOR: {
                return frameworkTypeMemberSelect;
            }
            case PROVIDER_OF_LAZY: {
                return CodeBlock.of("$T.create($L)", TypeNames.PROVIDER_OF_LAZY, frameworkTypeMemberSelect);
            }
        }
        throw new AssertionError((Object)dependencyKind);
    }

    static ClassName generatedClassNameForBinding(Binding binding) {
        switch (binding.bindingType()) {
            case PROVISION: 
            case PRODUCTION: {
                ContributionBinding contribution = (ContributionBinding)binding;
                Preconditions.checkArgument((boolean)contribution.bindingTypeElement().isPresent());
                ClassName enclosingClassName = ClassName.get(contribution.bindingTypeElement().get());
                switch (contribution.bindingKind()) {
                    case INJECTION: 
                    case PROVISION: 
                    case PRODUCTION: {
                        return enclosingClassName.topLevelClassName().peerClass(SourceFiles.classFileName(enclosingClassName) + "_" + SourceFiles.factoryPrefix(contribution) + "Factory");
                    }
                }
                throw new AssertionError();
            }
            case MEMBERS_INJECTION: {
                return SourceFiles.membersInjectorNameForType(((MembersInjectionBinding)binding).membersInjectedType());
            }
        }
        throw new AssertionError();
    }

    static TypeName parameterizedGeneratedTypeNameForBinding(Binding binding) {
        ClassName className = SourceFiles.generatedClassNameForBinding(binding);
        ImmutableList<TypeVariableName> typeParameters = SourceFiles.bindingTypeElementTypeVariableNames(binding);
        return typeParameters.isEmpty() ? className : ParameterizedTypeName.get(className, (TypeName[])Iterables.toArray(typeParameters, TypeName.class));
    }

    static ClassName membersInjectorNameForType(TypeElement typeElement) {
        return SourceFiles.siblingClassName(typeElement, "_MembersInjector");
    }

    static String classFileName(ClassName className) {
        return CLASS_FILE_NAME_JOINER.join(className.simpleNames());
    }

    static ClassName generatedMonitoringModuleName(TypeElement componentElement) {
        return SourceFiles.siblingClassName(componentElement, "_MonitoringModule");
    }

    static ClassName generatedProductionExecutorModuleName(TypeElement componentElement) {
        return SourceFiles.siblingClassName(componentElement, "_ProductionExecutorModule");
    }

    private static ClassName siblingClassName(TypeElement typeElement, String suffix) {
        ClassName className = ClassName.get(typeElement);
        return className.topLevelClassName().peerClass(SourceFiles.classFileName(className) + suffix);
    }

    private static String factoryPrefix(ContributionBinding binding) {
        switch (binding.bindingKind()) {
            case INJECTION: {
                return "";
            }
            case PROVISION: 
            case PRODUCTION: {
                return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, binding.bindingElement().get().getSimpleName().toString());
            }
        }
        throw new IllegalArgumentException();
    }

    static ImmutableList<TypeVariableName> bindingTypeElementTypeVariableNames(Binding binding) {
        ContributionBinding contributionBinding;
        if (binding instanceof ContributionBinding && !(contributionBinding = (ContributionBinding)binding).bindingKind().equals((Object)ContributionBinding.Kind.INJECTION) && !contributionBinding.requiresModuleInstance()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TypeParameterElement typeParameterElement : binding.bindingTypeElement().get().getTypeParameters()) {
            builder.add((Object)TypeVariableName.get(typeParameterElement));
        }
        return builder.build();
    }

    static String simpleVariableName(TypeElement typeElement) {
        String candidateName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, typeElement.getSimpleName().toString());
        String variableName = SourceFiles.protectAgainstKeywords(candidateName);
        Verify.verify((boolean)SourceVersion.isName(variableName), (String)"'%s' was expected to be a valid variable name", (Object[])new Object[0]);
        return variableName;
    }

    private static String protectAgainstKeywords(String candidateName) {
        switch (candidateName) {
            case "package": {
                return "pkg";
            }
            case "boolean": {
                return "b";
            }
            case "double": {
                return "d";
            }
            case "byte": {
                return "b";
            }
            case "int": {
                return "i";
            }
            case "short": {
                return "s";
            }
            case "char": {
                return "c";
            }
            case "void": {
                return "v";
            }
            case "class": {
                return "clazz";
            }
            case "float": {
                return "f";
            }
            case "long": {
                return "l";
            }
        }
        return SourceVersion.isKeyword(candidateName) ? candidateName + '_' : candidateName;
    }

    private SourceFiles() {
    }
}

