/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dagger.Binds;
import dagger.Provides;
import dagger.internal.codegen.DaggerElements;
import dagger.producers.Produces;
import dagger.shaded.auto.common.MoreElements;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class Util {
    static boolean requiresAPassedInstance(Elements elements, Types types, TypeElement typeElement) {
        ImmutableSet<ExecutableElement> methods = MoreElements.getLocalAndInheritedMethods(typeElement, types, elements);
        boolean foundInstanceMethod = false;
        for (ExecutableElement method : methods) {
            if (method.getModifiers().contains((Object)Modifier.ABSTRACT) && !MoreElements.isAnnotationPresent(method, Binds.class)) {
                return true;
            }
            if (method.getModifiers().contains((Object)Modifier.STATIC) || !DaggerElements.isAnyAnnotationPresent(method, Provides.class, Produces.class)) continue;
            foundInstanceMethod = true;
        }
        if (foundInstanceMethod) {
            return !Util.componentCanMakeNewInstances(typeElement);
        }
        return false;
    }

    static boolean componentCanMakeNewInstances(TypeElement typeElement) {
        switch (typeElement.getKind()) {
            case CLASS: {
                break;
            }
            case ENUM: 
            case ANNOTATION_TYPE: 
            case INTERFACE: {
                return false;
            }
            default: {
                throw new AssertionError((Object)("TypeElement cannot have kind: " + (Object)((Object)typeElement.getKind())));
            }
        }
        if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return false;
        }
        if (Util.requiresEnclosingInstance(typeElement)) {
            return false;
        }
        for (Element element : typeElement.getEnclosedElements()) {
            if (!element.getKind().equals((Object)ElementKind.CONSTRUCTOR) || !((ExecutableElement)element).getParameters().isEmpty() || element.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            return true;
        }
        return false;
    }

    private static boolean requiresEnclosingInstance(TypeElement typeElement) {
        switch (typeElement.getNestingKind()) {
            case TOP_LEVEL: {
                return false;
            }
            case MEMBER: {
                return !typeElement.getModifiers().contains((Object)Modifier.STATIC);
            }
            case ANONYMOUS: 
            case LOCAL: {
                return true;
            }
        }
        throw new AssertionError((Object)("TypeElement cannot have nesting kind: " + (Object)((Object)typeElement.getNestingKind())));
    }

    static <T> Collector<T, ?, ImmutableList<T>> toImmutableList() {
        return Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf);
    }

    static <T> Collector<T, ?, ImmutableSet<T>> toImmutableSet() {
        return Collectors.collectingAndThen(Collectors.toList(), ImmutableSet::copyOf);
    }

    private Util() {
    }
}

