/*
 * Decompiled with CFR 0.152.
 */
package dagger.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.graph.Graph;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.errorprone.annotations.DoNotMock;
import dagger.internal.codegen.DaggerStreams;
import dagger.model.AutoValue_BindingGraph_BindingNode;
import dagger.model.AutoValue_BindingGraph_ComponentNode;
import dagger.model.Binding;
import dagger.model.ComponentPath;
import dagger.model.DependencyRequest;
import dagger.model.ForwardingNetwork;
import dagger.model.Key;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public final class BindingGraph
extends ForwardingNetwork<Node, Edge> {
    BindingGraph(Network<Node, Edge> network) {
        super(ImmutableNetwork.copyOf(network));
    }

    public ImmutableSet<BindingNode> bindingNodes() {
        return this.bindingNodesStream().collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<BindingNode> bindingNodes(Key key) {
        return this.bindingNodesStream().filter(node -> node.binding().key().equals(key)).collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<ComponentNode> componentNodes() {
        return this.componentNodeStream().collect(DaggerStreams.toImmutableSet());
    }

    public Optional<ComponentNode> componentNode(ComponentPath component) {
        return this.componentNodeStream().filter(node -> node.componentPath().equals(component)).findFirst();
    }

    public ImmutableSet<ComponentNode> componentNodes(TypeElement component) {
        return this.componentNodeStream().filter(node -> node.componentPath().currentComponent().equals(component)).collect(DaggerStreams.toImmutableSet());
    }

    public ComponentNode rootComponentNode() {
        return this.componentNodeStream().filter(node -> node.componentPath().atRoot()).findFirst().get();
    }

    public ImmutableSet<DependencyEdge> dependencyEdges() {
        return this.dependencyEdgeStream().collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableMap<DependencyRequest, DependencyEdge> dependencyEdges(BindingNode bindingNode) {
        return this.outEdges(bindingNode).stream().flatMap(DaggerStreams.instancesOf(DependencyEdge.class)).collect(DaggerStreams.toImmutableMap(DependencyEdge::dependencyRequest, edge -> edge));
    }

    public ImmutableSet<DependencyEdge> dependencyEdges(DependencyRequest dependencyRequest) {
        return this.dependencyEdgeStream().filter(edge -> edge.dependencyRequest().equals(dependencyRequest)).collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<DependencyEdge> entryPointEdges() {
        return this.entryPointEdgeStream().collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<DependencyEdge> entryPointEdges(ComponentPath component) {
        return this.outEdges((Node)this.componentNode(component).get()).stream().flatMap(DaggerStreams.instancesOf(DependencyEdge.class)).collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<BindingNode> entryPointBindingNodes() {
        return this.entryPointEdgeStream().map(edge -> (BindingNode)this.incidentNodes(edge).target()).collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<DependencyEdge> entryPointEdgesDependingOnBindingNode(BindingNode bindingNode) {
        MutableNetwork subgraphDependingOnBindingNode = Graphs.inducedSubgraph((Network)this, (Iterable)Graphs.reachableNodes((Graph)Graphs.transpose((Network)this).asGraph(), (Object)bindingNode));
        return ImmutableSet.copyOf((Collection)Sets.intersection(this.entryPointEdges(), (Set)subgraphDependingOnBindingNode.edges()));
    }

    private Stream<BindingNode> bindingNodesStream() {
        return this.nodes().stream().flatMap(DaggerStreams.instancesOf(BindingNode.class));
    }

    private Stream<ComponentNode> componentNodeStream() {
        return this.nodes().stream().flatMap(DaggerStreams.instancesOf(ComponentNode.class));
    }

    private Stream<DependencyEdge> dependencyEdgeStream() {
        return this.edges().stream().flatMap(DaggerStreams.instancesOf(DependencyEdge.class));
    }

    private Stream<DependencyEdge> entryPointEdgeStream() {
        return this.dependencyEdgeStream().filter(DependencyEdge::isEntryPoint);
    }

    public static abstract class ComponentNode
    implements Node {
        static ComponentNode create(ComponentPath componentPath) {
            return new AutoValue_BindingGraph_ComponentNode(componentPath);
        }

        @Override
        public abstract ComponentPath componentPath();
    }

    @DoNotMock(value="Use Dagger-supplied implementations")
    public static abstract class BindingNode
    implements Node {
        static BindingNode create(ComponentPath component, Binding binding, Iterable<Element> associatedDeclarations) {
            return new AutoValue_BindingGraph_BindingNode(component, binding, (ImmutableSet<Element>)ImmutableSet.copyOf(associatedDeclarations));
        }

        @Override
        public abstract ComponentPath componentPath();

        public abstract Binding binding();

        public abstract ImmutableSet<Element> associatedDeclarations();
    }

    public static interface Node {
        public ComponentPath componentPath();
    }

    public static final class SubcomponentBuilderBindingEdge
    implements Edge {
        private final ImmutableSet<TypeElement> declaringModules;

        SubcomponentBuilderBindingEdge(Iterable<TypeElement> declaringModules) {
            this.declaringModules = ImmutableSet.copyOf(declaringModules);
        }

        public ImmutableSet<TypeElement> declaringModules() {
            return this.declaringModules;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("declaringModules", this.declaringModules).toString();
        }
    }

    public static final class ChildFactoryMethodEdge
    implements Edge {
        private final ExecutableElement factoryMethod;

        ChildFactoryMethodEdge(ExecutableElement factoryMethod) {
            this.factoryMethod = factoryMethod;
        }

        public ExecutableElement factoryMethod() {
            return this.factoryMethod;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("factoryMethod", (Object)this.factoryMethod).toString();
        }
    }

    public static final class DependencyEdge
    implements Edge {
        private final DependencyRequest dependencyRequest;
        private final boolean entryPoint;

        DependencyEdge(DependencyRequest dependencyRequest, boolean entryPoint) {
            this.dependencyRequest = dependencyRequest;
            this.entryPoint = entryPoint;
        }

        public DependencyRequest dependencyRequest() {
            return this.dependencyRequest;
        }

        public boolean isEntryPoint() {
            return this.entryPoint;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("dependencyRequest", (Object)this.dependencyRequest).add("entryPoint", this.entryPoint).toString();
        }
    }

    public static interface Edge {
    }
}

