/*
 * Decompiled with CFR 0.152.
 */
package dagger.model;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import dagger.Reusable;
import dagger.model.AutoValue_Scope;
import dagger.producers.ProductionScope;
import dagger.releasablereferences.CanReleaseReferences;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.inject.Singleton;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public abstract class Scope {
    abstract Equivalence.Wrapper<AnnotationMirror> wrappedScopeAnnotation();

    public final AnnotationMirror scopeAnnotation() {
        return (AnnotationMirror)this.wrappedScopeAnnotation().get();
    }

    public final TypeElement scopeAnnotationElement() {
        return MoreTypes.asTypeElement(this.scopeAnnotation().getAnnotationType());
    }

    public static Scope scope(AnnotationMirror scopeAnnotation) {
        Preconditions.checkArgument((boolean)Scope.isScope(scopeAnnotation));
        return new AutoValue_Scope((Equivalence.Wrapper<AnnotationMirror>)AnnotationMirrors.equivalence().wrap((Object)scopeAnnotation));
    }

    public static boolean isScope(AnnotationMirror scopeAnnotation) {
        return Scope.isScope(MoreElements.asType(scopeAnnotation.getAnnotationType().asElement()));
    }

    public static boolean isScope(TypeElement scopeAnnotationType) {
        return MoreElements.isAnnotationPresent(scopeAnnotationType, javax.inject.Scope.class);
    }

    public final boolean isSingleton() {
        return this.isScope(Singleton.class);
    }

    public final boolean isReusable() {
        return this.isScope(Reusable.class);
    }

    public final boolean isProductionScope() {
        return this.isScope(ProductionScope.class);
    }

    private boolean isScope(Class<? extends Annotation> annotation) {
        return this.scopeAnnotationElement().getQualifiedName().contentEquals(annotation.getCanonicalName());
    }

    public final boolean canReleaseReferences() {
        return MoreElements.isAnnotationPresent(this.scopeAnnotationElement(), CanReleaseReferences.class) || !this.releasableReferencesMetadata().isEmpty();
    }

    public final ImmutableSet<AnnotationMirror> releasableReferencesMetadata() {
        return ImmutableSet.copyOf(AnnotationMirrors.getAnnotatedAnnotations(this.scopeAnnotationElement(), CanReleaseReferences.class));
    }

    public final Optional<AnnotationMirror> releasableReferencesMetadata(TypeMirror metadataType) {
        for (AnnotationMirror metadata : this.releasableReferencesMetadata()) {
            if (!MoreTypes.equivalence().equivalent((Object)metadata.getAnnotationType(), (Object)metadataType)) continue;
            return Optional.of(metadata);
        }
        return Optional.empty();
    }

    public String toString() {
        return this.scopeAnnotation().toString();
    }
}

