/*
 * Decompiled with CFR 0.152.
 */
package dagger.model;

import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Sets;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import dagger.internal.codegen.DaggerStreams;
import dagger.model.AutoValue_BindingGraph_MissingBindingNode;
import dagger.model.Binding;
import dagger.model.ComponentPath;
import dagger.model.DependencyRequest;
import dagger.model.ForwardingNetwork;
import dagger.model.Key;
import dagger.model.Scope;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public final class BindingGraph
extends ForwardingNetwork<Node, Edge> {
    BindingGraph(Network<Node, Edge> network) {
        super(ImmutableNetwork.copyOf(network));
    }

    public ImmutableSet<BindingNode> bindingNodes() {
        return this.nodes(BindingNode.class);
    }

    public ImmutableSet<BindingNode> bindingNodes(Key key) {
        return this.nodeStream(BindingNode.class).filter(node -> node.binding().key().equals(key)).collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<MissingBindingNode> missingBindingNodes() {
        return this.nodes(MissingBindingNode.class);
    }

    public ImmutableSet<ComponentNode> componentNodes() {
        return this.nodes(ComponentNode.class);
    }

    public Optional<ComponentNode> componentNode(ComponentPath component) {
        return this.nodeStream(ComponentNode.class).filter(node -> node.componentPath().equals(component)).findFirst();
    }

    public ImmutableSet<ComponentNode> componentNodes(TypeElement component) {
        return this.nodeStream(ComponentNode.class).filter(node -> node.componentPath().currentComponent().equals(component)).collect(DaggerStreams.toImmutableSet());
    }

    public ComponentNode rootComponentNode() {
        return this.nodeStream(ComponentNode.class).filter(node -> node.componentPath().atRoot()).findFirst().get();
    }

    public ImmutableSet<DependencyEdge> dependencyEdges() {
        return this.dependencyEdgeStream().collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSetMultimap<DependencyRequest, DependencyEdge> dependencyEdges(BindingNode bindingNode) {
        return this.dependencyEdgeStream(bindingNode).collect(DaggerStreams.toImmutableSetMultimap(DependencyEdge::dependencyRequest, edge -> edge));
    }

    public ImmutableSet<DependencyEdge> dependencyEdges(DependencyRequest dependencyRequest) {
        return this.dependencyEdgeStream().filter(edge -> edge.dependencyRequest().equals(dependencyRequest)).collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<DependencyEdge> entryPointEdges(ComponentPath component) {
        return this.dependencyEdgeStream(this.componentNode(component).get()).collect(DaggerStreams.toImmutableSet());
    }

    private Stream<DependencyEdge> dependencyEdgeStream(Node node) {
        return this.outEdges(node).stream().flatMap(DaggerStreams.instancesOf(DependencyEdge.class));
    }

    public ImmutableSet<DependencyEdge> entryPointEdges() {
        return this.entryPointEdgeStream().collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<BindingNode> entryPointBindingNodes() {
        return this.entryPointEdgeStream().map(edge -> (BindingNode)this.incidentNodes(edge).target()).collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<DependencyEdge> entryPointEdgesDependingOnBindingNode(BindingNode bindingNode) {
        ImmutableNetwork<Node, DependencyEdge> dependencyGraph = this.dependencyGraph();
        MutableNetwork subgraphDependingOnBindingNode = Graphs.inducedSubgraph(dependencyGraph, (Iterable)Graphs.reachableNodes((Graph)Graphs.transpose(dependencyGraph).asGraph(), (Object)bindingNode));
        return ImmutableSet.copyOf((Collection)Sets.intersection(this.entryPointEdges(), (Set)subgraphDependingOnBindingNode.edges()));
    }

    private ImmutableNetwork<Node, DependencyEdge> dependencyGraph() {
        MutableNetwork dependencyGraph = NetworkBuilder.from((Network)this).expectedNodeCount(this.nodes().size()).expectedEdgeCount((int)this.dependencyEdgeStream().count()).build();
        this.dependencyEdgeStream().forEach(edge -> {
            EndpointPair endpoints = this.incidentNodes(edge);
            dependencyGraph.addEdge((Object)((Node)endpoints.source()), (Object)((Node)endpoints.target()), edge);
        });
        return ImmutableNetwork.copyOf((Network)dependencyGraph);
    }

    private <N extends Node> ImmutableSet<N> nodes(Class<N> clazz) {
        return this.nodeStream(clazz).collect(DaggerStreams.toImmutableSet());
    }

    private <N extends Node> Stream<N> nodeStream(Class<N> clazz) {
        return this.nodes().stream().flatMap(DaggerStreams.instancesOf(clazz));
    }

    private Stream<DependencyEdge> dependencyEdgeStream() {
        return this.edges().stream().flatMap(DaggerStreams.instancesOf(DependencyEdge.class));
    }

    private Stream<DependencyEdge> entryPointEdgeStream() {
        return this.dependencyEdgeStream().filter(DependencyEdge::isEntryPoint);
    }

    public static interface ComponentNode
    extends Node {
        @Override
        public ComponentPath componentPath();

        public ImmutableSet<DependencyRequest> entryPoints();

        public ImmutableSet<Scope> scopes();
    }

    @AutoValue
    public static abstract class MissingBindingNode
    implements Node {
        static MissingBindingNode create(ComponentPath component, Key key) {
            return new AutoValue_BindingGraph_MissingBindingNode(component, key);
        }

        @Override
        public abstract ComponentPath componentPath();

        public abstract Key key();

        public String toString() {
            return String.format("missing binding for %s in %s", this.key(), this.componentPath());
        }
    }

    public static interface BindingNode
    extends Node {
        @Override
        public ComponentPath componentPath();

        public Binding binding();
    }

    public static interface Node {
        public ComponentPath componentPath();
    }

    public static final class SubcomponentBuilderBindingEdge
    implements Edge {
        private final ImmutableSet<TypeElement> declaringModules;

        SubcomponentBuilderBindingEdge(Iterable<TypeElement> declaringModules) {
            this.declaringModules = ImmutableSet.copyOf(declaringModules);
        }

        public ImmutableSet<TypeElement> declaringModules() {
            return this.declaringModules;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("declaringModules", this.declaringModules).toString();
        }
    }

    public static final class ChildFactoryMethodEdge
    implements Edge {
        private final ExecutableElement factoryMethod;

        ChildFactoryMethodEdge(ExecutableElement factoryMethod) {
            this.factoryMethod = factoryMethod;
        }

        public ExecutableElement factoryMethod() {
            return this.factoryMethod;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("factoryMethod", (Object)this.factoryMethod).toString();
        }
    }

    public static final class DependencyEdge
    implements Edge {
        private final DependencyRequest dependencyRequest;
        private final boolean entryPoint;

        DependencyEdge(DependencyRequest dependencyRequest, boolean entryPoint) {
            this.dependencyRequest = dependencyRequest;
            this.entryPoint = entryPoint;
        }

        public DependencyRequest dependencyRequest() {
            return this.dependencyRequest;
        }

        public boolean isEntryPoint() {
            return this.entryPoint;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("dependencyRequest", (Object)this.dependencyRequest).add("entryPoint", this.entryPoint).toString();
        }
    }

    public static interface Edge {
    }
}

