/*
 * Decompiled with CFR 0.152.
 */
package dagger.model;

import com.google.auto.value.AutoValue;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Sets;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import dagger.internal.codegen.DaggerStreams;
import dagger.model.AutoValue_BindingGraph_MissingBindingNode;
import dagger.model.Binding;
import dagger.model.ComponentPath;
import dagger.model.DependencyRequest;
import dagger.model.Key;
import dagger.model.Scope;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public final class BindingGraph {
    private final ImmutableNetwork<Node, Edge> network;

    BindingGraph(Network<Node, Edge> network) {
        this.network = ImmutableNetwork.copyOf(network);
    }

    public ImmutableNetwork<Node, Edge> network() {
        return this.network;
    }

    public int hashCode() {
        return this.network.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof BindingGraph) {
            return this.network.equals(((BindingGraph)other).network);
        }
        return false;
    }

    public String toString() {
        return this.network.toString();
    }

    public ImmutableSet<BindingNode> bindingNodes() {
        return this.nodes(BindingNode.class);
    }

    public ImmutableSet<BindingNode> bindingNodes(Key key) {
        return this.nodeStream(BindingNode.class).filter(node -> node.key().equals(key)).collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<MissingBindingNode> missingBindingNodes() {
        return this.nodes(MissingBindingNode.class);
    }

    public ImmutableSet<ComponentNode> componentNodes() {
        return this.nodes(ComponentNode.class);
    }

    public Optional<ComponentNode> componentNode(ComponentPath component) {
        return this.nodeStream(ComponentNode.class).filter(node -> node.componentPath().equals(component)).findFirst();
    }

    public ImmutableSet<ComponentNode> componentNodes(TypeElement component) {
        return this.nodeStream(ComponentNode.class).filter(node -> node.componentPath().currentComponent().equals(component)).collect(DaggerStreams.toImmutableSet());
    }

    public ComponentNode rootComponentNode() {
        return this.nodeStream(ComponentNode.class).filter(node -> node.componentPath().atRoot()).findFirst().get();
    }

    public ImmutableSet<DependencyEdge> dependencyEdges() {
        return this.dependencyEdgeStream().collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSetMultimap<DependencyRequest, DependencyEdge> dependencyEdges(BindingNode bindingNode) {
        return this.dependencyEdgeStream(bindingNode).collect(DaggerStreams.toImmutableSetMultimap(DependencyEdge::dependencyRequest, edge -> edge));
    }

    public ImmutableSet<DependencyEdge> dependencyEdges(DependencyRequest dependencyRequest) {
        return this.dependencyEdgeStream().filter(edge -> edge.dependencyRequest().equals(dependencyRequest)).collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<DependencyEdge> entryPointEdges(ComponentPath component) {
        return this.dependencyEdgeStream(this.componentNode(component).get()).collect(DaggerStreams.toImmutableSet());
    }

    private Stream<DependencyEdge> dependencyEdgeStream(Node node) {
        return this.network.outEdges((Object)node).stream().flatMap(DaggerStreams.instancesOf(DependencyEdge.class));
    }

    public ImmutableSet<DependencyEdge> entryPointEdges() {
        return this.entryPointEdgeStream().collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<MaybeBindingNode> entryPointBindingNodes() {
        return this.entryPointEdgeStream().map(edge -> (MaybeBindingNode)this.network.incidentNodes(edge).target()).collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<DependencyEdge> entryPointEdgesDependingOnBindingNode(MaybeBindingNode bindingNode) {
        ImmutableNetwork<Node, DependencyEdge> dependencyGraph = this.dependencyGraph();
        MutableNetwork subgraphDependingOnBindingNode = Graphs.inducedSubgraph(dependencyGraph, (Iterable)Graphs.reachableNodes((Graph)Graphs.transpose(dependencyGraph).asGraph(), (Object)bindingNode));
        ImmutableSet entryPointEdges = Sets.intersection(this.entryPointEdges(), (Set)subgraphDependingOnBindingNode.edges()).immutableCopy();
        Verify.verify((!entryPointEdges.isEmpty() ? 1 : 0) != 0, (String)"No entry points depend on binding %s", (Object)bindingNode);
        return entryPointEdges;
    }

    private ImmutableNetwork<Node, DependencyEdge> dependencyGraph() {
        MutableNetwork dependencyGraph = NetworkBuilder.from(this.network).expectedNodeCount(this.network.nodes().size()).expectedEdgeCount((int)this.dependencyEdgeStream().count()).build();
        this.dependencyEdgeStream().forEach(edge -> {
            EndpointPair endpoints = this.network.incidentNodes(edge);
            dependencyGraph.addEdge((Object)((Node)endpoints.source()), (Object)((Node)endpoints.target()), edge);
        });
        return ImmutableNetwork.copyOf((Network)dependencyGraph);
    }

    private <N extends Node> ImmutableSet<N> nodes(Class<N> clazz) {
        return this.nodeStream(clazz).collect(DaggerStreams.toImmutableSet());
    }

    private <N extends Node> Stream<N> nodeStream(Class<N> clazz) {
        return this.network.nodes().stream().flatMap(DaggerStreams.instancesOf(clazz));
    }

    private Stream<DependencyEdge> dependencyEdgeStream() {
        return this.network.edges().stream().flatMap(DaggerStreams.instancesOf(DependencyEdge.class));
    }

    private Stream<DependencyEdge> entryPointEdgeStream() {
        return this.dependencyEdgeStream().filter(DependencyEdge::isEntryPoint);
    }

    public static interface ComponentNode
    extends Node {
        @Override
        public ComponentPath componentPath();

        public ImmutableSet<DependencyRequest> entryPoints();

        public ImmutableSet<Scope> scopes();
    }

    @AutoValue
    public static abstract class MissingBindingNode
    implements MaybeBindingNode {
        static MissingBindingNode create(ComponentPath component, Key key) {
            return new AutoValue_BindingGraph_MissingBindingNode(component, key);
        }

        @Override
        public abstract ComponentPath componentPath();

        @Override
        public abstract Key key();

        @Override
        public final Optional<Binding> maybeBinding() {
            return Optional.empty();
        }

        public final String toString() {
            return String.format("missing binding for %s in %s", this.key(), this.componentPath());
        }
    }

    public static interface BindingNode
    extends MaybeBindingNode {
        @Override
        public ComponentPath componentPath();

        public Binding binding();

        @Override
        default public Key key() {
            return this.binding().key();
        }

        @Override
        default public Optional<Binding> maybeBinding() {
            return Optional.of(this.binding());
        }
    }

    public static interface MaybeBindingNode
    extends Node {
        @Override
        public ComponentPath componentPath();

        public Key key();

        public Optional<Binding> maybeBinding();
    }

    public static interface Node {
        public ComponentPath componentPath();
    }

    public static interface SubcomponentBuilderBindingEdge
    extends Edge {
        public ImmutableSet<TypeElement> declaringModules();
    }

    public static interface ChildFactoryMethodEdge
    extends Edge {
        public ExecutableElement factoryMethod();
    }

    public static interface DependencyEdge
    extends Edge {
        public DependencyRequest dependencyRequest();

        public boolean isEntryPoint();
    }

    public static interface Edge {
    }
}

