/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotated;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XEnumEntry;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMemberContainer;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XVariableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.auto.common.MoreElements;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor8;

public final class XElements {
    private static final SimpleTypeVisitor8<String, Void> JVM_DESCRIPTOR_TYPE_VISITOR = new SimpleTypeVisitor8<String, Void>(){

        @Override
        public String visitArray(ArrayType arrayType, Void v) {
            return "[" + XElements.getDescriptor(arrayType.getComponentType());
        }

        @Override
        public String visitDeclared(DeclaredType declaredType, Void v) {
            return "L" + this.getInternalName(declaredType.asElement()) + ";";
        }

        @Override
        public String visitError(ErrorType errorType, Void v) {
            return this.visitDeclared((DeclaredType)errorType, v);
        }

        @Override
        public String visitExecutable(ExecutableType executableType2, Void v) {
            String parameterDescriptors2 = executableType2.getParameterTypes().stream().map(x$0 -> XElements.getDescriptor(x$0)).collect(Collectors.joining());
            String returnDescriptor = XElements.getDescriptor(executableType2.getReturnType());
            return "(" + parameterDescriptors2 + ")" + returnDescriptor;
        }

        @Override
        public String visitIntersection(IntersectionType intersectionType, Void v) {
            return XElements.getDescriptor(intersectionType.getBounds().get(0));
        }

        @Override
        public String visitNoType(NoType noType, Void v) {
            return "V";
        }

        @Override
        public String visitPrimitive(PrimitiveType primitiveType, Void v) {
            switch (primitiveType.getKind()) {
                case BOOLEAN: {
                    return "Z";
                }
                case BYTE: {
                    return "B";
                }
                case SHORT: {
                    return "S";
                }
                case INT: {
                    return "I";
                }
                case LONG: {
                    return "J";
                }
                case CHAR: {
                    return "C";
                }
                case FLOAT: {
                    return "F";
                }
                case DOUBLE: {
                    return "D";
                }
            }
            throw new IllegalArgumentException("Unknown primitive type.");
        }

        @Override
        public String visitTypeVariable(TypeVariable typeVariable, Void v) {
            return XElements.getDescriptor(typeVariable.getUpperBound());
        }

        @Override
        public String defaultAction(TypeMirror typeMirror, Void v) {
            throw new IllegalArgumentException("Unsupported type: " + typeMirror);
        }

        @Override
        public String visitWildcard(WildcardType wildcardType, Void v) {
            return "";
        }

        private String getInternalName(Element element) {
            try {
                TypeElement typeElement2 = MoreElements.asType(element);
                switch (typeElement2.getNestingKind()) {
                    case TOP_LEVEL: {
                        return typeElement2.getQualifiedName().toString().replace('.', '/');
                    }
                    case MEMBER: {
                        return this.getInternalName(typeElement2.getEnclosingElement()) + "$" + typeElement2.getSimpleName();
                    }
                }
                throw new IllegalArgumentException("Unsupported nesting kind.");
            }
            catch (IllegalArgumentException typeElement2) {
                if (element instanceof QualifiedNameable) {
                    QualifiedNameable qualifiedNameElement = (QualifiedNameable)element;
                    return qualifiedNameElement.getQualifiedName().toString().replace('.', '/');
                }
                return element.getSimpleName().toString();
            }
        }
    };

    public static String getSimpleName(XMemberContainer memberContainer) {
        return memberContainer.getClassName().simpleName();
    }

    public static String getSimpleName(XElement element) {
        return XConverters.toJavac(element).getSimpleName().toString();
    }

    public static XTypeElement closestEnclosingTypeElement(XElement element) {
        return XElements.optionalClosestEnclosingTypeElement(element).orElseThrow(() -> new IllegalStateException("No enclosing TypeElement for: " + element));
    }

    public static boolean transitivelyEncloses(XElement encloser, XElement enclosed) {
        for (XElement current = enclosed; current != null; current = current.getEnclosingElement()) {
            if (!current.equals(encloser)) continue;
            return true;
        }
        return false;
    }

    private static Optional<XTypeElement> optionalClosestEnclosingTypeElement(XElement element) {
        if (XElementKt.isTypeElement(element)) {
            return Optional.of(XElements.asTypeElement(element));
        }
        if (XElementKt.isConstructor(element)) {
            return Optional.of(XElements.asConstructor(element).getEnclosingElement());
        }
        if (XElementKt.isMethod(element)) {
            return XElements.optionalClosestEnclosingTypeElement(XElements.asMethod(element).getEnclosingElement());
        }
        if (XElementKt.isField(element)) {
            return XElements.optionalClosestEnclosingTypeElement(XElements.asField(element).getEnclosingElement());
        }
        if (XElementKt.isMethodParameter(element)) {
            return XElements.optionalClosestEnclosingTypeElement(XElements.asMethodParameter(element).getEnclosingElement());
        }
        return Optional.empty();
    }

    public static boolean isAbstract(XElement element) {
        return XConverters.toJavac(element).getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public static boolean isPrivate(XElement element) {
        return XConverters.toJavac(element).getModifiers().contains((Object)Modifier.PRIVATE);
    }

    public static boolean isStatic(XElement element) {
        return XConverters.toJavac(element).getModifiers().contains((Object)Modifier.STATIC);
    }

    public static boolean isPackage(XElement element) {
        return XConverters.toJavac(element).getKind() == ElementKind.PACKAGE;
    }

    public static boolean isEnumEntry(XElement element) {
        return element instanceof XEnumEntry;
    }

    public static boolean isEnum(XElement element) {
        return XConverters.toJavac(element).getKind() == ElementKind.ENUM;
    }

    public static boolean isExecutable(XElement element) {
        return XElementKt.isConstructor(element) || XElementKt.isMethod(element);
    }

    public static XExecutableElement asExecutable(XElement element) {
        Preconditions.checkState((boolean)XElements.isExecutable(element));
        return (XExecutableElement)element;
    }

    public static XTypeElement asTypeElement(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isTypeElement(element));
        return (XTypeElement)element;
    }

    public static XExecutableParameterElement asMethodParameter(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isMethodParameter(element));
        return (XExecutableParameterElement)element;
    }

    public static XFieldElement asField(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isField(element));
        return (XFieldElement)element;
    }

    public static XVariableElement asVariable(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isVariableElement(element));
        return (XVariableElement)element;
    }

    public static XConstructorElement asConstructor(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isConstructor(element));
        return (XConstructorElement)element;
    }

    public static XMethodElement asMethod(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isMethod(element));
        return (XMethodElement)element;
    }

    public static ImmutableSet<XAnnotation> getAnnotatedAnnotations(XAnnotated annotated, ClassName annotationName) {
        return annotated.getAllAnnotations().stream().filter(annotation -> annotation.getType().getTypeElement().hasAnnotation(annotationName)).collect(DaggerStreams.toImmutableSet());
    }

    public static boolean hasAnyAnnotation(XAnnotated annotated, ClassName ... annotations2) {
        return XElements.hasAnyAnnotation(annotated, (Collection<ClassName>)ImmutableSet.copyOf((Object[])annotations2));
    }

    public static boolean hasAnyAnnotation(XAnnotated annotated, Collection<ClassName> annotations2) {
        return annotations2.stream().anyMatch(annotated::hasAnnotation);
    }

    public static Optional<XAnnotation> getAnyAnnotation(XAnnotated annotated, ClassName ... annotations2) {
        return XElements.getAnyAnnotation(annotated, (Collection<ClassName>)ImmutableSet.copyOf((Object[])annotations2));
    }

    public static Optional<XAnnotation> getAnyAnnotation(XAnnotated annotated, Collection<ClassName> annotations2) {
        return annotations2.stream().filter(annotated::hasAnnotation).map(annotated::getAnnotation).findFirst();
    }

    public static ImmutableSet<XAnnotation> getAllAnnotations(XAnnotated annotated, Collection<ClassName> annotations2) {
        return annotations2.stream().filter(annotated::hasAnnotation).map(annotated::getAnnotation).collect(DaggerStreams.toImmutableSet());
    }

    public static String getFieldDescriptor(XFieldElement element) {
        return XElements.getFieldDescriptor(XConverters.toJavac(element));
    }

    public static String getFieldDescriptor(VariableElement element) {
        return element.getSimpleName() + ":" + XElements.getDescriptor(element.asType());
    }

    public static String getMethodDescriptor(XMethodElement element) {
        return XElements.getMethodDescriptor(XConverters.toJavac(element));
    }

    public static String getMethodDescriptor(ExecutableElement element) {
        return element.getSimpleName() + XElements.getDescriptor(element.asType());
    }

    private static String getDescriptor(TypeMirror type2) {
        return type2.accept(JVM_DESCRIPTOR_TYPE_VISITOR, null);
    }

    private XElements() {
    }
}

