/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.Equivalence;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.xprocessing.XAnnotationValues;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.JavaPoetExtKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotationValue;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.auto.common.AnnotationMirrors;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class XAnnotations {
    private static final Equivalence<XAnnotation> XANNOTATION_EQUIVALENCE = new Equivalence<XAnnotation>(){

        protected boolean doEquivalent(XAnnotation left, XAnnotation right) {
            return XTypes.equivalence().equivalent((Object)left.getType(), (Object)right.getType()) && XAnnotationValues.equivalence().pairwise().equivalent(left.getAnnotationValues(), right.getAnnotationValues());
        }

        protected int doHash(XAnnotation annotation) {
            return Arrays.hashCode(new int[]{XTypes.equivalence().hash((Object)annotation.getType()), XAnnotationValues.equivalence().pairwise().hash(annotation.getAnnotationValues())});
        }

        public String toString() {
            return "XAnnotation.equivalence()";
        }
    };

    public static AnnotationSpec getAnnotationSpec(XAnnotation annotation) {
        return JavaPoetExtKt.toAnnotationSpec(annotation);
    }

    public static String toString(XAnnotation annotation) {
        return XConverters.getProcessingEnv(annotation).getBackend() == XProcessingEnv.Backend.JAVAC ? AnnotationMirrors.toString(XConverters.toJavac(annotation)) : XAnnotations.toStableString(annotation);
    }

    public static ClassName getClassName(XAnnotation annotation) {
        return annotation.getType().getTypeElement().getClassName();
    }

    public static Equivalence<XAnnotation> equivalence() {
        return XANNOTATION_EQUIVALENCE;
    }

    public static String toStableString(XAnnotation annotation) {
        return annotation.getAnnotationValues().isEmpty() ? String.format("@%s", XAnnotations.getClassName(annotation).canonicalName()) : String.format("@%s(%s)", XAnnotations.getClassName(annotation).canonicalName(), annotation.getAnnotationValues().stream().map(value2 -> {
            String name2 = value2.getName();
            String valueAsString = XAnnotations.toStableString(value2);
            return annotation.getAnnotationValues().size() == 1 && name2.contentEquals("value") ? valueAsString : String.format("%s=%s", name2, valueAsString);
        }).collect(Collectors.joining(", ")));
    }

    private static String toStableString(XAnnotationValue value2) {
        if (value2.hasListValue()) {
            return value2.asAnnotationValueList().stream().map(v -> XAnnotations.toStableString(v)).collect(Collectors.joining(", ", "{", "}"));
        }
        if (value2.hasAnnotationValue()) {
            return XAnnotations.toStableString(value2.asAnnotation());
        }
        if (value2.hasEnumValue()) {
            return XElements.getSimpleName(value2.asEnum());
        }
        if (value2.hasTypeValue()) {
            return value2.asType().getTypeElement().getQualifiedName();
        }
        if (value2.hasStringValue()) {
            return CodeBlock.of((String)"$S", (Object[])new Object[]{value2.asString()}).toString();
        }
        if (value2.hasCharValue()) {
            return XAnnotations.characterLiteralWithSingleQuotes(value2.asChar());
        }
        return value2.getValue().toString();
    }

    public static String characterLiteralWithSingleQuotes(char c) {
        return "'" + XAnnotations.characterLiteralWithoutSingleQuotes(c) + "'";
    }

    private static String characterLiteralWithoutSingleQuotes(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\"': {
                return "\"";
            }
            case '\'': {
                return "\\'";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return Character.isISOControl(c) ? String.format("\\u%04x", c) : Character.toString(c);
    }

    private XAnnotations() {
    }
}

